/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.FinSettleWriteBackerFactory;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.convert.FinApSettleVOConverter;
import kd.fi.arapcommon.service.settle.writeback.ISettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.SettleWriteBackerParam;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.FinApSettleWBService;

public class FinApBillHandleHelper {
    private static final Log logger = LogFactory.getLog(FinApBillHandleHelper.class);

    public static List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("duedate");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("asstactname");
        selector.add("billtypeid");
        selector.add("unsettleamount");
        selector.add("amount");
        selector.add("quotation");
        selector.add("exchangerate");
        selector.add("payproperty");
        selector.add("pricetaxtotal");
        selector.add("currency");
        selector.add("basecurrency");
        selector.add("settleamount");
        selector.add("settleamountbase");
        selector.add("sourcebilltype");
        selector.add("billstatus");
        selector.add("settleversion");
        selector.add("detailentry.e_pricetaxtotal");
        selector.add("detailentry.e_pricetaxtotalbase");
        selector.add("detailentry.material");
        selector.add("detailentry.expenseitem");
        selector.add("detailentry.e_prepayrate");
        selector.add("detailentry.unsettleamt");
        selector.add("detailentry.settledamt");
        selector.add("detailentry.corebillno");
        selector.add("detailentry.corebillentryseq");
        selector.add("detailentry.e_sourcebillid");
        selector.add("detailentry.e_sourcebillentryid");
        selector.add("detailentry.corebillid");
        selector.add("detailentry.corebillentryid");
        selector.add("detailentry.unlockamt");
        selector.add("detailentry.lockedamt");
        selector.add("detailentry.e_fixlockedamt");
        selector.add("detailentry.e_conbillnumber");
        selector.add("detailentry.e_conbillrownum");
        selector.add("planentity.planduedate");
        selector.add("planentity.plansettletype");
        selector.add("planentity.planpricetax");
        selector.add("planentity.unplanlockamt");
        selector.add("planentity.planlockedamt");
        selector.add("planentity.unplansettleamt");
        selector.add("planentity.plansettledamt");
        selector.add("planentity.e_fixsettleedamt");
        selector.add("planentity.p_sourcebillid");
        selector.add("planentity.p_sourcebillentryid");
        selector.add("planentity.plancorebillno");
        selector.add("planentity.plancontract");
        List<SettleRecordExtDataListKeyVO> keys = SettleExtDataLoader.loadSettleRecordExtListKeys("ap_finapbill");
        keys.forEach(v -> selector.add(v.getBillKey()));
        return selector;
    }

    public static List<String> getLockWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(12);
        selector.add("id");
        selector.add("org");
        selector.add("pricetaxtotal");
        selector.add("currency");
        selector.add("settleversion");
        selector.add("premiumamt");
        selector.add("detailentry.e_pricetaxtotal");
        selector.add("detailentry.unlockamt");
        selector.add("detailentry.lockedamt");
        selector.add("detailentry.e_fixlockedamt");
        selector.add("detailentry.e_splitdimensionid");
        selector.add("planentity.planpricetax");
        selector.add("planentity.unplanlockamt");
        selector.add("planentity.planlockedamt");
        selector.add("planentity.p_splitdimensionid");
        return selector;
    }

    public static DynamicObject[] load(QFilter[] filter) {
        QFilter billStatusFilter = new QFilter("billstatus", "<>", (Object)"A");
        filter = (QFilter[])ArrayUtils.addAll((Object[])filter, (Object[])new QFilter[]{billStatusFilter});
        return BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", FinApBillHandleHelper.getSelector()), (QFilter[])filter, (String)"createtime");
    }

    public static List<BillSettleVO> getMainListVO(DynamicObject[] mains, SettleSchemeVO scheme) {
        return FinApSettleVOConverter.convert2VO(mains, scheme);
    }

    public static List<BillSettleVO> getAsstListVO(DynamicObject[] assts, SettleSchemeVO scheme) {
        return FinApSettleVOConverter.convert2VO(assts, scheme);
    }

    public static List<BillSettleVO> getAsstListVOForPremAndTransfor(DynamicObject[] assts, SettleSchemeVO scheme) {
        return FinApSettleVOConverter.convert2VOForPremAndTransfor(assts, scheme);
    }

    public static void disposeByMainBill(SettleRecordVO result, SettleSchemeVO scheme) {
        ArrayList<SettleRecordVO> voList = new ArrayList<SettleRecordVO>(1);
        voList.add(result);
        FinApBillHandleHelper.batchDisposeByMainBill(voList, scheme);
    }

    public static void disposeByAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
        Set billIdSet = entryList.stream().map(SettleRecordEntryVO::getBillId).collect(Collectors.toSet());
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,settleversion,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, String> billVersion = new HashMap<Long, String>(8);
        for (DynamicObject apBill : apBills) {
            String billstatus = apBill.getString("billstatus");
            String billno = apBill.getString("billno");
            if (scheme.isUnSettleByWriteOff() && !"C".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8d22\u52a1\u5e94\u4ed8\u5355\uff1a%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"FinApBillHandleHelper_4", (String)"fi-arapcommon", (Object[])new Object[]{billno}));
            }
            billVersion.put(apBill.getLong("id"), apBill.getString("settleversion"));
        }
        ArrayList<SettleRecordEntryVO> oldList = new ArrayList<SettleRecordEntryVO>(8);
        ArrayList<SettleRecordEntryVO> newList = new ArrayList<SettleRecordEntryVO>(8);
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg(apBills[0].getLong("org.id"));
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        logger.info("FinApBillHandleHelper.disposeByAsstBill newCustomerUseNewSettle:" + newCustomerUseNewSettle);
        for (SettleRecordEntryVO vo : entryList) {
            long billId = vo.getBillId();
            String version = (String)billVersion.get(billId);
            if (newCustomerUseNewSettle) {
                newList.add(vo);
                continue;
            }
            if ("0".equals(version) || "".equals(version)) {
                oldList.add(vo);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(vo);
                continue;
            }
            oldList.add(vo);
        }
        logger.info("FinApBillHandleHelper.disposeByAsstBill oldList.size:" + oldList.size() + ",newList.size:" + newList.size());
        if (oldList.size() > 0) {
            FinApSettleWBService wbSesrvice = BeanFactory.getBean(FinApSettleWBService.class, new Object[0]);
            wbSesrvice.writeBackAsst(oldList, scheme);
        }
        if (newList.size() > 0) {
            ISettleWriteBacker finApSettleWriteBacker = FinSettleWriteBackerFactory.getFinApSettleWriteBacker(scheme);
            finApSettleWriteBacker.initParam(new SettleWriteBackerParam(scheme, "ap_finapbill"));
            finApSettleWriteBacker.writeBackAsAsst(newList);
        }
    }

    public static void batchDisposeByMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        Set billIdSet = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,settleversion,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, String> billVersion = new HashMap<Long, String>(8);
        for (DynamicObject apBill : apBills) {
            String billstatus = apBill.getString("billstatus");
            String billno = apBill.getString("billno");
            if (scheme.isUnSettleByWriteOff() && !"C".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8d22\u52a1\u5e94\u4ed8\u5355\uff1a%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"FinApBillHandleHelper_4", (String)"fi-arapcommon", (Object[])new Object[]{billno}));
            }
            billVersion.put(apBill.getLong("id"), apBill.getString("settleversion"));
        }
        ArrayList<SettleRecordVO> oldList = new ArrayList<SettleRecordVO>(8);
        ArrayList<SettleRecordVO> newList = new ArrayList<SettleRecordVO>(8);
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg(apBills[0].getLong("org.id"));
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        logger.info("FinApBillHandleHelper.batchDisposeByMainBill newCustomerUseNewSettle:" + newCustomerUseNewSettle);
        for (SettleRecordVO vo : voList) {
            long mainBillId = vo.getMainBillId();
            String version = (String)billVersion.get(mainBillId);
            if (newCustomerUseNewSettle) {
                newList.add(vo);
                continue;
            }
            if ("0".equals(version) || "".equals(version)) {
                oldList.add(vo);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(vo);
                continue;
            }
            oldList.add(vo);
        }
        logger.info("FinApBillHandleHelper.batchDisposeByMainBill oldList.size:" + oldList.size() + ",newList.size:" + newList.size());
        if (oldList.size() > 0) {
            FinApSettleWBService wbSesrvice = BeanFactory.getBean(FinApSettleWBService.class, new Object[0]);
            wbSesrvice.writeBack(oldList, scheme);
        }
        if (newList.size() > 0) {
            ISettleWriteBacker finApSettleWriteBacker = FinSettleWriteBackerFactory.getFinApSettleWriteBacker(scheme);
            finApSettleWriteBacker.initParam(new SettleWriteBackerParam(scheme, "ap_finapbill"));
            finApSettleWriteBacker.writeBackAsMain(newList);
        }
    }

    @Deprecated
    public static void disposeLockedAmt(long billEntryId, BigDecimal amt, Boolean isTrans) {
        String entrySql = "update t_ap_finapbilldetailentry ";
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        entrySql = isTrans != false ? entrySql + " set flockedamt = flockedamt+?,funlockamt = funlockamt-?,fmodifierid = ?,fmodifytime = ?" : entrySql + " set flockedamt = flockedamt-?,funlockamt = funlockamt+?,fmodifierid = ?,fmodifytime = ?";
        entrySql = entrySql + " where fentryid = ?";
        Object[] entryParam = new Object[]{amt, amt, modifierId, modifyTime, billEntryId};
        DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql, (Object[])entryParam);
    }

    public static String getBillVerifyStatus(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("detailentry");
        boolean verified = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unverify = entry.getBigDecimal("unverifyquantity");
            if (unverify.compareTo(BigDecimal.ZERO) == 0) continue;
            verified = false;
            break;
        }
        if (verified) {
            return "30";
        }
        boolean unVerify = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unverify = entry.getBigDecimal("verifyquantity");
            if (unverify.compareTo(BigDecimal.ZERO) == 0) continue;
            unVerify = false;
            break;
        }
        if (unVerify) {
            return "10";
        }
        return "20";
    }

    @Deprecated
    public static String getBillSettleStatus(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("detailentry");
        boolean settled = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unsettleAmt = entry.getBigDecimal("unsettleamt");
            if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            settled = false;
            break;
        }
        if (settled) {
            return "settled";
        }
        boolean unSettle = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal settledAmt = entry.getBigDecimal("settledamt");
            if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            unSettle = false;
            break;
        }
        if (unSettle) {
            return "unsettle";
        }
        return "partsettle";
    }

    public static void processBillByDetailParam(AssignSettleParam param, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        block13: {
            block12: {
                if (!SettleDetailTypeEnum.BYHEAD.getValue().equals(param.getSettleDetailType())) break block12;
                for (DynamicObject bill : bills) {
                    Object billSettleDetailParam2;
                    List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == bill.getLong("id")).collect(Collectors.toList());
                    BigDecimal billSettleAmt = BigDecimal.ZERO;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FinApBillHandleHelper.getApEntryKey(settleModel));
                    for (Object billSettleDetailParam2 : billSettleDetailParams) {
                        BigDecimal settleAmt = ((SettleDetailParam)billSettleDetailParam2).getSettleAmt();
                        billSettleAmt = billSettleAmt.add(settleAmt);
                    }
                    boolean isSameDirection = false;
                    billSettleDetailParam2 = entrys.iterator();
                    while (billSettleDetailParam2.hasNext()) {
                        DynamicObject entry = (DynamicObject)billSettleDetailParam2.next();
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(FinApBillHandleHelper.getApEntryUnLockKey(settleModel));
                        if (entryUnLockAmt.compareTo(BigDecimal.ZERO) == 0 || entryUnLockAmt.multiply(billSettleAmt).compareTo(BigDecimal.ZERO) < 0) {
                            entry.set(FinApBillHandleHelper.getApEntryUnSettleKey(settleModel), (Object)BigDecimal.ZERO);
                            continue;
                        }
                        isSameDirection = true;
                        if (billSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(FinApBillHandleHelper.getApEntryUnSettleKey(settleModel), (Object)entryUnLockAmt);
                            billSettleAmt = billSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(FinApBillHandleHelper.getApEntryUnSettleKey(settleModel), (Object)billSettleAmt);
                        billSettleAmt = BigDecimal.ZERO;
                    }
                    if (!isSameDirection) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u4e0e\u6307\u5b9a\u7684\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_3", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    if (billSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5141\u8bb8\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u6307\u5b9a\u7684\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                }
                break block13;
            }
            if (!SettleDetailTypeEnum.BYENTRY.getValue().equals(param.getSettleDetailType())) break block13;
            Set billEntryIdSet = detailParamList.stream().map(SettleDetailParam::getBillEntryId).collect(Collectors.toSet());
            for (DynamicObject bill : bills) {
                long id = bill.getLong("id");
                List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == id).collect(Collectors.toList());
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FinApBillHandleHelper.getApEntryKey(settleModel));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal entryUnLockAmt = entry.getBigDecimal(param.isRefundByBotp() ? FinApBillHandleHelper.getApEntryUnSettleKey(settleModel) : FinApBillHandleHelper.getApEntryUnLockKey(settleModel));
                    if (!billEntryIdSet.contains(entryId)) {
                        entrys.remove(i);
                        continue;
                    }
                    BigDecimal totalSettleAmt = BigDecimal.ZERO;
                    for (SettleDetailParam settleDetailParam2 : billSettleDetailParams) {
                        long billId = settleDetailParam2.getBillId();
                        long billEntryId = settleDetailParam2.getBillEntryId();
                        if (id != billId || entryId != billEntryId) continue;
                        BigDecimal settleAmt = settleDetailParam2.getSettleAmt();
                        if (entryUnLockAmt.multiply(settleAmt).compareTo(BigDecimal.ZERO) < 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0e\u5355\u636e\u5206\u5f55\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                        }
                        totalSettleAmt = totalSettleAmt.add(settleAmt);
                    }
                    if (totalSettleAmt.abs().subtract(entryUnLockAmt.abs()).compareTo(BigDecimal.ZERO) > 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5206\u5f55\u7684\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    entry.set(FinApBillHandleHelper.getApEntryUnSettleKey(settleModel), (Object)totalSettleAmt);
                }
            }
        }
    }

    private static String getApEntryKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "detailentry" : "planentity";
    }

    private static String getApEntryUnSettleKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "unsettleamt" : "unplansettleamt";
    }

    private static String getApEntryUnLockKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "unlockamt" : "unplanlockamt";
    }
}

