/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.FinSettleWriteBackerFactory;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.convert.FinArSettleVOConverter;
import kd.fi.arapcommon.service.settle.writeback.ISettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.SettleWriteBackerParam;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.FinArSettleWBService;

public class FinArBillHandleHelper {
    private static final Log logger = LogFactory.getLog(FinArBillHandleHelper.class);

    public static List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("duedate");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("asstactname");
        selector.add("billtype");
        selector.add("unsettleamount");
        selector.add("quotation");
        selector.add("exchangerate");
        selector.add("recamount");
        selector.add("currency");
        selector.add("isperiod");
        selector.add("payproperty");
        selector.add("basecurrency");
        selector.add("settleamount");
        selector.add("settlelocalamt");
        selector.add("billstatus");
        selector.add("settleversion");
        selector.add("entry.id");
        selector.add("entry.seq");
        selector.add("entry.e_recamount");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettleamt");
        selector.add("entry.e_settledamt");
        selector.add("entry.e_corebillno");
        selector.add("entry.e_corebillentryseq");
        selector.add("entry.e_srcid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.corebillid");
        selector.add("entry.corebillentryid");
        selector.add("entry.e_unlockamt");
        selector.add("entry.e_lockedamt");
        selector.add("entry.e_fixlockedamt");
        selector.add("planentity.id");
        selector.add("planentity.planduedate");
        selector.add("planentity.plansettletype");
        selector.add("planentity.planpricetax");
        selector.add("planentity.unplanlockamt");
        selector.add("planentity.planlockedamt");
        selector.add("planentity.unplansettleamt");
        selector.add("planentity.plansettledamt");
        selector.add("planentity.e_fixsettleedamt");
        selector.add("planentity.p_sourcebillid");
        selector.add("planentity.p_sourcebillentryid");
        List<SettleRecordExtDataListKeyVO> keys = SettleExtDataLoader.loadSettleRecordExtListKeys("ar_finarbill");
        keys.forEach(v -> selector.add(v.getBillKey()));
        return selector;
    }

    public static List<String> getLockWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(12);
        selector.add("id");
        selector.add("org");
        selector.add("recamount");
        selector.add("currency");
        selector.add("settleversion");
        selector.add("premiumamt");
        selector.add("entry.e_recamount");
        selector.add("entry.e_unlockamt");
        selector.add("entry.e_lockedamt");
        selector.add("entry.e_fixlockedamt");
        selector.add("entry.e_splitdimensionid");
        selector.add("planentity.planpricetax");
        selector.add("planentity.unplanlockamt");
        selector.add("planentity.planlockedamt");
        selector.add("planentity.p_splitdimensionid");
        return selector;
    }

    public static DynamicObject[] load(QFilter[] filter) {
        QFilter billStatusFilter = new QFilter("billstatus", "<>", (Object)"A");
        filter = (QFilter[])ArrayUtils.addAll((Object[])filter, (Object[])new QFilter[]{billStatusFilter});
        return BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", FinArBillHandleHelper.getSelector()), (QFilter[])filter, (String)"createtime");
    }

    public static List<BillSettleVO> getMainListVO(DynamicObject[] mains, SettleSchemeVO scheme) {
        return FinArSettleVOConverter.convert2VO(mains, scheme);
    }

    public static List<BillSettleVO> getAsstListVO(DynamicObject[] assts, SettleSchemeVO scheme) {
        return FinArSettleVOConverter.convert2VO(assts, scheme);
    }

    public static List<BillSettleVO> getAsstListVOForTransfer(DynamicObject[] assts, SettleSchemeVO scheme) {
        return FinArSettleVOConverter.convert2VOForTransfer(assts, scheme);
    }

    public static List<BillSettleVO> getAsstListVOForPrem(DynamicObject[] assts, SettleSchemeVO scheme) {
        return FinArSettleVOConverter.convert2VOForPrem(assts, scheme);
    }

    public static void disposeByMainBill(SettleRecordVO result, SettleSchemeVO scheme) {
        ArrayList<SettleRecordVO> voList = new ArrayList<SettleRecordVO>(1);
        voList.add(result);
        FinArBillHandleHelper.batchDisposeByMainBill(voList, scheme);
    }

    public static void batchDisposeByMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        Set billIdSet = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,settleversion,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, String> billVersion = new HashMap<Long, String>(8);
        for (DynamicObject bill : arBills) {
            String billstatus = bill.getString("billstatus");
            String billno = bill.getString("billno");
            if (scheme.isUnSettleByWriteOff() && !"C".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8d22\u52a1\u5e94\u6536\u5355\uff1a%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"FinArBillHandleHelper_4", (String)"fi-arapcommon", (Object[])new Object[]{billno}));
            }
            billVersion.put(bill.getLong("id"), bill.getString("settleversion"));
        }
        ArrayList<SettleRecordVO> oldList = new ArrayList<SettleRecordVO>(8);
        ArrayList<SettleRecordVO> newList = new ArrayList<SettleRecordVO>(8);
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg(arBills[0].getLong("org.id"));
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        logger.info("FinArBillHandleHelper.batchDisposeByMainBill newCustomerUseNewSettle:" + newCustomerUseNewSettle);
        for (SettleRecordVO vo : voList) {
            long mainBillId = vo.getMainBillId();
            String version = (String)billVersion.get(mainBillId);
            if (newCustomerUseNewSettle) {
                newList.add(vo);
                continue;
            }
            if ("0".equals(version)) {
                oldList.add(vo);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(vo);
                continue;
            }
            oldList.add(vo);
        }
        logger.info("FinArBillHandleHelper.batchDisposeByMainBill oldList.size:" + oldList.size() + ",newList.size:" + newList.size());
        if (oldList.size() > 0) {
            FinArSettleWBService.INSTANCE.writeBack(oldList, scheme);
        }
        if (newList.size() > 0) {
            ISettleWriteBacker finArSettleWriteBacker = FinSettleWriteBackerFactory.getFinArSettleWriteBacker(scheme);
            finArSettleWriteBacker.initParam(new SettleWriteBackerParam(scheme, "ar_finarbill"));
            finArSettleWriteBacker.writeBackAsMain(newList);
        }
    }

    public static void disposeByAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
        FinArBillHandleHelper.batchDisposeByAsstBill(entryList, scheme);
    }

    public static void batchDisposeByAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
        Set billIdSet = entryList.stream().map(SettleRecordEntryVO::getBillId).collect(Collectors.toSet());
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,settleversion,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, String> billVersion = new HashMap<Long, String>(8);
        for (DynamicObject bill : arBills) {
            String billstatus = bill.getString("billstatus");
            String billno = bill.getString("billno");
            if (scheme.isUnSettleByWriteOff() && !"C".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8d22\u52a1\u5e94\u6536\u5355\uff1a%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"FinArBillHandleHelper_4", (String)"fi-arapcommon", (Object[])new Object[]{billno}));
            }
            billVersion.put(bill.getLong("id"), bill.getString("settleversion"));
        }
        ArrayList<SettleRecordEntryVO> oldList = new ArrayList<SettleRecordEntryVO>(8);
        ArrayList<SettleRecordEntryVO> newList = new ArrayList<SettleRecordEntryVO>(8);
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg(arBills[0].getLong("org.id"));
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        logger.info("FinArBillHandleHelper.batchDisposeByAsstBill newCustomerUseNewSettle:" + newCustomerUseNewSettle);
        for (SettleRecordEntryVO vo : entryList) {
            long billId = vo.getBillId();
            String version = (String)billVersion.get(billId);
            if (newCustomerUseNewSettle) {
                newList.add(vo);
                continue;
            }
            if ("0".equals(version)) {
                oldList.add(vo);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(vo);
                continue;
            }
            oldList.add(vo);
        }
        logger.info("FinArBillHandleHelper.batchDisposeByAsstBill oldList.size:" + oldList.size() + ",newList.size:" + newList.size());
        if (oldList.size() > 0) {
            FinArSettleWBService.INSTANCE.writeBackAsst(oldList, scheme);
        }
        if (newList.size() > 0) {
            ISettleWriteBacker finArSettleWriteBacker = FinSettleWriteBackerFactory.getFinArSettleWriteBacker(scheme);
            finArSettleWriteBacker.initParam(new SettleWriteBackerParam(scheme, "ar_finarbill"));
            finArSettleWriteBacker.writeBackAsAsst(newList);
        }
    }

    @Deprecated
    public static void disposeLockedAmt(long billEntryId, BigDecimal amt, Boolean isTransfer) {
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        String entrySql = "update t_ar_finarbillentry ";
        entrySql = isTransfer != false ? entrySql + " set flockedamt = flockedamt+?,funlockamt = funlockamt-?,fmodifierid = ?,fmodifytime = ?" : entrySql + " set flockedamt = flockedamt-?,funlockamt = funlockamt+?,fmodifierid = ?,fmodifytime = ?";
        entrySql = entrySql + " where fentryid=?";
        Object[] entryParam = new Object[]{amt, amt, modifierId, modifyTime, billEntryId};
        DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql, (Object[])entryParam);
    }

    @Deprecated
    public static void disposeLockedAmt(long billId, long billEntryId, BigDecimal amt, Boolean isTransfer) {
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)billId)});){
            String entrySql = "update t_ar_finarbillentry ";
            entrySql = isTransfer != false ? entrySql + " set flockedamt = flockedamt+?,funlockamt = funlockamt-?,fmodifierid = ?,fmodifytime = ?" : entrySql + " set flockedamt = flockedamt-?,funlockamt = funlockamt+?,fmodifierid = ?,fmodifytime = ?";
            entrySql = entrySql + " where fentryid=? and fid=?";
            Object[] entryParam = new Object[]{amt, amt, modifierId, modifyTime, billEntryId, billId};
            DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql, (Object[])entryParam);
        }
    }

    public static void processBillByDetailParam(AssignSettleParam param, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        block12: {
            block11: {
                if (!SettleDetailTypeEnum.BYHEAD.getValue().equals(param.getSettleDetailType())) break block11;
                for (DynamicObject bill : bills) {
                    List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == bill.getLong("id")).collect(Collectors.toList());
                    BigDecimal billSettleAmt = BigDecimal.ZERO;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FinArBillHandleHelper.getArEntryKey(settleModel));
                    for (SettleDetailParam billSettleDetailParam : billSettleDetailParams) {
                        BigDecimal settleAmt = billSettleDetailParam.getSettleAmt();
                        billSettleAmt = billSettleAmt.add(settleAmt);
                    }
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(FinArBillHandleHelper.getArEntryUnLockKey(settleModel));
                        if (entryUnLockAmt.compareTo(BigDecimal.ZERO) == 0 || entryUnLockAmt.multiply(billSettleAmt).compareTo(BigDecimal.ZERO) < 0) {
                            entry.set(FinArBillHandleHelper.getArEntryUnSettleKey(settleModel), (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (billSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(FinArBillHandleHelper.getArEntryUnSettleKey(settleModel), (Object)entryUnLockAmt);
                            billSettleAmt = billSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(FinArBillHandleHelper.getArEntryUnSettleKey(settleModel), (Object)billSettleAmt);
                        billSettleAmt = BigDecimal.ZERO;
                    }
                    if (billSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5141\u8bb8\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u6307\u5b9a\u7684\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillHandleHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                }
                break block12;
            }
            if (!SettleDetailTypeEnum.BYENTRY.getValue().equals(param.getSettleDetailType())) break block12;
            Set billEntryIdSet = detailParamList.stream().map(SettleDetailParam::getBillEntryId).collect(Collectors.toSet());
            for (DynamicObject bill : bills) {
                long id = bill.getLong("id");
                List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == id).collect(Collectors.toList());
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FinArBillHandleHelper.getArEntryKey(settleModel));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal entryUnLockAmt = entry.getBigDecimal(param.isRefundByBotp() ? FinArBillHandleHelper.getArEntryUnSettleKey(settleModel) : FinArBillHandleHelper.getArEntryUnLockKey(settleModel));
                    if (!billEntryIdSet.contains(entryId)) {
                        entrys.remove(i);
                        continue;
                    }
                    BigDecimal totalSettleAmt = BigDecimal.ZERO;
                    for (SettleDetailParam settleDetailParam2 : billSettleDetailParams) {
                        long billId = settleDetailParam2.getBillId();
                        long billEntryId = settleDetailParam2.getBillEntryId();
                        if (id != billId || entryId != billEntryId) continue;
                        BigDecimal settleAmt = settleDetailParam2.getSettleAmt();
                        if (entryUnLockAmt.multiply(settleAmt).compareTo(BigDecimal.ZERO) < 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0e\u5355\u636e\u5206\u5f55\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillHandleHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                        }
                        totalSettleAmt = totalSettleAmt.add(settleAmt);
                    }
                    if (totalSettleAmt.abs().subtract(entryUnLockAmt.abs()).compareTo(BigDecimal.ZERO) > 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5206\u5f55\u7684\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillHandleHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    entry.set(FinArBillHandleHelper.getArEntryUnSettleKey(settleModel), (Object)totalSettleAmt);
                }
            }
        }
    }

    public static void processBillByDetailParam4Claim(AssignSettleParam param, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        Set billEntryIdSet = detailParamList.stream().map(SettleDetailParam::getBillEntryId).collect(Collectors.toSet());
        for (DynamicObject bill : bills) {
            long id = bill.getLong("id");
            List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == id).collect(Collectors.toList());
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FinArBillHandleHelper.getArEntryKey(settleModel));
            for (int i = entrys.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                long entryId = entry.getLong("id");
                BigDecimal entryUnLockAmt = entry.getBigDecimal(FinArBillHandleHelper.getArEntryUnLockKey(settleModel));
                BigDecimal entryLockAmt = entry.getBigDecimal(FinArBillHandleHelper.getArEntryLockKey(settleModel));
                BigDecimal entryUnSettleAmt = entry.getBigDecimal(FinArBillHandleHelper.getArEntryUnSettleKey(settleModel));
                if (!billEntryIdSet.contains(entryId)) {
                    entrys.remove(i);
                    continue;
                }
                BigDecimal totalSettleAmt = BigDecimal.ZERO;
                for (SettleDetailParam settleDetailParam2 : billSettleDetailParams) {
                    long billId = settleDetailParam2.getBillId();
                    long billEntryId = settleDetailParam2.getBillEntryId();
                    if (id != billId || entryId != billEntryId) continue;
                    BigDecimal settleAmt = settleDetailParam2.getSettleAmt();
                    if (entryUnLockAmt.multiply(settleAmt).compareTo(BigDecimal.ZERO) < 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0e\u5355\u636e\u5206\u5f55\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillHandleHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    totalSettleAmt = totalSettleAmt.add(settleAmt);
                }
                if (totalSettleAmt.abs().subtract(entryLockAmt.abs()).compareTo(BigDecimal.ZERO) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5206\u5f55\u7684\u5df2\u9501\u5b9a\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillHandleHelper_3", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                }
                if (totalSettleAmt.abs().subtract(entryUnSettleAmt.abs()).compareTo(BigDecimal.ZERO) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5206\u5f55\u7684\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillHandleHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                }
                entry.set(FinArBillHandleHelper.getArEntryUnSettleKey(settleModel), (Object)totalSettleAmt);
            }
        }
    }

    private static String getArEntryKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "entry" : "planentity";
    }

    private static String getArEntryUnSettleKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "e_unsettleamt" : "unplansettleamt";
    }

    private static String getArEntryUnLockKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "e_unlockamt" : "unplanlockamt";
    }

    private static String getArEntryLockKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "e_lockedamt" : "planlockedamt";
    }
}

