/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.service.log.BizLog;
import kd.fi.arapcommon.service.log.OpLogInfo;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class OpLogServiceHelper {
    private static Log logger = LogFactory.getLog(OpLogServiceHelper.class);
    private static final int MAXENTRYCOUNT = 100;
    private static final int MAX_PUBLISH_SIZE = 100;

    public static void addLog(IFormView formView, String opName) {
        OpLogServiceHelper.addLog(formView, opName, "");
    }

    public static void addLog(IFormView formView, String opName, String opDesc) {
        OpLogServiceHelper.addLog(formView, opName, opDesc, false);
    }

    public static void addLog(IFormView formView, String opName, String opDesc, boolean saveJson) {
        try {
            DynamicObject dataEntity;
            if (!OpLogServiceHelper.getLogParam()) {
                return;
            }
            ArrayList<OpLogInfo> logList = new ArrayList<OpLogInfo>(1);
            OpLogInfo logInfo = new OpLogInfo();
            logInfo.setClientIP(OpLogServiceHelper.getClientIp());
            logInfo.setOpTime(new Date());
            logInfo.setOpName(opName);
            logInfo.setOpDescription(opDesc);
            logInfo.setSaveJson(saveJson);
            if (saveJson) {
                logInfo.setObj(formView.getModel().getDataEntity(true));
            }
            if (EntityMetadataUtils.isExistProperty(dataEntity = formView.getModel().getDataEntity(), "billno")) {
                logInfo.setBillNo(dataEntity.getString("billno"));
            }
            logInfo.setEntity(dataEntity.getDataEntityType().getName());
            logInfo.setNeedReload(false);
            Long userId = RequestContext.get().getCurrUserId();
            logInfo.setUserID(userId);
            logList.add(logInfo);
            OpLogServiceHelper.processLog(logList, false);
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    public static void addLog(String opName, DynamicObject[] dataEntities) {
        OpLogServiceHelper.addLog(opName, dataEntities, true);
    }

    public static void addLogInTransaction(String opName, String opMessage, DynamicObject[] dataEntities) {
        OpLogServiceHelper.addLogInTransaction(opName, opMessage, dataEntities, false);
    }

    public static void addLog(String opName, DynamicObject[] dataEntities, boolean needReload) {
        OpLogServiceHelper.addLog(opName, null, dataEntities, needReload);
    }

    public static void addLog(String opName, Object opDescription, DynamicObject[] dataEntities, boolean needReload) {
        try {
            if (!ObjectUtils.isEmpty((Object[])dataEntities) && OpLogServiceHelper.getLogParam()) {
                int size = dataEntities.length;
                ArrayList<OpLogInfo> logList = new ArrayList<OpLogInfo>(size);
                opDescription = SerializationUtils.toJsonString((Object)opDescription);
                for (DynamicObject data : dataEntities) {
                    OpLogInfo logInfo = new OpLogInfo();
                    logInfo.setClientIP(OpLogServiceHelper.getClientIp());
                    logInfo.setOpTime(new Date());
                    logInfo.setOpName(opName);
                    logInfo.setOpDescription(opDescription);
                    logInfo.setEntity(data.getDataEntityType().getName());
                    logInfo.setObj(data);
                    logInfo.setNeedReload(needReload);
                    logInfo.setSaveJson(true);
                    Long userId = RequestContext.get().getCurrUserId();
                    logInfo.setUserID(userId);
                    logList.add(logInfo);
                }
                OpLogServiceHelper.processLog(logList, false);
            }
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    public static void addLogInTransaction(String opName, Object opDescription, DynamicObject[] dataEntities, boolean needReload) {
        try {
            if (!ObjectUtils.isEmpty((Object[])dataEntities) && OpLogServiceHelper.getLogParam()) {
                int size = dataEntities.length;
                ArrayList<OpLogInfo> logList = new ArrayList<OpLogInfo>(size);
                opDescription = SerializationUtils.toJsonString((Object)opDescription);
                for (DynamicObject data : dataEntities) {
                    OpLogInfo logInfo = new OpLogInfo();
                    logInfo.setClientIP(OpLogServiceHelper.getClientIp());
                    logInfo.setOpTime(new Date());
                    logInfo.setOpName(opName);
                    logInfo.setOpDescription(opDescription);
                    logInfo.setEntity(data.getDataEntityType().getName());
                    logInfo.setObj(data);
                    logInfo.setNeedReload(needReload);
                    logInfo.setSaveJson(true);
                    Long userId = RequestContext.get().getCurrUserId();
                    logInfo.setUserID(userId);
                    logList.add(logInfo);
                }
                OpLogServiceHelper.processLog(logList, true);
            }
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    @Deprecated
    public static void addLog(String billNo, String json, String opName) {
        try {
            if (!OpLogServiceHelper.getLogParam()) {
                return;
            }
            ArrayList<OpLogInfo> logList = new ArrayList<OpLogInfo>(1);
            OpLogInfo logInfo = new OpLogInfo();
            logInfo.setClientIP(OpLogServiceHelper.getClientIp());
            logInfo.setOpTime(new Date());
            logInfo.setOpName(opName);
            logInfo.setObjJsonStr(json);
            Long userId = RequestContext.get().getCurrUserId();
            logInfo.setUserID(userId);
            logInfo.setSaveJson(true);
            logList.add(logInfo);
            OpLogServiceHelper.processLog(logList, false);
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    public static void addLog(BizLog bizLog, String key) {
        try {
            if (!OpLogServiceHelper.getLogParam()) {
                return;
            }
            ArrayList<OpLogInfo> logList = new ArrayList<OpLogInfo>(1);
            OpLogInfo logInfo = new OpLogInfo();
            logInfo.setClientIP(OpLogServiceHelper.getClientIp());
            logInfo.setOpTime(new Date());
            logInfo.setOpName(key);
            logInfo.setObjJsonStr(bizLog.getSb().toString());
            Long userId = RequestContext.get().getCurrUserId();
            logInfo.setUserID(userId);
            logInfo.setSaveJson(true);
            logInfo.setEntity(bizLog.getBillEntity());
            logList.add(logInfo);
            OpLogServiceHelper.processLog(logList, false);
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    public static void addLog(OpLogInfo logInfo) {
        try {
            if (logInfo == null || logInfo.getOpName() == null) {
                return;
            }
            ArrayList<OpLogInfo> logInfoList = new ArrayList<OpLogInfo>(1);
            logInfoList.add(logInfo);
            OpLogServiceHelper.addLog(logInfoList);
        }
        catch (Throwable e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    public static void addLog(List<OpLogInfo> logInfoList) {
        try {
            if (ObjectUtils.isEmpty(logInfoList)) {
                return;
            }
            OpLogInfo firstLogInfo = logInfoList.get(0);
            if (!firstLogInfo.isIgnoreLogParam() && !OpLogServiceHelper.getLogParam()) {
                return;
            }
            for (OpLogInfo logInfo : logInfoList) {
                logInfo.setClientIP(OpLogServiceHelper.getClientIp());
                logInfo.setOpTime(new Date());
                Long userId = RequestContext.get().getCurrUserId();
                logInfo.setUserID(userId);
            }
            OpLogServiceHelper.processLog(logInfoList, firstLogInfo.isInDbTransaction());
        }
        catch (Throwable e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    private static void processLog(List<OpLogInfo> logList, boolean inDbTransaction) {
        if (logList == null) {
            return;
        }
        try {
            OpLogServiceHelper.beforeProcess(logList);
            if (logList.size() > 100) {
                ArrayList<OpLogInfo> batchList = new ArrayList<OpLogInfo>(100);
                for (OpLogInfo logInfo : logList) {
                    batchList.add(logInfo);
                    if (batchList.size() != 100) continue;
                    OpLogServiceHelper.publishLog(batchList, inDbTransaction);
                    batchList.clear();
                }
                if (!batchList.isEmpty()) {
                    OpLogServiceHelper.publishLog(batchList, inDbTransaction);
                }
            } else {
                OpLogServiceHelper.publishLog(logList, inDbTransaction);
            }
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    private static void publishLog(List<OpLogInfo> logList, boolean inDbTransaction) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.ap.oplog");){
            if (inDbTransaction) {
                pub.publishInDbTranscation(logList);
                return;
            }
            pub.publish(logList);
        }
    }

    private static void beforeProcess(List<OpLogInfo> logList) {
        if (logList != null) {
            String traceId = RequestContext.get().getTraceId();
            for (OpLogInfo logInfo : logList) {
                DynamicObject obj;
                if (logInfo.isSaveJson() && (obj = logInfo.getObj()) != null) {
                    EntityType dataEntityType = (EntityType)obj.getDataEntityType();
                    List entryEntities = EntityTypeUtil.getEntryEntities((EntityType)dataEntityType);
                    for (EntryEntityDto entryDto : entryEntities) {
                        DynamicObjectCollection entryColl;
                        if (!EntityMetadataUtils.isExistProperty(obj, entryDto.getKey()) || (entryColl = obj.getDynamicObjectCollection(entryDto.getKey())) == null || entryColl.size() <= 100) continue;
                        logInfo.setObj(null);
                        logInfo.setSaveJson(false);
                        logInfo.setBillNo(EntityMetadataUtils.isExistProperty(obj, "billno") ? obj.getString("billno") : "");
                    }
                }
                logInfo.setTraceId(traceId);
            }
        }
    }

    public static void addLog(String opName, Object opDescription, List<Long> ids, String entityName) {
        try {
            if (!ObjectUtils.isEmpty(ids) && OpLogServiceHelper.getLogParam()) {
                int size = ids.size();
                ArrayList<OpLogInfo> logList = new ArrayList<OpLogInfo>(size);
                opDescription = SerializationUtils.toJsonString((Object)opDescription);
                for (Long id : ids) {
                    OpLogInfo logInfo = new OpLogInfo();
                    logInfo.setClientIP(OpLogServiceHelper.getClientIp());
                    logInfo.setOpTime(new Date());
                    logInfo.setOpName(opName);
                    logInfo.setOpDescription(opDescription);
                    logInfo.setEntity(entityName);
                    DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                    entity.set("id", (Object)id);
                    logInfo.setObj(entity);
                    logInfo.setNeedReload(true);
                    logInfo.setSaveJson(true);
                    Long userId = RequestContext.get().getCurrUserId();
                    logInfo.setUserID(userId);
                    logList.add(logInfo);
                }
                OpLogServiceHelper.processLog(logList, false);
            }
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
    }

    private static String getClientIp() {
        String loginIp = RequestContext.get().getLoginIP();
        if (EmptyUtils.isEmpty(loginIp)) {
            return "";
        }
        String[] ipArr = loginIp.split(",");
        return ipArr[0];
    }

    private static boolean getLogParam() {
        boolean flag = false;
        Object logParam = SystemParameterHelper.getAPAppParameter(RequestContext.get().getOrgId(), "ap_009");
        logger.info("getLogParam:" + logParam);
        if (logParam != null) {
            flag = (Boolean)logParam;
        }
        return flag;
    }
}

