/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.RecSettleVOConverter;
import kd.fi.arapcommon.service.settle.convert.RecedSettleVOConverter;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.RecBillSettleWBService;

public class RecBillHandlerHelper {
    private static final String RECTYPE_NUM = "101";
    public static final String REC_SELECTOR = "id,org,billno,bizdate,receivingtype,biztype,payertype,entrance,currency,payer,payername,quotation,exchangerate,itempayertype,entry.id,entry.e_material,entry.e_receivableamt,entry.e_sourcebillentryid,entry.e_unsettledamt,entry.e_settledamt,entry.e_expenseitem,entry.e_corebillno,entry.e_corebillentryseq,entry.e_corebilltype,entry.e_settleorg,basecurrency,entry.e_receivingtype";
    public static final String RECED_SELECTOR = "id,org,billno,bizdate,rectype,currency,asstacttype,asstact,quotation,exchangerate,entry.id,entry.e_material,entry.e_expenseitem,entry.e_amount,entry.e_unsettledamt,entry.e_settledamt,entry.e_corebillno,entry.e_corebillentryseq,basecurrency";

    public static DynamicObject[] load(String entity, QFilter[] filter) {
        if (ObjectUtils.isEmpty((Object)entity) || ObjectUtils.isEmpty((Object[])filter)) {
            return new DynamicObject[0];
        }
        if ("cas_recbill".equals(entity)) {
            return RecBillHandlerHelper.loadRec(filter);
        }
        if ("ar_receivedbill".equals(entity)) {
            return RecBillHandlerHelper.loadReced(filter);
        }
        return new DynamicObject[0];
    }

    public static DynamicObject[] loadRec(QFilter[] filter) {
        QFilter otherFilter = new QFilter("billstatus", "in", (Object)new String[]{"D"});
        otherFilter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
        filter = (QFilter[])ArrayUtils.addAll((Object[])filter, (Object[])new QFilter[]{otherFilter});
        return BusinessDataServiceHelper.load((String)"cas_recbill", (String)RecBillHandlerHelper.getSeletorOfRec(), (QFilter[])filter, (String)"bizdate");
    }

    public static DynamicObject[] loadRecById(List<Object> idList) {
        if (ObjectUtils.isEmpty(idList)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("id", "in", idList);
        filter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
        return BusinessDataServiceHelper.load((String)"cas_recbill", (String)RecBillHandlerHelper.getSeletorOfRec(), (QFilter[])filter.toArray(), (String)"bizdate");
    }

    public static DynamicObject[] loadReced(QFilter[] filter) {
        QFilter otherFilter = new QFilter("billstatus", "=", (Object)"C");
        otherFilter.and(new QFilter("rectype.ispartreceivable", "=", (Object)Boolean.TRUE));
        filter = (QFilter[])ArrayUtils.addAll((Object[])filter, (Object[])new QFilter[]{otherFilter});
        return BusinessDataServiceHelper.load((String)"ar_receivedbill", (String)RecBillHandlerHelper.getSeletorOfReced(), (QFilter[])filter, (String)"bizdate");
    }

    public static String getSeletorOfRec() {
        String extFields = RecBillHandlerHelper.getExtFields("cas_recbill");
        return REC_SELECTOR + (StringUtils.isEmpty((String)extFields) ? "" : "," + extFields);
    }

    public static String getSeletorOfReced() {
        String extFields = RecBillHandlerHelper.getExtFields("ar_receivedbill");
        return RECED_SELECTOR + (StringUtils.isEmpty((String)extFields) ? "" : "," + extFields);
    }

    private static String getExtFields(String number) {
        ArrayList list = new ArrayList(100);
        List<SettleRecordExtDataListKeyVO> keys = SettleExtDataLoader.loadSettleRecordExtListKeys(number);
        keys.forEach(key -> list.add(key.getBillKey()));
        return String.join((CharSequence)",", list);
    }

    public static List<BillSettleVO> getMainListVO(DynamicObject[] mains) {
        List<DynamicObject> recedBills;
        ArrayList<BillSettleVO> resultList = new ArrayList<BillSettleVO>(64);
        List<DynamicObject> recBills = Arrays.stream(mains).filter(main -> "cas_recbill".equals(main.getDynamicObjectType().getName())).collect(Collectors.toList());
        if (recBills.size() > 0) {
            List<BillSettleVO> recSettleVOs = RecSettleVOConverter.convert2VO(recBills.toArray(new DynamicObject[0]));
            resultList.addAll(recSettleVOs);
        }
        if ((recedBills = Arrays.stream(mains).filter(main -> "ar_receivedbill".equals(main.getDynamicObjectType().getName())).collect(Collectors.toList())).size() > 0) {
            List<BillSettleVO> recedSettleVOs = RecedSettleVOConverter.convert2VO(recedBills.toArray(new DynamicObject[0]));
            resultList.addAll(recedSettleVOs);
        }
        return resultList;
    }

    public static List<BillSettleVO> getAsstListVO(DynamicObject[] assts) {
        return RecBillHandlerHelper.getMainListVO(assts);
    }

    public static void batchDisposeByMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        RecBillSettleWBService wbSesrvice = BeanFactory.getBean(RecBillSettleWBService.class, new Object[0]);
        wbSesrvice.writeBack(voList, scheme);
    }

    public static void disposeByMainBill(SettleRecordVO result, SettleSchemeVO scheme) {
        ArrayList<SettleRecordVO> voList = new ArrayList<SettleRecordVO>(1);
        voList.add(result);
        RecBillHandlerHelper.batchDisposeByMainBill(voList, scheme);
    }

    public static void disposeByAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
        RecBillSettleWBService wbSesrvice = BeanFactory.getBean(RecBillSettleWBService.class, new Object[0]);
        wbSesrvice.writeBackAsst(entryList, scheme);
    }

    public static void processBillByDetailParam(AssignSettleParam param, DynamicObject[] bills, List<SettleDetailParam> detailParamList) {
        block12: {
            block11: {
                if (!SettleDetailTypeEnum.BYHEAD.getValue().equals(param.getSettleDetailType())) break block11;
                for (DynamicObject bill : bills) {
                    List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == bill.getLong("id")).collect(Collectors.toList());
                    BigDecimal billSettleAmt = BigDecimal.ZERO;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                    for (SettleDetailParam billSettleDetailParam : billSettleDetailParams) {
                        BigDecimal settleAmt = billSettleDetailParam.getSettleAmt();
                        billSettleAmt = billSettleAmt.add(settleAmt);
                    }
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        if (entryUnSettleAmt.multiply(billSettleAmt).compareTo(BigDecimal.ZERO) < 0 || "cas_recbill".equals(bill.getDataEntityType().getName()) && (param.getOrgId() != entry.getLong("e_settleorg.id") || !entry.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (billSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            billSettleAmt = billSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)billSettleAmt);
                        billSettleAmt = BigDecimal.ZERO;
                    }
                    if (billSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5141\u8bb8\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u6307\u5b9a\u7684\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                }
                break block12;
            }
            if (!SettleDetailTypeEnum.BYENTRY.getValue().equals(param.getSettleDetailType())) break block12;
            Set billEntryIdSet = detailParamList.stream().map(SettleDetailParam::getBillEntryId).collect(Collectors.toSet());
            for (DynamicObject bill : bills) {
                long id = bill.getLong("id");
                List billSettleDetailParams = detailParamList.stream().filter(settleDetailParam -> settleDetailParam.getBillId() == id).collect(Collectors.toList());
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (!billEntryIdSet.contains(entryId)) {
                        entrys.remove(i);
                        continue;
                    }
                    BigDecimal totalSettleAmt = BigDecimal.ZERO;
                    for (SettleDetailParam settleDetailParam2 : billSettleDetailParams) {
                        long billId = settleDetailParam2.getBillId();
                        long billEntryId = settleDetailParam2.getBillEntryId();
                        if (id != billId || entryId != billEntryId) continue;
                        BigDecimal settleAmt = settleDetailParam2.getSettleAmt();
                        if (unSettleAmt.multiply(settleAmt).compareTo(BigDecimal.ZERO) < 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0e\u5355\u636e\u5206\u5f55\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                        }
                        totalSettleAmt = totalSettleAmt.add(settleAmt);
                    }
                    if (totalSettleAmt.abs().subtract(unSettleAmt.abs()).compareTo(BigDecimal.ZERO) > 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e%s\u6307\u5b9a\u7684\u5206\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5206\u5f55\u7684\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillHandleHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    entry.set("e_unsettledamt", (Object)totalSettleAmt);
                }
            }
        }
    }
}

