/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleLogExecStatusEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class SettleLogHelper {
    public static final Log logger = LogFactory.getLog(SettleLogHelper.class);

    public static DynamicObject newSettleLog4Scheme(DynamicObject scheme, String settleLogEntity) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)settleLogEntity);
        long logId = DB.genLongId((String)("t_" + settleLogEntity));
        log.set("id", (Object)logId);
        log.set("billno", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSSS").format(new Date()));
        log.set("billstatus", (Object)"B");
        log.set("creator", (Object)scheme.getDynamicObject("executer"));
        log.set("begintime", (Object)new Date());
        log.set("settletype", (Object)SettleTypeEnum.MATCH.getValue());
        log.set("schemename", (Object)scheme.getString("name"));
        log.set("schemeno", (Object)scheme.getString("number"));
        log.set("schemepk", scheme.getPkValue());
        log.set("executestatus", (Object)SettleLogExecStatusEnum.DOING.getValue());
        SettleLogHelper.saveSettleLog4Scheme(log);
        return log;
    }

    public static void saveSettleLog4Scheme(DynamicObject log) {
        try (TXHandle tx = TX.requiresNew((String)"savesettlelog4scheme");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
            }
            catch (Throwable exc) {
                tx.markRollback();
            }
        }
    }

    public static DynamicObject newLogEntry(DynamicObject log, String settleRelation, long orgId) {
        String entityName = log.getDataEntityType().getName();
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)entityName).findProperty("entryentity");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        DynamicObject entryObject = new DynamicObject(dt);
        long logEntryId = DB.genLongId((String)("t_" + entityName + "entry"));
        entryObject.set("id", (Object)logEntryId);
        entryObject.set("org", (Object)orgId);
        entryObject.set("settlerelation", (Object)settleRelation);
        log.getDynamicObjectCollection("entryentity").add((Object)entryObject);
        return entryObject;
    }

    public static String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    public static void logBeginSettle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, String settleRelation, SettleSchemeVO scheme, String settleType) {
        try {
            StringBuilder mainStr = new StringBuilder();
            mainStr.append(ResManager.loadKDString((String)"-----\u7ed3\u7b97\u5173\u7cfb\u5173\u7cfb:", (String)"SettleLogHelper_0", (String)"fi-arapcommon", (Object[])new Object[0])).append(settleRelation).append(ResManager.loadKDString((String)" \u7ed3\u7b97\u7c7b\u578b\uff1a", (String)"SettleLogHelper_1", (String)"fi-arapcommon", (Object[])new Object[0])).append(settleType).append("-----\r\n").append(ResManager.loadKDString((String)"-----\u7ed3\u7b97\u76f8\u5173\u53c2\u6570:", (String)"SettleLogHelper_2", (String)"fi-arapcommon", (Object[])new Object[0])).append(scheme).append("-----\r\n").append(ResManager.loadKDString((String)"--\u4e3b\u65b9\u53c2\u4e0e\u7ed3\u7b97\u660e\u7ec6\u6570\u636e\uff1a", (String)"SettleLogHelper_3", (String)"fi-arapcommon", (Object[])new Object[0])).append(mainList.size()).append(ResManager.loadKDString((String)"\u6761\uff0c\u5177\u4f53\u4fe1\u606f\uff1a--", (String)"SettleLogHelper_4", (String)"fi-arapcommon", (Object[])new Object[0])).append("\r\n");
            for (BillSettleVO main : mainList) {
                mainStr.append(main).append("\r\n");
            }
            logger.info(mainStr.toString());
            StringBuilder asstStr = new StringBuilder();
            asstStr.append(ResManager.loadKDString((String)"--\u8f85\u65b9\u53c2\u4e0e\u7ed3\u7b97\u660e\u7ec6\u6570\u636e\uff1a", (String)"SettleLogHelper_5", (String)"fi-arapcommon", (Object[])new Object[0])).append(asstList.size()).append(ResManager.loadKDString((String)"\u6761\uff0c\u5177\u4f53\u4fe1\u606f\uff1a--", (String)"SettleLogHelper_4", (String)"fi-arapcommon", (Object[])new Object[0])).append("\r\n");
            for (BillSettleVO asst : asstList) {
                asstStr.append(asst).append("\r\n");
            }
            logger.info(asstStr.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void logSettleRecord(List<SettleRecordVO> resultList) {
        try {
            StringBuilder vrStr = new StringBuilder();
            vrStr.append(ResManager.loadKDString((String)"----\u672c\u6b21\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55\uff1a", (String)"SettleLogHelper_6", (String)"fi-arapcommon", (Object[])new Object[0])).append(resultList.size()).append(ResManager.loadKDString((String)"\u6761\u5f85\u4fdd\u5b58\uff0c\u5177\u4f53\u4fe1\u606f\uff1a----", (String)"SettleLogHelper_7", (String)"fi-arapcommon", (Object[])new Object[0])).append("\r\n");
            for (int i = 0; i < resultList.size(); ++i) {
                SettleRecordVO vo = resultList.get(i);
                vrStr.append(i).append(ResManager.loadKDString((String)"-\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\uff1a", (String)"SettleLogHelper_8", (String)"fi-arapcommon", (Object[])new Object[0])).append(vo).append("\r\n");
                vrStr.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\uff1a", (String)"SettleLogHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                List<SettleRecordEntryVO> vrEntrys = vo.getEntrys();
                for (SettleRecordEntryVO entry : vrEntrys) {
                    vrStr.append(entry).append("\r\n");
                }
            }
            logger.info(vrStr.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void logUnSettle(List<SettleRecordVO> resultList, SettleSchemeVO scheme) {
        try {
            StringBuilder vrStr = new StringBuilder();
            vrStr.append(ResManager.loadKDString((String)"--\u672c\u6b21\u53cd\u7ed3\u7b97\u76f8\u5173\u53c2\u6570\uff1a", (String)"SettleLogHelper_10", (String)"fi-arapcommon", (Object[])new Object[0])).append(scheme).append("\r\n").append(ResManager.loadKDString((String)"--\u672c\u6b21\u53cd\u7ed3\u7b97\u8bb0\u5f55\uff1a", (String)"SettleLogHelper_11", (String)"fi-arapcommon", (Object[])new Object[0])).append(resultList.size()).append(ResManager.loadKDString((String)"\u6761\uff0c\u5177\u4f53\u4fe1\u606f\uff1a--", (String)"SettleLogHelper_4", (String)"fi-arapcommon", (Object[])new Object[0])).append("\r\n");
            for (int i = 0; i < resultList.size(); ++i) {
                SettleRecordVO vo = resultList.get(i);
                vrStr.append(i).append(ResManager.loadKDString((String)"-\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\uff1a", (String)"SettleLogHelper_8", (String)"fi-arapcommon", (Object[])new Object[0])).append(vo).append("\r\n");
                vrStr.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\uff1a", (String)"SettleLogHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                List<SettleRecordEntryVO> vrEntrys = vo.getEntrys();
                for (SettleRecordEntryVO entry : vrEntrys) {
                    vrStr.append(entry).append("\r\n");
                }
            }
            logger.info(vrStr.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void logInvokeScmcParam(List<Map<String, Object>> disposeList, boolean settle) {
        try {
            String name = settle ? ResManager.loadKDString((String)"\u5e94\u4ed8-\u4ed8\u6b3e\u7ed3\u7b97", (String)"SettleLogHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8-\u4ed8\u6b3e\u53cd\u7ed3\u7b97", (String)"SettleLogHelper_13", (String)"fi-arapcommon", (Object[])new Object[0]);
            StringBuilder paramStr = new StringBuilder();
            paramStr.append("-----").append(name).append(ResManager.loadKDString((String)"\u8c03\u7528\u91c7\u8d2d\u63a5\u53e3\u53c2\u6570\u96c6\u5408\u4e2d\u6709", (String)"SettleLogHelper_14", (String)"fi-arapcommon", (Object[])new Object[0])).append(disposeList.size()).append(ResManager.loadKDString((String)"\u6761\u4fe1\u606f\uff1a-----", (String)"SettleLogHelper_15", (String)"fi-arapcommon", (Object[])new Object[0])).append("\r\n");
            int listSize = Math.min(disposeList.size(), 100);
            for (int i = 0; i < listSize; ++i) {
                Map<String, Object> map = disposeList.get(i);
                paramStr.append(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636eid\uff1a", (String)"SettleLogHelper_16", (String)"fi-arapcommon", (Object[])new Object[0])).append(map.get("mainbillid")).append(ResManager.loadKDString((String)" \u6838\u5fc3\u5355\u636e\u884cid:", (String)"SettleLogHelper_17", (String)"fi-arapcommon", (Object[])new Object[0])).append(map.get("mainbillentryid")).append(ResManager.loadKDString((String)" \u5e94\u4ed8\u5355\u636eid:", (String)"SettleLogHelper_18", (String)"fi-arapcommon", (Object[])new Object[0])).append(map.get("apbillid")).append(ResManager.loadKDString((String)" \u5e94\u4ed8\u5355\u636e\u5206\u5f55id:", (String)"SettleLogHelper_19", (String)"fi-arapcommon", (Object[])new Object[0])).append(map.get("apbillentryid")).append(ResManager.loadKDString((String)" \u4ed8\u6b3e\u5355\u5e01\u79cdid:", (String)"SettleLogHelper_20", (String)"fi-arapcommon", (Object[])new Object[0])).append(map.get("currencyid")).append(ResManager.loadKDString((String)" \u672c\u6b21\u7ed3\u7b97/\u53cd\u7ed3\u7b97\u91d1\u989d:", (String)"SettleLogHelper_21", (String)"fi-arapcommon", (Object[])new Object[0])).append(map.get("paidamount")).append("\r\n");
            }
            logger.info(paramStr.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

