/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.journal.JournalService;

public class SettleRecordOpHelper {
    public static void saveSettleRecord(List<DynamicObject> resultList, String entityName) {
        DynamicObject[] results = resultList.toArray(new DynamicObject[0]);
        SettleRecordOpHelper.saveSettleRecord(results, entityName);
    }

    public static void saveSettleRecord(DynamicObject[] results, String entityName) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])results, (OperateOption)option);
        OperationHelper.assertResult(saveResult);
    }

    public static void submitSettleRecord(Object[] ids, String entityName) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityName, (Object[])ids, (OperateOption)option);
        OperationHelper.assertResult(submitResult);
    }

    public static void auditSettleRecord(List<DynamicObject> results, String entityName) {
        Object[] ids = results.stream().map(result -> result.getLong("id")).toArray(Object[]::new);
        SettleRecordOpHelper.auditSettleRecord(ids, entityName);
    }

    public static void auditSettleRecord(Object[] ids, String entityName) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityName, (Object[])ids, (OperateOption)option);
        OperationHelper.assertResult(submitResult);
    }

    public static void sumbitStatusSettleRecordAudit(List<DynamicObject> results, String entityName) {
        Object[] ids = results.stream().map(result -> result.getLong("id")).toArray(Object[]::new);
        OperateOption option = OperateOption.create();
        option.setVariableValue("submitsettlerecords", "true");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityName, (Object[])ids, (OperateOption)option);
        OperationHelper.assertResult(submitResult);
    }

    public static void persistenceSettleRecord(List<DynamicObject> resultList, String entityName) {
        DynamicObject[] results = resultList.toArray(new DynamicObject[0]);
        SettleRecordOpHelper.persistenceSettleRecord(results, entityName);
    }

    public static void persistenceSettleRecord(DynamicObject[] results, String entityName) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])results, (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityName, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityName, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
    }

    public static void deleteSettleRecord(DynamicObject[] results) {
        JournalService journalService = new JournalService();
        journalService.deleteJournals(results);
        Object[] deleteIds = Arrays.stream(results).map(result -> result.getLong("id")).toArray(Object[]::new);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"remove", (String)results[0].getDataEntityType().getName(), (Object[])deleteIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)results[0].getDataEntityType().getName(), (String)"remove", Arrays.stream(results).map(result -> result.getLong("id")).collect(Collectors.toList()), (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
    }

    public static void updateSettleRecord(DynamicObject[] results) {
        List<Object> settleRecordIds = DynamicObjectHelper.getIdList(results);
        String settleRecordType = results[0].getDataEntityType().getName();
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((Object[])settleRecordIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)settleRecordType));
        for (DynamicObject updateSR : results) {
            long resultPk = updateSR.getLong("id");
            for (DynamicObject allFieldSR : settleRecords) {
                if (resultPk != allFieldSR.getLong("id")) continue;
                allFieldSR.set("totalsettleamt", (Object)updateSR.getBigDecimal("totalsettleamt"));
                allFieldSR.set("localtotalsettleamt", (Object)updateSR.getBigDecimal("localtotalsettleamt"));
                allFieldSR.set("swappl", (Object)updateSR.getBigDecimal("swappl"));
                DynamicObjectCollection remainEntries = updateSR.getDynamicObjectCollection("entry");
                List<Object> remainEntryIds = DynamicObjectHelper.getIdList((Collection<DynamicObject>)remainEntries);
                DynamicObjectCollection entries = allFieldSR.getDynamicObjectCollection("entry");
                for (int i = entries.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    if (remainEntryIds.contains(entry.getPkValue())) continue;
                    entries.remove(i);
                }
            }
        }
        ArrayList<DynamicObject> newRecords = new ArrayList<DynamicObject>(settleRecords.length);
        CloneUtils clone = new CloneUtils(false, true);
        for (DynamicObject settleRecord : settleRecords) {
            DynamicObject newSettleRecord = (DynamicObject)clone.clone((IDataEntityBase)settleRecord);
            newRecords.add(newSettleRecord);
        }
        OperationResult removeResult = OperationServiceHelper.executeOperate((String)"remove", (String)results[0].getDataEntityType().getName(), (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(removeResult);
        JournalService journalService = new JournalService();
        journalService.deleteJournals(results);
        for (DynamicObject record : newRecords) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            boolean isFlag = true;
            for (DynamicObject entry : entries) {
                boolean isHadWrittenOff = entry.getBoolean("e_hadwrittenoff");
                if (isHadWrittenOff) continue;
                isFlag = false;
            }
            if (!isFlag) continue;
            record.set("hadwrittenoff", (Object)1);
        }
        SettleRecordOpHelper.persistenceSettleRecord(newRecords, settleRecordType);
    }

    public static void updateSettleRecordsByPart(DynamicObject[] results) {
        JournalService journalService = new JournalService();
        journalService.deleteJournals(results);
        List<Object> ids = DynamicObjectHelper.getIdList(results);
        String settleRecordType = results[0].getDataEntityType().getName();
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)settleRecordType));
        for (DynamicObject result : results) {
            long resultPk = result.getLong("id");
            for (DynamicObject settleRecord : settleRecords) {
                if (resultPk != settleRecord.getLong("id")) continue;
                settleRecord.set("totalsettleamt", (Object)result.getBigDecimal("totalsettleamt"));
                settleRecord.set("localtotalsettleamt", (Object)result.getBigDecimal("localtotalsettleamt"));
                settleRecord.set("swappl", (Object)result.getBigDecimal("swappl"));
                settleRecord.set("hadwrittenoff", (Object)result.getBoolean("hadwrittenoff"));
                DynamicObjectCollection remainEntries = result.getDynamicObjectCollection("entry");
                List<Object> remainEntryIds = DynamicObjectHelper.getIdList((Collection<DynamicObject>)remainEntries);
                DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
                for (int i = entries.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    if (remainEntryIds.contains(entry.getPkValue())) continue;
                    entries.remove(i);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])settleRecords);
        journalService.pushAndSaveJournals(settleRecords);
    }

    public static Map<String, List<DynamicObject>> classfySettleRecordBySettleModel(List<DynamicObject> settleRecordList) {
        HashMap<String, List<DynamicObject>> settleModelGroup = new HashMap<String, List<DynamicObject>>(2);
        for (DynamicObject settleRecord : settleRecordList) {
            DynamicObjectCollection settleRecordEntryColl = settleRecord.getDynamicObjectCollection("entry");
            String settleModel = "1";
            for (DynamicObject settleRecordEntry : settleRecordEntryColl) {
                settleModel = settleRecordEntry.getString("e_settleentry");
            }
            List settleReocrdList = settleModelGroup.getOrDefault(settleModel, new ArrayList(8));
            settleReocrdList.add(settleRecord);
            settleModelGroup.put(settleModel, settleReocrdList);
        }
        return settleModelGroup;
    }

    public static Map<String, List<DynamicObject>> classfySettleRecord(DynamicObject[] entities) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(64);
        for (DynamicObject entity : entities) {
            Set keySet = map.keySet();
            String settleRelation = entity.getString("settlerelation");
            ArrayList<DynamicObject> objList = null;
            objList = keySet.contains(settleRelation) ? (ArrayList<DynamicObject>)map.get(settleRelation) : new ArrayList<DynamicObject>(8);
            objList.add(entity);
            map.put(settleRelation, objList);
        }
        return map;
    }

    public static void updateWriteoffOpen(DynamicObject[] results) {
        if (!ObjectUtils.isEmpty((Object[])results)) {
            ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(results.length);
            for (int i = 0; i < results.length; ++i) {
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", -5, results[i].getPkValue())};
                paramsList.add(param);
            }
            String entrySql = "update t_ap_settlerecordentry set fhadwrittenoff=1 where fid=?";
            String sql = "update t_ap_settlerecord set fhadwrittenoff=1 where fid=?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)entrySql, paramsList);
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramsList);
        }
    }

    public static void updateWriteoffClose(Long[] billIds) {
        if (!ObjectUtils.isEmpty((Object[])billIds)) {
            ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.length);
            for (int i = 0; i < billIds.length; ++i) {
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)billIds[i])};
                paramsList.add(param);
            }
            String entrySql = "update t_ap_settlerecordentry set fhadwrittenoff=0 where fid=?";
            String sql = "update t_ap_settlerecord set fhadwrittenoff=0 where fid=?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)entrySql, paramsList);
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramsList);
        }
    }
}

