/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TxSettleServiceHelper {
    public static List<String> loadPayBillSettleUnfinishedTxBillIds(List<String> businessIds) {
        return TxSettleServiceHelper.loadBillSettleUnfinishedTxBillIds(businessIds);
    }

    public static List<String> loadRecBillSettleUnfinishedTxBillIds(List<String> businessIds) {
        return TxSettleServiceHelper.loadBillSettleUnfinishedTxBillIds(businessIds);
    }

    private static List<String> loadBillSettleUnfinishedTxBillIds(List<String> businessIds) {
        return TxCheckUtil.getLocked(businessIds);
    }

    public static List<String> loadPayBillSettleUnfinishedTxBillNos(List<String> businessIds) {
        return TxSettleServiceHelper.loadBillSettleUnfinishedTxBillNos("cas_paybill", businessIds);
    }

    public static List<String> loadRecBillSettleUnfinishedTxBillNos(List<String> businessIds) {
        return TxSettleServiceHelper.loadBillSettleUnfinishedTxBillNos("cas_recbill", businessIds);
    }

    private static List<String> loadBillSettleUnfinishedTxBillNos(String billEntity, List<String> businessIds) {
        ArrayList<String> billNos = new ArrayList<String>(1);
        List<String> unFinishedIds = TxSettleServiceHelper.loadBillSettleUnfinishedTxBillIds(businessIds);
        if (!unFinishedIds.isEmpty()) {
            DynamicObject[] payBills;
            HashSet<Long> billIds = new HashSet<Long>(unFinishedIds.size());
            for (String unFinishedId : unFinishedIds) {
                billIds.add(Long.valueOf(unFinishedId));
            }
            for (DynamicObject payBill : payBills = BusinessDataServiceHelper.load((String)billEntity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
                billNos.add(payBill.getString("billno"));
            }
        }
        return billNos;
    }

    public static void validatePayBillIsExistUnfinishedTx(List<String> businessIds) {
        TxSettleServiceHelper.validateBillIsExistUnfinishedTx("cas_paybill", businessIds);
    }

    public static void validateRecBillIsExistUnfinishedTx(List<String> businessIds) {
        TxSettleServiceHelper.validateBillIsExistUnfinishedTx("cas_recbill", businessIds);
    }

    private static void validateBillIsExistUnfinishedTx(String billEntity, List<String> businessIds) {
        List<String> billNos = TxSettleServiceHelper.loadBillSettleUnfinishedTxBillNos(billEntity, businessIds);
        if (billNos.size() > 0) {
            StringBuilder showBillsInfo = new StringBuilder();
            int count = 0;
            for (String billNo : billNos) {
                if (++count > 5) break;
                showBillsInfo.append(billNo).append(',');
            }
            if (!ObjectUtils.isEmpty((Object)showBillsInfo.toString())) {
                showBillsInfo.deleteCharAt(showBillsInfo.length() - 1);
            }
            if (billNos.size() > 5) {
                showBillsInfo.append("......");
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
            String msg = String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u9700\u53c2\u4e0e\u7ed3\u7b97\uff0c\u4f46\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TxSettleServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), dataEntityType.getDisplayName(), showBillsInfo);
            throw new KDBizException(msg);
        }
    }
}

