/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.log;

import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.service.log.BizLog;

@KSObject
public class BizLogger {
    private static ThreadLocal<BizLog> CURRENT_LOG = new ThreadLocal();

    @KSMethod
    public static void begin(String key) {
        BizLog curThreadLog = CURRENT_LOG.get();
        if (StringUtils.isEmpty((String)key) || curThreadLog != null) {
            return;
        }
        BizLog bizLog = new BizLog(key);
        CURRENT_LOG.set(bizLog);
    }

    @KSMethod
    public static void begin(String key, String billEntity) {
        BizLog curThreadLog = CURRENT_LOG.get();
        if (StringUtils.isEmpty((String)key) || curThreadLog != null) {
            return;
        }
        BizLog bizLog = new BizLog(key, billEntity);
        CURRENT_LOG.set(bizLog);
    }

    @KSMethod
    public static void log(String log) {
        BizLog curThreadLog = CURRENT_LOG.get();
        if (curThreadLog == null) {
            return;
        }
        curThreadLog.addLog(log);
        CURRENT_LOG.set(curThreadLog);
    }

    @KSMethod
    public static void logWithBegin(String key, String log) {
        BizLogger.begin(key);
        BizLogger.log(log);
    }

    @KSMethod
    public static void logWithBegin(String key, String billEntity, String log) {
        BizLogger.begin(key, billEntity);
        BizLogger.log(log);
    }

    @KSMethod
    public static BizLog end(String key) {
        BizLog curThreadLog = CURRENT_LOG.get();
        if (StringUtils.isEmpty((String)key) || curThreadLog == null || !key.equals(curThreadLog.getKey())) {
            return null;
        }
        CURRENT_LOG.remove();
        return curThreadLog;
    }

    @KSMethod
    public static BizLog logWithEnd(String key, String log) {
        BizLogger.log(log);
        return BizLogger.end(key);
    }
}

