/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.service.log.BizLog;
import kd.fi.arapcommon.service.log.BizLogger;
import kd.fi.arapcommon.service.log.OpLogInfo;

public class LogUtil {
    private static Log logger = LogFactory.getLog(LogUtil.class);

    public static void beginLog(String opKey) {
        BizLogger.begin(opKey);
    }

    public static void beginLog(String opKey, String billEntity) {
        BizLogger.begin(opKey, billEntity);
    }

    public static void endLog(String opKey, DynamicObject[] dataEntity) {
        OpLogServiceHelper.addLog(opKey, dataEntity);
        BizLog curThreadLog = BizLogger.end(opKey);
        if (curThreadLog != null && !curThreadLog.isEmpty()) {
            OpLogServiceHelper.addLog(curThreadLog, opKey);
        }
    }

    public static void addInvokeLog(String serviceName, Object[] objects, Object result, boolean ignoreLogParam) {
        try {
            final OpLogInfo log = LogUtil.genInvokeLogInfo(serviceName, objects, ignoreLogParam);
            final StringBuilder sb = new StringBuilder(log.getObjJsonStr());
            sb.append("result:").append(result);
            sb.append('\n');
            log.setObjJsonStr(sb.toString());
            if (TX.inTX()) {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        sb.append("rollbacked:").append(rollbacked);
                        log.setObjJsonStr(sb.toString());
                        OpLogServiceHelper.addLog(log);
                    }
                });
            } else {
                OpLogServiceHelper.addLog(log);
            }
        }
        catch (Throwable throwable) {
            logger.info("addInvokeLog exception:" + throwable);
        }
    }

    public static void addInvokeErrorLog(String serviceName, Object[] objects, Throwable e, boolean ignoreLogParam) {
        try {
            OpLogInfo logInfo = LogUtil.genInvokeLogInfo(serviceName, objects, ignoreLogParam);
            logInfo.setObjJsonStr(SettleLogHelper.getStackTraceMessage(e));
            OpLogServiceHelper.addLog(logInfo);
        }
        catch (Throwable throwable) {
            logger.info("addInvokeErrorLog exception:" + throwable);
        }
    }

    private static OpLogInfo genInvokeLogInfo(String serviceName, Object[] objects, boolean ignoreLogParam) {
        OpLogInfo logInfo = new OpLogInfo();
        StringBuilder stackTraceSb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        stackTraceSb.append("stackTrace--");
        for (int i = 0; i < 10; ++i) {
            stackTraceSb.append(stackTrace[i]);
            stackTraceSb.append('\n');
        }
        stackTraceSb.append('\n');
        StringBuilder paramSb = new StringBuilder();
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                paramSb.append(i).append(':').append(objects[i]).append('\n');
            }
        }
        logInfo.setOpName(serviceName).setOpDescription(paramSb.toString()).setObjJsonStr(stackTraceSb.toString()).setIgnoreLogParam(ignoreLogParam);
        return logInfo;
    }

    public static void addOpLog(String entityName, Object billNo, String opNumber, String opDesc, boolean ignoreLogParam) {
        final OpLogInfo logInfo = new OpLogInfo();
        logInfo.setEntity(entityName).setBillNo(ObjectUtils.isEmpty((Object)billNo) ? opNumber : billNo.toString()).setOpName(opNumber).setOpDescription(opDesc).setObjJsonStr(opDesc).setIgnoreLogParam(ignoreLogParam);
        try {
            if (TX.inTX()) {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        OpLogServiceHelper.addLog(logInfo);
                    }
                });
            } else {
                OpLogServiceHelper.addLog(logInfo);
            }
        }
        catch (Throwable throwable) {
            logger.info("addOpLog exception:" + throwable);
        }
    }

    public static void addOpLog(List<Map<String, Object>> addLogList) {
        final ArrayList<OpLogInfo> logInfoList = new ArrayList<OpLogInfo>(addLogList.size());
        for (Map<String, Object> addLog : addLogList) {
            Object ignoreLogParam;
            Object objJsonStr;
            Object opDesc;
            Object opName;
            Object billNo;
            Object entityName = addLog.get("entityName");
            if (entityName == null) {
                entityName = "";
            }
            if ((billNo = addLog.get("billNo")) == null) {
                billNo = "";
            }
            if ((opName = addLog.get("opName")) == null) {
                opName = "";
            }
            if ((opDesc = addLog.get("opDesc")) == null) {
                opDesc = "";
            }
            if ((objJsonStr = addLog.get("objJsonStr")) == null) {
                objJsonStr = "";
            }
            if ((ignoreLogParam = addLog.get("ignoreLogParam")) == null) {
                ignoreLogParam = true;
            }
            OpLogInfo logInfo = new OpLogInfo();
            logInfo.setEntity(entityName.toString()).setBillNo(billNo.toString()).setOpName(opName.toString()).setOpDescription(opDesc).setObjJsonStr(objJsonStr.toString()).setIgnoreLogParam((Boolean)ignoreLogParam);
            logInfoList.add(logInfo);
        }
        try {
            if (TX.inTX()) {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        OpLogServiceHelper.addLog(logInfoList);
                    }
                });
            } else {
                OpLogServiceHelper.addLog(logInfoList);
            }
        }
        catch (Throwable throwable) {
            logger.info("addOpLog exception:" + throwable);
        }
    }
}

