/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.manualsettle;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.exception.ManaulSettleQueryException;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.service.ext.SettleExtDataListKeyVO;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.manualsettle.IManualSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractSettleBillProvider
implements IManualSettleBillProvider {
    protected static final Log logger = LogFactory.getLog(AbstractSettleBillProvider.class);
    protected ManualProviderParam param;
    protected Object orgPk;
    protected List<String> fields;
    protected int settleEntryParam = 1;
    protected int filterType = 0;
    protected DynamicObject asstact;

    public AbstractSettleBillProvider(ManualProviderParam param) {
        this.param = param;
        this.orgPk = param.getOrgPk();
        this.fields = param.getFields();
        this.settleEntryParam = param.getSettleEntryParam();
        if (!param.isMain() && 0 != param.getAsstSettleEntryParam()) {
            this.settleEntryParam = param.getAsstSettleEntryParam();
        }
        this.filterType = param.getFilterType();
        this.asstact = param.getAsstact();
    }

    @Override
    public List<String> getFilterFieldKeys() {
        return SettleExtDataLoader.loadManualSettleFilterKeys(this.getEntityNumber());
    }

    @Override
    public List<String> getSelector(boolean totalDisplay) {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("basecurrency");
        selector.add("basecurrency.sign");
        selector.add("basecurrency.amtprecision");
        selector.add("currency.sign");
        selector.add("currency.amtprecision");
        selector.add("'0.00000000' cursettlelocamt");
        this.addExtField(totalDisplay, selector);
        return selector;
    }

    @Override
    public List<Object[]> getBillDataRows(boolean totalDisplay, QFilter gridFilter) {
        ArrayList<Object[]> dataRows = new ArrayList<Object[]>();
        List<String> selector = this.getSelector(totalDisplay);
        QFilter queryFilter = this.getQueryFilter(gridFilter);
        String entityNumber = this.getEntityNumber();
        logger.info("manualsettlequery " + entityNumber + "-" + String.join((CharSequence)",", selector) + "-" + queryFilter);
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        DataSet totalDataSet = QueryServiceHelper.queryDataSet((String)"manualsettlequery-id", (String)entityNumber, (String)"id", (QFilter[])queryFilter.toArray(), (String)"id");
        if (totalDataSet.isEmpty()) {
            return dataRows;
        }
        int count = 0;
        for (Row row : totalDataSet) {
            Long id = row.getLong("id");
            billIdSet.add(id);
            ++count;
        }
        int queryEntryCount = this.getQueryEntryCount();
        if (count > queryEntryCount) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ErrorCode ec = new ErrorCode("MANUALSETTLE_QUERY", String.format(ResManager.loadKDString((String)"[%1$s]\u67e5\u8be2\u7684\u5355\u636e\u5206\u5f55\u6570\u91cf\u8d85\u8fc7\u4e86\u8bbe\u7f6e\u7684\u6700\u5927\u503c%2$s\u3002", (String)"AbstractSettleBillProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]), dataEntityType.getDisplayName(), queryEntryCount));
            throw new ManaulSettleQueryException(ec);
        }
        queryFilter = queryFilter.and(new QFilter("id", "in", billIdSet));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"manualsettlequery", (String)entityNumber, (String)String.join((CharSequence)",", selector), (QFilter[])queryFilter.toArray(), (String)"id", (int)queryEntryCount);
        if (!ObjectUtils.isEmpty((Object)coll)) {
            HashSet<Long> entryIdSet = new HashSet<Long>(10);
            for (int i = coll.size() - 1; i >= 0; --i) {
                DynamicObject obj = (DynamicObject)coll.get(i);
                Long entryId = obj.getLong("entryid");
                if (entryIdSet.add(entryId)) continue;
                coll.remove(i);
            }
            if (totalDisplay) {
                DynamicObject tempObj = null;
                for (int i = coll.size() - 1; i >= 0; --i) {
                    DynamicObject obj = (DynamicObject)coll.get(i);
                    if (tempObj == null || tempObj.getLong("id") != obj.getLong("id")) {
                        tempObj = obj;
                        continue;
                    }
                    if ("cas_paybill".equals(entityNumber) || "cas_recbill".equals(entityNumber) || "ap_paidbill".equals(entityNumber) || "ar_receivedbill".equals(entityNumber)) {
                        tempObj.set("pricetaxtotal", (Object)tempObj.getBigDecimal("pricetaxtotal").add(obj.getBigDecimal("pricetaxtotal")));
                    }
                    tempObj.set("unsettleamt", (Object)tempObj.getBigDecimal("unsettleamt").add(obj.getBigDecimal("unsettleamt")));
                    tempObj.set("enableamt", (Object)tempObj.getBigDecimal("enableamt").add(obj.getBigDecimal("enableamt")));
                    tempObj.set("cursettleamt", (Object)tempObj.getBigDecimal("cursettleamt").add(obj.getBigDecimal("cursettleamt")));
                    coll.remove(i);
                }
            }
        }
        if (coll.size() > 0) {
            Map<Long, String> asstMap = null;
            if ("cas_paybill".equals(entityNumber) || "cas_recbill".equals(entityNumber) || "ap_paidbill".equals(entityNumber) || "ar_receivedbill".equals(entityNumber)) {
                asstMap = this.getAsstMap(coll);
            }
            for (DynamicObject obj : coll) {
                String asstActName;
                if (!this.isExistProperty(obj, "bookdate")) {
                    DynamicProperty property = new DynamicProperty();
                    property.setName("bookdate");
                    obj.getDynamicObjectType().addProperty(property);
                }
                if (asstMap != null && EmptyUtils.isNotEmpty(asstActName = asstMap.get(obj.get("asstact")))) {
                    obj.set("asstactname", (Object)asstActName);
                }
                BigDecimal enableamt = obj.getBigDecimal("enableamt");
                BigDecimal cursettleamt = obj.getBigDecimal("cursettleamt");
                if (enableamt.compareTo(BigDecimal.ZERO) == 0 || cursettleamt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal exchangeRate = obj.getBigDecimal("exchangerate");
                int baseAmtPrecision = obj.getInt("basecurrency.amtprecision");
                String quotation = obj.getString("quotation");
                BigDecimal cursettlelocamt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, cursettleamt, exchangeRate, baseAmtPrecision);
                obj.set("cursettlelocamt", (Object)cursettlelocamt);
                Map<String, SettleExtDataListKeyVO> extColumnkeyMap = this.getExtListInfo(totalDisplay, true);
                List<Object> rowObj = this.buildOneRow(obj, extColumnkeyMap);
                if (ObjectUtils.isEmpty(rowObj)) continue;
                dataRows.add(rowObj.toArray());
            }
        }
        return dataRows;
    }

    protected Map<Long, String> getAsstMap(DynamicObjectCollection coll) {
        Map<String, Set<Object>> asstMap = coll.stream().filter(this::filter).collect(Collectors.groupingBy(obj -> obj.getString("asstacttype"), Collectors.mapping(obj -> obj.get("asstact"), Collectors.toSet())));
        return AsstactHelper.getAsstactNames(asstMap);
    }

    protected boolean filter(DynamicObject obj) {
        BigDecimal enableamt = obj.getBigDecimal("enableamt");
        BigDecimal cursettleamt = obj.getBigDecimal("cursettleamt");
        return enableamt.compareTo(BigDecimal.ZERO) != 0 && cursettleamt.compareTo(BigDecimal.ZERO) != 0 && EmptyUtils.isNotEmpty(obj.getString("asstacttype")) && EmptyUtils.isNotEmpty(obj.get("asstact"));
    }

    protected List<Object> buildOneRow(DynamicObject obj, Map<String, SettleExtDataListKeyVO> map) {
        ArrayList<Object> rowObj = new ArrayList<Object>();
        if (!ObjectUtils.isEmpty(this.fields)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
            for (String field : this.fields) {
                if (this.isExistProperty(obj, field)) {
                    SettleExtDataListKeyVO extInfo = map.get(field);
                    if (extInfo != null) {
                        DateProp prop;
                        Object s;
                        String[] extKeys = extInfo.getBillKey().split("\\.");
                        IDataEntityProperty property = null;
                        String[] stringArray = extKeys;
                        int n = stringArray.length;
                        for (int i = 0; i < n && ((property = dataEntityType.findProperty((String)(s = stringArray[i]))) instanceof EntryProp || property == null); ++i) {
                        }
                        if (property instanceof ComboProp) {
                            String displayValue = "";
                            ComboProp prop2 = (ComboProp)property;
                            List mapItems = prop2.getComboItems();
                            s = mapItems.iterator();
                            while (s.hasNext()) {
                                ValueMapItem mapItem = (ValueMapItem)s.next();
                                if (!mapItem.getValue().equals(obj.get(field))) continue;
                                displayValue = mapItem.getName().getLocaleValue();
                            }
                            rowObj.add(displayValue);
                            continue;
                        }
                        if (property instanceof AmountProp) {
                            if (obj.getBigDecimal(field).compareTo(BigDecimal.ZERO) != 0) {
                                prop = (AmountProp)property;
                                String currencyName = prop.getControlPropName();
                                int presicion = obj.getInt(currencyName + ".amtprecision");
                                String sign = obj.getString(currencyName + ".sign");
                                String result = sign + this.formatAmount(obj.getBigDecimal(field), presicion);
                                rowObj.add(result);
                                continue;
                            }
                            rowObj.add("");
                            continue;
                        }
                        if (property instanceof DateProp) {
                            prop = (DateProp)property;
                            if (obj.get(field) != null) {
                                String formatValue = prop.getDateFormat().format(obj.get(field));
                                rowObj.add(formatValue);
                                continue;
                            }
                            rowObj.add(null);
                            continue;
                        }
                        if (property instanceof DateTimeProp) {
                            prop = (DateTimeProp)property;
                            if (obj.get(field) != null) {
                                String formatValue = prop.getDateFormat().format(obj.get(field));
                                rowObj.add(formatValue);
                                continue;
                            }
                            rowObj.add(null);
                            continue;
                        }
                        rowObj.add(obj.get(field));
                        continue;
                    }
                    rowObj.add(obj.get(field));
                    continue;
                }
                rowObj.add(null);
            }
        }
        return rowObj;
    }

    @Override
    public Map<String, SettleExtDataListKeyVO> getExtListInfo(boolean totalDisplay, boolean isMain) {
        String prefix = isMain ? "ext_field" : "asst_ext_field";
        HashMap<String, SettleExtDataListKeyVO> map = new HashMap<String, SettleExtDataListKeyVO>(5);
        List<SettleExtDataListKeyVO> listKeys = this.getSettleExtDataListKeys();
        for (int i = 0; i < listKeys.size(); ++i) {
            SettleExtDataListKeyVO vo = listKeys.get(i);
            String billKeyPlace = vo.getBillKeyPlace();
            if ("head".equals(billKeyPlace) || StringUtils.isEmpty((String)billKeyPlace)) {
                map.put(prefix + i, vo);
                continue;
            }
            if (totalDisplay) continue;
            if (this.settleEntryParam == 1 && !"planentry".equals(billKeyPlace)) {
                map.put(prefix + i, vo);
            }
            if (this.settleEntryParam != 2 || "detailentry".equals(billKeyPlace)) continue;
            map.put(prefix + i, vo);
        }
        return map;
    }

    private void addExtField(boolean totalDisplay, List<String> selector) {
        List<SettleExtDataListKeyVO> listKeys = SettleExtDataLoader.loadManualSettleListKeys(this.getEntityNumber());
        for (int i = 0; i < listKeys.size(); ++i) {
            String billKey = listKeys.get(i).getBillKey();
            String billKeyPlace = listKeys.get(i).getBillKeyPlace();
            if ("head".equals(billKeyPlace) || StringUtils.isEmpty((String)billKeyPlace)) {
                selector.add(billKey + " as ext_field" + i);
                continue;
            }
            if (totalDisplay) continue;
            if (this.settleEntryParam == 1 && !"planentry".equals(billKeyPlace)) {
                selector.add(billKey + " as ext_field" + i);
            }
            if (this.settleEntryParam != 2 || "detailentry".equals(billKeyPlace)) continue;
            selector.add(listKeys.get(i).getBillKey() + " as ext_field" + i);
        }
    }

    private List<SettleExtDataListKeyVO> getSettleExtDataListKeys() {
        return SettleExtDataLoader.loadManualSettleListKeys(this.getEntityNumber());
    }

    public boolean isExistProperty(DynamicObject bill, String propertyName) {
        DynamicProperty property;
        boolean isExistProperty = false;
        DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
        if (dynamicObjectType != null && (property = dynamicObjectType.getProperty(propertyName)) != null) {
            isExistProperty = true;
        }
        return isExistProperty;
    }

    protected DynamicObject getStandardCurrency(String initEntity) {
        DynamicObject init = BusinessDataServiceHelper.loadSingleFromCache((String)initEntity, (QFilter[])new QFilter[]{new QFilter("org", "=", this.orgPk)});
        if (init == null || init.get("standardcurrency") == null) {
            return null;
        }
        return init.getDynamicObject("standardcurrency");
    }

    protected void replaceFilterProp(String oldName, String newName, QFilter filter) {
        String property = filter.getProperty();
        if (oldName.equals(property)) {
            filter.__setProperty(newName);
        } else {
            List filterNest = filter.getNests(true);
            for (QFilter.QFilterNest nest : filterNest) {
                QFilter filterInner = nest.getFilter();
                String innerProperty = filterInner.getProperty();
                if (!oldName.equals(innerProperty)) continue;
                filterInner.__setProperty(newName);
                if (!oldName.equals(filterInner.getValue())) continue;
                filterInner.__setValue((Object)newName);
            }
        }
    }

    protected void replaceFilterPropForMulti(String oldName, String newName, QFilter filter) {
        block4: {
            String oldFilterName;
            block5: {
                MultiBaseDataFilterValue[] multiValueArray;
                Object value;
                block6: {
                    String property;
                    oldFilterName = oldName + ".name";
                    if (!oldFilterName.equals(property = filter.getProperty())) break block5;
                    filter.__setProperty(newName + ".name");
                    value = filter.getValue();
                    if (!(value instanceof MultiBaseDataFilterValue)) break block6;
                    MultiBaseDataFilterValue multiValue = (MultiBaseDataFilterValue)value;
                    multiValue.setJoinProperty(newName);
                    break block4;
                }
                if (!(value instanceof MultiBaseDataFilterValue[])) break block4;
                for (MultiBaseDataFilterValue multiValue : multiValueArray = (MultiBaseDataFilterValue[])value) {
                    multiValue.setJoinProperty(newName);
                }
                break block4;
            }
            List filterNest = filter.getNests(true);
            for (QFilter.QFilterNest nest : filterNest) {
                MultiBaseDataFilterValue[] multiValueArray;
                QFilter filterInner = nest.getFilter();
                String innerProperty = filterInner.getProperty();
                if (!oldFilterName.equals(innerProperty)) continue;
                filterInner.__setProperty(newName + ".name");
                Object value = filterInner.getValue();
                if (value instanceof MultiBaseDataFilterValue) {
                    MultiBaseDataFilterValue multiValue = (MultiBaseDataFilterValue)value;
                    multiValue.setJoinProperty(newName);
                    break;
                }
                if (!(value instanceof MultiBaseDataFilterValue[])) break;
                for (MultiBaseDataFilterValue multiValue : multiValueArray = (MultiBaseDataFilterValue[])value) {
                    multiValue.setJoinProperty(newName);
                }
                break;
            }
        }
    }

    @Override
    public ManualProviderParam getManualParam() {
        return this.param;
    }

    private int getQueryEntryCount() {
        int queryEntryCount = 50000;
        String queryEntryCountConfig = StdConfig.get("queryEntryCount");
        if (!ObjectUtils.isEmpty((Object)queryEntryCountConfig)) {
            queryEntryCount = Integer.parseInt(queryEntryCountConfig);
        }
        return queryEntryCount;
    }

    private String formatAmount(BigDecimal amount, int presicion) {
        StringBuilder formatSB = new StringBuilder();
        formatSB.append("###,###,###,###.");
        for (int i = 0; i < presicion; ++i) {
            formatSB.append('0');
        }
        DecimalFormat format = new DecimalFormat(formatSB.toString());
        return format.format(amount);
    }
}

