/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.manualsettle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.manualsettle.AbstractSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettlePaidBillProvider;

public class ManualSettlePayBillProvider
extends AbstractSettleBillProvider {
    protected ManualSettlePaidBillProvider paidProvider;

    public ManualSettlePayBillProvider(ManualProviderParam param) {
        super(param);
    }

    @Override
    public FilterCondition getDefaultFilter() {
        DynamicObject currency;
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow asstActTypeRow = new SimpleFilterRow();
        asstActTypeRow.setCompareType("105");
        asstActTypeRow.setFieldName("itempayeetype");
        asstActTypeRow.setLogic("0");
        ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
        FilterValue asstActTypeValue = new FilterValue();
        asstActTypeValue.setValue((Object)"bd_supplier");
        asstActTypeValues.add(asstActTypeValue);
        asstActTypeRow.setValue(asstActTypeValues);
        rows.add(asstActTypeRow);
        SimpleFilterRow asstActRow = new SimpleFilterRow();
        asstActRow.setCompareType("800");
        asstActRow.setFieldName("itempayee.name");
        asstActRow.setLogic("0");
        rows.add(asstActRow);
        if (this.orgPk != null && (currency = this.getStandardCurrency("cas_cashmgtinit")) != null) {
            SimpleFilterRow currencyRow = new SimpleFilterRow();
            currencyRow.setCompareType("67");
            currencyRow.setFieldName("currency.name");
            currencyRow.setLogic("0");
            ArrayList<FilterValue> currencyValues = new ArrayList<FilterValue>();
            FilterValue currencyValue = new FilterValue();
            currencyValue.setValue((Object)currency.getString("name"));
            currencyValues.add(currencyValue);
            currencyRow.setValue(currencyValues);
            rows.add(currencyRow);
        }
        return fc;
    }

    @Override
    public List<String> getSelector(boolean totalDisplay) {
        List<String> selector = super.getSelector(totalDisplay);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("'" + this.getEntityNumber() + "' billtype");
        selector.add("itempayeetype asstacttype");
        selector.add("itempayee asstact");
        selector.add("payeetype asstacttypeenum");
        selector.add("payeename asstactname");
        selector.add("currency");
        selector.add("payquotation quotation");
        selector.add("exchangerate");
        if (totalDisplay) {
            selector.add("paymenttype paymenttype");
            selector.add("paymenttype paymentbilltype");
            selector.add("entry.e_actamt pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
        } else {
            selector.add("entry.e_paymenttype paymenttype");
            selector.add("entry.e_paymenttype paymentbilltype");
            selector.add("0 pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_actamt e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter(QFilter gridFilter) {
        QFilter filter = new QFilter("entry.settleorg", "=", this.orgPk);
        if (gridFilter != null) {
            filter.and(gridFilter);
        }
        if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(this.param.getSettleRelation())) {
            List<String> asstTypeList = Arrays.asList("bos_org", "other");
            filter.and(new QFilter("payeetype", "not in", asstTypeList));
        }
        if (this.asstact != null) {
            if ("payrecsettle".equals(this.param.getSettleRelation()) || "recpaysettle".equals(this.param.getSettleRelation())) {
                filter.and("payeename", "=", (Object)this.asstact.getString("name"));
            } else {
                filter.and("itempayee", "in", BaseDataHelper.getBaseDataIds(this.asstact.getDataEntityType().getName(), this.asstact.getLong("masterid")));
            }
        }
        String sign = this.filterType == 0 ? "<>" : (this.filterType == 1 ? ">" : "<");
        filter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"}).and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", sign, (Object)0);
        return filter;
    }

    @Override
    public List<Object[]> getBillDataRows(boolean totalDisplay, QFilter gridFilter) {
        List<Object[]> payRows = super.getBillDataRows(totalDisplay, gridFilter);
        if (!SettleRelationEnum.ARPAYSETTLE.getValue().equals(this.param.getSettleRelation())) {
            if (this.paidProvider == null) {
                this.paidProvider = new ManualSettlePaidBillProvider(this.param);
            }
            List<Object[]> paidRows = this.paidProvider.getBillDataRows(totalDisplay, gridFilter);
            payRows.addAll(paidRows);
        }
        return payRows;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"ManualSettlePayBillProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public String getEntityNumber() {
        return "cas_paybill";
    }

    @Override
    public FilterCondition getServletFilter(DynamicObject finarbill) {
        return null;
    }
}

