/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.match;

import java.math.BigDecimal;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.service.match.IMatchService;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractMatchService
implements IMatchService {
    @Override
    public boolean match(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        return this.coreMatch(main, asst, scheme) && this.orgMatch(main, asst, scheme) && this.directionMatch(main, asst, scheme) && this.otherMatch(main, asst, scheme) && this.extMatch(main, asst, scheme);
    }

    protected abstract boolean coreMatch(BillSettleVO var1, BillSettleVO var2, SettleSchemeVO var3);

    protected boolean otherMatch(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        return true;
    }

    protected boolean extMatch(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        return BizExtendHelper.settleMatchCallbackExt(main, asst, scheme);
    }

    protected boolean currencyMatch(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        return main.getCurrencyId() == asst.getCurrencyId();
    }

    protected boolean orgMatch(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        return main.getOrgId() == asst.getOrgId();
    }

    protected boolean directionMatch(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        boolean match = false;
        if (main.getBillEntity() != null) {
            if (scheme.isSettleSelf() || main.getBillEntity().equals(asst.getBillEntity())) {
                match = main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0 && asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0 || main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0 && asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0;
            } else {
                boolean bl = match = main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0 && asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0 || main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0 && asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0;
            }
            if ("ar_finarbill".equals(main.getBillEntity()) && "cas_paybill".equals(asst.getBillEntity()) || "ap_finapbill".equals(main.getBillEntity()) && "cas_recbill".equals(asst.getBillEntity())) {
                match = main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0 && asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0;
            }
        }
        return match;
    }

    protected boolean sourceEntryIdMatch(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        return main.getEntryId() == asst.getEntrySouBillId();
    }
}

