/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ConditionSetting {
    private static final List<ConditionSetting> settings = new ArrayList<ConditionSetting>(16);
    private final String conditionType;
    private final String entityKey;
    private final String dateProp;
    private final String alias;

    public ConditionSetting(String conditionType, String entityKey, String dateProp, String alias) {
        this.conditionType = conditionType;
        this.entityKey = entityKey;
        this.dateProp = dateProp;
        this.alias = alias;
    }

    public String getConditionType() {
        return this.conditionType;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getDateProp() {
        return this.dateProp;
    }

    public String getAlias() {
        return this.alias;
    }

    public static List<ConditionSetting> getSettings() {
        return settings;
    }

    public static ConditionSetting getSettingByEntityKey(String entityKey) {
        List<ConditionSetting> settings = ConditionSetting.getSettings();
        List collect = settings.stream().filter(item -> item.getEntityKey().equals(entityKey)).collect(Collectors.toList());
        return collect.isEmpty() ? null : (ConditionSetting)collect.get(0);
    }

    public static ConditionSetting getSettingByConditionTypeAndCalculateType(String conditonType, String calculateType) {
        List<ConditionSetting> settings = ConditionSetting.getSettings();
        ConditionSetting result = null;
        for (ConditionSetting setting : settings) {
            if (!setting.getConditionType().equals(conditonType) || !setting.getAlias().equals(calculateType)) continue;
            result = setting;
            break;
        }
        return result;
    }

    static {
        settings.add(new ConditionSetting("bd_paycondition", "pm_purorderbill", "biztime", "A"));
        settings.add(new ConditionSetting("bd_paycondition", "im_purreceivebill", "biztime", "B"));
        settings.add(new ConditionSetting("bd_paycondition", "im_purinbill", "biztime", "C"));
        settings.add(new ConditionSetting("bd_paycondition", "ap_finapbill", "bizdate", "D"));
        settings.add(new ConditionSetting("bd_paycondition", "ap_busbill", "bizdate", "D"));
        settings.add(new ConditionSetting("bd_reccondition", "sm_salorder", "bizdate", "A"));
        settings.add(new ConditionSetting("bd_reccondition", "im_saloutbill", "biztime", "B"));
        settings.add(new ConditionSetting("bd_reccondition", "ar_finarbill", "bizdate", "C"));
        settings.add(new ConditionSetting("bd_reccondition", "ar_busbill", "bizdate", "C"));
    }
}

