/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.service.plan.ConditionSetting;
import kd.fi.arapcommon.service.plan.PlanRow;
import kd.fi.arapcommon.service.plan.PlanRowDataCalculator;
import kd.fi.arapcommon.util.EmptyUtils;

public class PlanRowService {
    @Deprecated
    public List<PlanRow> calculatePlanRows(DynamicObject bill) {
        List<PlanRow> planRows;
        String entityKey = bill.getDataEntityType().getName();
        if ("ar_busbill".equals(entityKey) || "ap_busbill".equals(entityKey)) {
            return this.createDefaultPlanRows(bill);
        }
        if (this.getCondition(bill) == null) {
            return this.createDefaultPlanRows(bill);
        }
        Date basicDate = this.getBasicDate(bill);
        int precision = 2;
        DynamicObject currency = bill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        if ((planRows = this.getPlanData(this.getCondition(bill), basicDate, this.getAmount(bill), precision)).isEmpty()) {
            return this.createDefaultPlanRows(bill);
        }
        return planRows;
    }

    public List<PlanRow> calculatePlanRows(DynamicObject bill, Date termsDate) {
        List<PlanRow> planRows;
        String entityKey = bill.getDataEntityType().getName();
        if ("ar_busbill".equals(entityKey) || "ap_busbill".equals(entityKey)) {
            return this.createDefaultPlanRows(bill);
        }
        if (this.getCondition(bill) == null) {
            return this.createDefaultPlanRows(bill);
        }
        int precision = 2;
        DynamicObject currency = bill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        if ((planRows = this.getPlanData(this.getCondition(bill), termsDate, this.getAmount(bill), precision)).isEmpty()) {
            return this.createDefaultPlanRows(bill);
        }
        return planRows;
    }

    public Date getTermsDate(DynamicObject bill) {
        return this.getBasicDate(bill);
    }

    public Date getBasicDate(DynamicObject bill) {
        String arapBillKey = bill.getDataEntityType().getName();
        DynamicObject payCondition = this.getCondition(bill);
        ConditionSetting setting = this.getCaculateDateSetting(payCondition);
        if (setting == null) {
            return this.getBizDate(bill);
        }
        String sourceBillType = this.getSourceBillType(bill);
        if (arapBillKey.equals(setting.getEntityKey())) {
            return this.getBizDate(bill);
        }
        Set<Long> sourceBillIds = this.getSourceBillIds(bill);
        if (EmptyUtils.isNotEmpty(sourceBillType)) {
            if (sourceBillType.equals(setting.getEntityKey())) {
                QFilter filter = new QFilter("id", "in", sourceBillIds);
                DynamicObjectCollection srcBills = QueryServiceHelper.query((String)sourceBillType, (String)setting.getDateProp(), (QFilter[])filter.toArray(), (String)setting.getDateProp());
                if (!srcBills.isEmpty()) {
                    return ((DynamicObject)srcBills.get(0)).getDate(setting.getDateProp());
                }
            } else {
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)sourceBillType, (Long[])sourceBillIds.toArray(new Long[0]));
                HashSet sourcePks = (HashSet)sourceBills.get(setting.getEntityKey());
                if (sourcePks != null) {
                    QFilter filter = new QFilter("id", "in", (Object)sourcePks);
                    DynamicObjectCollection srcBills = QueryServiceHelper.query((String)setting.getEntityKey(), (String)setting.getDateProp(), (QFilter[])filter.toArray(), (String)setting.getDateProp());
                    if (!srcBills.isEmpty()) {
                        return ((DynamicObject)srcBills.get(0)).getDate(setting.getDateProp());
                    }
                }
            }
        }
        return this.getBizDate(bill);
    }

    private List<PlanRow> createDefaultPlanRows(DynamicObject bill) {
        PlanRow planRow = new PlanRow();
        BigDecimal totalAmount = this.getAmount(bill);
        planRow.setPlanAmt(totalAmount == null ? BigDecimal.ZERO : totalAmount);
        planRow.setDueDate(this.getDueDate(bill));
        return Collections.singletonList(planRow);
    }

    protected BigDecimal getAmount(DynamicObject bill) {
        String entityKey = bill.getDataEntityType().getName();
        if ("ap_finapbill".equals(entityKey) || "ap_busbill".equals(entityKey)) {
            return bill.getBigDecimal("pricetaxtotal");
        }
        return bill.getBigDecimal("recamount");
    }

    protected DynamicObject getCondition(DynamicObject bill) {
        return bill.getDynamicObject("paycond");
    }

    protected Date getDueDate(DynamicObject bill) {
        return bill.getDate("duedate");
    }

    protected Date getBizDate(DynamicObject bill) {
        return bill.getDate("bizdate");
    }

    protected String getSourceBillType(DynamicObject bill) {
        return bill.getString("sourcebilltype");
    }

    protected long getSourceBillId(DynamicObject bill) {
        Object sourceBillId = bill.get("sourcebillid");
        if (sourceBillId instanceof String) {
            sourceBillId = !ObjectUtils.isEmpty((Object)sourceBillId) ? Long.valueOf((String)sourceBillId) : Long.valueOf(0L);
        }
        return (Long)sourceBillId;
    }

    private Set<Long> getSourceBillIds(DynamicObject bill) {
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String entityKey = bill.getDataEntityType().getName();
        if ("ap_finapbill".equals(entityKey)) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                srcBillIds.add(row.getLong("e_sourcebillid"));
            }
        } else {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                srcBillIds.add(row.getLong("e_srcid"));
            }
        }
        return srcBillIds;
    }

    public List<PlanRow> getPlanData(DynamicObject condition, Date basicDate, BigDecimal totalAmount, int precision) {
        PlanRowDataCalculator planRowDataCalculator = BeanFactory.getBean(PlanRowDataCalculator.class, new Object[0]);
        List<Map<String, Object>> planData = planRowDataCalculator.getPayPlanData(condition, basicDate, totalAmount, precision);
        ArrayList<PlanRow> planRows = new ArrayList<PlanRow>(64);
        if (planData == null) {
            return planRows;
        }
        for (Map<String, Object> rowData : planData) {
            PlanRow planRow = new PlanRow();
            planRow.setPlanAmt((BigDecimal)rowData.get("amount"));
            Date dueDate = (Date)rowData.get("date");
            dueDate = dueDate == null ? basicDate : dueDate;
            planRow.setDueDate(dueDate);
            planRows.add(planRow);
        }
        return planRows;
    }

    private ConditionSetting getCaculateDateSetting(DynamicObject payCondition) {
        String conditionType = payCondition.getDataEntityType().getName();
        String calculateDateType = payCondition.getString("calculatetime");
        List<ConditionSetting> settings = ConditionSetting.getSettings();
        List collect = settings.stream().filter(item -> item.getConditionType().equals(conditionType) && item.getAlias().equals(calculateDateType)).collect(Collectors.toList());
        return collect.isEmpty() ? null : (ConditionSetting)collect.get(0);
    }

    public List<String> getSupportedCalculateType(DynamicObject bill) {
        String sourceBillType = this.getSourceBillType(bill);
        Long sourceBillId = this.getSourceBillId(bill);
        List<String> allSource = this.findAllSource(sourceBillType, sourceBillId);
        String entityKey = bill.getDataEntityType().getName();
        allSource.add(entityKey);
        ArrayList<String> supportedCaculateDateType = new ArrayList<String>();
        for (String ek : allSource) {
            ConditionSetting conditionSetting = ConditionSetting.getSettingByEntityKey(ek);
            if (conditionSetting == null) continue;
            supportedCaculateDateType.add(conditionSetting.getAlias());
        }
        return supportedCaculateDateType;
    }

    private List<String> findAllSource(String sourceBillType, Long sourceBillId) {
        if (ObjectUtils.isEmpty((Object)sourceBillType) || ObjectUtils.isEmpty((Object)sourceBillId)) {
            return new ArrayList<String>();
        }
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)sourceBillType, (Long[])new Long[]{sourceBillId});
        ArrayList<String> allSourceBillTypes = new ArrayList<String>(sourceBills.keySet());
        allSourceBillTypes.add(sourceBillType);
        return allSourceBillTypes;
    }
}

