/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan.split;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.plan.split.PlanSplitService;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;
import kd.fi.arapcommon.service.plan.split.entity.PlanRowData;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitServiceHelper;

public class PlanSplitAndBuilder {
    public static void splitAndBuild(DynamicObject finBill) {
        PlanSplitAndBuilder.splitAndBuild(new DynamicObject[]{finBill});
    }

    public static void splitAndBuild(DynamicObject[] finBills) {
        if (finBills.length == 0) {
            return;
        }
        String entityName = finBills[0].getDataEntityType().getName();
        DynamicObject[] needMatchSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes(finBills[0]);
        BillModel billModel = BillModelFactory.getModel(entityName);
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(billModel.P_ENTRY);
            planEntries.clear();
            boolean isPlanSettle = SystemParameterHelper.isPlanSettle(finBill.getLong("org.id"), "ar_finarbill".equals(entityName));
            boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
            DynamicObject matchScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finBill, needMatchSchemes);
            HashMap<String, String> dimensionMappings = new HashMap<String, String>(8);
            if (!isPlanSettle) {
                if (allowMaterialSplitPlanEntry) {
                    if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                        dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                        dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
                    }
                    if (matchScheme != null) {
                        finBill.set(billModel.HEAD_SPLITSCHEME, (Object)matchScheme);
                        dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                    }
                } else {
                    finBill.set(billModel.HEAD_SPLITSCHEME, null);
                    matchScheme = null;
                }
            } else {
                if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                    dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                    dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
                }
                if (matchScheme != null) {
                    finBill.set(billModel.HEAD_SPLITSCHEME, (Object)matchScheme);
                    dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                }
            }
            PlanSplitService splitService = new PlanSplitService(finBill, matchScheme);
            List<PlanRowData> planRowDatas = splitService.execute();
            DynamicObject settlementType = finBill.getDynamicObject(billModel.HEAD_SETTLEMENTTYPE);
            DynamicObjectType planEntryType = planEntries.getDynamicObjectType();
            for (int i = 0; i < planRowDatas.size(); ++i) {
                PlanRowData planRowData = planRowDatas.get(i);
                DetailGroupData groupData = planRowData.getGroupData();
                Map<String, Object> dimensionMap = groupData.getDimensionMap();
                DynamicObject planEntry = new DynamicObject(planEntryType);
                planEntry.set("seq", (Object)(i + 1));
                for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                    String detailKey = (String)dimensionMapping.getKey();
                    String planKey = (String)dimensionMapping.getValue();
                    Object dimensionValue = dimensionMap.get(detailKey);
                    planEntry.set(planKey, dimensionValue);
                }
                BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
                planEntry.set(billModel.P_PLANPRICETAX, (Object)priceTaxTotal);
                planEntry.set(billModel.P_UNPLANLOCKAMT, (Object)priceTaxTotal);
                planEntry.set(billModel.P_UNPLANSETTLEAMT, (Object)priceTaxTotal);
                BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
                planEntry.set(billModel.P_PLANPRICETAXLOC, (Object)priceTaxTotalLocal);
                planEntry.set(billModel.P_UNPLANSETTLELOCAMT, (Object)priceTaxTotalLocal);
                planEntry.set(billModel.P_PLANDUEDATE, (Object)planRowData.getDueDate());
                planEntry.set(billModel.P_PLANSETTLETYPE, (Object)settlementType);
                planEntry.set(billModel.P_RECORPAY_RATE, (Object)planRowData.getRate());
                planEntry.set(billModel.P_SPLITDIMENSION_ID, (Object)groupData.getSplitDimensionId());
                if ("ap_finapbill".equals(entityName)) {
                    planEntry.set("e_freezestate", (Object)"unfreeze");
                }
                planEntries.add((Object)planEntry);
            }
            if (dimensionMappings.size() > 0) {
                Map<Integer, Integer> detailEntryToSplitDimensionId = PlanRowData.convertDetailSplitDimension(planRowDatas);
                DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(billModel.ENTRY);
                int detailEntrySize = detailEntries.size();
                for (int i = 0; i < detailEntrySize; ++i) {
                    DynamicObject detailEntry = (DynamicObject)detailEntries.get(i);
                    detailEntry.set(billModel.E_SPLITDIMENSION_ID, (Object)detailEntryToSplitDimensionId.get(i));
                }
                continue;
            }
            DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(billModel.ENTRY);
            for (DynamicObject detailEntry : detailEntries) {
                detailEntry.set(billModel.E_SPLITDIMENSION_ID, (Object)0);
            }
        }
    }

    public static void splitAndBuildByApi(DynamicObject[] finBills) {
        if (finBills.length == 0) {
            return;
        }
        String entityName = finBills[0].getDataEntityType().getName();
        DynamicObject[] needMatchSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes(finBills[0]);
        BillModel billModel = BillModelFactory.getModel(entityName);
        for (DynamicObject finBill : finBills) {
            boolean isPlanSettle = SystemParameterHelper.isPlanSettle(finBill.getLong("org.id"), "ar_finarbill".equals(entityName));
            boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
            DynamicObject matchScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finBill, needMatchSchemes);
            HashMap<String, String> dimensionMappings = new HashMap<String, String>(8);
            if (!isPlanSettle) {
                if (allowMaterialSplitPlanEntry) {
                    if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                        dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                        dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
                    }
                    if (matchScheme != null) {
                        finBill.set(billModel.HEAD_SPLITSCHEME, (Object)matchScheme);
                        dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                    }
                } else {
                    finBill.set(billModel.HEAD_SPLITSCHEME, null);
                    matchScheme = null;
                }
            } else {
                if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                    dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                    dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
                }
                if (matchScheme != null) {
                    finBill.set(billModel.HEAD_SPLITSCHEME, (Object)matchScheme);
                    dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                }
            }
            PlanSplitService splitService = new PlanSplitService(finBill, matchScheme);
            List<PlanRowData> planRowDatas = splitService.execute();
            DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(billModel.P_ENTRY);
            planEntries.clear();
            DynamicObject settlementType = finBill.getDynamicObject(billModel.HEAD_SETTLEMENTTYPE);
            DynamicObjectType planEntryType = planEntries.getDynamicObjectType();
            for (int i = 0; i < planRowDatas.size(); ++i) {
                PlanRowData planRowData = planRowDatas.get(i);
                DetailGroupData groupData = planRowData.getGroupData();
                Map<String, Object> dimensionMap = groupData.getDimensionMap();
                DynamicObject planEntry = new DynamicObject(planEntryType);
                planEntry.set("seq", (Object)(i + 1));
                for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                    String detailKey = (String)dimensionMapping.getKey();
                    String planKey = (String)dimensionMapping.getValue();
                    Object dimensionValue = dimensionMap.get(detailKey);
                    planEntry.set(planKey, dimensionValue);
                }
                BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
                planEntry.set(billModel.P_PLANPRICETAX, (Object)priceTaxTotal);
                planEntry.set(billModel.P_UNPLANLOCKAMT, (Object)priceTaxTotal);
                planEntry.set(billModel.P_UNPLANSETTLEAMT, (Object)priceTaxTotal);
                BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
                planEntry.set(billModel.P_PLANPRICETAXLOC, (Object)priceTaxTotalLocal);
                planEntry.set(billModel.P_UNPLANSETTLELOCAMT, (Object)priceTaxTotalLocal);
                planEntry.set(billModel.P_PLANDUEDATE, (Object)planRowData.getDueDate());
                planEntry.set(billModel.P_PLANSETTLETYPE, (Object)settlementType);
                planEntry.set(billModel.P_RECORPAY_RATE, (Object)planRowData.getRate());
                planEntry.set(billModel.P_SPLITDIMENSION_ID, (Object)groupData.getSplitDimensionId());
                if ("ap_finapbill".equals(entityName)) {
                    planEntry.set("e_freezestate", (Object)"unfreeze");
                }
                planEntries.add((Object)planEntry);
            }
            if (dimensionMappings.size() > 0) {
                Map<Integer, Integer> detailEntryToSplitDimensionId = PlanRowData.convertDetailSplitDimension(planRowDatas);
                DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(billModel.ENTRY);
                int detailEntrySize = detailEntries.size();
                for (int i = 0; i < detailEntrySize; ++i) {
                    DynamicObject detailEntry = (DynamicObject)detailEntries.get(i);
                    detailEntry.set(billModel.E_SPLITDIMENSION_ID, (Object)detailEntryToSplitDimensionId.get(i));
                }
            } else {
                DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(billModel.ENTRY);
                for (DynamicObject detailEntry : detailEntries) {
                    detailEntry.set(billModel.E_SPLITDIMENSION_ID, (Object)0);
                }
            }
            PlanSplitAndBuilder.setHeadDueDate(finBill);
        }
    }

    public static void splitAndBuild(DynamicObject finBill, DynamicObject matchScheme) {
        String entityName = finBill.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        boolean isPlanSettle = SystemParameterHelper.isPlanSettle(finBill.getLong("org.id"), "ar_finarbill".equals(entityName));
        boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(8);
        if (!isPlanSettle) {
            if (allowMaterialSplitPlanEntry) {
                if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                    dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                    dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
                }
                if (matchScheme != null) {
                    finBill.set(billModel.HEAD_SPLITSCHEME, (Object)matchScheme);
                    dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                }
            } else {
                finBill.set(billModel.HEAD_SPLITSCHEME, null);
                matchScheme = null;
            }
        } else {
            if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
            }
            if (matchScheme != null) {
                finBill.set(billModel.HEAD_SPLITSCHEME, (Object)matchScheme);
                dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
            }
        }
        PlanSplitService splitService = new PlanSplitService(finBill, matchScheme);
        List<PlanRowData> planRowDatas = splitService.execute();
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(billModel.P_ENTRY);
        planEntries.clear();
        DynamicObject settlementType = finBill.getDynamicObject(billModel.HEAD_SETTLEMENTTYPE);
        DynamicObjectType planEntryType = planEntries.getDynamicObjectType();
        for (int i = 0; i < planRowDatas.size(); ++i) {
            PlanRowData planRowData = planRowDatas.get(i);
            DetailGroupData groupData = planRowData.getGroupData();
            Map<String, Object> dimensionMap = groupData.getDimensionMap();
            DynamicObject planEntry = new DynamicObject(planEntryType);
            planEntry.set("seq", (Object)(i + 1));
            for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                String detailKey = (String)dimensionMapping.getKey();
                String planKey = (String)dimensionMapping.getValue();
                Object dimensionValue = dimensionMap.get(detailKey);
                planEntry.set(planKey, dimensionValue);
            }
            BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
            planEntry.set(billModel.P_PLANPRICETAX, (Object)priceTaxTotal);
            planEntry.set(billModel.P_UNPLANLOCKAMT, (Object)priceTaxTotal);
            planEntry.set(billModel.P_UNPLANSETTLEAMT, (Object)priceTaxTotal);
            BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
            planEntry.set(billModel.P_PLANPRICETAXLOC, (Object)priceTaxTotalLocal);
            planEntry.set(billModel.P_UNPLANSETTLELOCAMT, (Object)priceTaxTotalLocal);
            planEntry.set(billModel.P_PLANDUEDATE, (Object)planRowData.getDueDate());
            planEntry.set(billModel.P_PLANSETTLETYPE, (Object)settlementType);
            planEntry.set(billModel.P_RECORPAY_RATE, (Object)planRowData.getRate());
            planEntry.set(billModel.P_SPLITDIMENSION_ID, (Object)groupData.getSplitDimensionId());
            if ("ap_finapbill".equals(entityName)) {
                planEntry.set("e_freezestate", (Object)"unfreeze");
            }
            planEntries.add((Object)planEntry);
        }
        if (dimensionMappings.size() > 0) {
            Map<Integer, Integer> detailEntryToSplitDimensionId = PlanRowData.convertDetailSplitDimension(planRowDatas);
            DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(billModel.ENTRY);
            int detailEntrySize = detailEntries.size();
            for (int i = 0; i < detailEntrySize; ++i) {
                DynamicObject detailEntry = (DynamicObject)detailEntries.get(i);
                detailEntry.set(billModel.E_SPLITDIMENSION_ID, (Object)detailEntryToSplitDimensionId.get(i));
            }
        } else {
            DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(billModel.ENTRY);
            for (DynamicObject detailEntry : detailEntries) {
                detailEntry.set(billModel.E_SPLITDIMENSION_ID, (Object)0);
            }
        }
        PlanSplitAndBuilder.setHeadDueDate(finBill);
    }

    private static void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }
}

