/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan.split;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.plan.split.IPlanSplitService;
import kd.fi.arapcommon.service.plan.split.entity.ConditionInfo;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;
import kd.fi.arapcommon.service.plan.split.entity.DimensionValue;
import kd.fi.arapcommon.service.plan.split.entity.PlanRowData;
import kd.fi.arapcommon.service.plan.split.helper.ConditionServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitServiceHelper;

public class PlanSplitService
implements IPlanSplitService {
    private static final Log logger = LogFactory.getLog(PlanSplitService.class);
    private static final String DIMENSIONKEY_PREIX = "dimensionkeyPreix";
    private final DynamicObject finBill;
    private final List<String> dimensions;
    private final String entityName;
    private final String detailEntryName;
    private final String detailPriceTaxTotalName;
    private final String detailPriceTaxTotalLocalName;
    private final String priceTaxTotalName;
    private final String priceTaxTotalLocalName;
    private final String paycondName;

    public PlanSplitService(DynamicObject finBill, DynamicObject scheme) {
        this.finBill = finBill;
        this.entityName = finBill.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(this.entityName);
        this.detailEntryName = billModel.ENTRY;
        this.detailPriceTaxTotalName = billModel.E_PRICETAXTOTAL;
        this.detailPriceTaxTotalLocalName = billModel.E_PRICETAXTOTALLOC;
        this.priceTaxTotalName = billModel.HEAD_PRICETAXTOTAL;
        this.priceTaxTotalLocalName = billModel.HEAD_PRICETAXTOTALLOC;
        this.paycondName = billModel.HEAD_PAYCOND;
        this.dimensions = scheme != null ? PlanSplitSchemeServiceHelper.getDimensionsByScheme(scheme) : new ArrayList<String>(8);
        boolean isPlanSettle = SystemParameterHelper.isPlanSettle(finBill.getLong("org.id"), "ar_finarbill".equals(this.entityName));
        boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
        if (!isPlanSettle) {
            if (allowMaterialSplitPlanEntry && PlanSplitServiceHelper.isSplitByCoreBill()) {
                this.dimensions.add(billModel.E_COREBILLNO);
                this.dimensions.add(billModel.E_COREBILLID);
            }
        } else if (PlanSplitServiceHelper.isSplitByCoreBill()) {
            this.dimensions.add(billModel.E_COREBILLNO);
            this.dimensions.add(billModel.E_COREBILLID);
        }
    }

    public PlanSplitService(DynamicObject finBill, List<String> dimensions) {
        this.finBill = finBill;
        this.entityName = finBill.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(this.entityName);
        this.detailEntryName = billModel.ENTRY;
        this.detailPriceTaxTotalName = billModel.E_PRICETAXTOTAL;
        this.detailPriceTaxTotalLocalName = billModel.E_PRICETAXTOTALLOC;
        this.priceTaxTotalName = billModel.HEAD_PRICETAXTOTAL;
        this.priceTaxTotalLocalName = billModel.HEAD_PRICETAXTOTALLOC;
        this.paycondName = billModel.HEAD_PAYCOND;
        this.dimensions = dimensions;
    }

    @Override
    public List<PlanRowData> execute() {
        Map<String, DetailGroupData> detailGroupDataMap = this.groupDetailEntryByDimension();
        return this.splitGroupDataByCondition(detailGroupDataMap);
    }

    private Map<String, DetailGroupData> groupDetailEntryByDimension() {
        logger.info("PlanSplitService.groupDetailEntryByDimension start");
        LinkedHashMap<String, DetailGroupData> detailGroupDataMap = new LinkedHashMap<String, DetailGroupData>(8);
        if (this.dimensions.size() == 0) {
            logger.info("PlanSplitService.groupDetailEntryByDimension no dimension, use head amt");
            DetailGroupData groupData = new DetailGroupData();
            groupData.setSplitDimensionId(0);
            groupData.setPriceTaxTotal(this.finBill.getBigDecimal(this.priceTaxTotalName));
            groupData.setPriceTaxTotalLocal(this.finBill.getBigDecimal(this.priceTaxTotalLocalName));
            detailGroupDataMap.put(DIMENSIONKEY_PREIX, groupData);
        } else {
            DynamicObjectCollection detailEntries = this.finBill.getDynamicObjectCollection(this.detailEntryName);
            ArrayList<DimensionValue> dimensionValues = new ArrayList<DimensionValue>(this.dimensions.size());
            int splitDimensionIndex = 0;
            int detailEntryCount = 0;
            for (DynamicObject detailEntry : detailEntries) {
                for (String string : this.dimensions) {
                    Object value = detailEntry.get(string);
                    dimensionValues.add(new DimensionValue(string, value));
                }
                StringBuilder keySb = new StringBuilder(DIMENSIONKEY_PREIX);
                for (DimensionValue dimensionValue : dimensionValues) {
                    Object value = dimensionValue.getDimensionValue();
                    if (value instanceof DynamicObject) {
                        keySb.append(((DynamicObject)value).getLong("id"));
                        continue;
                    }
                    if (value instanceof String) {
                        keySb.append(value);
                        continue;
                    }
                    keySb.append(value);
                }
                String string = keySb.toString();
                DetailGroupData detailGroupData = (DetailGroupData)detailGroupDataMap.get(string);
                if (detailGroupData == null) {
                    DetailGroupData groupData = new DetailGroupData();
                    groupData.setSplitDimensionId(splitDimensionIndex);
                    ArrayList<Integer> detailEntryIndexs = new ArrayList<Integer>(1);
                    detailEntryIndexs.add(detailEntryCount);
                    groupData.setDetailEntryIndexs(detailEntryIndexs);
                    groupData.setDimensionMap(dimensionValues);
                    groupData.setPriceTaxTotal(detailEntry.getBigDecimal(this.detailPriceTaxTotalName));
                    groupData.setPriceTaxTotalLocal(detailEntry.getBigDecimal(this.detailPriceTaxTotalLocalName));
                    detailGroupDataMap.put(string, groupData);
                    ++splitDimensionIndex;
                } else {
                    detailGroupData.getDetailEntryIndexs().add(detailEntryCount);
                    detailGroupData.setPriceTaxTotal(detailGroupData.getPriceTaxTotal().add(detailEntry.getBigDecimal(this.detailPriceTaxTotalName)));
                    detailGroupData.setPriceTaxTotalLocal(detailGroupData.getPriceTaxTotalLocal().add(detailEntry.getBigDecimal(this.detailPriceTaxTotalLocalName)));
                }
                dimensionValues.clear();
                ++detailEntryCount;
            }
        }
        logger.info("PlanSplitService.groupDetailEntryByDimension end");
        return detailGroupDataMap;
    }

    private List<PlanRowData> splitGroupDataByCondition(Map<String, DetailGroupData> detailGroupDataMap) {
        logger.info("PlanSplitService.splitGroupDataByCondition start");
        DynamicObject condition = this.finBill.getDynamicObject(this.paycondName);
        ArrayList<PlanRowData> result = new ArrayList<PlanRowData>(detailGroupDataMap.size());
        if (condition == null) {
            Date basicDate = ConditionServiceHelper.getBasicDate(this.finBill);
            for (Map.Entry<String, DetailGroupData> detailGroupDataEntry : detailGroupDataMap.entrySet()) {
                PlanRowData planRowData = new PlanRowData(detailGroupDataEntry.getValue(), basicDate);
                result.add(planRowData);
            }
        } else {
            condition = BusinessDataServiceHelper.loadSingleFromCache((Object)condition.getLong("id"), (String)condition.getDynamicObjectType().getName());
            int precision = this.getPrecision(this.finBill);
            int basePrecision = this.getBasePrecision(this.finBill);
            String quotation = this.getQuotation();
            BigDecimal exchange = this.getExchange();
            if (exchange != null && exchange.compareTo(BigDecimal.ZERO) == 0) {
                exchange = new BigDecimal(1);
            }
            Date basicDate = ConditionServiceHelper.getBasicDate(this.finBill);
            List<ConditionInfo> conditionInfos = ConditionServiceHelper.loadConditionInfo(condition, basicDate);
            BigDecimal hundred = new BigDecimal(100);
            for (Map.Entry<String, DetailGroupData> detailGroupDataEntry : detailGroupDataMap.entrySet()) {
                DetailGroupData detailGroupData = detailGroupDataEntry.getValue();
                BigDecimal priceTaxTotal = detailGroupData.getPriceTaxTotal();
                BigDecimal priceTaxTotalLocal = detailGroupData.getPriceTaxTotalLocal();
                int count = 0;
                BigDecimal remainAmount = BigDecimal.ZERO;
                BigDecimal remainAmountLocal = BigDecimal.ZERO;
                ArrayList<PlanRowData> tempResultList = new ArrayList<PlanRowData>(conditionInfos.size());
                for (ConditionInfo conditionInfo : conditionInfos) {
                    ++count;
                    BigDecimal rate = conditionInfo.getRate();
                    DetailGroupData groupData = new DetailGroupData();
                    groupData.setDimensionMap(detailGroupData.getDimensionMap());
                    groupData.setDetailEntryIndexs(detailGroupData.getDetailEntryIndexs());
                    groupData.setSplitDimensionId(detailGroupData.getSplitDimensionId());
                    if (count == conditionInfos.size()) {
                        groupData.setPriceTaxTotal(priceTaxTotal.subtract(remainAmount));
                        groupData.setPriceTaxTotalLocal(priceTaxTotalLocal.subtract(remainAmountLocal));
                    } else {
                        BigDecimal dimensionPriceTaxTotal = priceTaxTotal.multiply(rate).divide(hundred, precision, RoundingMode.HALF_UP);
                        BigDecimal dimensionPriceTaxTotalLocal = this.getLocalAmt(dimensionPriceTaxTotal, quotation, exchange, basePrecision);
                        remainAmount = remainAmount.add(dimensionPriceTaxTotal);
                        remainAmountLocal = remainAmountLocal.add(dimensionPriceTaxTotalLocal);
                        groupData.setPriceTaxTotal(dimensionPriceTaxTotal);
                        groupData.setPriceTaxTotalLocal(dimensionPriceTaxTotalLocal);
                    }
                    Date dueDate = conditionInfo.getDueDate();
                    PlanRowData planRowData = new PlanRowData(groupData, rate, dueDate);
                    tempResultList.add(planRowData);
                }
                this.handleLastRowNegative(tempResultList, priceTaxTotalLocal);
                result.addAll(tempResultList);
            }
        }
        logger.info("PlanSplitService.splitGroupDataByCondition end");
        return result;
    }

    private int getPrecision(DynamicObject finBill) {
        int precision = 2;
        DynamicObject currency = finBill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    private int getBasePrecision(DynamicObject finBill) {
        int basePrecision = 2;
        DynamicObject basecurrency = finBill.getDynamicObject("basecurrency");
        if (!ObjectUtils.isEmpty((Object)basecurrency)) {
            basePrecision = basecurrency.getInt("amtprecision");
        }
        return basePrecision;
    }

    private String getQuotation() {
        return this.finBill.getString("quotation");
    }

    private BigDecimal getExchange() {
        return this.finBill.getBigDecimal("exchangerate");
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }

    private void handleLastRowNegative(List<PlanRowData> tempResultList, BigDecimal priceTaxTotalLocal) {
        if (!ObjectUtils.isEmpty(tempResultList)) {
            for (int i = tempResultList.size() - 1; i >= 0; --i) {
                PlanRowData planRowData = tempResultList.get(i);
                DetailGroupData groupData = planRowData.getGroupData();
                BigDecimal planRowPriceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
                if (i == tempResultList.size() - 1 && planRowPriceTaxTotalLocal.multiply(priceTaxTotalLocal).compareTo(BigDecimal.ZERO) > 0) break;
                logger.info("PlanSplitService handleLastRowNegative handle is start lastrow locamt is " + planRowPriceTaxTotalLocal);
                if (planRowPriceTaxTotalLocal.multiply(priceTaxTotalLocal).compareTo(BigDecimal.ZERO) <= 0) {
                    groupData.setPriceTaxTotalLocal(BigDecimal.ZERO);
                    continue;
                }
                BigDecimal tempAllLocAmt = BigDecimal.ZERO;
                for (PlanRowData rowData : tempResultList) {
                    tempAllLocAmt = tempAllLocAmt.add(rowData.getGroupData().getPriceTaxTotalLocal());
                }
                BigDecimal groupDiffLocAmt = priceTaxTotalLocal.subtract(tempAllLocAmt);
                if (planRowPriceTaxTotalLocal.add(groupDiffLocAmt).multiply(priceTaxTotalLocal).compareTo(BigDecimal.ZERO) >= 0) {
                    groupData.setPriceTaxTotalLocal(planRowPriceTaxTotalLocal.add(groupDiffLocAmt));
                    break;
                }
                groupData.setPriceTaxTotalLocal(BigDecimal.ZERO);
            }
        }
    }
}

