/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.rpascheme.RPASchemeServiceHelper;
import kd.fi.arapcommon.service.rpascheme.RPASchemeSettleLogService;
import kd.fi.arapcommon.service.rpascheme.RPASettleServiceProxy;
import kd.fi.arapcommon.service.rpascheme.dataloader.RPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.RPABillDataLoaderFactory;
import kd.fi.arapcommon.service.rpascheme.entity.AsstactDimensionEnum;
import kd.fi.arapcommon.service.rpascheme.entity.BillEntryInfo;
import kd.fi.arapcommon.service.rpascheme.entity.DimensionMatchInfo;
import kd.fi.arapcommon.service.rpascheme.entity.MatchParam;
import kd.fi.arapcommon.service.rpascheme.entity.MatchStrategyEnum;
import kd.fi.arapcommon.service.rpascheme.entity.RPABillDataParam;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class RPASchemeSettleService {
    protected static final Log logger = LogFactory.getLog(RPASchemeSettleService.class);
    private static final int SETTLE_BATCH_SIZE = 10000;
    private final boolean isManual;

    public RPASchemeSettleService() {
        this(true);
    }

    public RPASchemeSettleService(boolean isManual) {
        this.isManual = isManual;
    }

    public void execute(DynamicObject scheme) {
        this.addControl(scheme);
        try {
            DynamicObjectCollection ruleEntries = scheme.getDynamicObjectCollection("ruleentry");
            DynamicObjectCollection orgEntries = scheme.getDynamicObjectCollection("orgentry");
            for (DynamicObject orgEntry : orgEntries) {
                for (DynamicObject ruleEntry : ruleEntries) {
                    long orgId = orgEntry.getLong("org.id");
                    String settleRelation = ruleEntry.getString("settlerelation");
                    if (this.isLiqSettle(settleRelation)) {
                        this.doExecuteLiq(orgId, ruleEntry, scheme);
                        continue;
                    }
                    this.doExecute(orgId, ruleEntry, scheme);
                }
            }
        }
        catch (Exception e) {
            logger.error("RPASchemeSettleService.execute() error", (Throwable)e);
            throw e;
        }
        finally {
            this.releaseControl(scheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(long orgId, DynamicObject ruleEntry, DynamicObject scheme) {
        int n;
        int settleModel;
        String timeOrder = ruleEntry.getString("timeorder");
        String asstactMatch = ruleEntry.getString("asstactmatch");
        String settleRelation = ruleEntry.getString("settlerelation");
        String mainBillKey = ruleEntry.getString("mainbill");
        String asstBillKey = ruleEntry.getString("asstbill");
        String mainFilter = ruleEntry.getString("mainfilter_tag");
        String asstFilter = ruleEntry.getString("asstfilter_tag");
        String mainDateSrc = ruleEntry.getString("maindatesrc");
        String asstDateSrc = ruleEntry.getString("asstdatesrc");
        String matchfieldInfo = ruleEntry.getString("matchfieldinfo");
        logger.info("RPASchemeSettleService.doExecute settleRelation:" + settleRelation);
        DynamicObject settleLog = RPASchemeSettleLogService.newSettleLog(scheme, orgId, ruleEntry, this.settleLogEntity(), this.isManual);
        List<DimensionMatchInfo> mainDimensionMatchInfo = this.buildDimensionMatchInfos(asstactMatch, matchfieldInfo, mainBillKey, true);
        List<DimensionMatchInfo> asstDimensionMatchInfo = this.buildDimensionMatchInfos(asstactMatch, matchfieldInfo, asstBillKey, false);
        boolean isAfterMatch = RPASchemeServiceHelper.isAfterMatch();
        logger.info("RPASchemeSettleService.doExecute isAfterMatch:" + isAfterMatch);
        logger.info("RPASchemeSettleService.doExecute mainDimensionMatchInfo:" + mainDimensionMatchInfo);
        logger.info("RPASchemeSettleService.doExecute asstDimensionMatchInfo:" + asstDimensionMatchInfo);
        HashSet<String> mainMatchFields = new HashSet<String>(8);
        HashSet<String> asstMatchFields = new HashSet<String>(8);
        List<Map<String, Object>> fieldEntrys = new ArrayList(1);
        if (isAfterMatch && StringUtils.isNotEmpty(matchfieldInfo)) {
            fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchfieldInfo, List.class);
            for (Map map : fieldEntrys) {
                String mainField = (String)map.get("mainfield");
                mainMatchFields.add(mainField);
                String asstField = (String)map.get("asstfield");
                asstMatchFields.add(asstField);
            }
        }
        int n2 = settleModel = this.getSettleModel(orgId, mainBillKey);
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            n = this.getSettleModel(orgId, asstBillKey);
        }
        boolean isLoadPartner = this.isLoadPartner(asstactMatch, settleRelation);
        RPABillDataParam mainBillParam = RPABillDataParam.New().setEntityName(mainBillKey).setOrgId(orgId).setSettleModel(settleModel).setLoadPartner(isLoadPartner).setFilterCondition(mainFilter).setDateSrc(mainDateSrc).setTimeOrder(timeOrder).setDimensionMatchInfos(mainDimensionMatchInfo).setMatchFields(mainMatchFields);
        RPABillDataLoader mainBillDataLoader = RPABillDataLoaderFactory.createInstance(mainBillKey, mainBillParam);
        RPABillDataParam asstBillParam = RPABillDataParam.New().setEntityName(asstBillKey).setOrgId(orgId).setSettleModel(n).setLoadPartner(isLoadPartner).setFilterCondition(asstFilter).setDateSrc(asstDateSrc).setTimeOrder(timeOrder).setDimensionMatchInfos(asstDimensionMatchInfo).setMatchFields(asstMatchFields);
        RPABillDataLoader asstBillDataLoader = RPABillDataLoaderFactory.createInstance(asstBillKey, asstBillParam);
        try {
            Map<String, List<BillEntryInfo>> mainDimensionMapping = mainBillDataLoader.loadDimensionMapping();
            Map<String, List<BillEntryInfo>> asstDimensionMapping = asstBillDataLoader.loadDimensionMapping();
            Set<Long> mainBillIds = this.getBillIdSet(mainDimensionMapping);
            Set<Long> asstBillIds = this.getBillIdSet(asstDimensionMapping);
            Set<Long> mainBillEntryIds = this.getBillEntryIdSet(mainDimensionMapping);
            Set<Long> asstBillEntryIds = this.getBillEntryIdSet(asstDimensionMapping);
            RPASchemeSettleLogService.updateCount(settleLog, mainBillIds.size(), mainBillEntryIds.size(), asstBillIds.size(), asstBillEntryIds.size());
            if (mainDimensionMapping.size() == 0 || asstDimensionMapping.size() == 0) {
                RPASchemeSettleLogService.updateSuccess(settleLog);
                return;
            }
            AbstractSettleTemplate service = (AbstractSettleTemplate)new RPASettleServiceProxy().getInstance(this.getSettleService(settleRelation), settleLog);
            SettleSchemeVO schemeVO = new SettleSchemeVO();
            schemeVO.setSettle(true);
            schemeVO.setSchemeSettle(true);
            schemeVO.setRpaSchemeSettle(true);
            schemeVO.setSettleEntryParam(settleModel);
            if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
                schemeVO.setAsstSettleEntryParam(n);
            }
            if (isAfterMatch) {
                schemeVO.setMatchFieldMap(fieldEntrys);
            }
            int settleBatchSize = this.getSettleBatchSize();
            HashSet<Long> mainIds = new HashSet<Long>(10000);
            ArrayList<Long> mainEntryIds = new ArrayList<Long>(10000);
            HashSet<Long> asstIds = new HashSet<Long>(10000);
            ArrayList<Long> asstEntryIds = new ArrayList<Long>(10000);
            HashSet<Long> mainIdCounts = new HashSet<Long>(10000);
            HashSet<Long> asstIdCounts = new HashSet<Long>(10000);
            for (Map.Entry<String, List<BillEntryInfo>> mainDimension : mainDimensionMapping.entrySet()) {
                String dimensionId = mainDimension.getKey();
                List<BillEntryInfo> mainBillEntryInfos = mainDimension.getValue();
                List<BillEntryInfo> asstBillEntryInfos = asstDimensionMapping.get(dimensionId);
                if (asstBillEntryInfos == null || asstBillEntryInfos.size() <= 0) continue;
                int batchSize = mainBillEntryInfos.size();
                for (int i = 0; i < batchSize; i += settleBatchSize) {
                    List<BillEntryInfo> mainBillInfos = mainBillEntryInfos.subList(i, Math.min(batchSize, i + settleBatchSize));
                    for (BillEntryInfo entryInfo : mainBillInfos) {
                        mainIds.add(entryInfo.getId());
                        mainEntryIds.add(entryInfo.getEntryId());
                    }
                    int remainSettleRecordCount = 0;
                    BigDecimal remainMainSettleAmt = BigDecimal.ZERO;
                    BigDecimal remainAsstSettleAmt = BigDecimal.ZERO;
                    int asstBatchSize = asstBillEntryInfos.size();
                    for (int j = 0; j < asstBatchSize; j += settleBatchSize) {
                        List<BillEntryInfo> asstBillInfos = asstBillEntryInfos.subList(j, Math.min(asstBatchSize, j + settleBatchSize));
                        for (BillEntryInfo entryInfo : asstBillInfos) {
                            asstIds.add(entryInfo.getId());
                            asstEntryIds.add(entryInfo.getEntryId());
                        }
                        try (TXHandle tx = TX.requiresNew((String)"rpabatchsettle");){
                            try {
                                DynamicObject[] settleRecords;
                                CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainIds, mainBillKey, asstIds, asstBillKey, false);
                                DynamicObject[] mainBills = mainBillDataLoader.loadBillsByIdAndEntryId(mainIds, mainEntryIds);
                                DynamicObject[] asstBills = asstBillDataLoader.loadBillsByIdAndEntryId(asstIds, asstEntryIds);
                                if (isAfterMatch) {
                                    schemeVO.setMainFieldValueMap(this.getMatchFieldMap(mainBills, mainMatchFields, schemeVO, true));
                                    schemeVO.setAsstFieldValueMap(this.getMatchFieldMap(asstBills, asstMatchFields, schemeVO, false));
                                }
                                this.processBillSettleAmt(mainBills, settleModel);
                                this.processBillSettleAmt(asstBills, n);
                                service.settle(mainBills, asstBills, schemeVO, SettleTypeEnum.RPAMATCH.getValue());
                                List<Object> settleRecordIds = schemeVO.getRecordPks();
                                remainSettleRecordCount += settleRecordIds != null ? settleRecordIds.size() : 0;
                                for (DynamicObject settleRecord : settleRecords = BusinessDataServiceHelper.load((String)this.settleRecordEntity(), (String)"totalsettleamt,entry.settleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", settleRecordIds)})) {
                                    remainMainSettleAmt = remainMainSettleAmt.add(settleRecord.getBigDecimal("totalsettleamt"));
                                    DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
                                    for (DynamicObject entry : entries) {
                                        remainAsstSettleAmt = remainAsstSettleAmt.add(entry.getBigDecimal("settleamt"));
                                    }
                                }
                                schemeVO.setRecordPks(null);
                            }
                            catch (Throwable e) {
                                tx.markRollback();
                                throw e;
                            }
                        }
                        asstIdCounts.addAll(asstIds);
                        asstIds.clear();
                        asstEntryIds.clear();
                    }
                    mainIdCounts.addAll(mainIds);
                    RPASchemeSettleLogService.updateProgress(settleLog, mainIdCounts.size(), asstIdCounts.size(), remainSettleRecordCount, remainMainSettleAmt, remainAsstSettleAmt);
                    mainIds.clear();
                    mainEntryIds.clear();
                    if (!RPASchemeSettleLogService.isStop(settleLog)) continue;
                    return;
                }
            }
            RPASchemeSettleLogService.updateSuccess(settleLog);
        }
        catch (Throwable e) {
            String message = ArApHelper.getStackTraceMessage(e);
            RPASchemeSettleLogService.catchException(settleLog, message);
        }
        finally {
            RPASchemeSettleLogService.updateProgressComplete(settleLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteLiq(long orgId, DynamicObject ruleEntry, DynamicObject scheme) {
        String message;
        String timeOrder = ruleEntry.getString("timeorder");
        String mainBillKey = ruleEntry.getString("mainbill");
        String mainFilter = ruleEntry.getString("mainfilter_tag");
        String mainDateSrc = ruleEntry.getString("maindatesrc");
        int settleModel = this.getSettleModel(orgId, mainBillKey);
        RPABillDataParam mainBillParam = RPABillDataParam.New().setEntityName(mainBillKey).setOrgId(orgId).setSettleModel(settleModel).setFilterCondition(mainFilter).setDateSrc(mainDateSrc).setTimeOrder(timeOrder);
        RPABillDataLoader mainBillDataLoader = RPABillDataLoaderFactory.createInstance(mainBillKey, mainBillParam);
        DynamicObject settleLog = RPASchemeSettleLogService.newSettleLog(scheme, orgId, ruleEntry, this.settleLogEntity(), this.isManual);
        try {
            Map<String, List<BillEntryInfo>> mainDimensionMapping = mainBillDataLoader.loadDimensionMapping();
            if (mainDimensionMapping.isEmpty()) {
                RPASchemeSettleLogService.updateSuccess(settleLog);
                return;
            }
            ArrayList<Long> mainIds = new ArrayList<Long>(10000);
            int settleBatchSize = this.getSettleBatchSize();
            for (Map.Entry<String, List<BillEntryInfo>> entry : mainDimensionMapping.entrySet()) {
                List<BillEntryInfo> mainBillEntryInfos = entry.getValue();
                List idInfoList = mainBillEntryInfos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BillEntryInfo>(Comparator.comparing(v -> v.getId()))), ArrayList::new));
                RPASchemeSettleLogService.updateCount(settleLog, idInfoList.size(), mainBillEntryInfos.size(), 0, 0);
                int batchSize = idInfoList.size();
                for (int i = 0; i < batchSize; i += settleBatchSize) {
                    List mainBillInfos = idInfoList.subList(i, Math.min(batchSize, i + settleBatchSize));
                    for (BillEntryInfo entryInfo : mainBillInfos) {
                        mainIds.add(entryInfo.getId());
                    }
                    try (TXHandle tx = TX.requiresNew((String)"rpabatchsettle");){
                        try {
                            CommonSettleServiceHelper.settleAddMutexCtrlInTX(new HashSet<Long>(mainIds), mainBillKey, false);
                            this.liqSettle(mainBillKey, mainIds, settleLog, orgId);
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            throw e;
                        }
                    }
                    mainIds.clear();
                    if (!RPASchemeSettleLogService.isStop(settleLog)) continue;
                    return;
                }
            }
            RPASchemeSettleLogService.updateSuccess(settleLog);
        }
        catch (KDBizException e) {
            message = e.getMessage();
            RPASchemeSettleLogService.catchException(settleLog, message);
        }
        catch (Throwable e) {
            message = ArApHelper.getStackTraceMessage(e);
            RPASchemeSettleLogService.catchException(settleLog, message);
        }
        finally {
            RPASchemeSettleLogService.updateProgressComplete(settleLog);
        }
    }

    protected void liqSettle(String mainBillKey, List<Long> mainIds, DynamicObject settleLog, long orgId) {
        List liquidationBills;
        if (ObjectUtils.isEmpty(mainIds)) {
            RPASchemeSettleLogService.updateProgress(settleLog, 0, 0, 0, BigDecimal.ZERO, BigDecimal.ZERO);
            return;
        }
        String liquidateBillKey = "ap_finapbill".equals(mainBillKey) || "cas_paybill".equals(mainBillKey) || "ap_paidbill".equals(mainBillKey) ? "ap_liquidation" : "ar_liquidation";
        HashMap<String, String> customParam = new HashMap<String, String>(1);
        customParam.put("orgId", String.valueOf(orgId));
        Map<String, Object> resultMap = BOTPHelper.push4Result(mainBillKey, liquidateBillKey, null, mainIds, customParam);
        Object target = resultMap.get("convertResult");
        if (target != null) {
            ConvertOperationResult convertResult = (ConvertOperationResult)target;
            String convertReport = BOTPHelper.getConvertReport(convertResult);
            if (StringUtils.isEmpty(convertReport)) {
                convertReport = convertResult.getMessage();
            }
            logger.info("------botp.ConvertReport------" + convertReport);
            RPASchemeSettleLogService.catchException(settleLog, convertReport);
        }
        if (ObjectUtils.isEmpty((Object)(liquidationBills = (List)resultMap.get("trgBills")))) {
            RPASchemeSettleLogService.updateProgress(settleLog, 0, 0, 0, BigDecimal.ZERO, BigDecimal.ZERO);
            return;
        }
        DynamicObject[] liquidationBillArr = liquidationBills.toArray(new DynamicObject[0]);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "false");
        operateOption.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)liquidateBillKey, (DynamicObject[])liquidationBillArr, (OperateOption)operateOption);
        try {
            OperationHelper.assertResult(liquidateBillKey, saveResult);
        }
        catch (KDBizException e) {
            String message = e.getMessage();
            RPASchemeSettleLogService.catchException(settleLog, message);
        }
        List saveIds = saveResult.getSuccessPkIds();
        if (saveIds.size() == 0) {
            RPASchemeSettleLogService.updateProgress(settleLog, 0, 0, 0, BigDecimal.ZERO, BigDecimal.ZERO);
            return;
        }
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)liquidateBillKey, (Object[])saveIds.toArray(new Long[0]), (OperateOption)operateOption);
        try {
            OperationHelper.assertResult(liquidateBillKey, submitResult);
        }
        catch (KDBizException e) {
            String message = e.getMessage();
            RPASchemeSettleLogService.catchException(settleLog, message);
        }
        int successCount = 0;
        int settleRecordCount = 0;
        BigDecimal sumAmt = BigDecimal.ZERO;
        List ids = submitResult.getSuccessPkIds();
        if (ids.size() > 0) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)liquidateBillKey, (Object[])ids.toArray(new Long[0]), (OperateOption)operateOption);
            try {
                OperationHelper.assertResult(liquidateBillKey, auditResult);
            }
            catch (KDBizException e) {
                String message = e.getMessage();
                RPASchemeSettleLogService.catchException(settleLog, message);
            }
            List resultIds = auditResult.getSuccessPkIds();
            if (resultIds.size() > 0) {
                QFilter filter = new QFilter("mainbillid", "in", mainIds);
                filter.and(new QFilter("settlerelation", "in", (Object)new String[]{SettleRelationEnum.APLIQUIDATIONSETTLE.getValue(), SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue(), SettleRelationEnum.RECCLEARINGSETTLE.getValue(), SettleRelationEnum.PAYCLEARINGSETTLE.getValue()}));
                DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)this.settleRecordEntity(), (String)"mainbillid,settlelogentryid,settletype,totalsettleamt", (QFilter[])filter.toArray());
                Object logPK = settleLog.getPkValue();
                HashSet<Object> mainIdSet = new HashSet<Object>(settleRecords.length);
                for (DynamicObject settleRecord : settleRecords) {
                    Long settlelogentryid = settleRecord.getLong("settlelogentryid");
                    if (settlelogentryid != null && settlelogentryid != 0L) continue;
                    settleRecord.set("settlelogentryid", logPK);
                    settleRecord.set("settletype", (Object)SettleTypeEnum.RPAMATCH.getValue());
                    BigDecimal totalsettleamt = settleRecord.getBigDecimal("totalsettleamt");
                    sumAmt = sumAmt.add(totalsettleamt);
                    ++settleRecordCount;
                    mainIdSet.add(settleRecord.get("mainbillid"));
                }
                SaveServiceHelper.update((DynamicObject[])settleRecords);
                successCount = mainIdSet.size();
            }
        }
        RPASchemeSettleLogService.updateProgress(settleLog, successCount, 0, settleRecordCount, sumAmt, BigDecimal.ZERO);
    }

    @Deprecated
    protected void liqSettle(String mainBillKey, List<Long> mainIds, DynamicObject settleLog) {
    }

    private List<DimensionMatchInfo> buildDimensionMatchInfos(String asstactMatch, String matchInfo, String billKey, boolean isMain) {
        ArrayList<DimensionMatchInfo> dimensionKeys = new ArrayList<DimensionMatchInfo>(64);
        if (this.isAsstactSame(asstactMatch)) {
            DimensionMatchInfo asstactMatchInfo = DimensionMatchInfo.New().setDimensionKey(AsstactDimensionEnum.getAsstactKey(billKey)).setMatchMode(MatchStrategyEnum.EQUAL.getMatchMode()).setMatchParam(new MatchParam());
            dimensionKeys.add(asstactMatchInfo);
        }
        if (RPASchemeServiceHelper.isAfterMatch()) {
            return dimensionKeys;
        }
        if (StringUtils.isNotEmpty(matchInfo)) {
            List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchInfo, List.class);
            for (Map entry : fieldEntrys) {
                String mainMatchMode = (String)entry.get("matchrelation");
                String splitSign = (String)entry.get("splitsign");
                if (isMain) {
                    String mainField = (String)entry.get("mainfield");
                    dimensionKeys.add(DimensionMatchInfo.New().setDimensionKey(mainField).setMatchMode(mainMatchMode).setMatchParam(new MatchParam(splitSign)));
                    continue;
                }
                String asstField = (String)entry.get("asstfield");
                dimensionKeys.add(DimensionMatchInfo.New().setDimensionKey(asstField).setMatchMode(mainMatchMode).setMatchParam(new MatchParam(splitSign)));
            }
        }
        return dimensionKeys;
    }

    private Map<Long, Map<String, Object>> getMatchFieldMap(DynamicObject[] bills, Set<String> matchFields, SettleSchemeVO schemeVO, boolean isMain) {
        HashMap map = null;
        if (matchFields != null && matchFields.size() > 0) {
            map = new HashMap(64);
            boolean isPlanSettle = schemeVO.getSettleEntryParam() == 2;
            String settleRelation = schemeVO.getSettleRelation();
            if (!isMain && (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation))) {
                isPlanSettle = schemeVO.getAsstSettleEntryParam() == 2;
            }
            for (DynamicObject bill : bills) {
                EntityType dataEntityType = (EntityType)bill.getDataEntityType();
                List entryEntities = EntityTypeUtil.getEntryEntities((EntityType)dataEntityType);
                String entryKey = ((EntryEntityDto)entryEntities.get(1)).getKey();
                if (isPlanSettle) {
                    for (EntryEntityDto entryDto : entryEntities) {
                        if (!entryDto.getKey().contains("plan")) continue;
                        entryKey = entryDto.getKey();
                        break;
                    }
                }
                DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryKey);
                for (DynamicObject entry : entries) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
                    for (String fieldName : matchFields) {
                        if (fieldName.startsWith(entryKey)) {
                            dataMap.put(fieldName, entry.get(fieldName.substring(entryKey.length() + 1)));
                            continue;
                        }
                        dataMap.put(fieldName, bill.get(fieldName));
                    }
                    map.put(entry.getLong("id"), dataMap);
                }
            }
        }
        return map;
    }

    protected void processBillSettleAmt(DynamicObject[] bills, int settleModel) {
        String entityName = bills[0].getDataEntityType().getName();
        if ("ap_finapbill".equals(entityName)) {
            this.processApBillAmt(bills, settleModel);
        } else if ("ar_finarbill".equals(entityName)) {
            this.processArBillAmt(bills, settleModel);
        }
    }

    private void processApBillAmt(DynamicObject[] objs, int settleModel) {
        for (DynamicObject obj : objs) {
            if (settleModel == 1) {
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entrys) {
                    entry.set("settledamt", entry.get("lockedamt"));
                    entry.set("unsettleamt", entry.get("unlockamt"));
                }
                continue;
            }
            DynamicObjectCollection planEntrys = obj.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : planEntrys) {
                entry.set("plansettledamt", entry.get("planlockedamt"));
                entry.set("unplansettleamt", entry.get("unplanlockamt"));
            }
        }
    }

    private void processArBillAmt(DynamicObject[] objs, int settleModel) {
        for (DynamicObject obj : objs) {
            if (settleModel == 1) {
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    entry.set("e_settledamt", entry.get("e_lockedamt"));
                    entry.set("e_unsettleamt", entry.get("e_unlockamt"));
                }
                continue;
            }
            DynamicObjectCollection planEntrys = obj.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : planEntrys) {
                entry.set("plansettledamt", entry.get("planlockedamt"));
                entry.set("unplansettleamt", entry.get("unplanlockamt"));
            }
        }
    }

    private int getSettleModel(long orgId, String mainBillKey) {
        int settleParam = 1;
        if ("ar_finarbill".equals(mainBillKey) || "cas_recbill".equals(mainBillKey)) {
            settleParam = ArApHelper.getArSettleParam(orgId);
        } else if ("ap_finapbill".equals(mainBillKey) || "cas_paybill".equals(mainBillKey)) {
            settleParam = ArApHelper.getApSettleParam(orgId);
        }
        return settleParam;
    }

    private boolean isLoadPartner(String asstactMatch, String settleRelation) {
        boolean result = false;
        if (this.isAsstactSame(asstactMatch) && (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation))) {
            result = true;
        }
        return result;
    }

    private boolean isAsstactSame(String asstactMatch) {
        return "0".equals(asstactMatch);
    }

    private int getSettleBatchSize() {
        String settleBatchSize = StdConfig.get("rpasettle.batchsize");
        return settleBatchSize == null ? 10000 : Integer.parseInt(settleBatchSize);
    }

    private void addControl(DynamicObject scheme) {
        HashSet<Long> idSet = new HashSet<Long>(1);
        idSet.add(scheme.getLong("id"));
        String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6b63\u5728\u6267\u884cRPA\u667a\u80fd\u7ed3\u7b97\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"RPASchemeSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        MutexLockHelper.requireMutex(scheme.getDataEntityType().getName(), idSet, "rpasettle", errorInfo);
    }

    private void releaseControl(DynamicObject scheme) {
        HashSet<Long> idSet = new HashSet<Long>(1);
        idSet.add(scheme.getLong("id"));
        MutexLockHelper.batchRelease(scheme.getDataEntityType().getName(), idSet, "rpasettle");
    }

    private void addSettleControl(String mainNumber, Set<Long> mainIds, String asstNumber, Set<Long> asstIds) {
        CommonSettleServiceHelper.settleAddMutexCtrl(mainIds, mainNumber, asstIds, asstNumber, false);
    }

    private void releaseSettleControl() {
        CommonSettleServiceHelper.settleReleaseMutexCtrl();
    }

    private Set<Long> getBillIdSet(Map<String, List<BillEntryInfo>> dimensionMapping) {
        HashSet<Long> billIdSet = new HashSet<Long>(8);
        dimensionMapping.forEach((key, value) -> {
            for (BillEntryInfo billEntryInfo : value) {
                billIdSet.add(billEntryInfo.getId());
            }
        });
        return billIdSet;
    }

    private Set<Long> getBillEntryIdSet(Map<String, List<BillEntryInfo>> dimensionMapping) {
        HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
        dimensionMapping.forEach((key, value) -> {
            for (BillEntryInfo billEntryInfo : value) {
                billEntryIdSet.add(billEntryInfo.getEntryId());
            }
        });
        return billEntryIdSet;
    }

    private boolean isLiqSettle(String settleRelation) {
        return SettleRelationEnum.APLIQUIDATIONSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation);
    }

    protected abstract String settleLogEntity();

    protected abstract String settleRecordEntity();

    protected abstract AbstractSettleTemplate getSettleService(String var1);
}

