/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme.dataloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.DimensionJoiner;
import kd.fi.arapcommon.service.DimensionValueResolver;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.rpascheme.dataloader.RPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.entity.BillEntryInfo;
import kd.fi.arapcommon.service.rpascheme.entity.DimensionMatchInfo;
import kd.fi.arapcommon.service.rpascheme.entity.MatchParam;
import kd.fi.arapcommon.service.rpascheme.entity.MatchStrategyEnum;
import kd.fi.arapcommon.service.rpascheme.entity.RPABillDataParam;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class AbstractRPABillDataLoader
implements RPABillDataLoader {
    private static final String DIMENSION_PREIX = "dimensionPrefix";
    protected long orgId;
    protected int settleModel;
    protected QFilter filter;
    protected String timeOrder;
    protected List<DimensionMatchInfo> dimensionMatchInfos;
    protected String entityName;
    protected boolean isLoadPartner;
    protected Set<String> matchFields;

    protected AbstractRPABillDataLoader(RPABillDataParam param) {
        this.orgId = param.getOrgId();
        this.settleModel = param.getSettleModel();
        this.entityName = param.getEntityName();
        this.filter = this.getFilter(param.getFilterCondition(), this.entityName);
        this.timeOrder = param.getDateSrc() + " " + param.getTimeOrder();
        this.dimensionMatchInfos = param.getDimensionMatchInfos();
        this.isLoadPartner = param.isLoadPartner();
        this.matchFields = param.getMatchFields();
    }

    @Override
    public DynamicObject[] loadBillsByIdAndEntryId(Set<Long> ids, List<Long> entryIds) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.getBillSelector()), (QFilter[])qFilter.toArray(), (String)this.timeOrder);
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(entryIds.size());
        for (Long entryId : entryIds) {
            entryIdMap.put(entryId, entryId);
        }
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(this.entityEntryName());
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                long entryId = entry.getLong("id");
                if (entryIdMap.get(entryId) != null) continue;
                iterator.remove();
            }
        }
        return bills;
    }

    @Override
    public Map<String, List<BillEntryInfo>> loadDimensionMapping() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadDimensionMapping", (String)this.entityName, (String)String.join((CharSequence)",", this.getDimensionSelector()), (QFilter[])this.filter.toArray(), (String)this.timeOrder);
        List<Map<String, Object>> dataList = this.dataSet2List(dataSet);
        dataSet.close();
        if (this.isLoadPartner) {
            this.repairDataListByPartner(dataList);
        } else {
            this.repairDataListByMaster(dataList);
        }
        Map<Long, Long> unFinishedIdMap = this.loadUnfinishedIdMap(dataList);
        HashMap<String, List<BillEntryInfo>> resultMap = new HashMap<String, List<BillEntryInfo>>(8);
        for (Map<String, Object> rowData : dataList) {
            Long id = (Long)rowData.get("id");
            if (unFinishedIdMap.get(id) != null) continue;
            Long entryId = (Long)rowData.get("entryId");
            Set<String> dimensionKeys = this.buildDimensionKeys(rowData);
            for (String dimensionKey : dimensionKeys) {
                BillEntryInfo info = new BillEntryInfo(id, entryId);
                if (resultMap.get(dimensionKey) != null) {
                    ((List)resultMap.get(dimensionKey)).add(info);
                    continue;
                }
                ArrayList<BillEntryInfo> entryInfos = new ArrayList<BillEntryInfo>(8);
                entryInfos.add(info);
                resultMap.put(dimensionKey, entryInfos);
            }
        }
        return resultMap;
    }

    protected Map<Long, Long> loadUnfinishedIdMap(List<Map<String, Object>> dataList) {
        return new HashMap<Long, Long>(1);
    }

    private List<Map<String, Object>> dataSet2List(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(64);
        for (Row row : dataSet) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>(8);
            int fieldCount = rowMeta.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                String fieldName = rowMeta.getFieldName(i);
                Object value = row.get(i);
                rowMap.put(fieldName, value);
            }
            dataList.add(rowMap);
        }
        return dataList;
    }

    private void repairDataListByPartner(List<Map<String, Object>> dataList) {
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        for (Map<String, Object> row : dataList) {
            Long asstactId = (Long)row.get("asstactid");
            asstactIds.add(asstactId);
        }
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id,bizpartner.id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,bizpartner.id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Iterator<Map<String, Object>> dataListItr = dataList.iterator();
        while (dataListItr.hasNext()) {
            Map<String, Object> data = dataListItr.next();
            Object asstactId = data.get("asstactid");
            DynamicObject customer = (DynamicObject)customers.get(asstactId);
            if (customer != null && customer.getLong("bizpartner.id") != 0L) {
                data.put("asstactid", customer.getLong("bizpartner.id"));
                continue;
            }
            DynamicObject supplier = (DynamicObject)suppliers.get(asstactId);
            if (supplier != null && supplier.getLong("bizpartner.id") != 0L) {
                data.put("asstactid", supplier.getLong("bizpartner.id"));
                continue;
            }
            dataListItr.remove();
        }
    }

    private void repairDataListByMaster(List<Map<String, Object>> dataList) {
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        for (Map<String, Object> row : dataList) {
            Long asstactId = (Long)row.get("asstactid");
            if (!EmptyUtils.isNotEmpty(asstactId)) continue;
            asstactIds.add(asstactId);
        }
        if (asstactIds.isEmpty()) {
            return;
        }
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (Map<String, Object> data : dataList) {
            Object asstactId = data.get("asstactid");
            DynamicObject customer = (DynamicObject)customers.get(asstactId);
            if (customer != null) {
                data.put("asstactid", customer.getLong("masterid"));
                continue;
            }
            DynamicObject supplier = (DynamicObject)suppliers.get(asstactId);
            if (supplier == null) continue;
            data.put("asstactid", supplier.getLong("masterid"));
        }
    }

    private List<String> getBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        List<SettleRecordExtDataListKeyVO> keys = SettleExtDataLoader.loadSettleRecordExtListKeys(this.entityName);
        selector.addAll(this.billSelector());
        if (this.matchFields != null && this.matchFields.size() > 0) {
            selector.addAll(this.processMatchFields());
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.entityName);
        DynamicObjectType entryType = ((EntryProp)mainType.getProperty(this.entityEntryName())).getDynamicCollectionItemPropertyType();
        for (SettleRecordExtDataListKeyVO key : keys) {
            DynamicProperty property;
            String filedKey = key.getBillKey();
            DynamicProperty headProperty = mainType.getProperty(filedKey);
            if (headProperty != null) {
                selector.add(filedKey);
            }
            if ((property = entryType.getProperty(filedKey)) == null) continue;
            selector.add(filedKey);
        }
        return selector;
    }

    private List<String> getDimensionSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        selector.add("id");
        selector.add(this.entityEntryName() + ".id as entryId");
        if (this.dimensionMatchInfos != null && this.dimensionMatchInfos.size() > 0) {
            for (DimensionMatchInfo dimensionMatchInfo : this.dimensionMatchInfos) {
                selector.add(dimensionMatchInfo.getDimensionKey());
            }
        }
        return selector;
    }

    private QFilter getFilter(String condition, String number) {
        QFilter qFilter = new QFilter(this.orgEntityName(), "=", (Object)this.orgId);
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
        FilterCondition filterCondition = formula.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        qFilter.and(filterBuilder.getQFilter());
        if ("cas_paybill".equals(number)) {
            qFilter.and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
        } else if ("cas_recbill".equals(number)) {
            qFilter.and("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE);
        }
        return qFilter;
    }

    private List<String> processMatchFields() {
        ArrayList<String> results = new ArrayList<String>(this.matchFields.size());
        for (String matchField : this.matchFields) {
            if (matchField.startsWith(this.entityEntryName())) {
                results.add(matchField.substring(this.entityEntryName().length() + 1));
                continue;
            }
            results.add(matchField);
        }
        return results;
    }

    private Set<String> buildDimensionKeys(Map<String, Object> rowData) {
        ArrayList<String> results = new ArrayList<String>(8);
        StringBuilder keySb = new StringBuilder(DIMENSION_PREIX);
        if (this.dimensionMatchInfos == null || this.dimensionMatchInfos.size() == 0) {
            results.add(keySb.toString());
        } else {
            DimensionJoiner dimensionJoiner = new DimensionJoiner();
            for (DimensionMatchInfo dimensionMatchInfo : this.dimensionMatchInfos) {
                DimensionValueResolver.Params params;
                String[] dimensionValues;
                String dimensionKey = dimensionMatchInfo.getDimensionKey();
                if (dimensionKey.contains("asstactid")) {
                    dimensionKey = "asstactid";
                }
                String matchMode = dimensionMatchInfo.getMatchMode();
                MatchParam matchParam = dimensionMatchInfo.getMatchParam();
                Object dimensionValue = rowData.get(dimensionKey);
                if (dimensionValue == null || (dimensionValues = DimensionValueResolver.loadValues(params = new DimensionValueResolver.Params(matchMode, matchParam.getSpiltSign()), dimensionValue)).length <= 0) continue;
                dimensionJoiner.addDimensionValue(dimensionValues);
            }
            results.addAll(dimensionJoiner.join());
        }
        return new HashSet<String>(results);
    }

    @Deprecated
    private boolean isNeedSplit() {
        boolean isSplit = false;
        for (DimensionMatchInfo dimensionMatchInfo : this.dimensionMatchInfos) {
            String matchMode = dimensionMatchInfo.getMatchMode();
            if (!MatchStrategyEnum.isNeedSplit(matchMode)) continue;
            isSplit = true;
        }
        return isSplit;
    }

    protected abstract String orgEntityName();

    protected abstract List<String> billSelector();

    protected abstract String entityEntryName();
}

