/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme.dataloader;

import kd.fi.arapcommon.service.rpascheme.dataloader.AbstractRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.CasPayRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.CasRecRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.FinApRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.FinArRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.PaidRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.RPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.dataloader.RecedRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.entity.RPABillDataParam;

public class RPABillDataLoaderFactory {
    public static RPABillDataLoader createInstance(String billKey, RPABillDataParam param) {
        AbstractRPABillDataLoader billDataLoader = null;
        switch (billKey) {
            case "ar_finarbill": {
                billDataLoader = new FinArRPABillDataLoader(param);
                break;
            }
            case "ap_finapbill": {
                billDataLoader = new FinApRPABillDataLoader(param);
                break;
            }
            case "cas_recbill": {
                billDataLoader = new CasRecRPABillDataLoader(param);
                break;
            }
            case "cas_paybill": {
                billDataLoader = new CasPayRPABillDataLoader(param);
                break;
            }
            case "ar_receivedbill": {
                billDataLoader = new RecedRPABillDataLoader(param);
                break;
            }
            case "ap_paidbill": {
                billDataLoader = new PaidRPABillDataLoader(param);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + billKey);
            }
        }
        return billDataLoader;
    }
}

