/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle;

import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.service.match.IMatchService;
import kd.fi.arapcommon.service.settle.match.service.BotpMatcher;
import kd.fi.arapcommon.service.settle.match.service.ConBillNoMatcher;
import kd.fi.arapcommon.service.settle.match.service.CoreBillNoMatcher;
import kd.fi.arapcommon.service.settle.match.service.DefaultMatcher;
import kd.fi.arapcommon.service.settle.match.service.ISettleMatcher;
import kd.fi.arapcommon.service.settle.match.service.LiquidateMatcher;
import kd.fi.arapcommon.service.settle.match.service.RPASchemeMatcher;
import kd.fi.arapcommon.service.settle.match.service.RecepitClaimMatcher;
import kd.fi.arapcommon.service.settle.match.service.SchemeMatcher;
import kd.fi.arapcommon.service.settle.match.service.SettleMatcherAdapter;
import kd.fi.arapcommon.service.settle.match.service.SettleMatcherParam;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class MatchManager {
    public static ISettleMatcher getMatcher(SettleSchemeVO scheme) {
        String matchServiceClass = scheme.getMatchServiceClass();
        if (StringUtils.isNotEmpty(matchServiceClass)) {
            try {
                Class<?> serviceClass = Class.forName(matchServiceClass);
                IMatchService matchService = (IMatchService)serviceClass.newInstance();
                SettleMatcherAdapter settleMatcher = new SettleMatcherAdapter();
                settleMatcher.initParam(new SettleMatcherParam(scheme));
                settleMatcher.setMatchService(matchService);
                return settleMatcher;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ISettleMatcher matcher = scheme.isLiquidateSettle() ? (ISettleMatcher)BeanFactory.getBean(LiquidateMatcher.class, new Object[0]) : (scheme.isOnlyByBotp() ? (ISettleMatcher)BeanFactory.getBean(BotpMatcher.class, new Object[0]) : (scheme.isOnlyByCoreBill() ? (ISettleMatcher)BeanFactory.getBean(CoreBillNoMatcher.class, new Object[0]) : (scheme.isOnlyByConBill() ? (ISettleMatcher)BeanFactory.getBean(ConBillNoMatcher.class, new Object[0]) : (scheme.isRpaSchemeSettle() ? (ISettleMatcher)BeanFactory.getBean(RPASchemeMatcher.class, new Object[0]) : (scheme.isSchemeSettle() ? (ISettleMatcher)BeanFactory.getBean(SchemeMatcher.class, new Object[0]) : (scheme.isClaim() ? (ISettleMatcher)BeanFactory.getBean(RecepitClaimMatcher.class, new Object[0]) : (ISettleMatcher)BeanFactory.getBean(DefaultMatcher.class, new Object[0])))))));
        matcher.initParam(new SettleMatcherParam(scheme));
        return matcher;
    }
}

