/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.callscmc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.settle.callscmc.ICallOrderConInvoker;
import kd.fi.arapcommon.service.settle.callscmc.build.CallOrderConParamBuilderFactory;
import kd.fi.arapcommon.service.settle.callscmc.build.ICallOrderConParamBuilder;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.CallSCMCParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractCallOrderConService
implements ICallOrderConInvoker {
    protected static final Log logger = LogFactory.getLog(AbstractCallOrderConService.class);
    private static final int MAX_SIZE = 1000;
    protected SettleSchemeVO scheme;
    protected boolean isMain = false;
    protected String entryName = "";
    protected String eSettleAmtName = "";
    protected String eCoreBillIdName = "corebillid";
    protected String eConBillIdName = "e_conbillid";
    protected ICallOrderConParamBuilder orderConParamBuilder;
    protected Map<Long, BigDecimal> wbBeforeAmountMap = new HashMap<Long, BigDecimal>(64);
    protected Map<Long, DynamicObject> mainBillMap = new HashMap<Long, DynamicObject>(64);
    protected Map<Long, DynamicObject> mainBillEntryMap = new HashMap<Long, DynamicObject>(64);
    protected Map<Long, DynamicObject> asstBillMap = new HashMap<Long, DynamicObject>(64);
    protected Map<Long, DynamicObject> asstBillEntryMap = new HashMap<Long, DynamicObject>(64);
    protected Map<Long, List<SettleRecordEntryVO>> settleRecordsMap = new HashMap<Long, List<SettleRecordEntryVO>>(64);

    @Override
    public void initParam(CallSCMCParam callSCMCParam) {
        this.scheme = callSCMCParam.getScheme();
        this.isMain = callSCMCParam.isMain();
    }

    @Override
    public void invoke(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills) {
        this.invoke(settleRecords, wbAfterBills, null);
    }

    @Override
    public void invoke(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills, DynamicObject[] wbBeforeBills) {
        logger.info("AbstractCallOrderConService.invoke start , use:" + this.getClass().getSimpleName());
        if (ObjectUtils.isEmpty(settleRecords) || ObjectUtils.isEmpty((Object[])wbAfterBills)) {
            return;
        }
        logger.info("AbstractCallOrderConService.invoke isGoNextStep start");
        if (!this.isGoNextStep(settleRecords, wbAfterBills)) {
            return;
        }
        logger.info("AbstractCallOrderConService.invoke prepareParam start");
        long start = System.currentTimeMillis();
        this.prepareParam(settleRecords, wbAfterBills, wbBeforeBills);
        logger.info("AbstractCallOrderConService.invoke prepareParam end,cost time is :" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.buildWriteBackParamAndCall(wbAfterBills);
        logger.info("AbstractCallOrderConService.invoke buildWriteBackParamAndCall end,cost time is :" + (System.currentTimeMillis() - start));
    }

    protected void prepareParam(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills, DynamicObject[] wbBeforeBills) {
        this.prepareMainParam(wbAfterBills, wbBeforeBills);
        this.prepareAsstParam(settleRecords);
        this.prepareSettleRecordParam(settleRecords);
        this.prepareBuildParamService(settleRecords, wbAfterBills);
    }

    protected abstract void prepareAsstParam(List<SettleRecordVO> var1);

    protected abstract boolean isMainBillLegal(DynamicObject var1);

    protected boolean isGoNextStep(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills) {
        if ("true".equals(StdConfig.get("isCancelWriteBackPurAndCon"))) {
            return false;
        }
        for (DynamicObject finApBill : wbAfterBills) {
            DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection(this.entryName);
            for (DynamicObject detailRow : detailEntry) {
                if (0L == detailRow.getLong(this.eCoreBillIdName) && 0L == detailRow.getLong(this.eConBillIdName)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void buildWriteBackParamAndCall(DynamicObject[] var1);

    private void prepareBuildParamService(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills) {
        SettleRecordVO settleRecordVO = settleRecords.get(0);
        String billEntity = settleRecordVO.getBillEntity();
        this.orderConParamBuilder = CallOrderConParamBuilderFactory.getBuildCallOrderConParamService(billEntity);
        CallSCMCParam callSCMCParam = new CallSCMCParam();
        callSCMCParam.setScheme(this.scheme);
        Map<Object, Object> assactInterMap = new HashMap(8);
        if ("ap_finapbill".equals(billEntity) || "ar_finarbill".equals(billEntity)) {
            assactInterMap = AsstactHelper.isExistInternalBusinessUnit(wbAfterBills);
        } else if ("cas_paybill".equals(billEntity)) {
            HashSet<Long> supplierIds = new HashSet<Long>(64);
            for (DynamicObject casPayBill : wbAfterBills) {
                supplierIds.add(casPayBill.getLong("payee"));
            }
            assactInterMap = AsstactHelper.isExistInternalBusinessUnit("bd_supplier", supplierIds.toArray(new Long[0]));
        } else if ("cas_recbill".equals(billEntity)) {
            HashSet<Long> asstIds = new HashSet<Long>(64);
            for (DynamicObject recBillInfo : wbAfterBills) {
                asstIds.add(recBillInfo.getLong("payer"));
            }
            assactInterMap = AsstactHelper.isExistInternalBusinessUnit("bd_customer", asstIds.toArray(new Long[0]));
        }
        callSCMCParam.setAssactInterMap(assactInterMap);
        this.orderConParamBuilder.initParam(callSCMCParam);
    }

    private void prepareSettleRecordParam(List<SettleRecordVO> settleRecords) {
        for (SettleRecordVO settleRecord : settleRecords) {
            List<SettleRecordEntryVO> entrys = settleRecord.getEntrys();
            List allAsstRecords = this.settleRecordsMap.getOrDefault(settleRecord.getMainBillEntryId(), new ArrayList(64));
            allAsstRecords.addAll(entrys);
            this.settleRecordsMap.put(settleRecord.getMainBillEntryId(), allAsstRecords);
        }
    }

    private void prepareMainParam(DynamicObject[] wbAfterBills, DynamicObject[] wbBeforeBills) {
        for (DynamicObject mainBill : wbAfterBills) {
            this.mainBillMap.put(mainBill.getLong("id"), mainBill);
            DynamicObjectCollection detailEntry = mainBill.getDynamicObjectCollection(this.entryName);
            for (DynamicObject detail : detailEntry) {
                this.mainBillEntryMap.put(detail.getLong("id"), detail);
            }
        }
        if (wbBeforeBills == null) {
            ArrayList<String> selectors = new ArrayList<String>(2);
            selectors.add(this.entryName + ".id");
            selectors.add(this.eSettleAmtName);
            String entityName = wbAfterBills[0].getDataEntityType().getName();
            wbBeforeBills = BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{new QFilter("id", "in", this.mainBillMap.keySet())});
        }
        for (DynamicObject wbBeforeBill : wbBeforeBills) {
            DynamicObjectCollection wbBeforeEntry = wbBeforeBill.getDynamicObjectCollection(this.entryName);
            for (DynamicObject wbBeforeDetail : wbBeforeEntry) {
                this.wbBeforeAmountMap.put(wbBeforeDetail.getLong("id"), wbBeforeDetail.getBigDecimal(this.eSettleAmtName));
            }
        }
    }

    protected void callSCMC(List<Map<String, Object>> allWriteBackParams, boolean isFinal) {
        if (allWriteBackParams.size() > 1000 || isFinal && !allWriteBackParams.isEmpty()) {
            Settle4ScmcHelper.writeBackPurOrderOrContract(allWriteBackParams, this.scheme.isSettle());
            Settle4ScmcHelper.writeBackSalOrderOrContract(allWriteBackParams, this.scheme.isSettle());
            allWriteBackParams.clear();
        }
    }
}

