/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.callscmc.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.callscmc.AbstractDimensionService;
import kd.fi.arapcommon.vo.CallSCMCParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class ArPayCallOrderConServiceImpl
extends AbstractDimensionService {
    @Override
    public void initParam(CallSCMCParam callSCMCParam) {
        super.initParam(callSCMCParam);
        this.entryName = "entry";
        this.eSettleAmtName = "e_settledamt";
    }

    @Override
    protected Map<Long, Map<String, List<SettleRecordEntryVO>>> prepareAsstSameDimensionParam() {
        boolean isNewSettle = !SettleVersionServiceHelper.isOldVersion((DynamicObject)this.mainBillMap.entrySet().iterator().next().getValue());
        HashMap<Long, Map<String, List<SettleRecordEntryVO>>> settleEntryIdToAsstSameDimensionMap = new HashMap<Long, Map<String, List<SettleRecordEntryVO>>>(64);
        if (isNewSettle) {
            DynamicObjectCollection detailEntries;
            DynamicObject mainBill;
            Long mainBillId;
            logger.info("ArPayCallOrderConServiceImpl.prepareAsstSameDimensionParam use new settle");
            HashMap<Long, Object> mainIdToDetailEntryIdToSplitDimension = new HashMap<Long, Object>(8);
            HashMap mainIdToSplitDimensionIdToPlanEntryIds = new HashMap(8);
            for (Map.Entry mainBillSet : this.mainBillMap.entrySet()) {
                mainBillId = (Long)mainBillSet.getKey();
                mainBill = (DynamicObject)mainBillSet.getValue();
                detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
                HashMap detailEntryIdToSplitDimension = new HashMap(detailEntries.size());
                for (DynamicObject detailEntry : detailEntries) {
                    detailEntryIdToSplitDimension.put(detailEntry.getLong("id"), detailEntry.getLong("e_splitdimensionid"));
                }
                mainIdToDetailEntryIdToSplitDimension.put(mainBillId, detailEntryIdToSplitDimension);
                DynamicObjectCollection planEntries = mainBill.getDynamicObjectCollection("planentity");
                HashMap<Long, ArrayList<Long>> splitDimensionIdToPlanEntryIds = new HashMap<Long, ArrayList<Long>>(8);
                for (DynamicObject planEntry : planEntries) {
                    long planEntryId = planEntry.getLong("id");
                    long splitDimensionId = planEntry.getLong("p_splitdimensionid");
                    ArrayList<Long> planEntryIds = (ArrayList<Long>)splitDimensionIdToPlanEntryIds.get(splitDimensionId);
                    if (planEntryIds == null) {
                        planEntryIds = new ArrayList<Long>(1);
                        planEntryIds.add(planEntryId);
                    } else {
                        planEntryIds.add(planEntryId);
                    }
                    splitDimensionIdToPlanEntryIds.put(splitDimensionId, planEntryIds);
                }
                mainIdToSplitDimensionIdToPlanEntryIds.put(mainBillId, splitDimensionIdToPlanEntryIds);
            }
            for (Map.Entry mainBillSet : this.mainBillMap.entrySet()) {
                mainBillId = (Long)mainBillSet.getKey();
                mainBill = (DynamicObject)mainBillSet.getValue();
                detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
                for (DynamicObject detailEntry : detailEntries) {
                    long detailEntryId = detailEntry.getLong("id");
                    ArrayList recordEntryS = new ArrayList(8);
                    if (1 == this.scheme.getSettleEntryParam()) {
                        List settleRecordEntryVOS = (List)this.settleRecordsMap.get(detailEntryId);
                        if (settleRecordEntryVOS != null && settleRecordEntryVOS.size() > 0) {
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(detailEntryId));
                        }
                    } else {
                        Map detailEntryIdToSplitDimension = (Map)mainIdToDetailEntryIdToSplitDimension.get(mainBillId);
                        Map splitDimensionIdToPlanEntryIds = (Map)mainIdToSplitDimensionIdToPlanEntryIds.get(mainBillId);
                        List planEntryIds = (List)splitDimensionIdToPlanEntryIds.get(detailEntryIdToSplitDimension.get(detailEntryId));
                        if (planEntryIds == null) continue;
                        for (Long planEntryId : planEntryIds) {
                            List settleRecordEntryVOS = (List)this.settleRecordsMap.get(planEntryId);
                            if (settleRecordEntryVOS == null || settleRecordEntryVOS.size() <= 0) continue;
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(planEntryId));
                        }
                    }
                    Map sameDimensionMap = settleEntryIdToAsstSameDimensionMap.getOrDefault(detailEntryId, new HashMap(64));
                    for (SettleRecordEntryVO recordEntry : recordEntryS) {
                        String asstBillEntity = recordEntry.getBillEntity();
                        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
                        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
                        if (!"cas_paybill".equals(asstBillEntity)) continue;
                        String bizType = asstEntry.getString("e_paymenttype.biztype");
                        String eCoreBillType = asstEntry.getString("e_corebilltype");
                        long eCoreBillId = asstEntry.getLong("e_corebillid");
                        long eCoreBillEntryId = asstEntry.getLong("e_corebillentryid");
                        String dimension = bizType + eCoreBillType + eCoreBillId + eCoreBillEntryId;
                        List sameDimensionEntrys = sameDimensionMap.getOrDefault(dimension, new ArrayList(64));
                        sameDimensionEntrys.add(recordEntry);
                        sameDimensionMap.put(dimension, sameDimensionEntrys);
                    }
                    settleEntryIdToAsstSameDimensionMap.put(detailEntryId, sameDimensionMap);
                }
            }
        } else {
            for (Map.Entry mainBillSet : this.mainBillMap.entrySet()) {
                DynamicObject mainBill = (DynamicObject)mainBillSet.getValue();
                DynamicObjectCollection detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
                DynamicObjectCollection planEntries = mainBill.getDynamicObjectCollection("planentity");
                ArrayList<Long> planEntryIds = new ArrayList<Long>(planEntries.size());
                for (DynamicObject planEntry : planEntries) {
                    planEntryIds.add(planEntry.getLong("id"));
                }
                for (DynamicObject detailEntry : detailEntries) {
                    long detailEntryId = detailEntry.getLong("id");
                    ArrayList recordEntryS = new ArrayList(8);
                    if (1 == this.scheme.getSettleEntryParam()) {
                        List settleRecordEntryVOS = (List)this.settleRecordsMap.get(detailEntryId);
                        if (settleRecordEntryVOS != null && settleRecordEntryVOS.size() > 0) {
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(detailEntryId));
                        }
                    } else {
                        for (Long planEntryId : planEntryIds) {
                            List settleRecordEntryVOS = (List)this.settleRecordsMap.get(planEntryId);
                            if (settleRecordEntryVOS == null || settleRecordEntryVOS.size() <= 0) continue;
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(planEntryId));
                        }
                    }
                    Map sameDimensionMap = settleEntryIdToAsstSameDimensionMap.getOrDefault(detailEntryId, new HashMap(64));
                    for (SettleRecordEntryVO recordEntry : recordEntryS) {
                        String asstBillEntity = recordEntry.getBillEntity();
                        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
                        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
                        if (!"cas_paybill".equals(asstBillEntity)) continue;
                        String bizType = asstEntry.getString("e_paymenttype.biztype");
                        String eCoreBillType = asstEntry.getString("e_corebilltype");
                        long eCoreBillId = asstEntry.getLong("e_corebillid");
                        long eCoreBillEntryId = asstEntry.getLong("e_corebillentryid");
                        String dimension = bizType + eCoreBillType + eCoreBillId + eCoreBillEntryId;
                        List sameDimensionEntrys = sameDimensionMap.getOrDefault(dimension, new ArrayList(64));
                        sameDimensionEntrys.add(recordEntry);
                        sameDimensionMap.put(dimension, sameDimensionEntrys);
                    }
                    settleEntryIdToAsstSameDimensionMap.put(detailEntryId, sameDimensionMap);
                }
            }
        }
        return settleEntryIdToAsstSameDimensionMap;
    }

    @Override
    protected Map<String, Object> buildAsstParam(BigDecimal disposeAmt, SettleRecordEntryVO recordEntry) {
        HashMap<String, Object> asstParamMap = new HashMap<String, Object>(16);
        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
        if ("cas_paybill".equals(recordEntry.getBillEntity())) {
            asstParamMap.put("amount", disposeAmt);
            asstParamMap.put("bizType", asstEntry.getString("e_paymenttype.biztype"));
            asstParamMap.put("recMainBillEntity", asstEntry.getString("e_corebilltype"));
            asstParamMap.put("recMainBillID", asstEntry.getLong("e_corebillid"));
            asstParamMap.put("recMainBillEntryID", asstEntry.getLong("e_corebillentryid"));
        }
        return asstParamMap;
    }

    @Override
    protected void prepareAsstParam(List<SettleRecordVO> settleRecords) {
        ArrayList<Long> asstCasPayIds = new ArrayList<Long>(64);
        for (SettleRecordVO settleRecord : settleRecords) {
            List<SettleRecordEntryVO> recordEntrys = settleRecord.getEntrys();
            for (SettleRecordEntryVO recordEntry : recordEntrys) {
                if (!"cas_paybill".equals(recordEntry.getBillEntity())) continue;
                asstCasPayIds.add(recordEntry.getBillId());
            }
        }
        if (!asstCasPayIds.isEmpty()) {
            DynamicObject[] asstBills;
            String selectors = "entry.id,paymenttype,e_corebilltype,e_corebillid,e_corebillentryid,e_paymenttype";
            for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", asstCasPayIds)})) {
                this.asstBillMap.put(asstBill.getLong("id"), asstBill);
                DynamicObjectCollection entry = asstBill.getDynamicObjectCollection("entry");
                for (DynamicObject detail : entry) {
                    this.asstBillEntryMap.put(detail.getLong("id"), detail);
                }
            }
        }
    }

    @Override
    protected boolean isMainBillLegal(DynamicObject mainBill) {
        return !mainBill.getBoolean("istransfer");
    }
}

