/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.callscmc.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.callscmc.AbstractDimensionService;
import kd.fi.arapcommon.vo.CallSCMCParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class ArRecCallOrderConServiceImpl
extends AbstractDimensionService {
    @Override
    public void initParam(CallSCMCParam callSCMCParam) {
        super.initParam(callSCMCParam);
        this.entryName = "entry";
        this.eSettleAmtName = "e_settledamt";
    }

    @Override
    protected Map<Long, Map<String, List<SettleRecordEntryVO>>> prepareAsstSameDimensionParam() {
        boolean isNewSettle = !SettleVersionServiceHelper.isOldVersion((DynamicObject)this.mainBillMap.entrySet().iterator().next().getValue());
        HashMap<Long, Map<String, List<SettleRecordEntryVO>>> settleEntryIdToAsstSameDimensionMap = new HashMap<Long, Map<String, List<SettleRecordEntryVO>>>(64);
        if (isNewSettle) {
            DynamicObjectCollection detailEntries;
            DynamicObject mainBill;
            Long mainBillId;
            logger.info("ArPayCallOrderConServiceImpl.prepareAsstSameDimensionParam use new settle");
            HashMap<Long, Object> mainIdToDetailEntryIdToSplitDimension = new HashMap<Long, Object>(8);
            HashMap mainIdToSplitDimensionIdToPlanEntryIds = new HashMap(8);
            for (Map.Entry mainBillSet : this.mainBillMap.entrySet()) {
                mainBillId = (Long)mainBillSet.getKey();
                mainBill = (DynamicObject)mainBillSet.getValue();
                detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
                HashMap detailEntryIdToSplitDimension = new HashMap(detailEntries.size());
                for (DynamicObject detailEntry : detailEntries) {
                    detailEntryIdToSplitDimension.put(detailEntry.getLong("id"), detailEntry.getLong("e_splitdimensionid"));
                }
                mainIdToDetailEntryIdToSplitDimension.put(mainBillId, detailEntryIdToSplitDimension);
                DynamicObjectCollection planEntries = mainBill.getDynamicObjectCollection("planentity");
                HashMap<Long, ArrayList<Long>> splitDimensionIdToPlanEntryIds = new HashMap<Long, ArrayList<Long>>(8);
                for (DynamicObject planEntry : planEntries) {
                    long planEntryId = planEntry.getLong("id");
                    long splitDimensionId = planEntry.getLong("p_splitdimensionid");
                    ArrayList<Long> planEntryIds = (ArrayList<Long>)splitDimensionIdToPlanEntryIds.get(splitDimensionId);
                    if (planEntryIds == null) {
                        planEntryIds = new ArrayList<Long>(1);
                        planEntryIds.add(planEntryId);
                    } else {
                        planEntryIds.add(planEntryId);
                    }
                    splitDimensionIdToPlanEntryIds.put(splitDimensionId, planEntryIds);
                }
                mainIdToSplitDimensionIdToPlanEntryIds.put(mainBillId, splitDimensionIdToPlanEntryIds);
            }
            for (Map.Entry mainBillSet : this.mainBillMap.entrySet()) {
                mainBillId = (Long)mainBillSet.getKey();
                mainBill = (DynamicObject)mainBillSet.getValue();
                detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
                for (DynamicObject detailEntry : detailEntries) {
                    long detailEntryId = detailEntry.getLong("id");
                    ArrayList recordEntryS = new ArrayList(8);
                    if (1 == this.scheme.getSettleEntryParam()) {
                        List settleRecordEntryVOS = (List)this.settleRecordsMap.get(detailEntryId);
                        if (settleRecordEntryVOS != null && settleRecordEntryVOS.size() > 0) {
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(detailEntryId));
                        }
                    } else {
                        Map detailEntryIdToSplitDimension = (Map)mainIdToDetailEntryIdToSplitDimension.get(mainBillId);
                        Map splitDimensionIdToPlanEntryIds = (Map)mainIdToSplitDimensionIdToPlanEntryIds.get(mainBillId);
                        List planEntryIds = (List)splitDimensionIdToPlanEntryIds.get(detailEntryIdToSplitDimension.get(detailEntryId));
                        if (planEntryIds == null) continue;
                        for (Long planEntryId : planEntryIds) {
                            List settleRecordEntryVOS = (List)this.settleRecordsMap.get(planEntryId);
                            if (settleRecordEntryVOS == null || settleRecordEntryVOS.size() <= 0) continue;
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(planEntryId));
                        }
                    }
                    Map sameDimensionMap = settleEntryIdToAsstSameDimensionMap.getOrDefault(detailEntryId, new HashMap(64));
                    for (SettleRecordEntryVO recordEntry : recordEntryS) {
                        String asstBillEntity = recordEntry.getBillEntity();
                        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
                        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
                        String dimension = null;
                        if ("ar_receivedbill".equals(asstBillEntity)) {
                            dimension = asstBill.getString("rectype.biztype");
                        } else if ("cas_recbill".equals(asstBillEntity)) {
                            String bizType = asstEntry.getString("e_receivingtype.biztype");
                            boolean confirmLogo = asstBill.getBoolean("confirmlogo");
                            String eCoreBillType = asstEntry.getString("e_corebilltype");
                            long eCoreBillId = asstEntry.getLong("e_corebillid");
                            long eCoreBillEntryId = asstEntry.getLong("e_corebillentryid");
                            dimension = bizType + confirmLogo + eCoreBillType + eCoreBillId + eCoreBillEntryId;
                        }
                        if (dimension == null) continue;
                        List sameDimensionEntrys = sameDimensionMap.getOrDefault(dimension, new ArrayList(64));
                        sameDimensionEntrys.add(recordEntry);
                        sameDimensionMap.put(dimension, sameDimensionEntrys);
                    }
                    settleEntryIdToAsstSameDimensionMap.put(detailEntryId, sameDimensionMap);
                }
            }
        } else {
            for (Map.Entry mainBillSet : this.mainBillMap.entrySet()) {
                DynamicObject mainBill = (DynamicObject)mainBillSet.getValue();
                DynamicObjectCollection detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
                DynamicObjectCollection planEntries = mainBill.getDynamicObjectCollection("planentity");
                ArrayList<Long> planEntryIds = new ArrayList<Long>(planEntries.size());
                for (DynamicObject planEntry : planEntries) {
                    planEntryIds.add(planEntry.getLong("id"));
                }
                for (DynamicObject detailEntry : detailEntries) {
                    long detailEntryId = detailEntry.getLong("id");
                    ArrayList recordEntryS = new ArrayList(8);
                    if (1 == this.scheme.getSettleEntryParam()) {
                        List settleRecordEntryVOS = (List)this.settleRecordsMap.get(detailEntryId);
                        if (settleRecordEntryVOS != null && settleRecordEntryVOS.size() > 0) {
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(detailEntryId));
                        }
                    } else {
                        for (Long planEntryId : planEntryIds) {
                            List settleRecordEntryVOS = (List)this.settleRecordsMap.get(planEntryId);
                            if (settleRecordEntryVOS == null || settleRecordEntryVOS.size() <= 0) continue;
                            recordEntryS.addAll((Collection)this.settleRecordsMap.get(planEntryId));
                        }
                    }
                    Map sameDimensionMap = settleEntryIdToAsstSameDimensionMap.getOrDefault(detailEntryId, new HashMap(64));
                    for (SettleRecordEntryVO recordEntry : recordEntryS) {
                        String asstBillEntity = recordEntry.getBillEntity();
                        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
                        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
                        String dimension = null;
                        if ("ar_receivedbill".equals(asstBillEntity)) {
                            dimension = asstBill.getString("rectype.biztype");
                        } else if ("cas_recbill".equals(asstBillEntity)) {
                            String bizType = asstEntry.getString("e_receivingtype.biztype");
                            boolean confirmLogo = asstBill.getBoolean("confirmlogo");
                            String eCoreBillType = asstEntry.getString("e_corebilltype");
                            long eCoreBillId = asstEntry.getLong("e_corebillid");
                            long eCoreBillEntryId = asstEntry.getLong("e_corebillentryid");
                            dimension = bizType + confirmLogo + eCoreBillType + eCoreBillId + eCoreBillEntryId;
                        }
                        if (dimension == null) continue;
                        List sameDimensionEntrys = sameDimensionMap.getOrDefault(dimension, new ArrayList(64));
                        sameDimensionEntrys.add(recordEntry);
                        sameDimensionMap.put(dimension, sameDimensionEntrys);
                    }
                    settleEntryIdToAsstSameDimensionMap.put(detailEntryId, sameDimensionMap);
                }
            }
        }
        return settleEntryIdToAsstSameDimensionMap;
    }

    @Override
    protected Map<String, Object> buildAsstParam(BigDecimal disposeAmt, SettleRecordEntryVO recordEntry) {
        HashMap<String, Object> asstParamMap = new HashMap<String, Object>(16);
        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
        asstParamMap.put("amount", disposeAmt);
        if ("ar_receivedbill".equals(recordEntry.getBillEntity())) {
            asstParamMap.put("bizType", asstBill.getString("rectype.biztype"));
        } else {
            asstParamMap.put("bizType", asstEntry.getString("e_receivingtype.biztype"));
            asstParamMap.put("confirmLogo", asstBill.getBoolean("confirmlogo"));
            asstParamMap.put("recMainBillEntity", asstEntry.getString("e_corebilltype"));
            asstParamMap.put("recMainBillID", asstEntry.getLong("e_corebillid"));
            asstParamMap.put("recMainBillEntryID", asstEntry.getLong("e_corebillentryid"));
        }
        return asstParamMap;
    }

    @Override
    protected void prepareAsstParam(List<SettleRecordVO> settleRecords) {
        DynamicObject[] asstBills;
        String selectors;
        ArrayList<Long> asstCasRecIds = new ArrayList<Long>(64);
        ArrayList<Long> asstArRecIds = new ArrayList<Long>(64);
        for (SettleRecordVO settleRecord : settleRecords) {
            List<SettleRecordEntryVO> recordEntrys = settleRecord.getEntrys();
            for (SettleRecordEntryVO recordEntry : recordEntrys) {
                if ("ar_receivedbill".equals(recordEntry.getBillEntity())) {
                    asstArRecIds.add(recordEntry.getBillId());
                    continue;
                }
                asstCasRecIds.add(recordEntry.getBillId());
            }
        }
        if (!asstArRecIds.isEmpty()) {
            selectors = "id,rectype";
            for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)"ar_receivedbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", asstArRecIds)})) {
                this.asstBillMap.put(asstBill.getLong("id"), asstBill);
            }
        }
        if (!asstCasRecIds.isEmpty()) {
            selectors = "id,receivingtype,confirmlogo,e_corebilltype,e_corebillid,e_corebillentryid,entry.id,e_receivingtype";
            for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", asstCasRecIds)})) {
                this.asstBillMap.put(asstBill.getLong("id"), asstBill);
                DynamicObjectCollection entries = asstBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    this.asstBillEntryMap.put(entry.getLong("id"), entry);
                }
            }
        }
    }

    @Override
    protected boolean isMainBillLegal(DynamicObject mainBill) {
        return !mainBill.getBoolean("istransfer");
    }
}

