/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.SettleRecordExtConverter;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class BaddebtSettleVOConverter {
    private static final Log logger = LogFactory.getLog(BaddebtSettleVOConverter.class);

    public static List<BillSettleVO> convert2VO(DynamicObject[] bills, SettleSchemeVO scheme) {
        logger.info("BaddebtSettleVOConverter convert2VO start");
        int settleParam = scheme.getSettleEntryParam();
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("ar_baddebtlossbill");
        ArrayList<BillSettleVO> mainList = new ArrayList<BillSettleVO>(8);
        if (1 == settleParam) {
            logger.info("BaddebtSettleVOConverter convert2VO settleParam : detail");
            for (DynamicObject bill : bills) {
                DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries) {
                    BigDecimal allowSettleAmt = detailEntry.getBigDecimal("e_unsettleamt");
                    if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    BillSettleVO settleVO = BaddebtSettleVOConverter.newDetailVO(bill, detailEntry, extKeys);
                    settleVO.setSettleEntry(settleParam);
                    mainList.add(settleVO);
                }
            }
        } else {
            logger.info("BaddebtSettleVOConverter convert2VO settleParam : plan");
            for (DynamicObject bill : bills) {
                DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentry");
                for (DynamicObject planEntry : planEntrys) {
                    BigDecimal allowSettleAmt = planEntry.getBigDecimal("p_unsettleamt");
                    if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    BillSettleVO settleVO = BaddebtSettleVOConverter.newPlanVO(bill, planEntry, extKeys);
                    settleVO.setSettleEntry(settleParam);
                    mainList.add(settleVO);
                }
            }
        }
        logger.info("BaddebtSettleVOConverter convert2VO end");
        return mainList;
    }

    private static BillSettleVO newDetailVO(DynamicObject bill, DynamicObject detailEntry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        BaddebtSettleVOConverter.newHead(settleVO, bill);
        settleVO.setEntryId(detailEntry.getLong("id"));
        settleVO.setEntryEntity(detailEntry.getDataEntityType().getName());
        settleVO.setEntryMaterialId(detailEntry.getLong("e_material.id"));
        settleVO.setEntryExpenseItemId(detailEntry.getLong("e_expenseitem.id"));
        settleVO.setEntryPayableAmt(detailEntry.getBigDecimal("e_baddebtamt"));
        settleVO.setEntryUnSettleAmt(detailEntry.getBigDecimal("e_unsettleamt"));
        settleVO.setEntrySettledAmt(detailEntry.getBigDecimal("e_settledamt"));
        settleVO.setEntrySouBillId(detailEntry.getLong("e_srcentryid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, detailEntry, extKeys));
        }
        return settleVO;
    }

    private static BillSettleVO newPlanVO(DynamicObject bill, DynamicObject planEntry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        BaddebtSettleVOConverter.newHead(settleVO, bill);
        settleVO.setEntryId(planEntry.getLong("id"));
        settleVO.setEntryEntity(planEntry.getDataEntityType().getName());
        settleVO.setEntryPayableAmt(planEntry.getBigDecimal("p_baddebtamt"));
        settleVO.setEntrySettledAmt(planEntry.getBigDecimal("p_settledamt"));
        settleVO.setEntryUnSettleAmt(planEntry.getBigDecimal("p_unsettleamt"));
        settleVO.setPlanDueDate(planEntry.getDate("p_duedate"));
        settleVO.setEntrySouBillId(planEntry.getLong("p_srcplanentryid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, planEntry, extKeys));
        }
        return settleVO;
    }

    private static void newHead(BillSettleVO settleVO, DynamicObject bill) {
        settleVO.setId(bill.getLong("id"));
        settleVO.setBillEntity(bill.getDataEntityType().getName());
        settleVO.setOrgId(bill.getLong("org.id"));
        settleVO.setBillNo(bill.getString("billno"));
        settleVO.setBizdate(bill.getDate("bizdate"));
        settleVO.setBillType(BillTypeConsts.getBillTypeMap().get(bill.getLong("billtype.id")));
        settleVO.setCurrencyId(bill.getLong("currency.id"));
        settleVO.setBasePrecision(bill.getInt("basecurrency.amtprecision"));
        settleVO.setQuotation(bill.getString("quotation"));
        settleVO.setExchangeRate(bill.getBigDecimal("exchangerate"));
        settleVO.setAsstActType(bill.getString("asstacttype"));
        settleVO.setAsstActId(bill.getLong("asstact.id"));
        settleVO.setAsstActName(bill.getString("asstact.name"));
    }
}

