/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.SettleRecordExtConverter;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.BillSettleVO;

public class PaidSettleVOConverter {
    private static final Log logger = LogFactory.getLog(PaidSettleVOConverter.class);
    private static final String PAYMENTTYPE_NUM = "202";

    public static List<BillSettleVO> convert2VO(DynamicObject[] bills) {
        logger.info("PaidSettleVOConverter convert2VO start");
        ArrayList<BillSettleVO> resultList = new ArrayList<BillSettleVO>(64);
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("ap_paidbill");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal allowSettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BillSettleVO settleVO = PaidSettleVOConverter.newVO(bill, entry, extKeys);
                resultList.add(settleVO);
            }
        }
        logger.info("PaidSettleVOConverter convert2VO end");
        return resultList;
    }

    private static BillSettleVO newVO(DynamicObject bill, DynamicObject entry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        String entityName = bill.getDynamicObjectType().getName();
        settleVO.setBillEntity(entityName);
        settleVO.setId(bill.getLong("id"));
        settleVO.setBillNo(bill.getString("billno"));
        settleVO.setOrgId(bill.getLong("org.id"));
        settleVO.setBillType(SettleBillTypeEnum.PAID.getValue());
        DynamicObject paymentType = bill.getDynamicObject("paymenttype");
        if (paymentType != null && EntityMetadataUtils.isExistProperty(paymentType, "biztype") && PAYMENTTYPE_NUM.equals(paymentType.getString("biztype"))) {
            settleVO.setBillType(SettleBillTypeEnum.ADVPAY.getValue());
        }
        settleVO.setBizdate(bill.getDate("bizdate"));
        settleVO.setCurrencyId(bill.getLong("currency.id"));
        settleVO.setBasePrecision(bill.getInt("basecurrency.amtprecision"));
        settleVO.setExchangeRate(bill.getBigDecimal("exchangerate"));
        settleVO.setQuotation(bill.getString("quotation"));
        settleVO.setPayPropertyType("cas_paymentbilltype");
        settleVO.setPayPropertyField(bill.getLong("paymenttype.id"));
        settleVO.setAsstActType(bill.getString("payeetype"));
        settleVO.setAsstActId(bill.getLong("payee.id"));
        settleVO.setAsstActName(bill.getString("payeename"));
        settleVO.setEntryEntity(entry.getDataEntityType().getName());
        settleVO.setEntryId(entry.getLong("id"));
        settleVO.setEntryMaterialId(entry.getLong("e_material.id"));
        settleVO.setEntryExpenseItemId(entry.getLong("e_expenseitem.id"));
        settleVO.setEntryPayableAmt(entry.getBigDecimal("e_actamt"));
        settleVO.setEntryUnSettleAmt(entry.getBigDecimal("e_unsettledamt"));
        settleVO.setEntrySettledAmt(entry.getBigDecimal("e_settledamt"));
        settleVO.setEntryCoreBillNum(entry.getString("e_corebillno"));
        settleVO.setEntryCoreBillseq(entry.getString("e_corebillentryseq"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, entry, extKeys));
        }
        return settleVO;
    }
}

