/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.SettleRecordExtConverter;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.BillSettleVO;

public class PaySettleVOConverter {
    private static final Log logger = LogFactory.getLog(PaySettleVOConverter.class);
    private static final String PAYBILL_PUR = "cas_paybill_pur_BT_S";
    private static final String PAYBILL_EXP = "cas_paybill_other&settle_BT_S";
    private static final String PAYMENTTYPE_NUM = "202";

    public static List<BillSettleVO> convert2VO(DynamicObject[] bills) {
        logger.info("PaySettleVOConverter convert2VO start");
        ArrayList<BillSettleVO> resultList = new ArrayList<BillSettleVO>(64);
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("cas_paybill");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                DynamicObject paymentType = entry.getDynamicObject("e_paymenttype");
                if (ObjectUtils.isEmpty((Object)paymentType)) continue;
                boolean isPartPayment = paymentType.getBoolean("ispartpayment");
                BigDecimal allowSettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0 || !isPartPayment) continue;
                BillSettleVO settleVO = PaySettleVOConverter.newVO(bill, entry, extKeys);
                resultList.add(settleVO);
            }
        }
        logger.info("PaySettleVOConverter convert2VO end");
        return resultList;
    }

    private static BillSettleVO newVO(DynamicObject bill, DynamicObject entry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        settleVO.setBillEntity(bill.getDynamicObjectType().getName());
        settleVO.setId(bill.getLong("id"));
        settleVO.setBillNo(bill.getString("billno"));
        settleVO.setOrgId(entry.getLong("settleorg.id"));
        String billTypeNo = bill.getDynamicObject("billtype").getString("number");
        if (PAYBILL_PUR.equals(billTypeNo)) {
            settleVO.setBillType(SettleBillTypeEnum.APPAY.getValue());
        } else if (PAYBILL_EXP.equals(billTypeNo)) {
            settleVO.setBillType(SettleBillTypeEnum.OTHERPAY.getValue());
        } else {
            settleVO.setBillType(bill.getString("billtype.number"));
        }
        DynamicObject paymentType = bill.getDynamicObject("paymenttype");
        if (paymentType != null && EntityMetadataUtils.isExistProperty(paymentType, "biztype") && PAYMENTTYPE_NUM.equals(paymentType.getString("biztype"))) {
            settleVO.setBillType(SettleBillTypeEnum.ADVPAY.getValue());
        }
        settleVO.setBizdate(bill.getDate("bizdate"));
        settleVO.setCurrencyId(bill.getLong("currency.id"));
        settleVO.setPrecision(bill.getInt("currency.amtprecision"));
        settleVO.setBasePrecision(bill.getInt("basecurrency.amtprecision"));
        settleVO.setQuotation(bill.getString("payquotation"));
        settleVO.setExchangeRate(bill.getBigDecimal("exchangerate"));
        settleVO.setPayPropertyType("cas_paymentbilltype");
        settleVO.setPayPropertyField(entry.getLong("e_paymenttype.id"));
        settleVO.setAsstActType(bill.getString("payeetype"));
        settleVO.setAsstActId(bill.getLong("payee"));
        settleVO.setAsstActName(bill.getString("payeename"));
        settleVO.setEntryId(entry.getLong("id"));
        settleVO.setEntryEntity(entry.getDataEntityType().getName());
        settleVO.setEntryMaterialId(entry.getLong("e_material.id"));
        settleVO.setEntryExpenseItemId(entry.getLong("e_expenseitem.id"));
        settleVO.setEntryPayableAmt(entry.getBigDecimal("e_payableamt"));
        settleVO.setEntryUnSettleAmt(entry.getBigDecimal("e_unsettledamt"));
        settleVO.setEntrySettledAmt(entry.getBigDecimal("e_settledamt"));
        settleVO.setEntryCoreBillNum(entry.getString("e_corebillno"));
        settleVO.setEntryCoreBillseq(entry.getString("e_corebillentryseq"));
        settleVO.setEntryConBillNum(entry.getString("conbillnumber"));
        settleVO.setEntryConBillseq(entry.getString("conbillrownum"));
        settleVO.setEntrySouBillId(entry.getLong("e_sourcebillentryid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, entry, extKeys));
        }
        return settleVO;
    }
}

