/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.match.base;

import java.math.BigDecimal;
import kd.fi.arapcommon.service.settle.match.base.ISettleMatch;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class AmtDirectionMatch
implements ISettleMatch {
    @Override
    public boolean match(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        boolean matchResult = false;
        if (main.getBillEntity() != null) {
            if (scheme.isTransferPay() || scheme.isLiquidateSettle() || scheme.isAdjust() || scheme.isPremAutoSettle()) {
                matchResult = true;
            } else if (scheme.isSettleSelf() || main.getBillEntity().equals(asst.getBillEntity())) {
                matchResult = main.getEntryUnSettleAmt().signum() != asst.getEntryUnSettleAmt().signum();
            } else {
                boolean bl = matchResult = main.getEntryUnSettleAmt().signum() == asst.getEntryUnSettleAmt().signum();
            }
            if ("ar_finarbill".equals(main.getBillEntity()) && "cas_paybill".equals(asst.getBillEntity()) || "ap_finapbill".equals(main.getBillEntity()) && "cas_recbill".equals(asst.getBillEntity())) {
                matchResult = main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0 && asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0;
            }
        }
        return matchResult;
    }
}

