/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.match.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.fi.arapcommon.service.settle.match.base.AmtDirectionMatch;
import kd.fi.arapcommon.service.settle.match.service.AbstractSettleMatcher;
import kd.fi.arapcommon.util.DateUtils;

public class SchemeMatcher
extends AbstractSettleMatcher {
    @Override
    protected void addMatchHandlers() {
        this.matchHandlers.add(new AmtDirectionMatch());
        this.matchHandlers.add((main, asst, scheme) -> {
            boolean match = true;
            if (scheme.getMatchFieldMap() != null) {
                Map<Long, Map<String, Object>> mainFieldValueMap = scheme.getMainFieldValueMap();
                Map<Long, Map<String, Object>> asstFieldvalueMap = scheme.getAsstFieldValueMap();
                List<Map<String, Object>> fieldEntrys = scheme.getMatchFieldMap();
                for (Map<String, Object> entry : fieldEntrys) {
                    String mainField = (String)entry.get("mainfield");
                    String asstField = (String)entry.get("asstfield");
                    boolean isNullMatch = (Boolean)entry.get("isnullmatch");
                    Object mainValue = mainFieldValueMap.get(main.getEntryId()).get(mainField);
                    Object asstValue = asstFieldvalueMap.get(asst.getEntryId()).get(asstField);
                    if (ObjectUtils.isEmpty((Object)mainValue) && ObjectUtils.isEmpty((Object)asstValue)) {
                        if (isNullMatch) continue;
                        match = false;
                        break;
                    }
                    if (mainValue != null && asstValue != null) {
                        if (mainValue instanceof BigDecimal && asstValue instanceof BigDecimal) {
                            BigDecimal mainAmount = (BigDecimal)mainValue;
                            BigDecimal asstAmount = (BigDecimal)asstValue;
                            if (mainAmount.compareTo(asstAmount) == 0) continue;
                            match = false;
                            break;
                        }
                        if (mainValue instanceof Date && asstValue instanceof Date) {
                            Date mainDate = (Date)mainValue;
                            Date asstDate = (Date)asstValue;
                            if (DateUtils.getDiffDaysIgnoreTime(mainDate, asstDate) == 0) continue;
                            match = false;
                            break;
                        }
                        if (mainValue.toString().equals(asstValue.toString())) continue;
                        match = false;
                        break;
                    }
                    match = false;
                    break;
                }
            }
            return match;
        });
    }
}

