/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.settlerecord;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.ext.SettleMatchExtContext;
import kd.fi.arapcommon.service.settle.settlerecord.ISettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.SettleRecordBuildParam;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractSettleRecordBuilder
implements ISettleRecordBuilder {
    protected static final Log logger = LogFactory.getLog(AbstractSettleRecordBuilder.class);
    protected SettleSchemeVO scheme;
    protected String settleType;

    @Override
    public void initParam(SettleRecordBuildParam param) {
        this.scheme = param.getScheme();
        this.settleType = param.getSettleType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SettleRecordVO> build(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        List<SettleRecordVO> settleRecords;
        logger.info("SettleRecordBuilder start");
        logger.info("SettleRecordBuilder use:" + this.getClass().getSimpleName());
        long start = System.currentTimeMillis();
        try {
            settleRecords = this.doBuild(mainList, asstList);
        }
        finally {
            SettleMatchExtContext.remove();
        }
        long end = System.currentTimeMillis();
        logger.info("SettleRecordBuilder end---(ms)" + (end - start));
        return settleRecords;
    }

    protected abstract List<SettleRecordVO> doBuild(List<BillSettleVO> var1, List<BillSettleVO> var2);

    protected void fillSettleRecord(SettleRecordVO result, BillSettleVO main) {
        result.setOrgId(main.getOrgId());
        result.setSettleType(this.settleType);
        result.setCreatorId(RequestContext.get().getCurrUserId());
        result.setMaterialId(main.getEntryMaterialId());
        result.setBillNo(main.getBillNo());
        result.setBillDate(main.getBizdate());
        result.setBillType(main.getBillType());
        String quotation = main.getQuotation();
        result.setQuotation(quotation);
        BigDecimal mainExchangeRate = main.getExchangeRate();
        result.setExchangeRate(mainExchangeRate);
        result.setBasePrecision(main.getBasePrecision());
        BigDecimal localTotalSettleAmt = this.getLocamtByQuotation(quotation, result.getTotalSettleAmt(), mainExchangeRate, main.getBasePrecision());
        result.setLocalTotalSettleamt(localTotalSettleAmt);
        result.setMainPayableAmt(main.getEntryPayableAmt());
        result.setCurrencyId(main.getCurrencyId());
        result.setMaterialId(main.getEntryMaterialId());
        result.setExpenseItemId(main.getEntryExpenseItemId());
        result.setAsstActType(main.getAsstActType());
        result.setAsstActId(main.getAsstActId());
        result.setAsstActName(main.getAsstActName());
        result.setMainBillId(main.getId());
        result.setMainBillEntryId(main.getEntryId());
        result.setCorebillId(main.getCorebillId());
        result.setCorebillEntryId(main.getCorebillEntryId());
        result.setPlanDueDate(main.getPlanDueDate());
        result.setSettleEntry(main.getSettleEntry());
        result.setBillEntity(main.getBillEntity());
        result.setPayPropertyType(main.getPayPropertyType());
        result.setPayPropertyField(main.getPayPropertyField());
        result.setExtFields(main.getExtFields());
        if (main.getImportSettleId() != 0L) {
            result.setSettleLogEntryId(main.getImportSettleId());
        }
    }

    protected void fillSettleRecordEntry(SettleRecordEntryVO entry, BillSettleVO asst) {
        entry.setBillNum(asst.getBillNo());
        entry.setBillDate(asst.getBizdate());
        entry.setBillType(asst.getBillType());
        entry.setCurrencyId(asst.getCurrencyId());
        entry.setAsstActType(asst.getAsstActType());
        entry.setAsstActId(asst.getAsstActId());
        entry.setMaterialId(asst.getEntryMaterialId());
        entry.setExpenseItemId(asst.getEntryExpenseItemId());
        entry.setAsstAct(asst.getAsstActName());
        String quotation = asst.getQuotation();
        entry.setQuotation(quotation);
        entry.setExchangeRate(asst.getExchangeRate());
        entry.setBasePrecision(asst.getBasePrecision());
        BigDecimal localSettleAmt = this.getLocamtByQuotation(quotation, entry.getSettleAmt(), entry.getExchangeRate(), entry.getBasePrecision());
        entry.setLocalSettleAmt(localSettleAmt);
        entry.setPayableAmt(asst.getEntryPayableAmt());
        entry.setBillId(asst.getId());
        entry.setBillEntryId(asst.getEntryId());
        entry.setPlanDueDate(asst.getPlanDueDate());
        entry.setSettleEntry(asst.getSettleEntry());
        entry.setBillEntity(asst.getBillEntity());
        entry.setPayPropertyType(asst.getPayPropertyType());
        entry.setPayPropertyField(asst.getPayPropertyField());
        entry.setExtFields(asst.getExtFields());
    }

    protected SettleRecordVO buildSettleRecord(BillSettleVO main, List<BillSettleVO> matchAsstList) {
        SettleRecordVO result = new SettleRecordVO();
        BigDecimal mainEntryUnSettleAmt = main.getEntryUnSettleAmt();
        BigDecimal mainEntrySettleAmt = BigDecimal.ZERO;
        for (BillSettleVO asst : matchAsstList) {
            BigDecimal asstEntryUnSettleAmt = asst.getEntryUnSettleAmt();
            BigDecimal curSettleAmt = mainEntryUnSettleAmt.abs().compareTo(asstEntryUnSettleAmt.abs()) >= 0 ? asstEntryUnSettleAmt.abs() : mainEntryUnSettleAmt.abs();
            BigDecimal mainDirection = new BigDecimal(mainEntryUnSettleAmt.signum());
            mainEntryUnSettleAmt = mainEntryUnSettleAmt.subtract(curSettleAmt.multiply(mainDirection));
            main.setEntryUnSettleAmt(mainEntryUnSettleAmt);
            mainEntrySettleAmt = mainEntrySettleAmt.add(curSettleAmt.multiply(mainDirection));
            BigDecimal asstDirection = new BigDecimal(asstEntryUnSettleAmt.signum());
            asstEntryUnSettleAmt = asstEntryUnSettleAmt.subtract(curSettleAmt.multiply(asstDirection));
            asst.setEntryUnSettleAmt(asstEntryUnSettleAmt);
            SettleRecordEntryVO entry = new SettleRecordEntryVO();
            entry.setSettleAmt(curSettleAmt.multiply(asstDirection));
            this.fillSettleRecordEntry(entry, asst);
            result.getEntrys().add(entry);
            if (mainEntryUnSettleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        result.setTotalSettleAmt(mainEntrySettleAmt);
        this.fillSettleRecord(result, main);
        return result;
    }

    private BigDecimal getLocamtByQuotation(String quotation, BigDecimal srcAmt, BigDecimal exchangeRate, int amtprecision) {
        if ("1".equals(quotation)) {
            return srcAmt.divide(exchangeRate, amtprecision, RoundingMode.HALF_UP);
        }
        return srcAmt.multiply(exchangeRate).setScale(amtprecision, RoundingMode.HALF_UP);
    }
}

