/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.settlerecord;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.fi.arapcommon.service.settle.settlerecord.AbstractSettleRecordBuilder;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class DiffCurrencySettleRecordBuilder
extends AbstractSettleRecordBuilder {
    @Override
    protected List<SettleRecordVO> doBuild(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        BigDecimal mainSumLocalAmt = BigDecimal.ZERO;
        for (BillSettleVO billSettleVO : mainList) {
            BigDecimal mainEntryUnSettleAmt = DiffCurrencySettleRecordBuilder.getLocamtByQuotation(billSettleVO.getQuotation(), billSettleVO.getEntryUnSettleAmt(), billSettleVO.getExchangeRate(), billSettleVO.getBasePrecision());
            mainSumLocalAmt = mainSumLocalAmt.add(mainEntryUnSettleAmt);
        }
        BigDecimal asstSumLocalAmt = BigDecimal.ZERO;
        for (BillSettleVO asst : asstList) {
            BigDecimal asstEntryUnSettleAmt = DiffCurrencySettleRecordBuilder.getLocamtByQuotation(asst.getQuotation(), asst.getEntryUnSettleAmt(), asst.getExchangeRate(), asst.getBasePrecision());
            asstSumLocalAmt = asstSumLocalAmt.add(asstEntryUnSettleAmt);
        }
        ArrayList<SettleRecordVO> arrayList = new ArrayList<SettleRecordVO>(mainList.size());
        int mainRows = 0;
        HashMap<Integer, BigDecimal> asstSettleAmtMap = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> asstSettleLocalAmtMap = new HashMap<Integer, BigDecimal>();
        for (BillSettleVO main : mainList) {
            ++mainRows;
            SettleRecordVO result = new SettleRecordVO();
            result.setSettleType(this.settleType);
            result.setTotalSettleAmt(main.getEntryUnSettleAmt());
            this.fillSettleRecord(result, main);
            BigDecimal mainLocalSettleAmt = result.getLocalTotalSettleamt();
            BigDecimal proportion = mainSumLocalAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainLocalSettleAmt.divide(mainSumLocalAmt, 12, RoundingMode.HALF_UP);
            for (int i = 0; i < asstList.size(); ++i) {
                BillSettleVO asst = asstList.get(i);
                SettleRecordEntryVO entry = new SettleRecordEntryVO();
                BigDecimal asstSettleAmt = asst.getEntryUnSettleAmt();
                BigDecimal asstSettleLocalAmt = DiffCurrencySettleRecordBuilder.getLocamtByQuotation(asst.getQuotation(), asstSettleAmt, asst.getExchangeRate(), asst.getBasePrecision());
                if (mainRows != mainList.size()) {
                    BigDecimal asstAmt = asstSettleAmt.multiply(proportion).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP);
                    entry.setSettleAmt(asstAmt);
                    if (asstSettleAmtMap.get(i) == null) {
                        asstSettleAmtMap.put(i, asstAmt);
                    } else {
                        asstSettleAmtMap.put(i, ((BigDecimal)asstSettleAmtMap.get(i)).add(asstAmt).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
                    }
                } else if (asstSettleAmtMap.get(i) == null) {
                    entry.setSettleAmt(asstSettleAmt);
                } else {
                    entry.setSettleAmt(asstSettleAmt.subtract((BigDecimal)asstSettleAmtMap.get(i)));
                }
                this.fillSettleRecordEntry(entry, asst);
                if (mainRows != mainList.size()) {
                    BigDecimal localSettleAmt = entry.getLocalSettleAmt();
                    entry.setLocalSettleAmt(localSettleAmt);
                    if (asstSettleLocalAmtMap.get(i) == null) {
                        asstSettleLocalAmtMap.put(i, localSettleAmt);
                    } else {
                        asstSettleLocalAmtMap.put(i, ((BigDecimal)asstSettleLocalAmtMap.get(i)).add(localSettleAmt).setScale((int)asst.getBasePrecision(), RoundingMode.HALF_UP));
                    }
                } else if (asstSettleLocalAmtMap.get(i) == null) {
                    entry.setLocalSettleAmt(asstSettleLocalAmt);
                } else {
                    entry.setLocalSettleAmt(asstSettleLocalAmt.subtract((BigDecimal)asstSettleLocalAmtMap.get(i)));
                }
                result.getEntrys().add(entry);
            }
            arrayList.add(result);
        }
        return arrayList;
    }

    private static BigDecimal getLocamtByQuotation(String quotation, BigDecimal srcAmt, BigDecimal exchangeRate, int amtprecision) {
        if ("1".equals(quotation)) {
            return srcAmt.divide(exchangeRate, amtprecision, RoundingMode.HALF_UP);
        }
        return srcAmt.multiply(exchangeRate).setScale(amtprecision, RoundingMode.HALF_UP);
    }
}

