/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.settlerecord;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.settle.MatchManager;
import kd.fi.arapcommon.service.settle.match.service.ISettleMatcher;
import kd.fi.arapcommon.service.settle.settlerecord.AbstractSettleRecordBuilder;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class OrdinalSettleRecordBuilder
extends AbstractSettleRecordBuilder {
    @Override
    protected List<SettleRecordVO> doBuild(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        if ("auto".equals(this.settleType) && (this.scheme.isOnlyByCoreBill() || this.scheme.isOnlyByConBill())) {
            Map<Long, Long> asstactIdToMasterIdMap = this.buildMapForAsstactIdToMasterId(mainList, asstList);
            this.scheme.setAsstactIdToMasterIdMap(asstactIdToMasterIdMap);
        }
        ArrayList<SettleRecordVO> resultList = new ArrayList<SettleRecordVO>(64);
        ISettleMatcher matcher = MatchManager.getMatcher(this.scheme);
        ArrayList<BillSettleVO> matchAsstList = new ArrayList<BillSettleVO>(asstList.size());
        for (BillSettleVO main : mainList) {
            matchAsstList.clear();
            for (BillSettleVO asst : asstList) {
                if (asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) == 0 || !matcher.match(main, asst)) continue;
                matchAsstList.add(asst);
            }
            if (matchAsstList.size() <= 0) continue;
            SettleRecordVO result = super.buildSettleRecord(main, matchAsstList);
            resultList.add(result);
        }
        return resultList;
    }

    private Map<Long, Long> buildMapForAsstactIdToMasterId(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        HashMap<Long, Long> asstactIdToMasterIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> supplierIdSet = new HashSet<Long>(64);
        HashSet<Long> customerIdSet = new HashSet<Long>(64);
        for (BillSettleVO main : mainList) {
            if ("bd_supplier".equals(main.getAsstActType())) {
                supplierIdSet.add(main.getAsstActId());
            }
            if (!"bd_customer".equals(main.getAsstActType())) continue;
            customerIdSet.add(main.getAsstActId());
        }
        for (BillSettleVO asst : asstList) {
            if ("bd_supplier".equals(asst.getAsstActType())) {
                supplierIdSet.add(asst.getAsstActId());
            }
            if (!"bd_customer".equals(asst.getAsstActType())) continue;
            customerIdSet.add(asst.getAsstActId());
        }
        String selectField = "id,masterid";
        if (supplierIdSet.size() > 0) {
            DynamicObjectCollection supplierCollection = QueryServiceHelper.query((String)"bd_supplier", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)});
            asstactIdToMasterIdMap.putAll(supplierCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        }
        if (customerIdSet.size() > 0) {
            DynamicObjectCollection customerCollection = QueryServiceHelper.query((String)"bd_customer", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", customerIdSet)});
            asstactIdToMasterIdMap.putAll(customerCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        }
        return asstactIdToMasterIdMap;
    }
}

