/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.settlerecord;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.arapcommon.service.settle.settlerecord.AbstractSettleRecordBuilder;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class ProportionNewSettleRecordBuilder
extends AbstractSettleRecordBuilder {
    @Override
    protected List<SettleRecordVO> doBuild(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        ArrayList<BillSettleVO> tempList;
        ArrayList<SettleRecordVO> resultList = new ArrayList<SettleRecordVO>(64);
        HashMap<Long, List> billIdSettleVOMap = new HashMap<Long, List>(2);
        HashMap<Long, List> sourIdSettleVOMap = new HashMap<Long, List>(2);
        for (BillSettleVO billSettleVO : mainList) {
            List billSettleVOs = (List)billIdSettleVOMap.get(billSettleVO.getId());
            if (billSettleVOs == null) {
                tempList = new ArrayList<BillSettleVO>(1);
                tempList.add(billSettleVO);
                billIdSettleVOMap.put(billSettleVO.getId(), tempList);
                continue;
            }
            billSettleVOs.add(billSettleVO);
            billIdSettleVOMap.put(billSettleVO.getId(), billSettleVOs);
        }
        for (BillSettleVO billSettleVO : asstList) {
            List billSettleVOS = (List)sourIdSettleVOMap.get(billSettleVO.getSouBillId());
            if (billSettleVOS == null) {
                tempList = new ArrayList(1);
                tempList.add(billSettleVO);
                sourIdSettleVOMap.put(billSettleVO.getSouBillId(), tempList);
                continue;
            }
            billSettleVOS.add(billSettleVO);
            sourIdSettleVOMap.put(billSettleVO.getSouBillId(), billSettleVOS);
        }
        for (Map.Entry entry : billIdSettleVOMap.entrySet()) {
            List settleVOs = (List)entry.getValue();
            long mainBillId = (Long)entry.getKey();
            List asstSettleVOs = (List)sourIdSettleVOMap.get(mainBillId);
            if (asstSettleVOs == null) continue;
            BigDecimal mainPriceTaxTotalAmt = BigDecimal.ZERO;
            for (BillSettleVO main : settleVOs) {
                mainPriceTaxTotalAmt = mainPriceTaxTotalAmt.add(main.getEntryPayableAmt());
            }
            HashMap<Long, BigDecimal> entryIdToSettleAmt = new HashMap<Long, BigDecimal>(mainList.size());
            BigDecimal needSettleAmt = BigDecimal.ZERO;
            for (BillSettleVO asst : asstSettleVOs) {
                needSettleAmt = needSettleAmt.add(asst.getEntryUnSettleAmt());
            }
            if (needSettleAmt.compareTo(mainPriceTaxTotalAmt) == 0) {
                for (BillSettleVO main : settleVOs) {
                    entryIdToSettleAmt.put(main.getEntryId(), main.getEntryPayableAmt());
                }
            } else {
                BigDecimal remainSettleAmt = needSettleAmt;
                int size = settleVOs.size();
                for (int i = 0; i < size; ++i) {
                    BigDecimal entryPriceTaxAmt;
                    BillSettleVO main = (BillSettleVO)settleVOs.get(i);
                    if (i == size - 1) {
                        entryPriceTaxAmt = main.getEntryPayableAmt();
                        BigDecimal endWriteBackedNoWriteBackAmt = BigDecimal.ZERO;
                        if (remainSettleAmt.signum() == entryPriceTaxAmt.signum()) {
                            if (remainSettleAmt.abs().compareTo(entryPriceTaxAmt.abs()) > 0) {
                                entryIdToSettleAmt.put(main.getEntryId(), entryPriceTaxAmt);
                                endWriteBackedNoWriteBackAmt = remainSettleAmt.subtract(entryPriceTaxAmt);
                            } else {
                                entryIdToSettleAmt.put(main.getEntryId(), remainSettleAmt);
                            }
                        } else {
                            endWriteBackedNoWriteBackAmt = remainSettleAmt;
                        }
                        if (endWriteBackedNoWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.writeBackBottomToTop(mainList, endWriteBackedNoWriteBackAmt, entryIdToSettleAmt);
                        continue;
                    }
                    entryPriceTaxAmt = main.getEntryPayableAmt();
                    BigDecimal proportion = entryPriceTaxAmt.divide(mainPriceTaxTotalAmt, 10, RoundingMode.DOWN);
                    BigDecimal curSettleAmt = needSettleAmt.multiply(proportion).setScale((int)main.getPrecision(), RoundingMode.DOWN);
                    entryIdToSettleAmt.put(main.getEntryId(), curSettleAmt);
                    remainSettleAmt = remainSettleAmt.subtract(curSettleAmt);
                }
            }
            resultList.addAll(this.buildSettleRecord(settleVOs, asstSettleVOs, entryIdToSettleAmt));
        }
        return resultList;
    }

    private void writeBackBottomToTop(List<BillSettleVO> mainList, BigDecimal remainNoWriteBackAmt, Map<Long, BigDecimal> result) {
        for (int index = mainList.size() - 2; index >= 0; --index) {
            BillSettleVO entry = mainList.get(index);
            long entryId = entry.getEntryId();
            BigDecimal entryPriceTaxAmt = entry.getEntryPayableAmt();
            if (remainNoWriteBackAmt.signum() != entryPriceTaxAmt.signum()) continue;
            BigDecimal beforeWriteBackAmt = result.get(entryId);
            if (beforeWriteBackAmt == null) {
                if (remainNoWriteBackAmt.abs().compareTo(entryPriceTaxAmt.abs()) > 0) {
                    result.put(entryId, entryPriceTaxAmt);
                    remainNoWriteBackAmt = remainNoWriteBackAmt.subtract(entryPriceTaxAmt);
                } else {
                    result.put(entryId, remainNoWriteBackAmt);
                    remainNoWriteBackAmt = BigDecimal.ZERO;
                }
            } else {
                BigDecimal allowWriteBackAmt = entryPriceTaxAmt.subtract(beforeWriteBackAmt);
                if (remainNoWriteBackAmt.abs().compareTo(allowWriteBackAmt.abs()) > 0) {
                    result.put(entryId, entryPriceTaxAmt);
                    remainNoWriteBackAmt = remainNoWriteBackAmt.subtract(allowWriteBackAmt);
                } else {
                    result.put(entryId, beforeWriteBackAmt.add(remainNoWriteBackAmt));
                    remainNoWriteBackAmt = BigDecimal.ZERO;
                }
            }
            if (remainNoWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    private List<SettleRecordVO> buildSettleRecord(List<BillSettleVO> mainList, List<BillSettleVO> asstList, Map<Long, BigDecimal> entryIdToSettleAmt) {
        ArrayList<SettleRecordVO> resultList = new ArrayList<SettleRecordVO>(mainList.size());
        BigDecimal asstPayableAmtTotal = BigDecimal.ZERO;
        for (BillSettleVO asst : asstList) {
            asstPayableAmtTotal = asstPayableAmtTotal.add(asst.getEntryPayableAmt());
        }
        HashMap<Long, BigDecimal> remainAsstSettleAmtMap = new HashMap<Long, BigDecimal>(asstList.size());
        int mainIndex = 0;
        for (BillSettleVO main : mainList) {
            ++mainIndex;
            BigDecimal curSettleAmt = entryIdToSettleAmt.get(main.getEntryId());
            if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            SettleRecordVO result = new SettleRecordVO();
            result.setTotalSettleAmt(curSettleAmt);
            this.fillSettleRecord(result, main);
            int asstIndex = 0;
            BigDecimal remainMainToAsstSettleAmtTotal = BigDecimal.ZERO;
            for (BillSettleVO asst : asstList) {
                BigDecimal curAsstSettleAmt;
                ++asstIndex;
                BigDecimal asstPayableAmt = asst.getEntryPayableAmt();
                long asstEntryId = asst.getEntryId();
                SettleRecordEntryVO entry = new SettleRecordEntryVO();
                if (mainIndex == mainList.size()) {
                    if (asstIndex == asstList.size()) {
                        curAsstSettleAmt = curSettleAmt.subtract(remainMainToAsstSettleAmtTotal);
                    } else {
                        BigDecimal remainAsstSettleAmt = (BigDecimal)remainAsstSettleAmtMap.get(asstEntryId);
                        curAsstSettleAmt = remainAsstSettleAmt != null ? asstPayableAmt.subtract(remainAsstSettleAmt) : asstPayableAmt;
                        remainMainToAsstSettleAmtTotal = remainMainToAsstSettleAmtTotal.add(curAsstSettleAmt);
                    }
                } else if (asstIndex == asstList.size()) {
                    curAsstSettleAmt = curSettleAmt.subtract(remainMainToAsstSettleAmtTotal);
                } else {
                    BigDecimal proportion = asstPayableAmt.divide(asstPayableAmtTotal, 10, RoundingMode.DOWN);
                    curAsstSettleAmt = curSettleAmt.multiply(proportion).setScale((int)asst.getPrecision(), RoundingMode.DOWN);
                    BigDecimal remainAsstSettleAmt = (BigDecimal)remainAsstSettleAmtMap.get(asstEntryId);
                    if (remainAsstSettleAmt == null) {
                        remainAsstSettleAmtMap.put(asstEntryId, curAsstSettleAmt);
                    } else {
                        remainAsstSettleAmt = remainAsstSettleAmt.add(curAsstSettleAmt);
                        remainAsstSettleAmtMap.put(asstEntryId, remainAsstSettleAmt);
                    }
                    remainMainToAsstSettleAmtTotal = remainMainToAsstSettleAmtTotal.add(curAsstSettleAmt);
                }
                entry.setSettleAmt(curAsstSettleAmt);
                this.fillSettleRecordEntry(entry, asst);
                result.getEntrys().add(entry);
            }
            resultList.add(result);
        }
        return resultList;
    }
}

