/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.settle.writeback.ISettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.SettleWriteBackerParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractSettleWriteBacker
implements ISettleWriteBacker {
    protected static final Log logger = LogFactory.getLog(AbstractSettleWriteBacker.class);
    protected SettleSchemeVO scheme;
    protected String entityName;
    protected Map<Long, WBAmtInfo> headNeedWBAmtMap = new HashMap<Long, WBAmtInfo>(8);
    protected Map<Long, List<SettleRecordVO>> entryIdToSettleRecordMap = new HashMap<Long, List<SettleRecordVO>>(8);
    protected boolean isAsMain;

    @Override
    public void initParam(SettleWriteBackerParam param) {
        this.scheme = param.getScheme();
        this.entityName = param.getEntityName();
    }

    @Override
    public void writeBackAsMain(List<SettleRecordVO> settleRecordVOList) {
        logger.info("settle writeback as main start:" + this.getClass().getSimpleName());
        this.isAsMain = true;
        this.writeBack(settleRecordVOList);
        logger.info("settle writeback as main end");
    }

    @Override
    public void writeBackAsAsst(List<SettleRecordEntryVO> entryVOList) {
        logger.info("settle writeback as asst start:" + this.getClass().getSimpleName());
        this.isAsMain = false;
        List<SettleRecordVO> settleRecordVOS = this.convert2SRList(entryVOList);
        this.writeBack(settleRecordVOS);
        this.repairSettleRecord(entryVOList, settleRecordVOS);
        logger.info("settle writeback as asst end");
    }

    private void writeBack(List<SettleRecordVO> settleRecordVOList) {
        if (ObjectUtils.isEmpty(settleRecordVOList) || this.scheme == null) {
            return;
        }
        DynamicObject[] bills = this.loadNeedWriteBackBills(settleRecordVOList);
        this.groupSettleRecordVO(settleRecordVOList);
        logger.info("settle writeback beforeDoWriteBack start");
        this.beforeDoWriteBack(bills, settleRecordVOList);
        logger.info("settle writeback beforeDoWriteBack end");
        logger.info("settle writeback doWriteBack start");
        this.doWriteBack(settleRecordVOList);
        logger.info("settle writeback doWriteBack end");
        logger.info("settle writeback afterDoWriteBack start");
        this.afterDoWriteBack(bills, settleRecordVOList);
        logger.info("settle writeback afterDoWriteBack end");
        this.saveBills(bills);
        this.afterSaveBills(bills);
        this.release();
    }

    protected void afterSaveBills(DynamicObject[] bills) {
    }

    protected abstract DynamicObject[] loadNeedWriteBackBills(List<SettleRecordVO> var1);

    protected abstract void beforeDoWriteBack(DynamicObject[] var1, List<SettleRecordVO> var2);

    protected abstract void doWriteBack(List<SettleRecordVO> var1);

    protected abstract void afterDoWriteBack(DynamicObject[] var1, List<SettleRecordVO> var2);

    protected void saveBills(DynamicObject[] bills) {
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    protected void release() {
        this.headNeedWBAmtMap.clear();
        this.entryIdToSettleRecordMap.clear();
    }

    private void groupSettleRecordVO(List<SettleRecordVO> settleRecordVOList) {
        for (SettleRecordVO result : settleRecordVOList) {
            if (!result.getEntrys().isEmpty()) {
                this.scheme.setAsstBillId(result.getEntrys().get(0).getBillId());
                this.scheme.setAsstEntity(result.getEntrys().get(0).getBillEntity());
            }
            long billId = result.getMainBillId();
            long billEntryId = result.getMainBillEntryId();
            BigDecimal curNeedWBAmt = result.getTotalSettleAmt();
            BigDecimal curNeedWBLocalAmt = result.getLocalTotalSettleamt();
            WBAmtInfo headWBAmtInfo = this.headNeedWBAmtMap.get(billId);
            if (headWBAmtInfo == null) {
                this.headNeedWBAmtMap.put(billId, new WBAmtInfo(curNeedWBAmt, curNeedWBLocalAmt));
            } else {
                headWBAmtInfo.wbAmt = headWBAmtInfo.wbAmt.add(curNeedWBAmt);
                headWBAmtInfo.wbLocalAmt = headWBAmtInfo.wbLocalAmt.add(curNeedWBLocalAmt);
            }
            List<SettleRecordVO> settleRecordVOS = this.entryIdToSettleRecordMap.get(billEntryId);
            if (settleRecordVOS == null) {
                settleRecordVOS = new ArrayList<SettleRecordVO>(1);
                settleRecordVOS.add(result);
                this.entryIdToSettleRecordMap.put(billEntryId, settleRecordVOS);
                continue;
            }
            settleRecordVOS.add(result);
        }
    }

    protected boolean isWBLock(SettleRecordVO result, String ... possibleSources) {
        boolean isWBLock = false;
        if (this.scheme.isSettle()) {
            if (this.scheme.isOnlyByBotp()) {
                if (this.scheme.isAdjust()) {
                    isWBLock = true;
                }
                if (SettleRelationEnum.APWRITEOFF.getValue().equals(this.scheme.getSettleRelation()) || SettleRelationEnum.ARWRITEOFF.getValue().equals(this.scheme.getSettleRelation())) {
                    isWBLock = true;
                }
            } else if (!(this.scheme.isTransferPay() || this.scheme.isLiquidateSettle() || this.scheme.isClaim())) {
                isWBLock = true;
            }
        } else {
            if (SettleTypeEnum.MANUAL.getValue().equals(result.getSettleType()) || SettleTypeEnum.MATCH.getValue().equals(result.getSettleType()) || this.scheme.isUnSettleByListOP() || !this.isBotpSettleRecord(result, possibleSources)) {
                isWBLock = true;
            }
            if ((SettleRelationEnum.ARPREMSETTLE.getValue().equals(this.scheme.getSettleRelation()) || SettleRelationEnum.PREMSETTLE.getValue().equals(this.scheme.getSettleRelation())) && !this.scheme.isUnSettleByListOP()) {
                isWBLock = false;
            }
        }
        return isWBLock;
    }

    private boolean isBotpSettleRecord(SettleRecordVO result, String ... possibleSources) {
        boolean isBotpSettle = false;
        String autoSettleType = result.getAutoSettleType();
        if ("1".equals(autoSettleType) || "5".equals(autoSettleType)) {
            isBotpSettle = true;
        } else if ("0".equals(autoSettleType)) {
            isBotpSettle = !ArApHelper.verifyByCoreBill(result.getSettleType(), this.scheme.getAsstBillId(), this.scheme.getAsstEntity(), possibleSources);
        }
        return isBotpSettle;
    }

    private List<SettleRecordVO> convert2SRList(List<SettleRecordEntryVO> entryVOList) {
        ArrayList<SettleRecordVO> srList = new ArrayList<SettleRecordVO>(entryVOList.size());
        for (SettleRecordEntryVO entry : entryVOList) {
            SettleRecordVO sr = new SettleRecordVO();
            sr.setMainBillId(entry.getBillId());
            sr.setMainBillEntryId(entry.getBillEntryId());
            sr.setTotalSettleAmt(entry.getSettleAmt());
            sr.setLocalTotalSettleamt(entry.getLocalSettleAmt());
            sr.setExchangeRate(entry.getExchangeRate());
            sr.setSettleType(entry.getSettleType());
            sr.setSettleEntry(entry.getSettleEntry());
            sr.setAutoSettleType(entry.getAutoSettleType());
            sr.setBillEntity(entry.getBillEntity());
            sr.setMainVo(false);
            srList.add(sr);
        }
        return srList;
    }

    private void repairSettleRecord(List<SettleRecordEntryVO> entryVOList, List<SettleRecordVO> settleRecordVOS) {
        int length = entryVOList.size();
        for (int i = 0; i < length; ++i) {
            entryVOList.get(i).setLocalSettleAmt(settleRecordVOS.get(i).getLocalTotalSettleamt());
        }
    }

    static class WBAmtInfo {
        BigDecimal wbAmt;
        BigDecimal wbLocalAmt;

        WBAmtInfo(BigDecimal wbAmt, BigDecimal wbLocalAmt) {
            this.wbAmt = wbAmt;
            this.wbLocalAmt = wbLocalAmt;
        }
    }
}

