/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.writeback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleEntryEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.PaySettle4ScmcHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.settle.writeback.FinSettleWriteBacker;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.writeback.settle.FinArSettleWBService;

public class FinArSettleWriteBacker
extends FinSettleWriteBacker {
    @Override
    protected void beforeDoWriteBack(DynamicObject[] bills, List<SettleRecordVO> settleRecordVOList) {
        super.beforeDoWriteBack(bills, settleRecordVOList);
    }

    @Override
    protected void afterDoWriteBack(DynamicObject[] wbAfterBills, List<SettleRecordVO> settleRecordVOList) {
        Set billIds = Arrays.stream(wbAfterBills).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] wbBeforeBills = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.getWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        logger.info("FinArSettleWriteBacker.afterDoWriteBack invokeCoreBillExtractScmc start");
        this.invokeCoreBillExtractScmc(settleRecordVOList, wbBeforeBills);
        logger.info("FinArSettleWriteBacker.afterDoWriteBack invokeCoreBillExtractScmc end");
        logger.info("FinArSettleWriteBacker.afterDoWriteBack invokePurAndConBill start");
        Settle4ScmcHelper.newWriteBackPurAndCon(settleRecordVOList, wbAfterBills, this.scheme, wbBeforeBills);
        logger.info("FinArSettleWriteBacker.afterDoWriteBack invokePurAndConBill end");
        logger.info("FinArSettleWriteBacker.afterDoWriteBack resolveReserveBill start");
        this.resolveReserveBill(wbAfterBills);
        logger.info("FinArSettleWriteBacker.afterDoWriteBack resolveReserveBill end");
        OpLogServiceHelper.addLog(this.scheme.isSettle() ? "settle" : "unsettle", (Object)this.scheme.toString(), wbAfterBills, false);
    }

    private void resolveReserveBill(DynamicObject[] wbAfterBills) {
        DynamicObject[] initReserves;
        HashMap<Long, DynamicObject> needReverseBillMap = new HashMap<Long, DynamicObject>(1);
        for (DynamicObject wbAfterBill : wbAfterBills) {
            if (!wbAfterBill.getBoolean("isperiod")) continue;
            needReverseBillMap.put(wbAfterBill.getLong("id"), wbAfterBill);
        }
        if (needReverseBillMap.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", needReverseBillMap.keySet());
        for (DynamicObject initReserve : initReserves = BusinessDataServiceHelper.load((String)"ar_baddebtreservebill", (String)"id, sourcebillid, unsettleamt, unsettlelocalamt, baddebtreserveamt, referencerate", (QFilter[])new QFilter[]{qFilter})) {
            long finArBillId = initReserve.getLong("sourcebillid");
            DynamicObject bill = (DynamicObject)needReverseBillMap.get(finArBillId);
            initReserve.set("unsettleamt", (Object)bill.getBigDecimal("unsettleamount"));
            BigDecimal unSettleLocAmt = bill.getBigDecimal("unsettlelocalamt");
            initReserve.set("unsettlelocalamt", (Object)unSettleLocAmt);
            int precision = bill.getBigDecimal("exchangerate").scale();
            if (unSettleLocAmt.compareTo(BigDecimal.ZERO) != 0) {
                initReserve.set("referencerate", (Object)initReserve.getBigDecimal("baddebtreserveamt").divide(initReserve.getBigDecimal("unsettlelocalamt"), 2 + precision, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(precision, RoundingMode.HALF_UP));
                continue;
            }
            initReserve.set("referencerate", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])initReserves);
    }

    private void invokeCoreBillExtractScmc(List<SettleRecordVO> settleRecordVOList, DynamicObject[] wbBeforeBills) {
        HashMap<Long, DynamicObject> arBillMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> arBillEntryMap = new HashMap<Long, DynamicObject>(64);
        boolean isSettleByMaterial = SettleEntryEnum.DETAIL.getValue() == settleRecordVOList.get(0).getSettleEntry();
        for (DynamicObject arBill : wbBeforeBills) {
            DynamicObjectCollection entries;
            arBillMap.put(arBill.getLong("id"), arBill);
            if (isSettleByMaterial) {
                entries = arBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    arBillEntryMap.put(entry.getLong("id"), entry);
                }
                continue;
            }
            entries = arBill.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : entries) {
                arBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
        Set<Long> recEntryIdSet = this.getConfirmRecSet(settleRecordVOList);
        FinArSettleWBService service = new FinArSettleWBService();
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(64);
        for (SettleRecordVO result : settleRecordVOList) {
            long mainBillId = result.getMainBillId();
            long mainBillEntryId = result.getMainBillEntryId();
            DynamicObject bill = (DynamicObject)arBillMap.get(mainBillId);
            DynamicObject entry = (DynamicObject)arBillEntryMap.get(mainBillEntryId);
            BigDecimal settleAmt = result.getTotalSettleAmt();
            if (!result.getEntrys().isEmpty()) {
                this.scheme.setAsstBillId(result.getEntrys().get(0).getBillId());
                this.scheme.setAsstEntity(result.getEntrys().get(0).getBillEntity());
            }
            if (!this.scheme.isSettle()) {
                settleAmt = settleAmt.negate();
            }
            service.processCoreBillParam(paramList, bill, settleAmt, entry, this.scheme, result, recEntryIdSet);
        }
        if (!paramList.isEmpty()) {
            PaySettle4ScmcHelper.disposeCoreBillExceptScmc(paramList, this.scheme.isSettle());
        }
    }

    private Set<Long> getConfirmRecSet(List<SettleRecordVO> voList) {
        HashSet<Long> idSet = new HashSet<Long>(64);
        String settleRela = voList.get(0).getSettleRela();
        if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRela)) {
            for (SettleRecordVO result : voList) {
                List<SettleRecordEntryVO> entrys = result.getEntrys();
                for (SettleRecordEntryVO entry : entrys) {
                    idSet.add(entry.getBillId());
                }
            }
            DynamicObjectCollection recColl = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("confirmlogo", "=", (Object)Boolean.TRUE), new QFilter("entry.e_corebilltype", "=", (Object)"sm_salorder")});
            DynamicObjectCollection recScmColl = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("entry.e_matchselltag", "=", (Object)Boolean.TRUE)});
            recColl.addAll((Collection)recScmColl);
            idSet.clear();
            for (DynamicObject rec : recColl) {
                idSet.add(rec.getLong("entry.id"));
                logger.info("getConfirmRecSet idSet:" + rec.getLong("entry.id"));
            }
        }
        return idSet;
    }

    @Override
    protected List<String> getWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("settlestatus");
        selector.add("currency");
        selector.add("billtype");
        selector.add("sourcebillid");
        selector.add("basecurrency");
        selector.add("quotation");
        selector.add("exchangerate");
        selector.add("asstacttype");
        selector.add("istransfer");
        selector.add("asstact");
        selector.add("recamount");
        selector.add("reclocalamt");
        selector.add("unsettleamount");
        selector.add("unsettlelocalamt");
        selector.add("settleamount");
        selector.add("settlelocalamt");
        selector.add("isperiod");
        selector.add("isbaddebt");
        selector.add("e_recamount");
        selector.add("e_reclocalamt");
        selector.add("e_unlockamt");
        selector.add("e_lockedamt");
        selector.add("e_unsettleamt");
        selector.add("e_unsettlelocalamt");
        selector.add("e_settledamt");
        selector.add("e_settledlocalamt");
        selector.add("e_corebilltype");
        selector.add("e_corebillno");
        selector.add("corebillid");
        selector.add("corebillentryid");
        selector.add("planpricetax");
        selector.add("planpricetaxloc");
        selector.add("unplanlockamt");
        selector.add("planlockedamt");
        selector.add("unplansettleamt");
        selector.add("unplansettlelocamt");
        selector.add("plansettledamt");
        selector.add("plansettledlocamt");
        selector.add("e_conbillentity");
        selector.add("e_conbillid");
        selector.add("e_conbillentryid");
        selector.add("e_ispresent");
        selector.add("e_fixlockedamt");
        selector.add("e_fixsettleedamt");
        selector.add("p_sourcebillid");
        selector.add("p_sourcebillentryid");
        selector.add("e_splitdimensionid");
        selector.add("p_splitdimensionid");
        selector.add("settleversion");
        return selector;
    }
}

