/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.service.settle.writeback.AbstractSettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.FinArSettleWriteBacker;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class FinArTransferSettleWriteBacker
extends FinArSettleWriteBacker {
    @Override
    protected void doWriteBack(List<SettleRecordVO> settleRecordVOList) {
        if (1 == this.scheme.getSettleEntryParam()) {
            super.doWriteBack(settleRecordVOList);
        } else {
            logger.info("settle writeback head start");
            this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
                DynamicObject bill = (DynamicObject)this.billMap.get(billId);
                super.wbHead(bill, (AbstractSettleWriteBacker.WBAmtInfo)headWBAmtInfo);
            });
            logger.info("settle writeback head end");
            logger.info("settle writeback mainentry start");
            this.entryIdToSettleRecordMap.forEach((entryId, resultList) -> {
                DynamicObject entry = (DynamicObject)this.billEntryMap.get(entryId);
                super.wbPlanEntryByEntryId(entry, (List<SettleRecordVO>)resultList);
            });
            logger.info("settle writeback mainentry end");
            logger.info("settle writeback asstentry start");
            this.wbDetailEntry(settleRecordVOList);
            logger.info("settle writeback asstentry end");
            logger.info("settle writeback head status start");
            this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
                DynamicObject bill = (DynamicObject)this.billMap.get(billId);
                super.wbHeadSettleStatus(bill);
            });
            logger.info("settle writeback head status end");
        }
    }

    private void wbDetailEntry(List<SettleRecordVO> settleRecordVOList) {
        HashSet<Long> transferBillIds = new HashSet<Long>(8);
        for (SettleRecordVO vo : settleRecordVOList) {
            List<SettleRecordEntryVO> entrys = vo.getEntrys();
            for (SettleRecordEntryVO entry : entrys) {
                long billId2 = entry.getBillId();
                transferBillIds.add(billId2);
            }
        }
        DynamicObject[] transferBills = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.getTransferBillSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", transferBillIds)});
        HashMap<Long, AbstractSettleWriteBacker.WBAmtInfo> detailDisposeAmtMap = new HashMap<Long, AbstractSettleWriteBacker.WBAmtInfo>(8);
        for (DynamicObject transferBill : transferBills) {
            DynamicObjectCollection transferDetailEntries = transferBill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject transferDetailEntry : transferDetailEntries) {
                long sourceEntryId = transferDetailEntry.getLong(this.billModel.E_SOURCEBILLENTRYID);
                BigDecimal disposeAmt = transferDetailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTAL);
                BigDecimal disposeLocalAmt = transferDetailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC);
                AbstractSettleWriteBacker.WBAmtInfo wbAmtInfo = (AbstractSettleWriteBacker.WBAmtInfo)detailDisposeAmtMap.get(sourceEntryId);
                if (wbAmtInfo == null) {
                    detailDisposeAmtMap.put(sourceEntryId, new AbstractSettleWriteBacker.WBAmtInfo(disposeAmt, disposeLocalAmt));
                    continue;
                }
                wbAmtInfo.wbAmt = wbAmtInfo.wbAmt.add(disposeAmt);
                wbAmtInfo.wbLocalAmt = wbAmtInfo.wbLocalAmt.add(disposeLocalAmt);
            }
        }
        this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
            DynamicObject bill = (DynamicObject)this.billMap.get(billId);
            DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject detailEntry : detailEntries) {
                boolean isUnSettleDisposeAll;
                long entryId = detailEntry.getLong("id");
                AbstractSettleWriteBacker.WBAmtInfo wbAmtInfo = (AbstractSettleWriteBacker.WBAmtInfo)detailDisposeAmtMap.get(entryId);
                if (wbAmtInfo == null) continue;
                BigDecimal disposeAmt = wbAmtInfo.wbAmt;
                BigDecimal disposeLocalAmt = wbAmtInfo.wbLocalAmt;
                if (!this.scheme.isSettle()) {
                    disposeAmt = disposeAmt.negate();
                    disposeLocalAmt = disposeLocalAmt.negate();
                }
                if (disposeAmt == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                detailEntry.set(this.billModel.E_UNSETTLEAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNSETTLEAMT).subtract(disposeAmt));
                detailEntry.set(this.billModel.E_SETTLEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_SETTLEDAMT).add(disposeAmt));
                detailEntry.set(this.billModel.E_FIXSETTLEEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_FIXSETTLEEDAMT).add(disposeAmt));
                boolean isSettleDisposeAll = detailEntry.getBigDecimal(this.billModel.E_UNSETTLEAMT).compareTo(BigDecimal.ZERO) == 0;
                boolean bl = isUnSettleDisposeAll = detailEntry.getBigDecimal(this.billModel.E_SETTLEDAMT).compareTo(BigDecimal.ZERO) == 0;
                if (isSettleDisposeAll) {
                    detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC));
                    detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)BigDecimal.ZERO);
                } else if (isUnSettleDisposeAll) {
                    detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)BigDecimal.ZERO);
                    detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC));
                } else {
                    detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_SETTLEDLOCALAMT).add(disposeLocalAmt));
                    detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNSETTLELOCALAMT).subtract(disposeLocalAmt));
                }
                if (!this.isNeedWBLock) continue;
                detailEntry.set(this.billModel.E_UNLOCKAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNLOCKAMT).subtract(disposeAmt));
                detailEntry.set(this.billModel.E_LOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_LOCKEDAMT).add(disposeAmt));
                detailEntry.set(this.billModel.E_FIXLOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_FIXLOCKEDAMT).add(disposeAmt));
            }
        });
    }

    private List<String> getTransferBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(12);
        selector.add("id");
        selector.add("entry.e_recamount");
        selector.add("entry.e_reclocalamt");
        selector.add("entry.e_srcid");
        selector.add("entry.e_srcentryid");
        return selector;
    }
}

