/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.settle.writeback.AbstractSettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.SettleWriteBackerParam;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;
import kd.fi.arapcommon.vo.SettleRecordVO;

public abstract class FinSettleWriteBacker
extends AbstractSettleWriteBacker {
    protected BillModel billModel;
    protected Map<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(64);
    protected Map<Long, DynamicObject> billEntryMap = new HashMap<Long, DynamicObject>(64);
    protected Map<Long, AbstractSettleWriteBacker.WBAmtInfo> entryIdToNeedWBAmtMap = new HashMap<Long, AbstractSettleWriteBacker.WBAmtInfo>(8);
    protected boolean isNeedWBLock;

    @Override
    public void initParam(SettleWriteBackerParam param) {
        super.initParam(param);
        this.billModel = BillModelFactory.getModel(this.entityName);
    }

    @Override
    protected DynamicObject[] loadNeedWriteBackBills(List<SettleRecordVO> settleRecordVOList) {
        if (this.scheme.getSettleEntryParam() == 0) {
            this.scheme.setSettleEntryParam(settleRecordVOList.get(0).getSettleEntry());
        }
        Set needWBBillIds = settleRecordVOList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        return BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.getWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", needWBBillIds)});
    }

    @Override
    protected void beforeDoWriteBack(DynamicObject[] bills, List<SettleRecordVO> settleRecordVOList) {
        this.prepareBillInfos(bills, settleRecordVOList);
        this.isNeedWBLock = this.isWBLock(settleRecordVOList.get(0), this.entityName);
        this.loadEntryIdToWriteBackAmtMap(settleRecordVOList);
    }

    @Override
    protected void doWriteBack(List<SettleRecordVO> settleRecordVOList) {
        int asstSettleEntryParam;
        logger.info("settle writeback head start");
        this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
            DynamicObject bill = this.billMap.get(billId);
            if (bill != null) {
                this.wbHead(bill, (AbstractSettleWriteBacker.WBAmtInfo)headWBAmtInfo);
            }
        });
        logger.info("settle writeback head end");
        logger.info("settle writeback mainentry start");
        int settleEntryParam = this.scheme.getSettleEntryParam();
        if (!this.isAsMain && (SettleRelationEnum.ARAPSETTLE.getValue().equals(this.scheme.getSettleRelation()) || SettleRelationEnum.APARSETTLE.getValue().equals(this.scheme.getSettleRelation())) && (asstSettleEntryParam = settleRecordVOList.get(0).getSettleEntry()) != 0) {
            settleEntryParam = asstSettleEntryParam;
        }
        int finalSettleEntryParam = settleEntryParam;
        this.entryIdToSettleRecordMap.forEach((entryId, resultList) -> {
            DynamicObject entry = this.billEntryMap.get(entryId);
            if (entry != null) {
                if (1 == finalSettleEntryParam) {
                    this.wbDetailEntryByEntryId(entry, (List<SettleRecordVO>)resultList);
                } else {
                    this.wbPlanEntryByEntryId(entry, (List<SettleRecordVO>)resultList);
                }
            }
        });
        logger.info("settle writeback mainentry end");
        logger.info("settle writeback asstentry start");
        logger.info("settle writeback asstentry isNeedWBLock : " + this.isNeedWBLock);
        HashMap<Long, Map<Long, BigDecimal>> billToDimensionToNeedWriteBackAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(8);
        HashMap<Long, Map<Long, List<DynamicObject>>> billToDimensionToNeedWriteBackEntriesMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(8);
        this.setWriteBackAsstEntryData(billToDimensionToNeedWriteBackAmtMap, billToDimensionToNeedWriteBackEntriesMap, settleEntryParam);
        IFinEntryWriteBacker detailEntrySettleWriteBacker = WriteBackerFactory.getDetailEntrySettleWriteBacker(this.entityName);
        IFinEntryWriteBacker planEntrySettleWriteBacker = WriteBackerFactory.getPlanEntrySettleWriteBacker(this.entityName);
        IFinEntryWriteBacker detailEntryLockWriteBacker = WriteBackerFactory.getDetailEntryLockWriteBacker(this.entityName);
        IFinEntryWriteBacker planEntryLockWriteBacker = WriteBackerFactory.getPlanEntryLockWriteBacker(this.entityName);
        for (Map.Entry writeBackInfo : billToDimensionToNeedWriteBackAmtMap.entrySet()) {
            Long finBillId = (Long)writeBackInfo.getKey();
            DynamicObject finBill = this.billMap.get(finBillId);
            Map dimensionToNeedWriteBackAmtMap = (Map)writeBackInfo.getValue();
            Map dimensionToNeedWriteBackEntriesMap = (Map)billToDimensionToNeedWriteBackEntriesMap.get(finBillId);
            for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                List needWriteBackEntries;
                Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                BigDecimal writeBackAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                if (writeBackAmt.compareTo(BigDecimal.ZERO) == 0 || (needWriteBackEntries = (List)dimensionToNeedWriteBackEntriesMap.get(dimensionId)).size() == 0) continue;
                DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                if (1 == finalSettleEntryParam) {
                    this.wbPlanEntryByStrategy(planEntrySettleWriteBacker, finBill, needWriteBackEntryColl, writeBackAmt);
                } else {
                    this.wbDetailEntryByStrategy(detailEntrySettleWriteBacker, finBill, needWriteBackEntryColl, writeBackAmt);
                }
                if (!this.isNeedWBLock) continue;
                if (1 == finalSettleEntryParam) {
                    this.wbPlanEntryByStrategy(planEntryLockWriteBacker, finBill, needWriteBackEntryColl, writeBackAmt);
                    continue;
                }
                this.wbDetailEntryByStrategy(detailEntryLockWriteBacker, finBill, needWriteBackEntryColl, writeBackAmt);
            }
        }
        logger.info("settle writeback asstentry end");
        logger.info("settle writeback head status start");
        this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
            DynamicObject bill = this.billMap.get(billId);
            this.wbHeadSettleStatus(bill);
        });
        logger.info("settle writeback head status end");
    }

    @Override
    protected void afterDoWriteBack(DynamicObject[] bills, List<SettleRecordVO> settleRecordVOList) {
    }

    @Override
    protected void release() {
        super.release();
        this.billMap.clear();
        this.billEntryMap.clear();
    }

    protected abstract List<String> getWBSelector();

    private void prepareBillInfos(DynamicObject[] bills, List<SettleRecordVO> settleRecordVOList) {
        int asstSettleEntryParam;
        int settleEntryParam = this.scheme.getSettleEntryParam();
        if (!this.isAsMain && (SettleRelationEnum.ARAPSETTLE.getValue().equals(this.scheme.getSettleRelation()) || SettleRelationEnum.APARSETTLE.getValue().equals(this.scheme.getSettleRelation())) && (asstSettleEntryParam = settleRecordVOList.get(0).getSettleEntry()) != 0) {
            settleEntryParam = asstSettleEntryParam;
        }
        boolean settleByMaterial = settleEntryParam == 1;
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries;
            this.billMap.put(bill.getLong("id"), bill);
            if (settleByMaterial) {
                entries = bill.getDynamicObjectCollection(this.billModel.ENTRY);
                for (DynamicObject entry : entries) {
                    this.billEntryMap.put(entry.getLong("id"), entry);
                }
                continue;
            }
            entries = bill.getDynamicObjectCollection(this.billModel.P_ENTRY);
            for (DynamicObject entry : entries) {
                this.billEntryMap.put(entry.getLong("id"), entry);
            }
        }
    }

    private void loadEntryIdToWriteBackAmtMap(List<SettleRecordVO> settleRecordVOList) {
        for (SettleRecordVO result : settleRecordVOList) {
            long billEntryId = result.getMainBillEntryId();
            BigDecimal curNeedWBAmt = result.getTotalSettleAmt();
            BigDecimal curNeedWBLocalAmt = result.getLocalTotalSettleamt();
            AbstractSettleWriteBacker.WBAmtInfo entryIdToWBAmtInfo = this.entryIdToNeedWBAmtMap.get(billEntryId);
            if (entryIdToWBAmtInfo == null) {
                this.entryIdToNeedWBAmtMap.put(billEntryId, new AbstractSettleWriteBacker.WBAmtInfo(curNeedWBAmt, curNeedWBLocalAmt));
                continue;
            }
            entryIdToWBAmtInfo.wbAmt = entryIdToWBAmtInfo.wbAmt.add(curNeedWBAmt);
            entryIdToWBAmtInfo.wbLocalAmt = entryIdToWBAmtInfo.wbLocalAmt.add(curNeedWBLocalAmt);
        }
    }

    private void setWriteBackAsstEntryData(Map<Long, Map<Long, BigDecimal>> billToDimensionToNeedWriteBackAmtMap, Map<Long, Map<Long, List<DynamicObject>>> billToDimensionToNeedWriteBackEntriesMap, int settleEntryParam) {
        for (Map.Entry<Long, DynamicObject> finBillSet : this.billMap.entrySet()) {
            List writeBackEntries;
            long dimensionId;
            long dimensionId2;
            BigDecimal writeBackAmt;
            AbstractSettleWriteBacker.WBAmtInfo wbAmtInfo;
            DynamicObject finBill = finBillSet.getValue();
            HashMap<Long, BigDecimal> dimensionToNeedWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
            billToDimensionToNeedWriteBackAmtMap.put(finBill.getLong("id"), dimensionToNeedWriteBackAmtMap);
            HashMap<Long, List> needWriteBackEntriesByDimension = new HashMap<Long, List>(8);
            billToDimensionToNeedWriteBackEntriesMap.put(finBill.getLong("id"), needWriteBackEntriesByDimension);
            if (1 == settleEntryParam) {
                Object detailEntry2;
                DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
                for (Object detailEntry2 : detailEntries) {
                    long entryId = detailEntry2.getLong("id");
                    wbAmtInfo = this.entryIdToNeedWBAmtMap.get(entryId);
                    if (wbAmtInfo == null || (writeBackAmt = wbAmtInfo.wbAmt).compareTo(BigDecimal.ZERO) == 0) continue;
                    dimensionId2 = detailEntry2.getLong(this.billModel.E_SPLITDIMENSION_ID);
                    dimensionToNeedWriteBackAmtMap.merge(dimensionId2, writeBackAmt, (a, b) -> b.add((BigDecimal)a));
                }
                Iterator planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
                detailEntry2 = planEntries.iterator();
                while (detailEntry2.hasNext()) {
                    DynamicObject planEntry = (DynamicObject)detailEntry2.next();
                    dimensionId = planEntry.getLong(this.billModel.P_SPLITDIMENSION_ID);
                    if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                    writeBackEntries = needWriteBackEntriesByDimension.getOrDefault(dimensionId, new ArrayList(8));
                    writeBackEntries.add(planEntry);
                    needWriteBackEntriesByDimension.put(dimensionId, writeBackEntries);
                }
                continue;
            }
            DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
            for (DynamicObject planEntry : planEntries) {
                long entryId = planEntry.getLong("id");
                wbAmtInfo = this.entryIdToNeedWBAmtMap.get(entryId);
                if (wbAmtInfo == null || (writeBackAmt = wbAmtInfo.wbAmt).compareTo(BigDecimal.ZERO) == 0) continue;
                dimensionId2 = planEntry.getLong(this.billModel.P_SPLITDIMENSION_ID);
                dimensionToNeedWriteBackAmtMap.merge(dimensionId2, writeBackAmt, (a, b) -> b.add((BigDecimal)a));
            }
            DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject detailEntry : detailEntries) {
                dimensionId = detailEntry.getLong(this.billModel.E_SPLITDIMENSION_ID);
                if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                writeBackEntries = needWriteBackEntriesByDimension.getOrDefault(dimensionId, new ArrayList(8));
                writeBackEntries.add(detailEntry);
                needWriteBackEntriesByDimension.put(dimensionId, writeBackEntries);
            }
        }
    }

    protected void wbHead(DynamicObject bill, AbstractSettleWriteBacker.WBAmtInfo headWBAmtInfo) {
        boolean isUnSettleDisposeAll;
        BigDecimal settleAmt = headWBAmtInfo.wbAmt;
        BigDecimal localSettleAmt = headWBAmtInfo.wbLocalAmt;
        if (!this.scheme.isSettle()) {
            settleAmt = settleAmt.negate();
            localSettleAmt = localSettleAmt.negate();
        }
        bill.set(this.billModel.HEAD_UNSETTLEAMOUNT, (Object)bill.getBigDecimal(this.billModel.HEAD_UNSETTLEAMOUNT).subtract(settleAmt));
        bill.set(this.billModel.HEAD_SETTLEAMOUNT, (Object)bill.getBigDecimal(this.billModel.HEAD_SETTLEAMOUNT).add(settleAmt));
        boolean isSettleDisposeAll = bill.getBigDecimal(this.billModel.HEAD_UNSETTLEAMOUNT).compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = bill.getBigDecimal(this.billModel.HEAD_SETTLEAMOUNT).compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            bill.set(this.billModel.HEAD_UNSETTLELOCALAMT, (Object)BigDecimal.ZERO);
            bill.set(this.billModel.HEAD_SETTLELOCALAMT, (Object)bill.getBigDecimal(this.billModel.HEAD_PRICETAXTOTALLOC));
        } else if (isUnSettleDisposeAll) {
            bill.set(this.billModel.HEAD_UNSETTLELOCALAMT, (Object)bill.getBigDecimal(this.billModel.HEAD_PRICETAXTOTALLOC));
            bill.set(this.billModel.HEAD_SETTLELOCALAMT, (Object)BigDecimal.ZERO);
        } else {
            bill.set(this.billModel.HEAD_UNSETTLELOCALAMT, (Object)bill.getBigDecimal(this.billModel.HEAD_UNSETTLELOCALAMT).subtract(localSettleAmt));
            bill.set(this.billModel.HEAD_SETTLELOCALAMT, (Object)bill.getBigDecimal(this.billModel.HEAD_SETTLELOCALAMT).add(localSettleAmt));
        }
    }

    protected void wbDetailEntryByEntryId(DynamicObject detailEntry, List<SettleRecordVO> resultList) {
        for (SettleRecordVO result : resultList) {
            boolean isUnSettleDisposeAll;
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!this.scheme.isSettle()) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            detailEntry.set(this.billModel.E_SETTLEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_SETTLEDAMT).add(settleAmt));
            detailEntry.set(this.billModel.E_UNSETTLEAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNSETTLEAMT).subtract(settleAmt));
            boolean isSettleDisposeAll = detailEntry.getBigDecimal(this.billModel.E_UNSETTLEAMT).compareTo(BigDecimal.ZERO) == 0;
            boolean bl = isUnSettleDisposeAll = detailEntry.getBigDecimal(this.billModel.E_SETTLEDAMT).compareTo(BigDecimal.ZERO) == 0;
            if (isSettleDisposeAll) {
                result.setLocalTotalSettleamt(detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC).subtract(detailEntry.getBigDecimal(this.billModel.E_SETTLEDLOCALAMT)));
                detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC));
                detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)BigDecimal.ZERO);
            } else if (isUnSettleDisposeAll) {
                detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)BigDecimal.ZERO);
                detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC));
            } else {
                detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_SETTLEDLOCALAMT).add(localSettleAmt));
                detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNSETTLELOCALAMT).subtract(localSettleAmt));
            }
            if (!this.isNeedWBLock) continue;
            detailEntry.set(this.billModel.E_LOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_LOCKEDAMT).add(settleAmt));
            detailEntry.set(this.billModel.E_UNLOCKAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNLOCKAMT).subtract(settleAmt));
        }
    }

    protected void wbPlanEntryByEntryId(DynamicObject planEntry, List<SettleRecordVO> resultList) {
        for (SettleRecordVO result : resultList) {
            boolean isUnSettleDisposeAll;
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!this.scheme.isSettle()) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            planEntry.set(this.billModel.P_PLANSETTLEDAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANSETTLEDAMT).add(settleAmt));
            planEntry.set(this.billModel.P_UNPLANSETTLEAMT, (Object)planEntry.getBigDecimal(this.billModel.P_UNPLANSETTLEAMT).subtract(settleAmt));
            boolean isSettleDisposeAll = planEntry.getBigDecimal(this.billModel.P_UNPLANSETTLEAMT).compareTo(BigDecimal.ZERO) == 0;
            boolean bl = isUnSettleDisposeAll = planEntry.getBigDecimal(this.billModel.P_PLANSETTLEDAMT).compareTo(BigDecimal.ZERO) == 0;
            if (isSettleDisposeAll) {
                result.setLocalTotalSettleamt(planEntry.getBigDecimal(this.billModel.P_PLANPRICETAXLOC).subtract(planEntry.getBigDecimal(this.billModel.P_PLANSETTLEDLOCAMT)));
                planEntry.set(this.billModel.P_PLANSETTLEDLOCAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANPRICETAXLOC));
                planEntry.set(this.billModel.P_UNPLANSETTLELOCAMT, (Object)BigDecimal.ZERO);
            } else if (isUnSettleDisposeAll) {
                planEntry.set(this.billModel.P_PLANSETTLEDLOCAMT, (Object)BigDecimal.ZERO);
                planEntry.set(this.billModel.P_UNPLANSETTLELOCAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANPRICETAXLOC));
            } else {
                planEntry.set(this.billModel.P_PLANSETTLEDLOCAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANSETTLEDLOCAMT).add(localSettleAmt));
                planEntry.set(this.billModel.P_UNPLANSETTLELOCAMT, (Object)planEntry.getBigDecimal(this.billModel.P_UNPLANSETTLELOCAMT).subtract(localSettleAmt));
            }
            if (!this.isNeedWBLock) continue;
            planEntry.set(this.billModel.P_PLANLOCKEDAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANLOCKEDAMT).add(settleAmt));
            planEntry.set(this.billModel.P_UNPLANLOCKAMT, (Object)planEntry.getBigDecimal(this.billModel.P_UNPLANLOCKAMT).subtract(settleAmt));
        }
    }

    private void wbDetailEntryByStrategy(IFinEntryWriteBacker detailEntryWriteBacker, DynamicObject bill, DynamicObjectCollection entries, BigDecimal wbAmt) {
        if (this.scheme.isSettle()) {
            detailEntryWriteBacker.directWriteBack(bill, entries, wbAmt);
        } else {
            detailEntryWriteBacker.inverseWriteBack(bill, entries, wbAmt);
        }
    }

    private void wbPlanEntryByStrategy(IFinEntryWriteBacker planEntryWriteBacker, DynamicObject bill, DynamicObjectCollection entries, BigDecimal wbAmt) {
        if (this.scheme.isSettle()) {
            planEntryWriteBacker.directWriteBack(bill, entries, wbAmt);
        } else {
            planEntryWriteBacker.inverseWriteBack(bill, entries, wbAmt);
        }
    }

    protected void wbHeadSettleStatus(DynamicObject bill) {
        bill.set("settlestatus", (Object)this.getBillSettleStatus(bill));
    }

    private String getBillSettleStatus(DynamicObject bill) {
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.billModel.ENTRY);
        boolean settled = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unsettleAmt = entry.getBigDecimal(this.billModel.E_UNSETTLEAMT);
            if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            settled = false;
            break;
        }
        if (settled) {
            return "settled";
        }
        boolean unSettle = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal settledAmt = entry.getBigDecimal(this.billModel.E_SETTLEDAMT);
            if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            unSettle = false;
            break;
        }
        if (unSettle) {
            return "unsettle";
        }
        return "partsettle";
    }
}

