/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.exception.ManaulSettleQueryException;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.ext.SettleExtDataListKeyVO;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.settleconsole.AsstactCount;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;
import kd.fi.arapcommon.service.settleconsole.IBillDataProvider;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractBillDataProvider
implements IBillDataProvider {
    protected static final Log logger = LogFactory.getLog(AbstractBillDataProvider.class);
    protected BillDataProviderParam param;

    public AbstractBillDataProvider(BillDataProviderParam param) {
        this.param = param;
        if (!param.isMain() && 0 != param.getAsstSettleEntryParam() && (SettleRelationEnum.ARAPSETTLE.getValue().equals(param.getSettleRelation()) || SettleRelationEnum.APARSETTLE.getValue().equals(param.getSettleRelation()))) {
            param.setSettleEntry(param.getAsstSettleEntryParam());
        }
    }

    @Override
    public List<String> getFilterFieldKeys() {
        return SettleExtDataLoader.loadManualSettleFilterKeys(this.getEntityNumber());
    }

    @Override
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("basecurrency");
        selector.add("basecurrency.sign");
        selector.add("basecurrency.amtprecision");
        selector.add("currency.sign");
        selector.add("currency.amtprecision");
        selector.add("'0.00000000' cursettlelocamt");
        this.addExtField(selector);
        return selector;
    }

    @Override
    public List<Object[]> getBillDataRows() {
        ArrayList<Object[]> dataRows = new ArrayList<Object[]>(64);
        List<String> selector = this.getSelector();
        QFilter queryFilter = this.getQueryFilter();
        String entityNumber = this.getEntityNumber();
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        DataSet totalDataSet = QueryServiceHelper.queryDataSet((String)"manualsettlequery-id", (String)entityNumber, (String)"id", (QFilter[])queryFilter.toArray(), (String)"id");
        if (totalDataSet.isEmpty()) {
            return dataRows;
        }
        int count = 0;
        for (Row row : totalDataSet) {
            Long id = row.getLong("id");
            billIdSet.add(id);
            ++count;
        }
        int queryEntryCount = this.getQueryEntryCount();
        if (count > queryEntryCount) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ErrorCode ec = new ErrorCode("MANUALSETTLE_QUERY", String.format(ResManager.loadKDString((String)"[%1$s]\u67e5\u8be2\u7684\u5355\u636e\u5206\u5f55\u6570\u91cf\u8d85\u8fc7\u4e86\u6700\u5927\u503c%2$s\uff0c\u8bf7\u5728\u9ad8\u7ea7\u67e5\u8be2\u4e2d\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u540e\u518d\u8fdb\u884c\u67e5\u8be2\u3002", (String)"AbstractBillDataProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]), dataEntityType.getDisplayName(), queryEntryCount));
            throw new ManaulSettleQueryException(ec);
        }
        queryFilter = queryFilter.and(new QFilter("id", "in", billIdSet));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"manualsettlequery", (String)entityNumber, (String)String.join((CharSequence)",", selector), (QFilter[])queryFilter.toArray(), (String)"id", (int)queryEntryCount);
        if (!ObjectUtils.isEmpty((Object)coll) && this.param.isTotalDisplay()) {
            HashSet<Long> entryIdSet = new HashSet<Long>(10);
            for (int i = coll.size() - 1; i >= 0; --i) {
                DynamicObject obj = (DynamicObject)coll.get(i);
                Long entryId = obj.getLong("entryid");
                if (entryIdSet.add(entryId)) continue;
                coll.remove(i);
            }
            DynamicObject tempObj = null;
            for (int i = coll.size() - 1; i >= 0; --i) {
                DynamicObject obj = (DynamicObject)coll.get(i);
                if (tempObj == null || tempObj.getLong("id") != obj.getLong("id")) {
                    tempObj = obj;
                    continue;
                }
                if ("cas_paybill".equals(entityNumber) || "cas_recbill".equals(entityNumber) || "ap_paidbill".equals(entityNumber) || "ar_receivedbill".equals(entityNumber)) {
                    tempObj.set("pricetaxtotal", (Object)tempObj.getBigDecimal("pricetaxtotal").add(obj.getBigDecimal("pricetaxtotal")));
                }
                tempObj.set("unsettleamt", (Object)tempObj.getBigDecimal("unsettleamt").add(obj.getBigDecimal("unsettleamt")));
                tempObj.set("enableamt", (Object)tempObj.getBigDecimal("enableamt").add(obj.getBigDecimal("enableamt")));
                tempObj.set("cursettleamt", (Object)tempObj.getBigDecimal("cursettleamt").add(obj.getBigDecimal("cursettleamt")));
                coll.remove(i);
            }
        }
        if (coll.size() > 0) {
            Map<Long, String> asstMap = null;
            if ("cas_paybill".equals(entityNumber) || "cas_recbill".equals(entityNumber) || "ap_paidbill".equals(entityNumber) || "ar_receivedbill".equals(entityNumber)) {
                asstMap = this.getAsstMap(coll);
            }
            for (DynamicObject obj : coll) {
                String asstActName;
                if (asstMap != null && EmptyUtils.isNotEmpty(asstActName = asstMap.get(obj.get("asstact")))) {
                    obj.set("asstactname", (Object)asstActName);
                }
                BigDecimal enableamt = obj.getBigDecimal("enableamt");
                BigDecimal cursettleamt = obj.getBigDecimal("cursettleamt");
                if (enableamt.compareTo(BigDecimal.ZERO) == 0 || cursettleamt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal exchangeRate = obj.getBigDecimal("exchangerate");
                int baseAmtPrecision = obj.getInt("basecurrency.amtprecision");
                String quotation = obj.getString("quotation");
                BigDecimal locamt = "0".equals(quotation) ? cursettleamt.multiply(exchangeRate).setScale(baseAmtPrecision, RoundingMode.HALF_UP) : cursettleamt.divide(exchangeRate, baseAmtPrecision, RoundingMode.HALF_UP);
                obj.set("cursettlelocamt", (Object)locamt);
                Map<String, SettleExtDataListKeyVO> extColumnkeyMap = this.getExtListInfo(true);
                List<Object> rowObj = this.buildOneRow(obj, extColumnkeyMap);
                if (ObjectUtils.isEmpty(rowObj)) continue;
                dataRows.add(rowObj.toArray());
            }
        }
        if (this.param.getAsstactIdSetZero() && this.param.isMain()) {
            dataRows.clear();
        }
        return dataRows;
    }

    protected Map<Long, String> getAsstMap(DynamicObjectCollection coll) {
        Map<String, Set<Object>> asstMap = coll.stream().filter(this::filter).collect(Collectors.groupingBy(obj -> obj.getString("asstacttype"), Collectors.mapping(obj -> obj.get("asstact"), Collectors.toSet())));
        return AsstactHelper.getAsstactNames(asstMap);
    }

    protected boolean filter(DynamicObject obj) {
        BigDecimal enableamt = obj.getBigDecimal("enableamt");
        BigDecimal cursettleamt = obj.getBigDecimal("cursettleamt");
        return enableamt.compareTo(BigDecimal.ZERO) != 0 && cursettleamt.compareTo(BigDecimal.ZERO) != 0 && EmptyUtils.isNotEmpty(obj.getString("asstacttype")) && EmptyUtils.isNotEmpty(obj.get("asstact"));
    }

    @Override
    public Set<String> getAsstactName() {
        List<String> selector = this.getTreeSelector();
        QFilter queryFilter = this.getQueryFilter();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getEntityNumber(), (String)String.join((CharSequence)",", selector), (QFilter[])queryFilter.toArray(), (String)"bizdate,billno", (int)-1);
        ArrayList<Long> asstactIds = new ArrayList<Long>(100);
        for (DynamicObject obj : coll) {
            Long asstactId = obj.getLong(this.getAsstactKey());
            asstactIds.add(asstactId);
        }
        Map masterIdDOMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        HashMap<Long, Long> idMasterIdMap = new HashMap<Long, Long>(32);
        for (Object obj : masterIdDOMap.values()) {
            Long id = obj.getLong("id");
            idMasterIdMap.put(id, obj.getLong("masterid"));
        }
        HashSet<Long> masterIds = new HashSet<Long>(32);
        for (DynamicObject masterIdDO : masterIdDOMap.values()) {
            masterIds.add(masterIdDO.getLong("masterid"));
        }
        Map tempAsstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterIds)});
        HashSet<String> asstactNameSet = new HashSet<String>(8);
        HashMap asstactMap = new HashMap(32);
        for (DynamicObject obj : tempAsstactMap.values()) {
            Long masterid = obj.getLong("masterid");
            if (ObjectUtils.isEmpty(asstactMap.get(masterid))) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(obj.getLocaleString("name").toString());
                asstactMap.put(masterid, list);
                continue;
            }
            ((List)asstactMap.get(masterid)).add(obj.getLocaleString("name").toString());
        }
        if (!ObjectUtils.isEmpty((Object)coll) && this.param.isTotalDisplay()) {
            DynamicObject tempObj = null;
            for (int i = coll.size() - 1; i >= 0; --i) {
                DynamicObject obj = (DynamicObject)coll.get(i);
                if (tempObj == null || tempObj.getLong("id") != obj.getLong("id")) {
                    tempObj = obj;
                    continue;
                }
                coll.remove(i);
            }
        }
        if (coll.size() > 0) {
            for (DynamicObject obj : coll) {
                Long id = obj.getLong(this.getAsstactKey());
                Long asstactMasterId = (Long)idMasterIdMap.get(id);
                List asstactName = (List)asstactMap.get(asstactMasterId);
                if (ObjectUtils.isEmpty((Object)asstactName)) continue;
                asstactNameSet.addAll(asstactName);
            }
        }
        return asstactNameSet;
    }

    @Override
    public Map<Long, AsstactCount> getAsstactCount() {
        List<String> selector = this.getTreeSelector();
        QFilter queryFilter = this.getQueryFilter();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getEntityNumber(), (String)String.join((CharSequence)",", selector), (QFilter[])queryFilter.toArray(), (String)"bizdate,billno", (int)-1);
        ArrayList<Long> asstactIds = new ArrayList<Long>(100);
        for (DynamicObject obj : coll) {
            Long asstactId = obj.getLong(this.getAsstactKey());
            asstactIds.add(asstactId);
        }
        Map masterIdDOMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        HashMap<Long, Long> idMasterIdMap = new HashMap<Long, Long>(32);
        for (Object obj : masterIdDOMap.values()) {
            Long id = obj.getLong("id");
            idMasterIdMap.put(id, obj.getLong("masterid"));
        }
        HashSet<Long> masterIds = new HashSet<Long>(32);
        for (DynamicObject masterIdDO : masterIdDOMap.values()) {
            masterIds.add(masterIdDO.getLong("masterid"));
        }
        Map tempAsstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterIds)});
        HashMap<Long, String> asstactMap = new HashMap<Long, String>(32);
        for (DynamicObject obj : tempAsstactMap.values()) {
            Long masterid = obj.getLong("masterid");
            asstactMap.put(masterid, obj.getLocaleString("name").toString());
        }
        HashMap<Long, AsstactCount> map = new HashMap<Long, AsstactCount>(32);
        if (!ObjectUtils.isEmpty((Object)coll) && this.param.isTotalDisplay()) {
            DynamicObject tempObj = null;
            for (int i = coll.size() - 1; i >= 0; --i) {
                DynamicObject obj = (DynamicObject)coll.get(i);
                if (tempObj == null || tempObj.getLong("id") != obj.getLong("id")) {
                    tempObj = obj;
                    continue;
                }
                coll.remove(i);
            }
        }
        if (coll.size() > 0) {
            for (DynamicObject obj : coll) {
                Long id = obj.getLong(this.getAsstactKey());
                Long asstactMasterId = (Long)idMasterIdMap.get(id);
                if (map.get(asstactMasterId) == null) {
                    map.put(asstactMasterId, new AsstactCount((String)asstactMap.get(asstactMasterId), 0));
                }
                AsstactCount asstactCount = (AsstactCount)map.get(asstactMasterId);
                asstactCount.setCount(asstactCount.getCount() + 1);
            }
        }
        return map;
    }

    protected abstract String getAsstactKey();

    private List<Object> buildOneRow(DynamicObject obj, Map<String, SettleExtDataListKeyVO> map) {
        ArrayList<Object> rowObj = new ArrayList<Object>();
        List<String> fields = this.param.getFields();
        if (!ObjectUtils.isEmpty(fields)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
            for (String field : fields) {
                if (this.isExistProperty(obj, field)) {
                    SettleExtDataListKeyVO extInfo = map.get(field);
                    if (extInfo != null) {
                        DateProp prop;
                        Object s;
                        String[] extKeys = extInfo.getBillKey().split("\\.");
                        IDataEntityProperty property = null;
                        String[] stringArray = extKeys;
                        int n = stringArray.length;
                        for (int i = 0; i < n && ((property = dataEntityType.findProperty((String)(s = stringArray[i]))) instanceof EntryProp || property == null); ++i) {
                        }
                        if (property instanceof ComboProp) {
                            String displayValue = "";
                            ComboProp prop2 = (ComboProp)property;
                            List mapItems = prop2.getComboItems();
                            s = mapItems.iterator();
                            while (s.hasNext()) {
                                ValueMapItem mapItem = (ValueMapItem)s.next();
                                if (!mapItem.getValue().equals(obj.get(field))) continue;
                                displayValue = mapItem.getName().getLocaleValue();
                            }
                            rowObj.add(displayValue);
                            continue;
                        }
                        if (property instanceof AmountProp) {
                            if (obj.getBigDecimal(field).compareTo(BigDecimal.ZERO) != 0) {
                                prop = (AmountProp)property;
                                String currencyName = prop.getControlPropName();
                                int presicion = obj.getInt(currencyName + ".amtprecision");
                                String sign = obj.getString(currencyName + ".sign");
                                String result = sign + this.formatAmount(obj.getBigDecimal(field), presicion);
                                rowObj.add(result);
                                continue;
                            }
                            rowObj.add("");
                            continue;
                        }
                        if (property instanceof DateProp) {
                            prop = (DateProp)property;
                            if (obj.get(field) != null) {
                                String formatValue = prop.getDateFormat().format(obj.get(field));
                                rowObj.add(formatValue);
                                continue;
                            }
                            rowObj.add(null);
                            continue;
                        }
                        if (property instanceof DateTimeProp) {
                            prop = (DateTimeProp)property;
                            if (obj.get(field) != null) {
                                String formatValue = prop.getDateFormat().format(obj.get(field));
                                rowObj.add(formatValue);
                                continue;
                            }
                            rowObj.add(null);
                            continue;
                        }
                        rowObj.add(obj.get(field));
                        continue;
                    }
                    rowObj.add(obj.get(field));
                    continue;
                }
                rowObj.add(null);
            }
        }
        return rowObj;
    }

    @Override
    public Map<String, SettleExtDataListKeyVO> getExtListInfo(boolean isMainPreix) {
        String prefix = isMainPreix ? "ext_field" : "asst_ext_field";
        HashMap<String, SettleExtDataListKeyVO> map = new HashMap<String, SettleExtDataListKeyVO>(5);
        List<SettleExtDataListKeyVO> listKeys = this.getSettleExtDataListKeys();
        for (int i = 0; i < listKeys.size(); ++i) {
            SettleExtDataListKeyVO vo = listKeys.get(i);
            String billKeyPlace = vo.getBillKeyPlace();
            if ("head".equals(billKeyPlace) || StringUtils.isEmpty((String)billKeyPlace)) {
                map.put(prefix + i, vo);
                continue;
            }
            if (this.param.isTotalDisplay()) continue;
            if (this.param.getSettleEntry() == 1 && !"planentry".equals(billKeyPlace)) {
                map.put(prefix + i, vo);
            }
            if (this.param.getSettleEntry() != 2 || "detailentry".equals(billKeyPlace)) continue;
            map.put(prefix + i, vo);
        }
        return map;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return null;
    }

    @Override
    public List<String> getTreeSelector() {
        return null;
    }

    protected void replaceFilterProp(String oldName, String newName, QFilter filter) {
        String property = filter.getProperty();
        if (oldName.equals(property)) {
            filter.__setProperty(newName);
        } else {
            List filterNest = filter.getNests(true);
            for (QFilter.QFilterNest nest : filterNest) {
                QFilter filterInner = nest.getFilter();
                String innerProperty = filterInner.getProperty();
                if (!oldName.equals(innerProperty)) continue;
                filterInner.__setProperty(newName);
                if (!oldName.equals(filterInner.getValue())) continue;
                filterInner.__setValue((Object)newName);
            }
        }
    }

    protected void replaceFilterPropForMulti(String oldName, String newName, QFilter filter) {
        block4: {
            String oldFilterName;
            block5: {
                MultiBaseDataFilterValue[] multiValueArray;
                Object value;
                block6: {
                    String property;
                    oldFilterName = oldName + ".name";
                    if (!oldFilterName.equals(property = filter.getProperty())) break block5;
                    filter.__setProperty(newName + ".name");
                    value = filter.getValue();
                    if (!(value instanceof MultiBaseDataFilterValue)) break block6;
                    MultiBaseDataFilterValue multiValue = (MultiBaseDataFilterValue)value;
                    multiValue.setJoinProperty(newName);
                    break block4;
                }
                if (!(value instanceof MultiBaseDataFilterValue[])) break block4;
                for (MultiBaseDataFilterValue multiValue : multiValueArray = (MultiBaseDataFilterValue[])value) {
                    multiValue.setJoinProperty(newName);
                }
                break block4;
            }
            List filterNest = filter.getNests(true);
            for (QFilter.QFilterNest nest : filterNest) {
                MultiBaseDataFilterValue[] multiValueArray;
                QFilter filterInner = nest.getFilter();
                String innerProperty = filterInner.getProperty();
                if (!oldFilterName.equals(innerProperty)) continue;
                filterInner.__setProperty(newName + ".name");
                Object value = filterInner.getValue();
                if (value instanceof MultiBaseDataFilterValue) {
                    MultiBaseDataFilterValue multiValue = (MultiBaseDataFilterValue)value;
                    multiValue.setJoinProperty(newName);
                    break;
                }
                if (!(value instanceof MultiBaseDataFilterValue[])) break;
                for (MultiBaseDataFilterValue multiValue : multiValueArray = (MultiBaseDataFilterValue[])value) {
                    multiValue.setJoinProperty(newName);
                }
                break;
            }
        }
    }

    protected List<String> getAsstact(String entityName, String masterid) {
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,name,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)Long.parseLong(masterid))});
        if (asstactMap == null || asstactMap.size() == 0) {
            return new ArrayList<String>();
        }
        return asstactMap.values().stream().map(asstact -> asstact.getString("name")).collect(Collectors.toList());
    }

    protected List<Long> getAsstactIds(String entityName, String masterid) {
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,name,masterid,bizpartner", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)Long.parseLong(masterid))});
        HashSet<Long> bizpartnerIdSet = new HashSet<Long>(8);
        ArrayList<Long> asstactIdList = new ArrayList<Long>(8);
        for (Map.Entry entry : asstactMap.entrySet()) {
            long bizPartnerId = ((DynamicObject)entry.getValue()).getLong("bizpartner.id");
            if (bizPartnerId == 0L) continue;
            bizpartnerIdSet.add(bizPartnerId);
        }
        if (!ObjectUtils.isEmpty(bizpartnerIdSet)) {
            Map supplierMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner.id", "in", bizpartnerIdSet)});
            Map customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner.id", "in", bizpartnerIdSet)});
            for (Map.Entry entry : supplierMap.entrySet()) {
                asstactIdList.add(((DynamicObject)entry.getValue()).getLong("id"));
            }
            for (Map.Entry entry : customerMap.entrySet()) {
                asstactIdList.add(((DynamicObject)entry.getValue()).getLong("id"));
            }
        }
        List<Long> asstactIds = BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId()));
        asstactIdList.addAll(asstactIds);
        return asstactIdList;
    }

    private void addExtField(List<String> selector) {
        List<SettleExtDataListKeyVO> listKeys = SettleExtDataLoader.loadManualSettleListKeys(this.getEntityNumber());
        for (int i = 0; i < listKeys.size(); ++i) {
            String billKey = listKeys.get(i).getBillKey();
            String billKeyPlace = listKeys.get(i).getBillKeyPlace();
            if ("head".equals(billKeyPlace) || StringUtils.isEmpty((String)billKeyPlace)) {
                selector.add(billKey + " as ext_field" + i);
                continue;
            }
            if (this.param.isTotalDisplay()) continue;
            if (this.param.getSettleEntry() == 1 && !"planentry".equals(billKeyPlace)) {
                selector.add(billKey + " as ext_field" + i);
            }
            if (this.param.getSettleEntry() != 2 || "detailentry".equals(billKeyPlace)) continue;
            selector.add(listKeys.get(i).getBillKey() + " as ext_field" + i);
        }
    }

    private List<SettleExtDataListKeyVO> getSettleExtDataListKeys() {
        return SettleExtDataLoader.loadManualSettleListKeys(this.getEntityNumber());
    }

    private boolean isExistProperty(DynamicObject bill, String propertyName) {
        DynamicProperty property;
        boolean isExistProperty = false;
        DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
        if (dynamicObjectType != null && (property = dynamicObjectType.getProperty(propertyName)) != null) {
            isExistProperty = true;
        }
        return isExistProperty;
    }

    private int getQueryEntryCount() {
        int queryEntryCount = 50000;
        String queryEntryCountConfig = StdConfig.get("queryEntryCount");
        if (!ObjectUtils.isEmpty((Object)queryEntryCountConfig)) {
            queryEntryCount = Integer.parseInt(queryEntryCountConfig);
        }
        return queryEntryCount;
    }

    private String formatAmount(BigDecimal amount, int presicion) {
        StringBuilder formatSB = new StringBuilder();
        formatSB.append("###,###,###,###.");
        for (int i = 0; i < presicion; ++i) {
            formatSB.append('0');
        }
        DecimalFormat format = new DecimalFormat(formatSB.toString());
        return format.format(amount);
    }
}

