/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.settleconsole.AbstractBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.AsstactCount;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;
import kd.fi.arapcommon.service.settleconsole.PaidBillDataProvider;

public class PayBillDataProvider
extends AbstractBillDataProvider {
    public PayBillDataProvider(BillDataProviderParam param) {
        super(param);
    }

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("'" + this.getEntityNumber() + "' billtype");
        selector.add("payeetype asstacttype");
        selector.add("payee asstact");
        selector.add("payeetype asstacttypeenum");
        selector.add("payeename asstactname");
        selector.add("currency");
        selector.add("payquotation quotation");
        selector.add("exchangerate");
        if (this.param.isTotalDisplay()) {
            selector.add("paymenttype");
            selector.add("entry.e_actamt pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
        } else {
            selector.add("0 pricetaxtotal");
            selector.add("entry.e_paymenttype paymenttype");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_actamt e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter() {
        QFilter filter = new QFilter("entry.settleorg", "=", this.param.getOrgPk());
        if (this.param.getGridFilter() != null) {
            filter.and(this.param.getGridFilter());
        }
        if (this.param.isOnlyShowPre()) {
            filter.and(new QFilter("entry.e_paymenttype.biztype", "=", (Object)"202"));
        }
        if (this.param.isMain()) {
            filter.and("payeetype", "=", (Object)this.param.getAsstactype());
        }
        if (!StringUtils.isEmpty((CharSequence)this.param.getAsstactId())) {
            if (this.param.isMain()) {
                filter.and("itempayee", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
            } else if ("asstandcur".equals(this.param.getMatchCondition())) {
                if ("recpaysettle".equals(this.param.getSettleRelation())) {
                    List<String> asstactName = this.getAsstact(this.param.getAsstactype(), this.param.getAsstactId());
                    filter.and("payeename", "in", asstactName);
                } else {
                    filter.and("itempayee", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
                }
            }
        } else if (!ObjectUtils.isEmpty(this.param.getMainAsstactIdSet()) && this.param.isMain()) {
            Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("masterid", "in", this.param.getMainAsstactIdSet())});
            filter.and("itempayee", "in", asstactMap.keySet());
        }
        String sign = "<>";
        if (SettleRelationEnum.PAYSELF.getValue().equals(this.param.getSettleRelation())) {
            sign = this.param.isMain() ? ">" : "<";
        }
        if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(this.param.getSettleRelation())) {
            sign = ">";
        }
        filter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"}).and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", sign, (Object)0);
        return filter;
    }

    @Override
    public List<Object[]> getBillDataRows() {
        List<Object[]> payRows = super.getBillDataRows();
        if (!SettleRelationEnum.ARPAYSETTLE.getValue().equals(this.param.getSettleRelation())) {
            PaidBillDataProvider paidProvider = new PaidBillDataProvider(this.param);
            List<Object[]> paidRows = paidProvider.getBillDataRows();
            payRows.addAll(paidRows);
        }
        return payRows;
    }

    @Override
    public Map<Long, AsstactCount> getAsstactCount() {
        Map<Long, AsstactCount> payAsstactCount = super.getAsstactCount();
        if (!SettleRelationEnum.ARPAYSETTLE.getValue().equals(this.param.getSettleRelation())) {
            PaidBillDataProvider paidProvider = new PaidBillDataProvider(this.param);
            Map<Long, AsstactCount> paidAsstactCount = paidProvider.getAsstactCount();
            paidAsstactCount.forEach((k, v) -> {
                AsstactCount payValue = (AsstactCount)payAsstactCount.get(k);
                if (payValue != null) {
                    payValue.setCount(payValue.getCount() + v.getCount());
                } else {
                    payAsstactCount.put((Long)k, (AsstactCount)v);
                }
            });
        }
        return payAsstactCount;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"PayBillDataProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public String getEntityNumber() {
        return "cas_paybill";
    }

    @Override
    public List<String> getTreeSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("payeetype");
        selector.add("payee");
        if (!this.param.isTotalDisplay()) {
            selector.add("entry.seq");
        }
        return selector;
    }

    @Override
    public FilterCondition getDefaultFilter() {
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        return fc;
    }

    @Override
    protected String getAsstactKey() {
        return "payee";
    }
}

