/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.settleconsole.AbstractBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.AsstactCount;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;
import kd.fi.arapcommon.service.settleconsole.RecedBillDataProvider;

public class RecBillDataProvider
extends AbstractBillDataProvider {
    public RecBillDataProvider(BillDataProviderParam param) {
        super(param);
    }

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("'" + this.getEntityNumber() + "' billtype");
        selector.add("payertype asstacttype");
        selector.add("payer asstact");
        selector.add("payertype asstacttypeenum");
        selector.add("payername asstactname");
        selector.add("currency");
        selector.add("quotation");
        selector.add("exchangerate");
        if (this.param.isTotalDisplay()) {
            selector.add("receivingtype receivetype");
            selector.add("entry.e_actamt pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
        } else {
            selector.add("0 pricetaxtotal");
            selector.add("entry.e_receivingtype receivetype");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_actamt e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter() {
        QFilter filter = new QFilter("entry.e_settleorg", "=", this.param.getOrgPk());
        if (this.param.getGridFilter() != null) {
            filter.and(this.param.getGridFilter());
        }
        if (this.param.isMain()) {
            filter.and("payertype", "=", (Object)this.param.getAsstactype());
        }
        if (this.param.isOnlyShowPre()) {
            filter.and(new QFilter("entry.e_receivingtype.biztype", "=", (Object)"101"));
        }
        if (!StringUtils.isEmpty((CharSequence)this.param.getAsstactId())) {
            if (this.param.isMain()) {
                filter.and("itempayer", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
            } else if ("asstandcur".equals(this.param.getMatchCondition())) {
                if ("payrecsettle".equals(this.param.getSettleRelation())) {
                    List<String> asstactName = this.getAsstact(this.param.getAsstactype(), this.param.getAsstactId());
                    filter.and("payername", "in", asstactName);
                } else {
                    filter.and("itempayer", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
                }
            }
        } else if (!ObjectUtils.isEmpty(this.param.getMainAsstactIdSet()) && this.param.isMain()) {
            Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("masterid", "in", this.param.getMainAsstactIdSet())});
            filter.and("itempayer", "in", asstactMap.keySet());
        }
        String sign = "<>";
        if (SettleRelationEnum.RECSELF.getValue().equals(this.param.getSettleRelation())) {
            sign = this.param.isMain() ? ">" : "<";
        }
        if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(this.param.getSettleRelation())) {
            sign = ">";
        }
        filter.and("billstatus", "=", (Object)"D").and("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", sign, (Object)0);
        return filter;
    }

    @Override
    public List<Object[]> getBillDataRows() {
        List<Object[]> recRows = super.getBillDataRows();
        if (!SettleRelationEnum.APRECSETTLE.getValue().equals(this.param.getSettleRelation())) {
            RecedBillDataProvider recedProvider = new RecedBillDataProvider(this.param);
            List<Object[]> paidRows = recedProvider.getBillDataRows();
            recRows.addAll(paidRows);
        }
        return recRows;
    }

    @Override
    public Map<Long, AsstactCount> getAsstactCount() {
        Map<Long, AsstactCount> recAsstactCount = super.getAsstactCount();
        if (!SettleRelationEnum.APRECSETTLE.getValue().equals(this.param.getSettleRelation())) {
            RecedBillDataProvider recedProvider = new RecedBillDataProvider(this.param);
            Map<Long, AsstactCount> recedAsstactCount = recedProvider.getAsstactCount();
            recedAsstactCount.forEach((k, v) -> {
                AsstactCount recValue = (AsstactCount)recAsstactCount.get(k);
                if (recValue != null) {
                    recValue.setCount(recValue.getCount() + v.getCount());
                } else {
                    recAsstactCount.put((Long)k, (AsstactCount)v);
                }
            });
        }
        return recAsstactCount;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"RecBillDataProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public String getEntityNumber() {
        return "cas_recbill";
    }

    @Override
    public List<String> getTreeSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("payertype");
        selector.add("payer");
        if (!this.param.isTotalDisplay()) {
            selector.add("entry.seq");
        }
        return selector;
    }

    @Override
    public FilterCondition getDefaultFilter() {
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        return fc;
    }

    @Override
    protected String getAsstactKey() {
        return "payer";
    }
}

