/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.settleconsole.AsstactCount;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderFactory;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;
import kd.fi.arapcommon.service.settleconsole.IBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.SettleConsoleBaseHandler;

public class SettleConsoleLeftTreeHandler
extends SettleConsoleBaseHandler {
    public SettleConsoleLeftTreeHandler() {
    }

    public SettleConsoleLeftTreeHandler(IFormView view, AbstractFormPlugin plugin, String entityName, String initEntityName) {
        super(view, plugin, initEntityName);
    }

    public void addListeners() {
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("rootnode"), TreeNode.class);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = root.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = root.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"SettleConsoleLeftTreeHandler_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    public void loadTreeView() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.deleteAllNodes();
        String rootNodeId = "all";
        TreeNode root = new TreeNode(null, "all", "", true);
        root.setIsOpened(true);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(100);
        String mainEntity = this.getPageCache().get("mainEntity");
        IBillDataProvider provider = BillDataProviderFactory.getBillProvider(mainEntity, this.isRedBillDataProvider(true), this.getBillDataProviderParam(true));
        Map<Long, AsstactCount> map = provider.getAsstactCount();
        String asstEntity = this.getPageCache().get("asstEntity");
        String settleRelation = this.getSettleRelation();
        if (((Boolean)this.getModel().getValue("issettlable")).booleanValue()) {
            Set<String> asstAsstactSet;
            IBillDataProvider asstProvider;
            String asstAsstactType;
            if ("asstandcur".equals(this.getModel().getValue("matchcondition"))) {
                if ("aparsettle".equals(settleRelation) || "payrecsettle".equals(settleRelation) || "aprecsettle".equals(settleRelation) || "arapsettle".equals(settleRelation) || "recpaysettle".equals(settleRelation) || "arpaysettle".equals(settleRelation)) {
                    asstAsstactType = this.getAsstAsstactType(settleRelation);
                    asstProvider = BillDataProviderFactory.getBillProvider(asstEntity, this.isRedBillDataProvider(false), this.getBillDataProviderParamForSettlable(asstAsstactType));
                    asstAsstactSet = asstProvider.getAsstactName();
                    Set<Long> masterIdList = map.keySet();
                    DynamicObject[] asstactName = BusinessDataServiceHelper.load((String)((String)this.getModel().getValue("asstactype")), (String)"id,name,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterIdList)});
                    HashMap mainasstactName = new HashMap();
                    for (DynamicObject value : asstactName) {
                        Long masterid = value.getLong("masterid");
                        if (ObjectUtils.isEmpty(mainasstactName.get(masterid))) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(value.getString("name"));
                            mainasstactName.put(masterid, list);
                            continue;
                        }
                        ((List)mainasstactName.get(masterid)).add(value.getString("name"));
                    }
                    Iterator<Map.Entry<Long, AsstactCount>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Long, AsstactCount> temp2 = iterator.next();
                        List mainAsstactList = (List)mainasstactName.get(temp2.getKey());
                        boolean isRemove = true;
                        for (String mainAsstact : mainAsstactList) {
                            if (!asstAsstactSet.contains(mainAsstact)) continue;
                            isRemove = false;
                            break;
                        }
                        if (!isRemove) continue;
                        iterator.remove();
                    }
                } else if (!"recclearing".equals(settleRelation) && !"payclearing".equals(settleRelation)) {
                    asstProvider = BillDataProviderFactory.getBillProvider(asstEntity, this.isRedBillDataProvider(false), this.getBillDataProviderParam(false));
                    Map<Long, AsstactCount> asstMap = asstProvider.getAsstactCount();
                    Set<Long> asstMasterId = asstMap.keySet();
                    map.entrySet().removeIf(temp -> !asstMasterId.contains(temp.getKey()));
                }
            } else if (!"recclearing".equals(settleRelation) && !"payclearing".equals(settleRelation)) {
                asstAsstactType = this.getAsstAsstactType(settleRelation);
                asstProvider = BillDataProviderFactory.getBillProvider(asstEntity, this.isRedBillDataProvider(false), this.getBillDataProviderParamForSettlable(asstAsstactType));
                asstAsstactSet = asstProvider.getAsstactName();
                if (ObjectUtils.isEmpty(asstAsstactSet)) {
                    map.clear();
                }
            }
        }
        Set<Long> mainAsstactIdSet = map.keySet();
        this.getPageCache().put("mainAsstactIdSet", SerializationUtils.toJsonString(mainAsstactIdSet));
        int allCount = 0;
        for (Map.Entry<Long, AsstactCount> entry : map.entrySet()) {
            Long key = entry.getKey();
            AsstactCount asstactCount = entry.getValue();
            TreeNode node = new TreeNode();
            String nodeID = String.valueOf(key);
            node.setText(String.format("%s(%s)", asstactCount.getName(), asstactCount.getCount()));
            allCount += asstactCount.getCount().intValue();
            node.setParentid("all");
            node.setId(nodeID);
            nodes.add(node);
        }
        ComboEdit asstactType = (ComboEdit)this.getControl("asstactype");
        ComboProp comboProp = (ComboProp)asstactType.getProperty();
        List mapItems = comboProp.getComboItems();
        String displayValue = "";
        for (ValueMapItem mapItem : mapItems) {
            if (!mapItem.getValue().equals((String)this.getModel().getValue("asstactype"))) continue;
            displayValue = mapItem.getName().getLocaleValue();
            break;
        }
        root.setText(ResManager.loadKDString((String)(displayValue + "(" + allCount + ")"), (String)"SettleConsoleLeftTreeHandler_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        root.addChildren(nodes);
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand("all");
        TreeNode focusNode = root;
        treeView.focusNode(root);
        if (nodes.size() > 0) {
            if (this.getPageCache().get("node") != null) {
                String nodeId = this.getPageCache().get("node");
                for (TreeNode node : nodes) {
                    if (!nodeId.equals(node.getId())) continue;
                    focusNode = node;
                    break;
                }
            }
            treeView.focusNode(focusNode);
            treeView.treeNodeClick("all", focusNode.getId());
        } else {
            treeView.treeNodeClick(null, root.getId());
        }
        this.getView().getPageCache().put("rootnode", SerializationUtils.toJsonString((Object)root));
    }

    private BillDataProviderParam getBillDataProviderParam(boolean isMain) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        String assactType = (String)this.getModel().getValue("asstactype");
        BillDataProviderParam param = new BillDataProviderParam();
        param.setOrgPk(org == null ? org : org.getPkValue());
        param.setAsstactype(assactType);
        param.setSettleEntry(this.getSettleEntry());
        param.setSettleRelation(this.getSettleRelation());
        param.setTotalDisplay(this.isTotalDisplay());
        param.setMain(isMain);
        return param;
    }

    private BillDataProviderParam getBillDataProviderParamForSettlable(String asstactType) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        String assactType = asstactType;
        BillDataProviderParam param = new BillDataProviderParam();
        param.setOrgPk(org == null ? org : org.getPkValue());
        param.setAsstactype(assactType);
        param.setSettleEntry(this.getSettleEntry());
        param.setSettleRelation(this.getSettleRelation());
        param.setTotalDisplay(this.isTotalDisplay());
        return param;
    }

    private boolean isRedBillDataProvider(boolean isMain) {
        return SettleRelationEnum.APRECSETTLE.getValue().equals(this.getSettleRelation()) || SettleRelationEnum.ARPAYSETTLE.getValue().equals(this.getSettleRelation());
    }

    private String getAsstAsstactType(String settleRelation) {
        String asstAsstactType = (String)this.getModel().getValue("asstactype");
        if ("aparsettle".equals(settleRelation) || "payrecsettle".equals(settleRelation) || "aprecsettle".equals(settleRelation) || "arapsettle".equals(settleRelation) || "recpaysettle".equals(settleRelation) || "arpaysettle".equals(settleRelation)) {
            asstAsstactType = "bd_customer";
            if ("arapsettle".equals(settleRelation) || "recpaysettle".equals(settleRelation) || "arpaysettle".equals(settleRelation)) {
                asstAsstactType = "bd_supplier";
            }
        }
        return asstAsstactType;
    }
}

