/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.arapcommon.filterscheme.FilterSchemeHandler;
import kd.fi.arapcommon.filterscheme.FilterSchemeHelper;
import kd.fi.arapcommon.filterscheme.IFilterSchemeCallBack;

public class SettleConsoleQueryPlugin
extends AbstractFormPlugin {
    private static String[] schemeOpKeys = new String[]{"addscheme", "savescheme", "deletescheme", "setdefault", "canceldefault"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_reset", "btn_query"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        Map customParams = showParam.getCustomParams();
        IDataModel model = this.getModel();
        Object orgPk = customParams.get("settleorg");
        model.setValue("settleorg", orgPk);
        String settlerelation = (String)customParams.get("settlerelation");
        model.setValue("settlerelation", (Object)settlerelation);
        FilterSchemeHelper helper = new FilterSchemeHelper(view.getEntityId());
        DynamicObjectCollection schemes = helper.getAllSchemes();
        Iterator iterator = schemes.iterator();
        boolean setButton = true;
        while (iterator.hasNext()) {
            DynamicObject scheme = (DynamicObject)iterator.next();
            Object schemeId = customParams.get("schemeid");
            if (ObjectUtils.isEmpty(schemeId) || scheme.getLong("id") != Long.parseLong((String)schemeId)) continue;
            boolean isdefault = scheme.getBoolean("isdefault");
            model.setValue("schemes", schemeId);
            model.setValue("schemename", customParams.get("schemename"));
            helper.setButtonVisible(isdefault, this.getView());
            setButton = false;
        }
        if (setButton) {
            helper.setButtonVisible(false, this.getView());
        }
        helper.setComboItems(schemes, view);
        this.setFilterGrid("mainfiltergrid", (String)customParams.get("mainEntity"), (List)customParams.get("mainFilterKeys"), true);
        if (!"recclearing".equals(settlerelation) && !"payclearing".equals(settlerelation)) {
            this.setFilterGrid("asstfiltergrid", (String)customParams.get("asstEntity"), (List)customParams.get("asstFilterKeys"), false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilterValue("mainFilter", "asstFilter");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btn_reset": {
                this.setFilterValue("mainFilterDefault", "asstFilterDefault");
                IDataModel model = this.getModel();
                model.setValue("schemes", null);
                model.setValue("schemename", null);
                break;
            }
            case "btn_query": {
                this.returnDataToParentAndClose();
            }
        }
    }

    private void setFilterGrid(String controlName, String entityNumber, List<String> filterKeys, boolean isMain) {
        Label nameLabel;
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlName);
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"SettleConsoleQueryPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0])});
        }
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.getEntityNumber();
        if (isMain) {
            nameLabel = (Label)this.getControl("mainnamelabel");
            filterGrid.setFilterFieldKeys(filterKeys);
        } else {
            nameLabel = (Label)this.getControl("asstnamelabel");
            filterGrid.setFilterFieldKeys(filterKeys);
        }
        nameLabel.setText(entityType.getDisplayName().toString());
    }

    private void setFilterValue(String main, String asst) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map customParams = showParam.getCustomParams();
        FilterGrid mainFilterGrid = (FilterGrid)this.getControl("mainfiltergrid");
        FilterCondition mainFilter = (FilterCondition)((JSONObject)customParams.get(main)).toJavaObject(FilterCondition.class);
        mainFilterGrid.SetValue(mainFilter);
        String settlerelation = (String)customParams.get("settlerelation");
        if (!"recclearing".equals(settlerelation) && !"payclearing".equals(settlerelation)) {
            FilterGrid asstFilterGrid = (FilterGrid)this.getControl("asstfiltergrid");
            FilterCondition asstFilter = (FilterCondition)((JSONObject)customParams.get(asst)).toJavaObject(FilterCondition.class);
            asstFilterGrid.SetValue(asstFilter);
        }
    }

    private void returnDataToParentAndClose() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        FilterGrid mainFilterGrid = (FilterGrid)this.getControl("mainfiltergrid");
        FilterCondition mainFilter = mainFilterGrid.getFilterGridState().getFilterCondition();
        FilterGrid asstFilterGrid = (FilterGrid)this.getControl("asstfiltergrid");
        FilterCondition asstFilter = asstFilterGrid.getFilterGridState().getFilterCondition();
        data.put("mainFilter", mainFilter);
        data.put("asstFilter", asstFilter);
        IDataModel model = this.getModel();
        data.put("schemeid", model.getValue("schemes"));
        data.put("schemename", model.getValue("schemename"));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("schemes".equals(name)) {
            FilterSchemeHandler handler = new FilterSchemeHandler(this.getView());
            handler.propertyChanged(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (Arrays.asList(schemeOpKeys).contains(opKey)) {
            FilterSchemeCallBack callBack = new FilterSchemeCallBack();
            FilterSchemeHandler handler = new FilterSchemeHandler(opKey, callBack, this.getView());
            handler.afterDoOperation();
        }
    }

    class FilterSchemeCallBack
    implements IFilterSchemeCallBack {
        FilterSchemeCallBack() {
        }

        @Override
        public void onAdd() {
            SettleConsoleQueryPlugin.this.setFilterValue("mainFilterDefault", "asstFilterDefault");
            IDataModel model = SettleConsoleQueryPlugin.this.getModel();
            model.setValue("schemes", null);
            model.setValue("schemename", null);
        }

        @Override
        public String onSave() {
            IDataModel model = SettleConsoleQueryPlugin.this.getModel();
            DynamicObject manualSettleData = model.getDataEntity();
            HashMap<String, Object> schemeMap = new HashMap<String, Object>(8);
            schemeMap.put("org", manualSettleData.getLong("settleorg.id"));
            String settleRelation = manualSettleData.getString("settlerelation");
            schemeMap.put("settlerelation", settleRelation);
            IFormView view = SettleConsoleQueryPlugin.this.getView();
            FilterGrid filterGrid = (FilterGrid)view.getControl("mainfiltergrid");
            FilterGrid.FilterGridState mainFilterGridState = filterGrid.getFilterGridState();
            FilterCondition mainFilter = mainFilterGridState.getFilterCondition();
            String mainFilterStr = SerializationUtils.toJsonString((Object)mainFilter);
            schemeMap.put("mainfilter", mainFilterStr);
            if (!"recclearing".equals(settleRelation) && !"payclearing".equals(settleRelation)) {
                filterGrid = (FilterGrid)view.getControl("asstfiltergrid");
                FilterGrid.FilterGridState asstFilterGridState = filterGrid.getFilterGridState();
                FilterCondition asstFilter = asstFilterGridState.getFilterCondition();
                String asstFilterStr = SerializationUtils.toJsonString((Object)asstFilter);
                schemeMap.put("asstfilter", asstFilterStr);
            }
            return SerializationUtils.toJsonString(schemeMap);
        }

        @Override
        public void onDelete() {
            SettleConsoleQueryPlugin.this.setFilterValue("mainFilterDefault", "asstFilterDefault");
        }
    }
}

