/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.UpgradeDataIntervalEnum;
import kd.fi.arapcommon.enums.UpgradeExecuteStatusEnum;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.concurrency.LightLockCtrlNoDBStrategy;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.service.upgrade.IUpgradeHandle;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.UpgradeConfigEntryVO;
import kd.fi.arapcommon.vo.UpgradeConfigVO;

public abstract class AbstractUpgradeHandle
implements IUpgradeHandle {
    private static final Log logger = LogFactory.getLog(AbstractUpgradeHandle.class);
    private int UPGRADE_BILL_NUMBER = 5000;
    protected int UPGRADE_ENTRY_NUMBER = 5000;
    private int seq = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void batchExecute(UpgradeConfigVO configVO) {
        Date dateStartDate;
        if (configVO == null) {
            return;
        }
        logger.info("AbstractUpgradeHandle : enter batchExecute method .");
        this.init(configVO);
        logger.info("AbstractUpgradeHandle configVO : " + configVO);
        Date date = dateStartDate = configVO.getStopDate() == null ? configVO.getDataStartDate() : configVO.getStopDate();
        if (dateStartDate == null || !configVO.isFirst() && dateStartDate.compareTo(configVO.getDataEndTime()) > 0) {
            logger.info("AbstractUpgradeHandle : configVO has error");
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u7684\u6570\u636e\u65e5\u671f\u8303\u56f4\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4fee\u590d\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"AbstractUpgradeHandle_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        logger.info("AbstractUpgradeHandle : begin to upgrade");
        UpgradeConfigHelper.updateUpgradeTask(configVO);
        List<UpgradeConfigEntryVO> entryVOList = this.splitUpgradeDataDate(configVO, dateStartDate);
        logger.info("AbstractUpgradeHandle entryVOList size : " + entryVOList.size());
        if (ObjectUtils.isEmpty(entryVOList)) {
            return;
        }
        UpgradeConfigHelper.createUpgradeTaskEntry(entryVOList);
        this.initUpgradeArgs();
        for (UpgradeConfigEntryVO entryVO : entryVOList) {
            try {
                entryVO.setExecuteStatus(UpgradeExecuteStatusEnum.DOING.getValue());
                UpgradeConfigHelper.updateUpgradeTaskEntry(entryVO);
                List<Long> advanceBillIds = this.getUpgradeBillIds(entryVO);
                this.executeUpgrade(entryVO, advanceBillIds);
            }
            catch (Throwable e) {
                String stackTraceMessage = SettleLogHelper.getStackTraceMessage(e.getCause() != null ? e.getCause() : e);
                entryVO.setExecuteStatus(UpgradeExecuteStatusEnum.FAILED.getValue());
                entryVO.setExceptionInfo(e.getMessage() == null ? stackTraceMessage.substring(0, 200) : e.getMessage());
                entryVO.setExceptionInfoTag(stackTraceMessage);
            }
            finally {
                UpgradeConfigHelper.updateUpgradeTaskEntryAfterExecute(entryVO);
            }
        }
        UpgradeConfigHelper.updateUpgradeTaskHeadAfterExecute(configVO);
        logger.info("AbstractUpgradeHandle : end to upgrade");
    }

    private List<UpgradeConfigEntryVO> splitUpgradeDataDate(UpgradeConfigVO configVO, Date dateStartDate) {
        ArrayList<UpgradeConfigEntryVO> entryVOList = new ArrayList<UpgradeConfigEntryVO>(64);
        if (configVO.isFirst()) {
            UpgradeConfigEntryVO entryVO = this.createConfigEntryVO(configVO, configVO.getDataEndTime(), null);
            entryVOList.add(entryVO);
        }
        entryVOList.addAll(this.upgradeNormalBills(configVO, dateStartDate));
        return entryVOList;
    }

    private List<UpgradeConfigEntryVO> upgradeNormalBills(UpgradeConfigVO configVO, Date dateStartDate) {
        ArrayList<UpgradeConfigEntryVO> entryVOList = new ArrayList<UpgradeConfigEntryVO>(64);
        if (configVO.getIntervalDays() <= 0) {
            UpgradeConfigEntryVO entryVO = this.createConfigEntryVO(configVO, dateStartDate, configVO.getDataEndTime());
            entryVOList.add(entryVO);
        } else {
            int diffDays = DateUtils.getDiffDays(dateStartDate, configVO.getDataEndTime());
            int dateTimes = diffDays % configVO.getIntervalDays() != 0 ? diffDays / configVO.getIntervalDays() + 1 : diffDays / configVO.getIntervalDays();
            for (int i = 0; i < dateTimes; ++i) {
                Date tempBeginDate = null;
                Date tempEndDate = null;
                tempBeginDate = i == dateTimes - 1 ? dateStartDate : DateUtils.getLastDay(configVO.getDataEndTime(), configVO.getIntervalDays() * (i + 1));
                tempEndDate = DateUtils.getLastDay(configVO.getDataEndTime(), configVO.getIntervalDays() * i);
                UpgradeConfigEntryVO entryVO = this.createConfigEntryVO(configVO, tempBeginDate, tempEndDate);
                entryVOList.add(entryVO);
            }
        }
        return entryVOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpgrade(UpgradeConfigEntryVO entryVO, List<Long> billIds) {
        if (billIds == null) {
            return;
        }
        if (ObjectUtils.isEmpty(billIds)) {
            entryVO.setExecuteStatus(UpgradeExecuteStatusEnum.DONE.getValue());
            logger.info("AbstractUpgradeHandle executeUpgrade billIds is null .");
            return;
        }
        int times = billIds.size() / this.UPGRADE_BILL_NUMBER;
        for (int i = 0; i <= times; ++i) {
            List<Long> batchBillIds = i == times ? billIds.subList(i * this.UPGRADE_BILL_NUMBER, billIds.size()) : billIds.subList(i * this.UPGRADE_BILL_NUMBER, (i + 1) * this.UPGRADE_BILL_NUMBER);
            if (ObjectUtils.isEmpty(batchBillIds)) continue;
            try (TXHandle tx = TX.requiresNew((String)"createNewUpgradeTask");){
                IBillConcurrencyCtrlStrategy ctrlStrategy;
                block22: {
                    ctrlStrategy = null;
                    try {
                        if (!entryVO.isUpgradePlugin()) {
                            BillConcuControlParam param = new BillConcuControlParam(entryVO.getBizObj(), "batchExecuteUpgrade", new HashSet<Long>(batchBillIds));
                            ctrlStrategy = new LightLockCtrlNoDBStrategy(param);
                            ctrlStrategy.addCtrl();
                        }
                        this.upgrade(batchBillIds);
                        if (UpgradeExecuteStatusEnum.FAILED.getValue().equals(entryVO.getExecuteStatus())) break block22;
                        entryVO.setExecuteStatus(UpgradeExecuteStatusEnum.DONE.getValue());
                    }
                    catch (Throwable throwable) {
                        try {
                            String stackTraceMessage = SettleLogHelper.getStackTraceMessage(throwable.getCause() != null ? throwable.getCause() : throwable);
                            entryVO.setExecuteStatus(UpgradeExecuteStatusEnum.FAILED.getValue());
                            entryVO.setExceptionInfo(throwable.getMessage() == null ? stackTraceMessage.substring(0, 200) : throwable.getMessage());
                            entryVO.setExceptionInfoTag(stackTraceMessage);
                            tx.markRollback();
                            logger.info("AbstractUpgradeHandle executeUpgrade upgrade error message is :" + stackTraceMessage);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            if (!entryVO.isUpgradePlugin() && ctrlStrategy != null) {
                                ctrlStrategy.releaseCtrl();
                            }
                        }
                    }
                }
                if (entryVO.isUpgradePlugin() || ctrlStrategy == null) continue;
                ctrlStrategy.releaseCtrl();
                continue;
            }
        }
    }

    private List<Long> getUpgradeBillIds(UpgradeConfigEntryVO entryVO) {
        Date begin = entryVO.getDataStartDate();
        Date end = entryVO.getDataEndTime();
        DataSet dataSet = null;
        ArrayList<Long> allBillIds = new ArrayList<Long>(64);
        if (this.isNewVersion()) {
            String filterSql = this.queryBillIdSql(entryVO);
            dataSet = DB.queryDataSet((String)"getUpgradeBillIds", (DBRoute)DBRoute.of((String)"fi"), (String)filterSql);
        } else {
            dataSet = this.getUpgradeBillIds_old(begin, end, entryVO.getBizObj());
        }
        if (ObjectUtils.isEmpty((Object)dataSet)) {
            return allBillIds;
        }
        for (Row row : dataSet) {
            allBillIds.add(row.getLong("fid"));
        }
        return allBillIds;
    }

    @Deprecated
    private DataSet getUpgradeBillIds_old(Date begin, Date end, String entityName) {
        if (begin == null && end == null) {
            return null;
        }
        QFilter qFilter = null;
        if (begin != null) {
            qFilter = new QFilter("bizdate", ">=", (Object)begin);
        }
        if (end != null) {
            QFilter filter = new QFilter("bizdate", "<=", (Object)end);
            QFilter qFilter2 = qFilter = qFilter == null ? filter : qFilter.and(filter);
        }
        if (qFilter != null) {
            QFilter extendFilter = this.getQFilter();
            qFilter = extendFilter == null ? qFilter : qFilter.and(extendFilter);
        }
        return QueryServiceHelper.queryDataSet((String)"getUpgradeBillIds", (String)entityName, (String)"id fid", (QFilter[])new QFilter[]{qFilter}, (String)"");
    }

    private void init(UpgradeConfigVO configVO) {
        String batchUpgradeEntryCount;
        String batchUpgradeCount;
        String existSql;
        DataSet dataSet;
        if (ObjectUtils.isEmpty((Object)configVO.getTableName())) {
            String tableName = MetadataServiceHelper.getDataEntityType((String)configVO.getBizObj()).getAlias();
            configVO.setTableName(tableName);
        }
        Date dataEndTime = configVO.getDataEndTime() == null ? DateUtils.getDataFormat(new Date(), true) : configVO.getDataEndTime();
        configVO.setDataEndTime(dataEndTime);
        if (configVO.getIntervalDays() == -1) {
            UpgradeDataIntervalEnum intervalEnum = UpgradeConfigHelper.getIntervalByDataCount(configVO);
            configVO.setIntervalDays(intervalEnum.getInterval());
        }
        if (configVO.getIntervalDays() == -1 || configVO.getStopDate() == null || configVO.getDataStartDate() != null && configVO.getDataStartDate().compareTo(configVO.getStopDate()) >= 0) {
            configVO.setCreateUpgradeTask(false);
            configVO.setStopDate(null);
        }
        if (configVO.isCreateUpgradeTask() && (dataSet = DB.queryDataSet((String)"isexisttask", (DBRoute)DBRouteConst.AP, (String)(existSql = "select fid from t_arap_upgradeconfig where fplugin = ?;"), (Object[])new Object[]{configVO.getPlugin()})).hasNext()) {
            configVO.setCreateUpgradeTask(false);
        }
        if (configVO.getBillId() != 0L) {
            String countSql = "select count(1) from t_arap_upgradeentry where fid = ?;";
            dataSet = DB.queryDataSet((String)"queryentrycount", (DBRoute)DBRouteConst.AP, (String)countSql, (Object[])new Object[]{configVO.getBillId()});
            this.seq = dataSet.next().getInteger("count(1)");
        }
        if (!ObjectUtils.isEmpty((Object)(batchUpgradeCount = StdConfig.get("batchUpgradeCount")))) {
            this.UPGRADE_BILL_NUMBER = Integer.parseInt(batchUpgradeCount);
        }
        if (!ObjectUtils.isEmpty((Object)(batchUpgradeEntryCount = StdConfig.get("batchUpgradeEntryCount")))) {
            this.UPGRADE_ENTRY_NUMBER = Integer.parseInt(batchUpgradeEntryCount);
        }
    }

    private UpgradeConfigEntryVO createConfigEntryVO(UpgradeConfigVO configVO, Date dataBeginDate, Date dataEndDate) {
        UpgradeConfigEntryVO entryVO = new UpgradeConfigEntryVO();
        entryVO.setBillId(configVO.getBillId());
        entryVO.setBizObj(configVO.getBizObj());
        entryVO.setEntryId(configVO.getEntryId());
        entryVO.setDataStartDate(dataBeginDate);
        entryVO.setDataEndTime(dataEndDate);
        entryVO.setCreateUpgradeTask(configVO.isCreateUpgradeTask());
        entryVO.setFirst(configVO.isFirst());
        entryVO.setTableName(configVO.getTableName());
        entryVO.setSeq(this.seq++);
        entryVO.setUpgradePlugin(configVO.isUpgradePlugin());
        return entryVO;
    }

    public boolean isNewVersion() {
        String className = this.getClass().getName();
        return !"kd.fi.ap.mservice.upgrade.BusApSrcBizDateUpgradeHandle".equals(className) && !"kd.fi.ar.mservice.upgrade.ArRevcfmBillBaseUnitUpgradeHandle".equals(className) && !"kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest".equals(className) && !"kd.fi.ar.mservice.upgrade.BusArSrcBizDateUpgradeHandle".equals(className) && !"kd.fi.ap.mservice.upgrade.BusBillInvoicedAmtDispatch".equals(className) && !"kd.fi.ap.mservice.upgrade.FinApBillCurrencyUpgradeHandle".equals(className) && !"kd.fi.ar.mservice.upgrade.BusArBillInvoicedAmtDispatch".equals(className);
    }

    @Deprecated
    public QFilter getQFilter() {
        return null;
    }

    public String getQueryFilter() {
        return null;
    }

    public String getDateFieldName() {
        return "fbizdate";
    }

    protected void initUpgradeArgs() {
    }

    public String getUpgradeEntryName() {
        return "";
    }

    protected abstract void upgrade(List<Long> var1);

    protected String queryBillIdSql(UpgradeConfigEntryVO entryVO) {
        String beginDate = DateUtils.formatString(entryVO.getDataStartDate(), "yyyy-MM-dd HH:mm:ss");
        String filterSql = "select fid from " + entryVO.getTableName() + " where " + this.getDateFieldName() + " >= '" + beginDate + "'";
        if (entryVO.getDataEndTime() != null) {
            String endDate = DateUtils.formatString(entryVO.getDataEndTime(), "yyyy-MM-dd HH:mm:ss");
            filterSql = filterSql + " and " + this.getDateFieldName() + " <= '" + endDate + "'";
        }
        if (!ObjectUtils.isEmpty((Object)this.getQueryFilter())) {
            filterSql = filterSql + " and " + this.getQueryFilter();
        }
        return filterSql;
    }
}

