/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.vchconsist;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;

public class BillVchouerSyncHelper {
    private static final String SCENES_CODE = "ap_vouchersync";

    public static void createSession(String serviceName, CommonParam commonParam) {
        String businessInfoStr = commonParam.getString((Object)"businessInfo");
        if (businessInfoStr == null) {
            return;
        }
        List businessInfo = (List)SerializationUtils.fromJsonString((String)businessInfoStr, List.class);
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((CharSequence)KdtxRequestContext.get().getXid()) || !SCENES_CODE.equals(session.getScenesCode())) {
            ECGlobalSession.begin((String)SCENES_CODE, (DBRoute)DBRoute.of((String)"fi"), (Propagation)Propagation.REQUIRES_NEW);
        }
        ECGlobalSession.register((String)"fi", (String)"ap", (String)serviceName, (Param)commonParam, null);
        ECGlobalSession.setBusinessType((String)SCENES_CODE);
        ECGlobalSession.setBusinessInfo((List)businessInfo);
        ECGlobalSession.setAsync((boolean)true);
    }

    public static CommonParam createParam(Set<Long> billIds, String requestId, MainEntityType billEntityType) {
        ArrayList<String> businessInfo = new ArrayList<String>(16);
        String entityKey = billEntityType.getName();
        String appId = billEntityType.getAppId();
        for (Long billId : billIds) {
            businessInfo.add(entityKey + "#" + billId);
        }
        CommonParam commonParam = new CommonParam();
        commonParam.put((Object)"appId", (Object)appId);
        commonParam.put((Object)"entityKey", (Object)entityKey);
        commonParam.put((Object)"requestId", (Object)requestId);
        commonParam.put((Object)"billIds", (Object)SerializationUtils.toJsonString(billIds));
        commonParam.put((Object)"businessInfo", (Object)SerializationUtils.toJsonString(businessInfo));
        return commonParam;
    }
}

