/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class ArOriginalManualVerifyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableAndVisible();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Long> orgIds = this.getOrgIdList();
        if (orgIds.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
            DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            this.getModel().setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
        }
        this.setDateRange();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName = e.getProperty().getName();
        if ("org".equals(proName)) {
            this.beforeF7Org(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("writeofftype".equals(name)) {
            this.writeOffTypeChange();
        } else if ("org".equals(name)) {
            this.setCurrencyByOrg();
        } else if ("e_uninvoicedqty_cur_a".equals(name) || "unpushnum_cur_b".equals(name) || "e_uninvoicedamt_cur_a".equals(name) || "unpushamt_cur_b".equals(name)) {
            this.verifyMainFieldChange(name, e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
    }

    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String curEntryKey, IFormView view) {
        this.dealEntryData(tableValueSetter, curEntryKey, view);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("wfmanual".equals(operateKey)) {
            this.checkSelectRows();
            this.checkAsstactAndCur();
        }
    }

    private void dealEntryData(TableValueSetter setter, String curEntryKey, IFormView view) {
        block12: {
            IDataModel model;
            block11: {
                if (setter == null) {
                    return;
                }
                model = view.getModel();
                if (!"entry_a".equals(curEntryKey)) break block11;
                HashSet<Long> paypropertyIdSet = new HashSet<Long>(setter.getCount());
                for (int i = 0; i < setter.getCount(); ++i) {
                    paypropertyIdSet.add((Long)setter.get("payproperty_a", i));
                }
                Map paypropertyMap = BusinessDataServiceHelper.loadFromCache((String)"ar_payproperty", (String)"isbasedonamt", (QFilter[])new QFilter[]{new QFilter("id", "in", paypropertyIdSet)});
                for (int i = 0; i < setter.getCount(); ++i) {
                    BigDecimal verifyAmt;
                    BigDecimal verifyPriceTax;
                    Long paypropertyId = (Long)setter.get("payproperty_a", i);
                    DynamicObject payproperty = (DynamicObject)paypropertyMap.get(paypropertyId);
                    if (ObjectUtils.isEmpty((Object)payproperty)) continue;
                    boolean isBaseDonamt = payproperty.getBoolean("isbasedonamt");
                    DynamicObject currency = (DynamicObject)model.getValue("currency");
                    int precision = currency.getInt("amtprecision");
                    if (isBaseDonamt) {
                        verifyPriceTax = (BigDecimal)setter.get("e_uninvoicedamt_cur_a", i);
                        BigDecimal taxRate = (BigDecimal)setter.get("e_taxrate_a", i);
                        verifyAmt = verifyPriceTax.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100))), precision, RoundingMode.HALF_UP);
                    } else {
                        BigDecimal unInvoicedAmt = (BigDecimal)setter.get("e_uninvoicedamt_a", i);
                        BigDecimal verifyQty = (BigDecimal)setter.get("e_uninvoicedqty_cur_a", i);
                        BigDecimal qty = (BigDecimal)setter.get("e_quantity_a", i);
                        BigDecimal actUnitPrice = (BigDecimal)setter.get("e_actunitprice_a", i);
                        verifyPriceTax = unInvoicedAmt;
                        verifyAmt = verifyQty.equals(qty) ? (BigDecimal)setter.get("e_amount_a", i) : verifyQty.multiply(actUnitPrice).setScale(precision, RoundingMode.HALF_UP);
                        setter.set("e_uninvoicedqty_cur_a", (Object)verifyQty, i);
                    }
                    BigDecimal verifyTax = verifyPriceTax.subtract(verifyAmt);
                    setter.set("e_uninvoicedamt_cur_a", (Object)verifyPriceTax, i);
                    setter.set("verifyamt_a", (Object)verifyAmt, i);
                    setter.set("verifytax_a", (Object)verifyTax, i);
                }
                break block12;
            }
            if (!"entry_b".equals(curEntryKey)) break block12;
            for (int i = 0; i < setter.getCount(); ++i) {
                BigDecimal verifyTax;
                BigDecimal verifyAmt;
                BigDecimal verifyPriceTax;
                String isBaseDonamt = (String)setter.get("benchmark_b", i);
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                int precision = currency.getInt("amtprecision");
                boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
                String taxRateStr = setter.get("taxrate_b", i).toString();
                Object oriUnit = setter.get("oriunit_b", i);
                if (ObjectUtils.isEmpty((Object)oriUnit)) {
                    String unit = (String)setter.get("unit_b", i);
                    setter.set("oriunit_b", (Object)unit, i);
                }
                BigDecimal taxRate = new BigDecimal(taxRateStr);
                if ("1".equals(isBaseDonamt)) {
                    verifyPriceTax = (BigDecimal)setter.get("unpushamt_cur_b", i);
                    verifyAmt = verifyPriceTax.divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_UP);
                    verifyTax = verifyPriceTax.subtract(verifyAmt);
                } else {
                    BigDecimal unInvoicedAmt = (BigDecimal)setter.get("unpushamt_b", i);
                    BigDecimal verifyQty = (BigDecimal)setter.get("unpushnum_cur_b", i);
                    BigDecimal unitPrice = (BigDecimal)setter.get("oriunitprice_b", i);
                    if (BigDecimal.ZERO.compareTo(unitPrice) == 0) {
                        unitPrice = isForm ? (BigDecimal)setter.get("fromprice_b", i) : (BigDecimal)setter.get("unitprice_b", i);
                    }
                    verifyAmt = verifyQty.multiply(unitPrice).setScale(precision, RoundingMode.HALF_UP);
                    verifyTax = verifyAmt.multiply(taxRate).setScale(precision, RoundingMode.HALF_UP);
                    setter.set("unpushnum_cur_b", (Object)verifyQty, i);
                    verifyPriceTax = unInvoicedAmt;
                    if (BigDecimal.ZERO.compareTo(unInvoicedAmt) == 0) {
                        verifyAmt = BigDecimal.ZERO;
                        verifyTax = BigDecimal.ZERO;
                    }
                }
                setter.set("unpushamt_cur_b", (Object)verifyPriceTax, i);
                setter.set("assverifyamt_b", (Object)verifyAmt, i);
                setter.set("assverifytax_b", (Object)verifyTax, i);
                setter.set("taxrate_b", (Object)taxRate.multiply(new BigDecimal(100)), i);
            }
        }
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject material = (DynamicObject)model.getValue("material");
        DynamicObject asstact = (DynamicObject)model.getValue("customer");
        if ("entry_a".equals(curEntryKey)) {
            QFilter billQ = new QFilter("org", "=", (Object)org.getLong("id"));
            billQ.and("billstatus", "=", (Object)"C");
            billQ.and("bookdate", ">=", (Object)startDate);
            billQ.and("bookdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
            billQ.and("currency", "=", (Object)currency.getLong("id"));
            if (asstact != null) {
                billQ.and("asstact", "in", (Object)asstact.getLong("id"));
            }
            if (material != null) {
                billQ.and("entry.e_material", "=", (Object)material.getLong("id"));
            }
            billFilters.add(billQ);
        } else if ("entry_b".equals(curEntryKey)) {
            QFilter billQ = new QFilter("settlementorgbase", "=", (Object)org.getLong("id"));
            billQ.and("billstatus", "=", (Object)"C");
            billQ.and("billdate", ">=", (Object)startDate);
            billQ.and("billdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
            billQ.and("fromcurr", "=", (Object)currency.getLong("id"));
            if (asstact != null) {
                billQ.and("customnameid", "in", (Object)asstact.getLong("id"));
            }
            if (material != null) {
                billQ.and("sim_original_bill_item.materielfield", "=", (Object)material.getLong("id"));
            }
            billFilters.add(billQ);
        }
    }

    private void checkSelectRows() {
        EntryGrid entryGridA = (EntryGrid)this.getControl("entry_a");
        EntryGrid entryGridB = (EntryGrid)this.getControl("entry_b");
        if (entryGridA.getSelectRows().length <= 0 || entryGridB.getSelectRows().length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"ArOriginalManualVerifyPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void checkAsstactAndCur() {
        Map<String, Set<Long>> mainAsstactAndCurMap = this.getAsstactAndCurByType("A");
        Map<String, Set<Long>> assistAsstactAndCurMap = this.getAsstactAndCurByType("B");
        boolean isDiffAsstact = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "asstact");
        boolean isDiffCurrency = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "currency");
        if (isDiffAsstact || isDiffCurrency) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5f80\u6765\u6237\u6216\u5e01\u79cd\u4e0d\u540c\uff0c\u65e0\u6cd5\u6838\u9500\u3002", (String)"ArOriginalManualVerifyPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private Map<String, Set<Long>> getAsstactAndCurByType(String type) {
        String currencyName;
        String asstactName;
        String entityNum;
        String billIdFieldName;
        String entryName;
        HashMap<String, Set<Long>> asstactAndCurrencyMap = new HashMap<String, Set<Long>>(16);
        IDataModel model = this.getModel();
        if ("A".equals(type)) {
            entryName = "entry_a";
            billIdFieldName = "billid_a";
            entityNum = "ar_finarbill";
            asstactName = "asstact";
            currencyName = "currency";
        } else {
            entryName = "entry_b";
            billIdFieldName = "billid_b";
            entityNum = "sim_original_bill";
            asstactName = "customnameid";
            currencyName = "fromcurr";
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        for (int index : selectedRowIndexs) {
            Long billId = (Long)model.getValue(billIdFieldName, index);
            billIdSet.add(billId);
        }
        String selectFiled = asstactName + "," + currencyName;
        DataSet scmBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNum, (String)selectFiled, (QFilter[])new QFilter("id", "in", billIdSet).toArray(), null);
        billIdSet.clear();
        for (Row bill : scmBillDataSet) {
            Long asstactId = bill.getLong(asstactName);
            Long currencyId = bill.getLong(currencyName);
            HashSet<Long> asstactIdSet = (HashSet<Long>)asstactAndCurrencyMap.get("asstact");
            HashSet<Long> currencyIdSet = (HashSet<Long>)asstactAndCurrencyMap.get("currency");
            if (asstactIdSet == null) {
                asstactIdSet = new HashSet<Long>(16);
            }
            if (currencyIdSet == null) {
                currencyIdSet = new HashSet<Long>(16);
            }
            asstactIdSet.add(asstactId);
            currencyIdSet.add(currencyId);
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
            asstactAndCurrencyMap.put("currency", currencyIdSet);
        }
        Set asstactIdSet = (Set)asstactAndCurrencyMap.get("asstact");
        if (asstactIdSet != null) {
            DataSet asstactDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_customer", (String)"masterid", (QFilter[])new QFilter("id", "in", (Object)asstactIdSet).toArray(), null);
            asstactIdSet.clear();
            for (Row row : asstactDataSet) {
                asstactIdSet.add(row.getLong("masterid"));
            }
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
        }
        return asstactAndCurrencyMap;
    }

    private boolean getIsDiffValue(Map<String, Set<Long>> mainAsstactAndCurMap, Map<String, Set<Long>> assistAsstactAndCurMap, String fieldName) {
        boolean isDiffValue = false;
        Set<Long> mainbillSet = mainAsstactAndCurMap.get(fieldName);
        Set<Long> assistbillSet = assistAsstactAndCurMap.get(fieldName);
        if (mainbillSet.size() != assistbillSet.size()) {
            isDiffValue = true;
        } else {
            for (Long mainBillId : mainbillSet) {
                if (assistbillSet.contains(mainBillId)) continue;
                isDiffValue = true;
                break;
            }
            for (Long assistBillId : assistbillSet) {
                if (mainbillSet.contains(assistBillId)) continue;
                isDiffValue = true;
                break;
            }
        }
        return isDiffValue;
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    private void verifyMainFieldChange(String name, PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal verifyMainField = (BigDecimal)e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "e_uninvoicedqty_cur_a": {
                DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_a").get(rowIndex);
                int precision = entryRow.getInt("currency_a.amtprecision");
                BigDecimal unInvoicedQty = (BigDecimal)model.getValue("e_uninvoicedqty_a", rowIndex);
                BigDecimal unInvoicedAmt = (BigDecimal)model.getValue("e_uninvoicedamt_a", rowIndex);
                BigDecimal actTaxUnitPrice = (BigDecimal)model.getValue("e_acttaxunitprice_a", rowIndex);
                BigDecimal actUnitPrice = (BigDecimal)model.getValue("e_actunitprice_a", rowIndex);
                BigDecimal verifyQty = verifyMainField;
                BigDecimal verifyPriceTax = verifyQty.multiply(actTaxUnitPrice).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal verifyAmt = actUnitPrice.multiply(verifyQty).setScale(precision, RoundingMode.HALF_UP);
                if (unInvoicedQty.equals(verifyQty)) {
                    verifyPriceTax = unInvoicedAmt;
                }
                model.setValue("e_uninvoicedqty_cur_a", (Object)verifyQty, rowIndex);
                model.setValue("e_uninvoicedamt_cur_a", (Object)verifyPriceTax, rowIndex);
                model.setValue("verifyamt_a", (Object)verifyAmt, rowIndex);
                model.setValue("verifytax_a", (Object)verifyPriceTax.subtract(verifyAmt), rowIndex);
                break;
            }
            case "unpushnum_cur_b": {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("fromcurr_b");
                boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
                DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_b").get(rowIndex);
                int precision = entryRow.getInt("fromcurr_b.amtprecision");
                BigDecimal unInvoicedQty = (BigDecimal)model.getValue("unpushnum_b", rowIndex);
                BigDecimal unInvoicedAmt = (BigDecimal)model.getValue("unpushamt_b", rowIndex);
                BigDecimal unitPrice = (BigDecimal)model.getValue("oriunitprice_b", rowIndex);
                Object oriUnit = model.getValue("oriunit_b", rowIndex);
                if (ObjectUtils.isEmpty((Object)oriUnit)) {
                    String unit = (String)model.getValue("unit_b", rowIndex);
                    model.setValue("oriunit_b", (Object)unit, rowIndex);
                }
                if (BigDecimal.ZERO.compareTo(unitPrice) == 0) {
                    unitPrice = isForm ? (BigDecimal)model.getValue("fromprice_b", rowIndex) : (BigDecimal)model.getValue("unitprice_b", rowIndex);
                }
                BigDecimal num = (BigDecimal)model.getValue("num_b", rowIndex);
                BigDecimal taxRate = (BigDecimal)model.getValue("taxrate_b", rowIndex);
                BigDecimal verifyQty = verifyMainField;
                BigDecimal verifyAmt = verifyQty.multiply(unitPrice).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal verifyTax = verifyAmt.multiply(taxRate.divide(new BigDecimal(100))).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal verifyPriceTax = verifyTax.add(verifyAmt);
                if (verifyMainField.compareTo(unInvoicedQty) == 0) {
                    verifyPriceTax = unInvoicedAmt;
                }
                if (BigDecimal.ZERO.compareTo(unInvoicedAmt) == 0) {
                    verifyAmt = BigDecimal.ZERO;
                    verifyTax = BigDecimal.ZERO;
                    verifyPriceTax = BigDecimal.ZERO;
                }
                model.setValue("unpushnum_cur_b", (Object)verifyQty.setScale(num.scale(), RoundingMode.HALF_UP), rowIndex);
                model.setValue("unpushamt_cur_b", (Object)verifyPriceTax, rowIndex);
                model.setValue("assverifyamt_b", (Object)verifyAmt, rowIndex);
                model.setValue("assverifytax_b", (Object)verifyTax, rowIndex);
                break;
            }
            case "e_uninvoicedamt_cur_a": {
                DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_a").get(rowIndex);
                int precision = entryRow.getInt("currency_a.amtprecision");
                BigDecimal verifyPriceTax = (BigDecimal)model.getValue("e_uninvoicedamt_cur_a", rowIndex);
                BigDecimal taxRate = (BigDecimal)model.getValue("e_taxrate_a", rowIndex);
                BigDecimal verifyAmt = verifyPriceTax.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100))), precision, RoundingMode.HALF_UP);
                model.setValue("e_uninvoicedamt_cur_a", (Object)verifyPriceTax, rowIndex);
                model.setValue("verifyamt_a", (Object)verifyAmt, rowIndex);
                model.setValue("verifytax_a", (Object)verifyPriceTax.subtract(verifyAmt), rowIndex);
                break;
            }
            case "unpushamt_cur_b": {
                DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_b").get(rowIndex);
                int precision = entryRow.getInt("fromcurr_b.amtprecision");
                BigDecimal verifyPriceTax = (BigDecimal)model.getValue("unpushamt_cur_b", rowIndex);
                BigDecimal taxRate = (BigDecimal)model.getValue("taxrate_b", rowIndex);
                BigDecimal verifyAmt = verifyPriceTax.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100))), precision, RoundingMode.HALF_UP);
                BigDecimal verifyTax = verifyPriceTax.subtract(verifyAmt);
                Object oriUnit = model.getValue("oriunit_b", rowIndex);
                if (ObjectUtils.isEmpty((Object)oriUnit)) {
                    String unit = (String)model.getValue("unit_b", rowIndex);
                    model.setValue("oriunit_b", (Object)unit, rowIndex);
                }
                model.setValue("unpushamt_cur_b", (Object)verifyPriceTax, rowIndex);
                model.setValue("assverifyamt_b", (Object)verifyAmt, rowIndex);
                model.setValue("assverifytax_b", (Object)verifyTax, rowIndex);
                break;
            }
        }
    }

    private void setCurrencyByOrg() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            model.setValue("currency", null);
            return;
        }
        Long orgId = org.getLong("id");
        DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        model.setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
    }

    private void writeOffTypeChange() {
        this.getModel().deleteEntryData("entry_a");
        this.getModel().deleteEntryData("entry_b");
        this.setEnableAndVisible();
    }

    private void setEnableAndVisible() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        long wfTypeId = wfType.getLong("id");
        if (1678144407779420160L == wfTypeId) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"e_uninvoicedamt_cur_a"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"unpushamt_cur_b"});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"e_uninvoicedqty_cur_a"});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"unpushnum_cur_b"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_uninvoicedqty_cur_a"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unpushnum_cur_b"});
        }
        if (1678148494499522560L == wfTypeId) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"e_uninvoicedamt_cur_a"});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"unpushamt_cur_b"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"e_uninvoicedqty_cur_a"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"unpushnum_cur_b"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_uninvoicedqty_cur_a"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unpushnum_cur_b"});
        }
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        List<Long> orgIds = this.getOrgIdList();
        QFilter qFilter = new QFilter("id", "in", orgIds);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
    }

    private List<Long> getOrgIdList() {
        return OrgHelper.getAuthorizedInitializedOrgIds("ar_original_manualverify", "47150e89000000ac", true);
    }
}

