/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.kdtx.ec.service.DefaultECServiceIdempotentProperties;
import kd.fi.arapcommon.service.verify.ArSaloutUnWriteOffService;

public class ArSaloutGenRedWfRecordECService
extends BaseECService
implements IdempotentService {
    protected static final Log logger = LogFactory.getLog(ArSaloutGenRedWfRecordECService.class);
    private static final String AR_SALOUT_WFRECORD = "ar_saloutwfrecord";
    private static final String RULEID = "1692181545080643584";
    private static final Long HXLB_AR_SAL_CORE = 1679120508043735040L;

    protected DtxResponse doExecute(Object param, Object lastParam) throws Exception {
        logger.info("ArSaloutGenRedWfRecordECService.params:" + param);
        CommonParam ecParam = (CommonParam)param;
        List srcBillIds = (List)ecParam.get((Object)"ids");
        if (srcBillIds.size() < 1) {
            return null;
        }
        QFilter billIdFilter = new QFilter("entry.assbillid", "in", (Object)srcBillIds);
        QFilter hadWrittenOffFilter = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        QFilter isWrittenOffFilter = new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)AR_SALOUT_WFRECORD, (String)"id,entry.id,entry.billid,entry.billentryid,entry.e_hadwrittenoff,entry.assbillid,entry.assbillentryid,entry.billtypeid,entry.assbilltypeid", (QFilter[])new QFilter[]{billIdFilter, hadWrittenOffFilter, isWrittenOffFilter});
        HashMap<Long, List<Long>> srcIdAndEntryId = new HashMap<Long, List<Long>>(8);
        for (DynamicObject record : records) {
            Long id = record.getLong("id");
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                Long salBillId = entry.getLong("assbillid");
                if (!srcBillIds.contains(salBillId)) continue;
                List entryIdList = srcIdAndEntryId.getOrDefault(id, new ArrayList(8));
                entryIdList.add(entryId);
                srcIdAndEntryId.put(id, entryIdList);
            }
        }
        if (srcIdAndEntryId.size() < 1) {
            return null;
        }
        List<DynamicObject> redRecords = BOTPHelper.push4Result(AR_SALOUT_WFRECORD, "entry", AR_SALOUT_WFRECORD, RULEID, srcIdAndEntryId);
        if (redRecords.size() < 1) {
            return null;
        }
        ArSaloutUnWriteOffService arSaloutUnWriteOffService = new ArSaloutUnWriteOffService();
        arSaloutUnWriteOffService.updateSrcRecordsHadWrittenOff(redRecords, records, false);
        List<Long> redRecordsForFinArBillIds = arSaloutUnWriteOffService.updateRedRecords(redRecords, records);
        List<DynamicObject> coreRecord = redRecords.stream().filter(e -> HXLB_AR_SAL_CORE.equals(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        arSaloutUnWriteOffService.writeBackSaloutBills(coreRecord);
        DynamicObject[] finArBills = arSaloutUnWriteOffService.writeBackFinArBills(redRecordsForFinArBillIds, redRecords);
        if (finArBills.length < 1) {
            return null;
        }
        arSaloutUnWriteOffService.writeBackOrderAndContract(coreRecord, finArBills);
        logger.info("ArSaloutGenRedWfRecordECService.end");
        return null;
    }

    public IdempotentProperties getIdempotentProperties(Object o, Object o1) {
        return DefaultECServiceIdempotentProperties.generate(((Object)((Object)this)).getClass().getName(), o);
    }
}

