/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class ArSaloutManualVerifyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    private static final Long HXLB_AR_SAL_CORE = 1679120508043735040L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public String manualWriteOffField(Long writeOffTypeId, String suffix) {
        if (HXLB_AR_SAL_CORE.equals(writeOffTypeId) && "_b".equals(suffix)) {
            return "remainjoinpricebaseqty";
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Long> orgIds = this.getOrgIdList();
        if (orgIds.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
            DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            this.getModel().setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
        }
        this.setDateRange();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("wfmanual".equals(operateKey)) {
            this.checkSelectRows();
            this.checkAsstactAndCur();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            this.setCurrencyByOrg();
        } else if ("e_unverifybaseqty_cur_a".equals(name)) {
            this.calculateQtyAndAmt(e, true);
        } else if ("remainjoinpricebaseqty".equals(name)) {
            this.calculateQtyAndAmt(e, false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName = e.getProperty().getName();
        if ("org".equals(proName)) {
            this.beforeF7Org(e);
        }
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject material = (DynamicObject)model.getValue("material");
        DynamicObject asstact = (DynamicObject)model.getValue("customer");
        QFilter billQ = new QFilter("org", "=", (Object)org.getLong("id"));
        billQ.and("billstatus", "=", (Object)"C");
        billQ.and("bookdate", ">=", (Object)startDate);
        billQ.and("bookdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
        if (currency != null) {
            if ("ar_finarbill".equals(entityNumber)) {
                billQ.and("currency", "=", (Object)currency.getLong("id"));
            } else {
                billQ.and("settlecurrency", "=", (Object)currency.getLong("id"));
            }
        }
        if (asstact != null) {
            if ("ar_finarbill".equals(entityNumber)) {
                billQ.and("asstact", "in", (Object)asstact.getLong("id"));
            } else {
                billQ.and("billentry.settlecustomer", "in", (Object)asstact.getLong("id"));
            }
        }
        if (material != null) {
            if ("ar_finarbill".equals(entityNumber)) {
                billQ.and("entry.e_material", "=", (Object)material.getLong("id"));
            } else {
                billQ.and("billentry.material", "=", (Object)material.getLong("id"));
            }
        }
        billFilters.add(billQ);
    }

    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String curEntryKey, IFormView view) {
        this.dealEntryData(curEntryKey, tableValueSetter, view);
    }

    private List<Long> getOrgIdList() {
        return OrgHelper.getAuthorizedInitializedOrgIds("ar_salout_manualverify", "47150e89000000ac", true);
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    private void checkAsstactAndCur() {
        Map<String, Set<Long>> mainAsstactAndCurMap = this.getAsstactAndCurByType("A");
        Map<String, Set<Long>> assistAsstactAndCurMap = this.getAsstactAndCurByType("B");
        boolean isDiffAsstact = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "asstact");
        boolean isDiffCurrency = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "currency");
        if (isDiffAsstact || isDiffCurrency) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5f80\u6765\u6237\u6216\u5e01\u79cd\u4e0d\u540c\uff0c\u65e0\u6cd5\u6838\u9500\u3002", (String)"ArRevManualVerifyPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void checkSelectRows() {
        EntryGrid entryGridA = (EntryGrid)this.getControl("entry_a");
        EntryGrid entryGridB = (EntryGrid)this.getControl("entry_b");
        if (entryGridA.getSelectRows().length <= 0 || entryGridB.getSelectRows().length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"ArRevManualVerifyPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private Map<String, Set<Long>> getAsstactAndCurByType(String type) {
        String entityNum;
        String billIdFieldName;
        String entryName;
        HashMap<String, Set<Long>> asstactAndCurrencyMap = new HashMap<String, Set<Long>>(16);
        IDataModel model = this.getModel();
        boolean isMain = "A".equals(type);
        if (isMain) {
            entryName = "entry_a";
            billIdFieldName = "billid_a";
            entityNum = "ar_finarbill";
        } else {
            entryName = "entry_b";
            billIdFieldName = "billid_b";
            entityNum = "im_saloutbill";
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        for (int index : selectedRowIndexs) {
            Long billId = (Long)model.getValue(billIdFieldName, index);
            billIdSet.add(billId);
        }
        String asstactName = isMain ? "asstact" : "billentry.settlecustomer";
        String currencyName = isMain ? "currency" : "settlecurrency";
        String selectFiled = asstactName + "," + currencyName;
        DataSet scmBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNum, (String)selectFiled, (QFilter[])new QFilter("id", "in", billIdSet).toArray(), null);
        billIdSet.clear();
        for (Row bill : scmBillDataSet) {
            Long asstactId = bill.getLong(asstactName);
            Long currencyId = bill.getLong(currencyName);
            Set asstactIdSet = asstactAndCurrencyMap.getOrDefault("asstact", new HashSet(16));
            Set currencyIdSet = asstactAndCurrencyMap.getOrDefault("currency", new HashSet(16));
            asstactIdSet.add(asstactId);
            currencyIdSet.add(currencyId);
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
            asstactAndCurrencyMap.put("currency", currencyIdSet);
        }
        Set asstactIdSet = (Set)asstactAndCurrencyMap.get("asstact");
        if (asstactIdSet != null) {
            DataSet asstactDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_customer", (String)"masterid", (QFilter[])new QFilter("id", "in", (Object)asstactIdSet).toArray(), null);
            asstactIdSet.clear();
            for (Row row : asstactDataSet) {
                asstactIdSet.add(row.getLong("masterid"));
            }
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
        }
        return asstactAndCurrencyMap;
    }

    private boolean getIsDiffValue(Map<String, Set<Long>> mainAsstactAndCurMap, Map<String, Set<Long>> assistAsstactAndCurMap, String fieldName) {
        boolean isDiffValue = false;
        Set<Long> mainbillSet = mainAsstactAndCurMap.get(fieldName);
        Set<Long> assistbillSet = assistAsstactAndCurMap.get(fieldName);
        if (mainbillSet.size() != assistbillSet.size()) {
            isDiffValue = true;
        } else {
            for (Long mainBillId : mainbillSet) {
                if (assistbillSet.contains(mainBillId)) continue;
                isDiffValue = true;
                break;
            }
            for (Long assistBillId : assistbillSet) {
                if (mainbillSet.contains(assistBillId)) continue;
                isDiffValue = true;
                break;
            }
        }
        return isDiffValue;
    }

    private void setCurrencyByOrg() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            model.setValue("currency", null);
            return;
        }
        Long orgId = org.getLong("id");
        DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        model.setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
    }

    private void calculateQtyAndAmt(PropertyChangedArgs e, boolean isMain) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal verifyMainField = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (isMain) {
            BigDecimal verifyPriceTotal;
            BigDecimal verifyAmt;
            BigDecimal verifyQty;
            BigDecimal unVerifyBaseQty = (BigDecimal)model.getValue("e_unverifybaseqty_a", rowIndex);
            if (unVerifyBaseQty.compareTo(verifyMainField) == 0) {
                verifyQty = (BigDecimal)model.getValue("e_unverifyqty_a", rowIndex);
                verifyAmt = (BigDecimal)model.getValue("e_unverifyamt_a", rowIndex);
                verifyPriceTotal = (BigDecimal)model.getValue("e_unverifypricetotal_a", rowIndex);
            } else {
                DynamicObject material = (DynamicObject)model.getValue("e_material_a", rowIndex);
                DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit_a", rowIndex);
                DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit_a", rowIndex);
                BigDecimal unitRateConv = this.getUnitRateConvWithPageCache(material, baseUnit, measureUnit);
                verifyQty = UnitConvertHelper.getUnitQty(verifyMainField, unitRateConv, measureUnit);
                DynamicObject currency = (DynamicObject)model.getValue("currency_a", rowIndex);
                int pricePrecision = currency.getInt("amtprecision");
                BigDecimal unitPrice = (BigDecimal)model.getValue("e_actunitprice_a", rowIndex);
                BigDecimal taxUnitPrice = (BigDecimal)model.getValue("e_acttaxunitprice_a", rowIndex);
                verifyAmt = verifyQty.multiply(unitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                verifyPriceTotal = verifyQty.multiply(taxUnitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
            }
            model.setValue("e_verifyamt_a", (Object)verifyAmt, rowIndex);
            model.setValue("e_verifypricetotal_a", (Object)verifyPriceTotal, rowIndex);
            model.setValue("e_verifytax_a", (Object)verifyPriceTotal.subtract(verifyAmt), rowIndex);
            model.setValue("e_verifyqty_a", (Object)verifyQty, rowIndex);
        } else {
            BigDecimal verifyPriceTotal;
            BigDecimal verifyAmt;
            BigDecimal verifyQty;
            BigDecimal unVerifyBaseQty = (BigDecimal)model.getValue("remainjoinpricebaseqty_b", rowIndex);
            if (unVerifyBaseQty.compareTo(verifyMainField) == 0) {
                verifyQty = (BigDecimal)model.getValue("remainjoinpriceqty_b", rowIndex);
                verifyAmt = (BigDecimal)model.getValue("e_unverifyamt_b", rowIndex);
                verifyPriceTotal = (BigDecimal)model.getValue("e_unverifypricetotal_b", rowIndex);
            } else {
                DynamicObject material = (DynamicObject)model.getValue("material_b", rowIndex);
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit_b", rowIndex);
                DynamicObject measureUnit = (DynamicObject)model.getValue("unit_b", rowIndex);
                BigDecimal unitRateConv = this.getUnitRateConvWithPageCache(material, baseUnit, measureUnit);
                verifyQty = UnitConvertHelper.getUnitQty(verifyMainField, unitRateConv, measureUnit);
                DynamicObject currency = (DynamicObject)model.getValue("settlecurrency_b", rowIndex);
                int pricePrecision = currency.getInt("amtprecision");
                BigDecimal unitPrice = (BigDecimal)model.getValue("actualprice_b", rowIndex);
                BigDecimal taxUnitPrice = (BigDecimal)model.getValue("actualtaxprice_b", rowIndex);
                verifyAmt = verifyQty.multiply(unitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                verifyPriceTotal = verifyQty.multiply(taxUnitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
            }
            model.setValue("e_verifyamt_b", (Object)verifyAmt, rowIndex);
            model.setValue("e_verifypricetotal_b", (Object)verifyPriceTotal, rowIndex);
            model.setValue("e_verifytax_b", (Object)verifyPriceTotal.subtract(verifyAmt), rowIndex);
            model.setValue("e_verifyqty_b", (Object)verifyQty, rowIndex);
        }
    }

    private Map<String, BigDecimal> getUnitRateConvMap() {
        String unitRateConvMapString = this.getPageCache().get("unitRateConvMap");
        HashMap<String, BigDecimal> unitRateConvMap = EmptyUtils.isNotEmpty(unitRateConvMapString) ? (HashMap<String, BigDecimal>)JSONObject.parseObject((String)unitRateConvMapString, Map.class) : new HashMap<String, BigDecimal>(8);
        return unitRateConvMap;
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        List<Long> orgIds = this.getOrgIdList();
        QFilter qFilter = new QFilter("id", "in", orgIds);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
    }

    private void dealEntryData(String entryName, TableValueSetter setter, IFormView view) {
        block13: {
            int count;
            block12: {
                if (setter == null) {
                    return;
                }
                count = setter.getCount();
                if (!"entry_a".equals(entryName)) break block12;
                for (int i = 0; i < count; ++i) {
                    BigDecimal verifyPriceTotal;
                    BigDecimal unVerifyBaseQty = (BigDecimal)setter.get("e_unverifybaseqty_cur_a", i);
                    BigDecimal e_baseUnitQty = (BigDecimal)setter.get("e_baseunitqty_a", i);
                    BigDecimal verifyQty = (BigDecimal)setter.get("e_unverifyqty_a", i);
                    BigDecimal verifyAmt = (BigDecimal)setter.get("e_unverifyamt_a", i);
                    if (unVerifyBaseQty.compareTo(e_baseUnitQty) == 0) {
                        verifyPriceTotal = (BigDecimal)setter.get("e_recamount_a", i);
                    } else {
                        DynamicObject currency = (DynamicObject)view.getModel().getValue("currency");
                        int pricePrecision = currency.getInt("amtprecision");
                        BigDecimal taxUnitPrice = (BigDecimal)setter.get("e_acttaxunitprice_a", i);
                        verifyPriceTotal = verifyQty.multiply(taxUnitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                    }
                    BigDecimal verifyTax = verifyPriceTotal.subtract(verifyAmt);
                    setter.set("e_unverifypricetotal_a", (Object)verifyPriceTotal, i);
                    setter.set("e_unverifytax_a", (Object)verifyTax, i);
                    setter.set("e_verifyamt_a", (Object)verifyAmt, i);
                    setter.set("e_verifypricetotal_a", (Object)verifyPriceTotal, i);
                    setter.set("e_verifytax_a", (Object)verifyTax, i);
                    setter.set("e_verifyqty_a", (Object)verifyQty, i);
                }
                break block13;
            }
            if (!"entry_b".equals(entryName)) break block13;
            HashSet<Long> masterIdSet = new HashSet<Long>(16);
            for (int i = 0; i < count; ++i) {
                Long matId = (Long)setter.get("material_b", i);
                masterIdSet.add(matId);
            }
            if (!masterIdSet.isEmpty()) {
                HashMap<Long, Long> matInfoAndMasterIdMap = new HashMap<Long, Long>(16);
                DynamicObjectCollection matInfo = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", masterIdSet)});
                for (DynamicObject materialInfo : matInfo) {
                    matInfoAndMasterIdMap.put(materialInfo.getLong("id"), materialInfo.getLong("masterid"));
                }
                if (!matInfoAndMasterIdMap.isEmpty()) {
                    for (int i = 0; i < count; ++i) {
                        Long matId = (Long)setter.get("material_b", i);
                        Long masterId = (Long)matInfoAndMasterIdMap.get(matId);
                        if (masterId == null) continue;
                        setter.set("material_b", (Object)masterId, i);
                    }
                }
            }
            for (int i = 0; i < count; ++i) {
                BigDecimal verifyPriceTotal;
                BigDecimal verifyAmt;
                BigDecimal unVerifyBaseQty = (BigDecimal)setter.get("remainjoinpricebaseqty_b", i);
                setter.set("remainjoinpricebaseqty", (Object)unVerifyBaseQty, i);
                BigDecimal e_baseUnitQty = (BigDecimal)setter.get("baseqty_b", i);
                BigDecimal verifyQty = (BigDecimal)setter.get("remainjoinpriceqty_b", i);
                if (unVerifyBaseQty.compareTo(e_baseUnitQty) == 0) {
                    verifyAmt = (BigDecimal)setter.get("amount_b", i);
                    verifyPriceTotal = (BigDecimal)setter.get("amountandtax_b", i);
                } else {
                    DynamicObject currency = (DynamicObject)view.getModel().getValue("currency");
                    int pricePrecision = currency.getInt("amtprecision");
                    BigDecimal unitPrice = (BigDecimal)setter.get("actualprice_b", i);
                    BigDecimal taxUnitPrice = (BigDecimal)setter.get("actualtaxprice_b", i);
                    verifyAmt = verifyQty.multiply(unitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                    verifyPriceTotal = verifyQty.multiply(taxUnitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                }
                BigDecimal verifyTax = verifyPriceTotal.subtract(verifyAmt);
                setter.set("e_unverifyamt_b", (Object)verifyAmt, i);
                setter.set("e_unverifypricetotal_b", (Object)verifyPriceTotal, i);
                setter.set("e_unverifytax_b", (Object)verifyTax, i);
                setter.set("e_verifyqty_b", (Object)verifyQty, i);
                setter.set("e_verifyamt_b", (Object)verifyAmt, i);
                setter.set("e_verifypricetotal_b", (Object)verifyPriceTotal, i);
                setter.set("e_verifytax_b", (Object)verifyTax, i);
            }
        }
    }

    private BigDecimal getUnitRateConvWithPageCache(DynamicObject material, DynamicObject baseUnit, DynamicObject measureUnit) {
        Long measureUnitId;
        Long baseUnitId;
        BigDecimal unitRateConv = BigDecimal.ONE;
        Map<String, BigDecimal> unitRateConvMap = this.getUnitRateConvMap();
        if (material != null && baseUnit != null && measureUnit != null && !(baseUnitId = Long.valueOf(baseUnit.getLong("id"))).equals(measureUnitId = Long.valueOf(measureUnit.getLong("id")))) {
            Long materialId = material.getLong("id");
            String convertKey = String.valueOf(baseUnitId) + measureUnitId;
            BigDecimal convertRate = unitRateConvMap.get(convertKey);
            if (convertRate != null) {
                unitRateConv = convertRate;
            } else {
                unitRateConv = UnitConvertHelper.getUnitRateConv(materialId, measureUnitId, baseUnitId);
                unitRateConvMap.put(convertKey, unitRateConv);
                this.getPageCache().put("unitRateConvMap", JSONObject.toJSONString(unitRateConvMap));
            }
        }
        return unitRateConv;
    }
}

