/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.util.JsonUtils;

public class BusRedBlueMatchVerifyOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BusRedBlueMatchVerifyOp.class);
    private static final Long WRITEOFFTYPE_AR_QTY_ID = 1403501182361552896L;
    private static final Long WRITEOFFTYPE_AR_AMT_ID = 1403592585204746240L;
    private static final Long WRITEOFFTYPE_AP_QTY_ID = 1399982985108795392L;
    private static final Long WRITEOFFTYPE_AP_AMT_ID = 1402878481745856512L;
    private static final Long WRITEOFFSHCEME_AR_QTY_ID = 1408849481142641664L;
    private static final Long WRITEOFFSHCEME_AR_AMT_ID = 1408852011759182848L;
    private static final Long WRITEOFFSHCEME_AP_QTY_ID = 1408683854788562944L;
    private static final Long WRITEOFFSHCEME_AP_AMT_ID = 1408848721025703936L;
    private static final Map<Long, Long> writeOffTypeToScheme = new HashMap<Long, Long>(4);
    private boolean isAr;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("payproperty");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.isAr = this.isAr(dataEntities[0]);
        DynamicObject writeOffType = this.getWriteOffType(dataEntities[0]);
        String pageFilter = this.getPageFilter(dataEntities);
        Map<String, Object> schemeParams = this.getSchemeParams(writeOffType);
        Map<String, Map<String, String>> conditionFilter = this.getConditionFilters(writeOffType, pageFilter);
        try {
            this.invokeManualAutoWriteOff(writeOffType, schemeParams, conditionFilter);
        }
        catch (Throwable exception) {
            if (exception instanceof KDException) {
                String message = ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"BusRedBlueMatchVerifyOp_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                if (message.equals(exception.getMessage())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5339\u914d\u6838\u9500\u5b8c\u6210\uff0c\u672a\u751f\u6210\u6838\u9500\u8bb0\u5f55\u3002", (String)"BusRedBlueMatchVerifyOp_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                throw new KDBizException(exception.getMessage());
            }
            throw new KDBizException(exception.getMessage());
        }
    }

    private void invokeManualAutoWriteOff(DynamicObject writeOffType, Map<String, Object> schemeParams, Map<String, Map<String, String>> conditionFilter) {
        HashMap<String, String> paramMap = this.getOption().getVariables();
        if (paramMap != null) {
            paramMap.put("woffmode", "batch");
        } else {
            paramMap = new HashMap<String, String>(2);
        }
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"startAutoManualWriteOff", (Object[])new Object[]{writeOffType.getLong("id"), schemeParams, new Date(), conditionFilter, paramMap});
    }

    private String getPageFilter(DynamicObject[] dataEntities) {
        List ids = Arrays.stream(dataEntities).map(data -> data.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        return filter.toSerializedString();
    }

    private Map<String, Map<String, String>> getConditionFilters(DynamicObject writeOffType, String pageFilter) {
        LinkedHashMap<String, Map<String, String>> billConditionsMap = new LinkedHashMap<String, Map<String, String>>(16);
        DynamicObjectCollection writeOffBillEntities = writeOffType.getDynamicObjectCollection("writeoffbillentry");
        for (int i = 0; i < writeOffBillEntities.size(); ++i) {
            DynamicObject writeOffBillEntry = (DynamicObject)writeOffBillEntities.get(i);
            String billFilterStr = writeOffBillEntry.getString("filterconditiondesc_tag");
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("pageFilter", pageFilter);
            map.put("wfTypeFilter", billFilterStr);
            billConditionsMap.put(writeOffBillEntry.getString("id"), map);
        }
        logger.info("getConditionFilters:" + JsonUtils.objToJson(billConditionsMap));
        return billConditionsMap;
    }

    private Map<String, Object> getSchemeParams(DynamicObject writeOffType) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("sub_wf_scheme", writeOffTypeToScheme.get(writeOffType.getLong("id")));
        map.put("seq", 0);
        map.put("sub_unilateral", Boolean.FALSE);
        map.put("sub_rbpriority", Boolean.FALSE);
        map.put("sub_equalsfirst", Boolean.FALSE);
        map.put("sub_onlyequals", Boolean.FALSE);
        map.put("sub_whole", Boolean.FALSE);
        return map;
    }

    private DynamicObject getWriteOffType(DynamicObject dataEntity) {
        DynamicObject payProperty = dataEntity.getDynamicObject("payproperty");
        boolean isAmt = payProperty.getBoolean("isbasedonamt");
        if (this.isAr) {
            return BusinessDataServiceHelper.loadSingle((Object)(isAmt ? WRITEOFFTYPE_AR_AMT_ID : WRITEOFFTYPE_AR_QTY_ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"msmod_writeofftype"));
        }
        return BusinessDataServiceHelper.loadSingle((Object)(isAmt ? WRITEOFFTYPE_AP_AMT_ID : WRITEOFFTYPE_AP_QTY_ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"msmod_writeofftype"));
    }

    private boolean isAr(DynamicObject dataEntity) {
        String name = dataEntity.getDataEntityType().getName();
        return !"ap_busbill".equals(name);
    }

    private String getSuffix(int index) {
        return "_" + (char)(97 + index);
    }

    static {
        writeOffTypeToScheme.put(WRITEOFFTYPE_AR_QTY_ID, WRITEOFFSHCEME_AR_QTY_ID);
        writeOffTypeToScheme.put(WRITEOFFTYPE_AR_AMT_ID, WRITEOFFSHCEME_AR_AMT_ID);
        writeOffTypeToScheme.put(WRITEOFFTYPE_AP_QTY_ID, WRITEOFFSHCEME_AP_QTY_ID);
        writeOffTypeToScheme.put(WRITEOFFTYPE_AP_AMT_ID, WRITEOFFSHCEME_AP_AMT_ID);
    }
}

