/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.validator.BusRedBlueUnVerifyValidator;

public class BusRedBlueUnVerifyOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        String entityTypeName = this.billEntityType.getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityTypeName);
        Map allFields = entityType.getAllFields();
        keys.addAll(allFields.keySet());
        keys.add("headwfinfo_tag");
        keys.add("wfinfo_tag");
        keys.add("mainwfinfo_tag");
        keys.add("asswfinfo_tag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BusRedBlueUnVerifyValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] busWoffBills;
        DynamicObject[] records = e.getDataEntities();
        if (records.length == 0) {
            return;
        }
        boolean isAr = this.isAr(records[0]);
        String busBillEntity = isAr ? "ar_busbill" : "ap_busbill";
        HashSet<Long> needWriteOffWoffBillIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                needWriteOffWoffBillIds.add(entry.getLong("woffbillid"));
                needWriteOffWoffBillIds.add(entry.getLong("asstwoffbillid"));
            }
        }
        List<DynamicObject> pushedBusBills = BOTPHelper.push(busBillEntity, busBillEntity, isAr ? "697561685841434624" : "712748085842822144", new ArrayList<Long>(needWriteOffWoffBillIds));
        this.setBusBillNumber(pushedBusBills, isAr);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)busBillEntity, (DynamicObject[])pushedBusBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)busBillEntity, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
        for (DynamicObject woffBusBill : busWoffBills = BusinessDataServiceHelper.load((String)busBillEntity, (String)"id,isverifybusiness", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)auditResult.getSuccessPkIds())})) {
            woffBusBill.set("isverifybusiness", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])busWoffBills);
        List needDeleteRecordIds = QueryServiceHelper.queryPrimaryKeys((String)records[0].getDataEntityType().getName(), (QFilter[])new QFilter[]{new QFilter("entry.woffbillid", "in", needWriteOffWoffBillIds), new QFilter("entry.asstwoffbillid", "in", needWriteOffWoffBillIds)}, (String)"createdate", (int)-1);
        for (DynamicObject record : records) {
            long id = record.getLong("id");
            needDeleteRecordIds.remove(id);
        }
        DeleteServiceHelper.delete((IDataEntityType)records[0].getDataEntityType(), (Object[])needDeleteRecordIds.toArray(new Object[0]));
    }

    private boolean isAr(DynamicObject recordBill) {
        String verifyRecordEntity = recordBill.getDataEntityType().getName();
        return !"ap_bus_verifyrecord".equals(verifyRecordEntity);
    }

    private void setBusBillNumber(List<DynamicObject> trgBills, Boolean isAr) {
        String busBillEntity = isAr != false ? "ar_busbill" : "ap_busbill";
        Map<String, List<DynamicObject>> orgPkGroup = trgBills.stream().collect(Collectors.groupingBy(bill -> bill.getDynamicObject("org").getPkValue().toString()));
        orgPkGroup.forEach((key, targetBills) -> {
            int size = targetBills.size();
            Object[] numbers = CodeRuleServiceHelper.getBatchNumber((String)busBillEntity, (DynamicObject)((DynamicObject)targetBills.get(0)), (String)key, (int)size);
            if (ObjectUtils.isEmpty((Object[])numbers) || numbers.length < size) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5355\u7f16\u7801\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u3002", (String)"FinWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            int i = 0;
            for (DynamicObject trgBusBill : targetBills) {
                trgBusBill.set("billno", numbers[i]);
                ++i;
            }
        });
    }
}

