/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.woff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.service.woff.IWriteOff;
import kd.fi.arapcommon.service.woff.WoffHelper;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.CollectionUtils;

@Deprecated
public abstract class AbstractWriteOff
implements IWriteOff {
    private static final Log logger = LogFactory.getLog(AbstractWriteOff.class);
    protected String busEntityKey;
    protected boolean isAr;
    protected boolean isAmt;
    protected String recAmountKey;
    protected String recLocAmtKey;

    public AbstractWriteOff(String busEntityKey, boolean isAr) {
        this.busEntityKey = busEntityKey;
        this.isAr = isAr;
        this.recAmountKey = isAr ? "e_recamount" : "e_pricetaxtotal";
        this.recLocAmtKey = isAr ? "e_reclocalamt" : "e_pricetaxtotalbase";
    }

    public AbstractWriteOff(String busEntityKey, boolean isAr, boolean isAmt) {
        this.busEntityKey = busEntityKey;
        this.isAr = isAr;
        this.isAmt = isAmt;
        this.recAmountKey = isAr ? "e_recamount" : "e_pricetaxtotal";
        this.recLocAmtKey = isAr ? "e_reclocalamt" : "e_pricetaxtotalbase";
    }

    @Override
    public Tuple<List<DynamicObject>, List<BusEntryInfo>> genWoffBill(DynamicObject finBill, List<BusEntryInfo> lastBusBills, List<BusEntryInfo> lastPreWoffs, List<BusEntryInfo> lastGenWoffs) {
        Map<Long, List<Long>> busMap;
        List<DynamicObject> woffBills = null;
        List<BusEntryInfo> busList = this.getBusBills(finBill);
        ArrayList<String> woffList = new ArrayList<String>(64);
        for (BusEntryInfo busEntry : lastBusBills) {
            if (!busEntry.isWoff()) continue;
            woffList.add(busEntry.getPk() + "&" + busEntry.getEntryPk());
        }
        if (!ObjectUtils.isEmpty(busList)) {
            busList.removeIf(bus -> woffList.contains(bus.getPk() + "&" + bus.getEntryPk()));
        }
        if (!ObjectUtils.isEmpty(busList) && !ObjectUtils.isEmpty(woffBills = BOTPHelper.push4Result(this.busEntityKey, "entry", this.busEntityKey, this.isAr ? "697561685841434624" : "712748085842822144", busMap = this.convertMap(busList)))) {
            if (lastBusBills.isEmpty()) {
                List<BusEntryInfo> preWoffBills = this.getPreWoffBills(busMap);
                if (!ObjectUtils.isEmpty(preWoffBills)) {
                    lastPreWoffs.addAll(preWoffBills);
                }
            } else {
                List<BusEntryInfo> incrWoffs;
                List<BusEntryInfo> increment = this.getIncrement(busList, lastPreWoffs);
                if (!ObjectUtils.isEmpty(increment) && !ObjectUtils.isEmpty(incrWoffs = this.getPreWoffBills(this.convertMap(increment)))) {
                    lastPreWoffs = this.add(incrWoffs, lastPreWoffs);
                }
            }
            logger.info("---lastPreWoffs.distinct---");
            lastPreWoffs = lastPreWoffs.stream().filter(CollectionUtils.distinctByKey(BusEntryInfo::getEntryPk)).collect(Collectors.toList());
            List<BusEntryInfo> busBills = WoffHelper.calculate(busList, lastPreWoffs, lastGenWoffs, this.isAmt);
            busBills = this.getSrcBusEntries(finBill, busBills);
            this.setLastBusBills(lastBusBills, busBills);
            List<BusEntryInfo> genWoffs = this.buildWoffBill(woffBills, busBills, (Long)finBill.getPkValue(), finBill.getDate("bizdate"));
            lastGenWoffs.addAll(genWoffs);
        }
        return Tuple.create(woffBills, busList);
    }

    private List<BusEntryInfo> add(List<BusEntryInfo> incrWoffs, List<BusEntryInfo> lastPreWoffs) {
        ArrayList<BusEntryInfo> merge = new ArrayList<BusEntryInfo>(lastPreWoffs);
        for (BusEntryInfo incWoff : incrWoffs) {
            Long busPk = incWoff.getSrcPk();
            Long busEntryPk = incWoff.getSrcEntryPk();
            for (BusEntryInfo woff : lastPreWoffs) {
                if (busPk.equals(woff.getSrcPk()) && busEntryPk.equals(woff.getSrcEntryPk())) continue;
                merge.add(incWoff);
            }
        }
        return merge;
    }

    private List<BusEntryInfo> getIncrement(List<BusEntryInfo> busBills, List<BusEntryInfo> lastPreWoffs) {
        ArrayList<BusEntryInfo> increment = new ArrayList();
        if (!ObjectUtils.isEmpty(lastPreWoffs) && lastPreWoffs.size() > 0) {
            for (BusEntryInfo beInfo : busBills) {
                Long busPk = beInfo.getPk();
                Long busEntryPk = beInfo.getEntryPk();
                for (BusEntryInfo woff : lastPreWoffs) {
                    if (busPk.equals(woff.getSrcPk()) && busEntryPk.equals(woff.getSrcEntryPk())) continue;
                    increment.add(beInfo);
                }
            }
        } else {
            increment = busBills;
        }
        return increment;
    }

    private void setLastBusBills(List<BusEntryInfo> lastBusBills, List<BusEntryInfo> busBills) {
        if (lastBusBills.isEmpty()) {
            lastBusBills.addAll(busBills);
        } else {
            ArrayList<BusEntryInfo> tmp = new ArrayList<BusEntryInfo>(lastBusBills);
            Map<String, List<BusEntryInfo>> pkStrGroup = tmp.stream().collect(Collectors.groupingBy(lastInfo -> lastInfo.getPk() + "-" + lastInfo.getEntryPk()));
            for (BusEntryInfo beInfo : busBills) {
                String key = beInfo.getPk() + "-" + beInfo.getEntryPk();
                List<BusEntryInfo> findList = pkStrGroup.get(key);
                if (!ObjectUtils.isEmpty(findList)) {
                    for (BusEntryInfo lastInfo2 : findList) {
                        lastInfo2.setQuantity(beInfo.getQuantity());
                        lastInfo2.setTax(beInfo.getTax());
                        lastInfo2.setTaxLocAmt(beInfo.getTaxLocAmt());
                        lastInfo2.setAmount(beInfo.getAmount());
                        lastInfo2.setLocalAmt(beInfo.getLocalAmt());
                        lastInfo2.setRecAmount(beInfo.getRecAmount());
                        lastInfo2.setRecLocAmt(beInfo.getRecLocAmt());
                        lastInfo2.setIsWoff(beInfo.isWoff());
                    }
                    continue;
                }
                lastBusBills.add(beInfo);
            }
        }
    }

    private Map<Long, List<Long>> convertMap(List<BusEntryInfo> busList) {
        HashMap<Long, List<Long>> busMap = new HashMap<Long, List<Long>>(64);
        for (BusEntryInfo beInfo : busList) {
            long key = beInfo.getPk();
            ArrayList<Long> lst = (ArrayList<Long>)busMap.get(key);
            if (lst == null) {
                lst = new ArrayList<Long>();
            }
            lst.add(beInfo.getEntryPk());
            busMap.put(key, lst);
        }
        return busMap;
    }

    protected List<BusEntryInfo> getPreWoffBills(Map<Long, List<Long>> busMap) {
        List<BusEntryInfo> preWoffBills = null;
        ArrayList<Long> pushPks = null;
        QFilter qf = new QFilter("entry.e_srcbillid", "in", busMap.keySet());
        qf.and(new QFilter("writeoffbusiness", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection preWoffs = QueryServiceHelper.query((String)this.busEntityKey, (String)"entry.e_srcbillid", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)preWoffs)) {
            pushPks = new ArrayList<Long>();
            for (DynamicObject preWoff : preWoffs) {
                long e_srcId = preWoff.getLong("entry.e_srcbillid");
                if (pushPks.contains(e_srcId)) continue;
                pushPks.add(e_srcId);
            }
            if (!ObjectUtils.isEmpty(pushPks)) {
                ArrayList<Long> pushEntryPks = new ArrayList<Long>();
                for (Map.Entry<Long, List<Long>> busPk : busMap.entrySet()) {
                    if (!pushPks.contains(busPk.getKey())) continue;
                    List<Long> entryPks = busMap.get(busPk.getKey());
                    Iterator<Long> it = entryPks.iterator();
                    while (it.hasNext()) {
                        pushEntryPks.add(it.next());
                    }
                }
                preWoffBills = WoffHelper.getPreWoffBills(this.busEntityKey, pushPks, pushEntryPks);
            }
        }
        return preWoffBills;
    }

    protected List<BusEntryInfo> buildWoffBill(List<DynamicObject> trgBills, List<BusEntryInfo> busBills, long finPk, Date bizdate) {
        ArrayList<BusEntryInfo> genWoffs = new ArrayList<BusEntryInfo>();
        for (DynamicObject trgBusBill : trgBills) {
            trgBusBill.set("srcfinbillid", (Object)finPk);
            trgBusBill.set("isselfwoff", (Object)this.setIsSelfwoff());
            trgBusBill.set("bizdate", (Object)bizdate);
            this.reCalculateAmt(trgBusBill, busBills, genWoffs);
        }
        if (!ObjectUtils.isEmpty(trgBills)) {
            String billType = trgBills.get(0).getDataEntityType().getName();
            if (billType.startsWith("ap")) {
                BookDateHelper.setBookDate(trgBills.toArray(new DynamicObject[0]), false);
            } else {
                BookDateHelper.setBookDate(trgBills.toArray(new DynamicObject[0]), true);
            }
        }
        return genWoffs;
    }

    private void reCalculateAmt(DynamicObject trgBusBill, List<BusEntryInfo> busBills, List<BusEntryInfo> genWoffs) {
        BigDecimal rate = trgBusBill.getBigDecimal("exchangerate");
        String quotation = trgBusBill.getString("quotation");
        boolean includetax = trgBusBill.getBoolean("isincludetax");
        DynamicObject currency = trgBusBill.getDynamicObject("currency");
        currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency", (String)"id,amtprecision,priceprecision");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = trgBusBill.getDynamicObject("basecurrency");
        basecurrency = !currency.getPkValue().equals(basecurrency.getPkValue()) ? BusinessDataServiceHelper.loadSingleFromCache((Object)basecurrency.getPkValue(), (String)"bd_currency", (String)"id,amtprecision,priceprecision") : currency;
        int localprecision = basecurrency.getInt("amtprecision");
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        DynamicObjectCollection entries = trgBusBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            for (BusEntryInfo srcBusEntry : busBills) {
                if (entry.getLong("e_srcentryid") != srcBusEntry.getEntryPk()) continue;
                WoffHelper.setTrgEntry(entry, srcBusEntry, quotation, rate, includetax, precision, localprecision, this.isAr, this.isAmt, false);
                BusEntryInfo woffInfo = new BusEntryInfo();
                woffInfo.setSrcPk(srcBusEntry.getPk());
                woffInfo.setSrcEntryPk(srcBusEntry.getEntryPk());
                woffInfo.setQuantity(entry.getBigDecimal("e_quantity"));
                woffInfo.setTax(entry.getBigDecimal("e_tax"));
                woffInfo.setTaxLocAmt(entry.getBigDecimal("e_taxlocalamt"));
                woffInfo.setAmount(entry.getBigDecimal("e_amount"));
                woffInfo.setLocalAmt(entry.getBigDecimal("e_localamt"));
                woffInfo.setRecAmount(entry.getBigDecimal(this.recAmountKey));
                woffInfo.setRecLocAmt(entry.getBigDecimal(this.recLocAmtKey));
                genWoffs.add(woffInfo);
                entryList.add(entry);
            }
        }
        this.reCalcHeadAmt(trgBusBill, entries, entryList);
        if (!this.isAr) {
            this.checkAndRecalulateAllocationAmt(trgBusBill);
        }
    }

    private void checkAndRecalulateAllocationAmt(DynamicObject trgBusBill) {
        BigDecimal headAmt = trgBusBill.getBigDecimal("amount");
        boolean needRecalculate = AllocationUtils.isNeedRecalculate(headAmt, trgBusBill);
        if (!needRecalculate) {
            return;
        }
        AllocationUtils.executeCalculation(headAmt, trgBusBill);
    }

    private void reCalcHeadAmt(DynamicObject trgBusBill, DynamicObjectCollection entries, List<DynamicObject> entryList) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)entries)) {
            entries.clear();
            for (DynamicObject entry : entryList) {
                amount = amount.add(entry.getBigDecimal("e_amount"));
                tax = tax.add(entry.getBigDecimal("e_tax"));
                entries.add((Object)entry);
                localamt = localamt.add(entry.getBigDecimal("e_localamt"));
                taxlocamt = taxlocamt.add(entry.getBigDecimal("e_taxlocalamt"));
                pricetaxtotalbase = pricetaxtotalbase.add(entry.getBigDecimal(this.recLocAmtKey));
                pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal(this.recAmountKey));
            }
        }
        trgBusBill.set("amount", (Object)amount);
        trgBusBill.set("tax", (Object)tax);
        trgBusBill.set("localamt", (Object)localamt);
        trgBusBill.set("taxlocamt", (Object)taxlocamt);
        trgBusBill.set(this.isAr ? "recamount" : "pricetaxtotal", (Object)pricetaxtotal);
        trgBusBill.set(this.isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)pricetaxtotalbase);
        trgBusBill.set("uninvoicedamt", (Object)pricetaxtotal);
        trgBusBill.set("uninvoicedlocamt", (Object)pricetaxtotalbase);
        trgBusBill.set("unwoffamt", (Object)pricetaxtotal);
        trgBusBill.set("unwofflocamt", (Object)pricetaxtotalbase);
        trgBusBill.set("unwoffnotaxamt", (Object)amount);
        trgBusBill.set("unwoffnotaxlocamt", (Object)localamt);
        trgBusBill.set("unwofftax", (Object)tax);
        trgBusBill.set("unwofftaxlocal", (Object)taxlocamt);
        DynamicObjectCollection planEntrys = trgBusBill.getDynamicObjectCollection("planentity");
        planEntrys.clear();
        DynamicObject planentry = new DynamicObject(planEntrys.getDynamicObjectType());
        planEntrys.add((Object)planentry);
        planentry.set("seq", (Object)1);
        planentry.set("planduedate", trgBusBill.get("duedate"));
        planentry.set("plansettletype", trgBusBill.get("settlementtype"));
        planentry.set("planpricetax", (Object)pricetaxtotal);
        planentry.set("planpricetaxloc", (Object)pricetaxtotalbase);
        planentry.set("p_uninvoicedamt", (Object)pricetaxtotal);
        planentry.set("p_uninvoicedlocamt", (Object)pricetaxtotalbase);
    }

    public abstract List<BusEntryInfo> getBusBills(DynamicObject var1);

    public abstract List<BusEntryInfo> getSrcBusEntries(DynamicObject var1, List<BusEntryInfo> var2);

    public abstract boolean setIsSelfwoff();
}

