/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.woff.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.service.woff.AbstractWriteOff;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;

@Deprecated
public class BusPushImpl
extends AbstractWriteOff {
    public BusPushImpl(boolean isAr, boolean isAmt) {
        super(isAr ? "ar_busbill" : "ap_busbill", isAr, isAmt);
    }

    @Override
    public List<BusEntryInfo> getBusBills(DynamicObject finBill) {
        Set<Long> idSet = null;
        if (this.busEntityKey.equals(finBill.getString("sourcebilltype"))) {
            idSet = new HashSet();
            DynamicObjectCollection finEntrys = finBill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
            for (DynamicObject finEntry : finEntrys) {
                long e_srcId = finEntry.getLong(this.isAr ? "e_srcid" : "e_sourcebillid");
                idSet.add(e_srcId);
            }
        } else {
            long finPk = (Long)finBill.getPkValue();
            Map linkBills = BFTrackerServiceHelper.findSourceBills((String)(this.isAr ? "ar_finarbill" : "ap_finapbill"), (Long[])new Long[]{finPk});
            idSet = (Set)linkBills.get(this.busEntityKey);
        }
        List<BusEntryInfo> busList = null;
        if (idSet != null && idSet.size() > 0) {
            String sql4bus = "id, sourcebilltype, entry.id, e_quantity, e_srcentryid,e_iswriteoff, e_tax, e_taxlocalamt, e_amount, e_localamt," + this.recAmountKey + "," + this.recLocAmtKey;
            QFilter qFilter = new QFilter("id", "in", idSet);
            qFilter.and(new QFilter("entry.e_iswriteoff", "=", (Object)Boolean.FALSE));
            QFilter amtFilter = new QFilter("payproperty.isbasedonamt", "=", (Object)this.isAmt);
            DynamicObject[] busBills = null;
            busBills = this.isAmt ? BusinessDataServiceHelper.load((String)this.busEntityKey, (String)sql4bus, (QFilter[])new QFilter[]{qFilter, amtFilter}) : BusinessDataServiceHelper.load((String)this.busEntityKey, (String)sql4bus, (QFilter[])new QFilter[]{qFilter});
            busList = this.getBusEntries(finBill, busBills);
        }
        return busList;
    }

    private List<BusEntryInfo> getBusEntries(DynamicObject finBill, DynamicObject[] busBills) {
        ArrayList<BusEntryInfo> busList = new ArrayList<BusEntryInfo>();
        DynamicObjectCollection finEntrys = finBill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
        for (DynamicObject finEntry : finEntrys) {
            long e_srcId = finEntry.getLong(this.isAr ? "e_srcid" : "e_sourcebillid");
            long e_srcEntryId = finEntry.getLong(this.isAr ? "e_srcentryid" : "e_sourcebillentryid");
            boolean isallverify = finEntry.getBoolean("e_isallverify");
            for (DynamicObject busBill : busBills) {
                String sourcebilltype = busBill.getString("sourcebilltype");
                if (!busBill.getPkValue().equals(e_srcId)) continue;
                for (DynamicObject busEntry : busBill.getDynamicObjectCollection("entry")) {
                    if (!busEntry.getPkValue().equals(e_srcEntryId)) continue;
                    BusEntryInfo beInfo = new BusEntryInfo();
                    beInfo.setPk(e_srcId);
                    beInfo.setEntryPk(e_srcEntryId);
                    beInfo.setIsAmt(this.isAmt);
                    beInfo.setQuantity(busEntry.getBigDecimal("e_quantity"));
                    beInfo.setTax(busEntry.getBigDecimal("e_tax"));
                    beInfo.setTaxLocAmt(busEntry.getBigDecimal("e_taxlocalamt"));
                    beInfo.setAmount(busEntry.getBigDecimal("e_amount"));
                    beInfo.setLocalAmt(busEntry.getBigDecimal("e_localamt"));
                    beInfo.setRecAmount(busEntry.getBigDecimal(this.recAmountKey));
                    beInfo.setRecLocAmt(busEntry.getBigDecimal(this.recLocAmtKey));
                    if (isallverify && this.isScmcBill(sourcebilltype)) {
                        beInfo.setSrcImEntryPk(busEntry.getLong("e_srcentryid"));
                    }
                    busList.add(beInfo);
                }
            }
        }
        return busList;
    }

    @Override
    public List<BusEntryInfo> getSrcBusEntries(DynamicObject finBill, List<BusEntryInfo> busBills) {
        DynamicObjectCollection finEntrys = finBill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
        String quantityKey = this.isAr ? "e_quantity" : "quantity";
        for (DynamicObject finEntry : finEntrys) {
            Long e_srcId = finEntry.getLong(this.isAr ? "e_srcid" : "e_sourcebillid");
            Long e_srcEntryId = finEntry.getLong(this.isAr ? "e_srcentryid" : "e_sourcebillentryid");
            BigDecimal finInvoiceQty = finEntry.getBigDecimal(quantityKey);
            BigDecimal finAmount = finEntry.getBigDecimal("e_amount");
            Boolean isallverify = finEntry.getBoolean("e_isallverify");
            for (BusEntryInfo beInfo : busBills) {
                boolean overflow;
                if (!e_srcId.equals(beInfo.getPk()) || !e_srcEntryId.equals(beInfo.getEntryPk())) continue;
                BigDecimal unInvoicedQty = beInfo.getQuantity();
                BigDecimal unInvoicedAmt = beInfo.getRecAmount();
                BigDecimal unWoffAmt = beInfo.getAmount();
                if (!this.isAmt) {
                    boolean bl = overflow = unInvoicedQty.abs().compareTo(finInvoiceQty.abs()) <= 0;
                    if (isallverify.booleanValue() || overflow) {
                        beInfo.setIsWoff(true);
                        continue;
                    }
                    beInfo.setQuantity(finInvoiceQty);
                    continue;
                }
                boolean bl = overflow = unWoffAmt.abs().compareTo(finAmount.abs()) <= 0;
                if (isallverify.booleanValue() || overflow) {
                    beInfo.setIsWoff(true);
                    continue;
                }
                beInfo.setAmount(finAmount);
            }
        }
        return busBills;
    }

    @Override
    public boolean setIsSelfwoff() {
        return false;
    }

    private boolean isScmcBill(String sourceBillType) {
        boolean isScmc = false;
        if (sourceBillType.startsWith("im_") || sourceBillType.startsWith("pm_") || sourceBillType.startsWith("sm_")) {
            isScmc = true;
        }
        return isScmc;
    }
}

